<?php
/*
Plugin Name: Lightweight Google Maps
Plugin URI: http://www.yuriko.net/travel/2007/01/18/1786/
Description: This plugin makes an instant googlemap of posts on your wordpress blog. Based on Plug 'n' Play Google Map plugin by yongfook (http://www.yongfook.com/2005/05/28/plug-n-play-google-map/)
Version: 0.7.0-beta
Author: IKEDA Yuriko
Author URI: http://www.yuriko.net/travel/category/wordpress/
*/

define('LWGM_PLUGIN_PATH','wp-content/plugins/lightweight-google-maps');
load_plugin_textdomain('lw_googlemaps', $path = LWGM_PLUGIN_PATH);

$Lwgm = new Lightweight_Google_Maps;
add_action('admin_menu', array($Lwgm, 'add_admin_page'));
add_action('wp_head',    array($Lwgm, 'output_style'));
add_action('wp_footer',  array($Lwgm, 'output_map'));

// ==================================================
function lwgm_button() {
	list($lat, $lon) = Lightweight_Google_Maps::get_LatLon();
	if ($lat && $lon) {
		echo '<p class="map_button"><a href="' . get_bloginfo('url') . '/' . get_option('yf_google_page_id') . "/?lat=$lat&amp;lon=$lon" . '"><img src="' . get_settings('siteurl') . '/' . LWGM_PLUGIN_PATH . '/map_button.gif" alt="click to view on my google maps." /></a></p>';
	}
}

/* ==================================================
 *   Lightweight_Google_Maps Class
   ================================================== */

class Lightweight_Google_Maps {

// ==================================================
public function get_LatLon() {
	global $post;
	list($lat, $lon) = split(',', get_post_meta($post->ID, 'Lat_Long', true));
	return array(floatval($lat), floatval($lon));
}

// ==================================================
public function add_admin_page() {
	add_options_page('Lightweight Google Maps', 'Google Maps', 8, basename(__FILE__), array('Lightweight_Google_Maps', 'admin_page'));
}

// ==================================================
public function admin_page() {
	if (isset($_POST['info_update'])) {
		$yf_google_api_key = @$_POST['yf_google_api_key'];
		if ($yf_google_api_key) {
			update_option('yf_google_api_key', $yf_google_api_key);
		}
		$yf_map_type = @$_POST['yf_map_type'];
		if ($yf_map_type) {
			update_option('yf_map_type', $yf_map_type);
		}
		$yf_zoom_level = intval(@$_POST['yf_zoom_level']);
		if ($yf_zoom_level || $yf_zoom_level==0) {
			update_option('yf_zoom_level', $yf_zoom_level);
		}
		$lw_num_recent_markers = intval(@$_POST['lw_num_recent_markers']);
		if ($lw_num_recent_markers) {
			update_option('lw_num_recent_markers', $lw_num_recent_markers);
		}
		$yf_google_width = intval(@$_POST['yf_google_width']);
		if ($yf_google_width) {
			update_option('yf_google_width', $yf_google_width);
		}
		$yf_google_height = intval(@$_POST['yf_google_height']);
		if ($yf_google_height) {
			update_option('yf_google_height', $yf_google_height);
		}
		$yf_google_page_id = @$_POST['yf_google_page_id'];
		if ($yf_google_page_id) {
			update_option('yf_google_page_id', $yf_google_page_id);
		}
		if ($_POST['lw_convert_geo_locations']) {
			$this->convert_geo_locations();
		}
?><div class="updated fade"><p><strong><?php
		_e('Options saved.');
?></strong></p></div><?php
	}
	if (! isset($yf_map_type)) {
		$yf_map_type = get_option('yf_map_type');
	}
	$map_type_check = array();
	switch ($yf_map_type) {
	case 'G_NORMAL_MAP':
		$map_type_check[0] = ' checked="checked"';
		break;
	case 'G_SATELLITE_MAP':
		$map_type_check[1] = ' checked="checked"';
		break;
	case 'G_HYBRID_MAP':
		$map_type_check[2] = ' checked="checked"';
		break;
	}
?><div class="wrap">
  <h2>Lightweight Google Maps</h2>
  <form method="post">
     <fieldset name="set1" class="options">
        <legend><?php _e('Your Googlemap API Key', 'lw_googlemaps'); ?></legend>
        <table width="100%" cellspacing="2" cellpadding="5" class="editform"> 
		<tr> 
		<th width="20%" scope="row"><label for="yf_google_api_key"><?php _e('API Key:', 'lw_googlemaps'); ?></label></th> 
		<td><input type="text" name="yf_google_api_key" id="yf_google_api_key" /> <?php echo sprintf(__('(don\'t have one? get one <a href=%s>here</a>)', 'lw_googlemaps'), '"http://www.google.com/apis/maps/signup.html"'); ?></td>
		</tr><tr>
        <th><?php _e('Current API Key:', 'lw_googlemaps'); ?></th>
		<td><em><?php echo get_option('yf_google_api_key'); ?></em></td>
		</tr> 
		</table> 
     </fieldset>
     <fieldset name="set2" class="options">
        <legend><?php _e('Map type, zoom level', 'lw_googlemaps'); ?></legend>
        <table width="100%" cellspacing="2" cellpadding="5" class="editform"> 
        <tr> 
		<th width="20%" scope="row"><label for="yf_map_type"><?php _e('Type:', 'lw_googlemaps'); ?></label></th> 
		<td>
		<label><input type="radio" name="yf_map_type" id="yf_map_type" value="G_NORMAL_MAP"<?php echo $map_type_check[0]; ?> /> <?php _e('Graphic', 'lw_googlemaps'); ?></label>
		<label><input type="radio" name="yf_map_type" id="yf_map_type" value="G_SATELLITE_MAP"<?php echo $map_type_check[1]; ?> /> <?php _e('Satellite', 'lw_googlemaps'); ?></label>
		<label><input type="radio" name="yf_map_type" id="yf_map_type" value="G_HYBRID_MAP"<?php echo $map_type_check[2]; ?> /> <?php _e('Hybrid', 'lw_googlemaps'); ?></label>
		</td>
		</tr>
		<tr>
		<th width="20%" scope="row"><label for="yf_zoom_level"><?php _e('Zoom Level:', 'lw_googlemaps'); ?></label></th>
		<td>
		<select name="yf_zoom_level" id="yf_zoom_level">
		<?php 
			$level_select = array();
			$level_select[intval(get_option('yf_zoom_level'))] = ' selected="selected"';
			for ($level = 19; $level >= 1; $level--) {
				echo '<option value="' . $level . '"' . $level_select[$level] . ">$level</option>\n";
			}
		?>
		</select>
		<span><?php _e('(1: Whole globe, Bigger: Narrower area)', 'lw_googlemaps'); ?></span>
		</td> 
		</tr> 
		<tr> 
		<th width="20%" scope="row"><label for="lw_num_recent_markers"><?php _e('Number of markers:', 'lw_googlemaps'); ?></label></th> 
		<td>
		<input type="text" value="<?php echo get_option('lw_num_recent_markers');?>" name="lw_num_recent_markers" id="lw_num_recent_markers" /> <?php _e('points', 'lw_googlemaps'); ?>
		</td> 
		</tr> 
		</table>
     </fieldset>
     <fieldset name="set3" class="options">
        <legend><?php _e('Map Size', 'lw_googlemaps'); ?></legend>
        <table width="100%" cellspacing="2" cellpadding="5" class="editform"> 
		<tr> 
		<th width="20%" scope="row"><label for="yf_google_width"><?php _e('Width:', 'lw_googlemaps'); ?></label></th> 
		<td>
		<input type="text" value="<?php echo get_option('yf_google_width');?>" name="yf_google_width" id="yf_google_width" /> px
		</td> 
		</tr> 
		<tr> 
		<th width="20%" scope="row"><label for="yf_google_height"><?php _e('Height:', 'lw_googlemaps'); ?></label></th> 
		<td>
		<input type="text" value="<?php echo get_option('yf_google_height');?>" name="yf_google_height" id="yf_google_height" /> px
		</td> 
		</tr> 
		</table> 
     </fieldset>
     <fieldset name="set4" class="options">
        <legend><?php _e('Map Page Slug', 'lw_googlemaps'); ?></legend>
        <p><?php _e('This is the wordpress page slug of your googlemap page. <em>Not sure what I mean?  Check the readme!</em>', 'lw_googlemaps'); ?></p>
        <table width="100%" cellspacing="2" cellpadding="5" class="editform"> 
		<tr> 
		<th width="20%" scope="row"><label for="yf_google_page_id"><?php _e('Page Slug:', 'lw_googlemaps'); ?></label></th> 
		<td>
		<input type="text" value="<?php echo get_option('yf_google_page_id');?>" name="yf_google_page_id" id="yf_google_page_id" />
		</td> 
		</tr> 
		</table> 
     </fieldset>
     <fieldset name="set5" class="options">
        <legend><?php _e('Convert geo locations', 'lw_googlemaps'); ?></legend>
		<p><label>
		<input type="checkbox" value="1" name="lw_convert_geo_locations" id="lw_convert_geo_locations" /> <?php _e('Convert location data from Geo plug-in.', 'lw_googlemaps');?>
		</label></p> 
		<p><?php _e('Notice: Please de-activate Geo plug-in and wp-eznavi plug-in BEFORE checking this option.', 'lw_googlemaps'); ?></p>
     </fieldset>
<div class="submit">
  <p><input type="submit" name="info_update" value="<?php
    _e('Update options');
        ?> &raquo;" /></div></p>
  </form>
 </div>
<?php
} 

// ==================================================
private function convert_geo_locations() {
	global $wpdb;
	$wpdb->query("DELETE FROM $wpdb->postmeta WHERE meta_key = '_geo_location' AND meta_value = ','");
	$wpdb->query("UPDATE $wpdb->postmeta SET meta_key = 'Lat_Long' WHERE meta_key = '_geo_location'");
	return;
}

// ==================================================
public function output_style() {
	$map_page_id = get_option('yf_google_page_id');
	if (! is_page($map_page_id)) {
		return;
	}
	global $Lwgm_On;
	$Lwgm_On = TRUE;
	$api_key = get_option('yf_google_api_key');
	$map_width = get_option('yf_google_width');
	$map_height = get_option('yf_google_height');
?>
<style type="text/css">
#google_maps {
<?php if (is_numeric($map_width)) { ?>
	width:<?php echo intval($map_width); ?>px;
<?php } ?>
<?php if (is_numeric($map_height)) { ?>
	height:<?php echo intval($map_height); ?>px;
<?php } else { ?>
	height:400px;
<?php } ?>
	margin:1em 0;
	border:1px solid #999;
	line-height:1.25em;
}
#google_maps img {
	margin:0;
	padding:0;
	border:0 none;
}
#google_maps .infowindow {
	text-align:left;
	font-size:0.88em;
}
#google_maps p {
	margin:0;
	text-indent:0;
	font-size:0.75em;
}
</style>
<script src="http://maps.google.com/maps?file=api&amp;v=2&amp;key=<?php echo $api_key;?>" type="text/javascript"></script>
<?php
}

// ==================================================
public function output_map() {
	global $Lwgm_On;
	if (! isset($Lwgm_On)) {
		return;
	}
	$loc = array();
	if (isset($_GET['lon'])) {
		$lat = floatval($_GET['lat']);
		$lon = floatval($_GET['lon']);
		$zoom = 13;
		$loc = $this->targeted_locations($lat, $lon, $zoom);
	} else {
		if (isset($_GET['cat'])) {
			$loc = $this->categorized_locations(intval($_GET['cat']));
			$zoom = 7;
		} else {
			$loc = $this->recent_locations(get_option('lw_num_recent_markers'));
			$zoom = intval(get_option('yf_zoom_level'));
		}
	}
	if (count($loc) > 0) {
		$lat = $loc[0]['lat'];
		$lon = $loc[0]['lon'];
	} else {
		$lat = "35.659240199027884";
		$lon = "139.7005659341812";
	}
	$map_type = get_option('yf_map_type');
	if (! $map_type) {
		$map_type = 'G_SATELLITE_MAP';
	}
	if (! $zoom) {
		$zoom = 8;
	}
?>
<script type="text/javascript">
	//<![CDATA[
	var map = new GMap2(document.getElementById("google_maps"));
	map.addControl(new GLargeMapControl());
	map.addControl(new GMapTypeControl());
	map.addControl(new GScaleControl());
	map.addControl(new GOverviewMapControl());
	map.setCenter(new GLatLng(<?php echo $lat;?>, <?php echo $lon;?>), <?php echo $zoom;?>, <?php echo $map_type; ?>);
	function lwgm_create_marker(lat, lon, title, link, date, excerpt) {
		var point = new GLatLng(lat, lon);
		var marker = new GMarker(point);
		// setting up the look of the marker
		var html = "<div class=\"infowindow\"><a href=\""+link+"\"><strong>"+title+"</strong></a><br />"+date+"</div><p>"+excerpt+"</p>";
		GEvent.addListener(marker, "click", function() {
			marker.openInfoWindowHtml(html, {"maxWidth":200});
		});
		return marker;
	}
<?php
	if (count($loc) > 0) {
		foreach($loc as $l) {
			echo sprintf('var marker = lwgm_create_marker(%F,%F,"%s","%s","%s","%s");', 
			floatval($l['lat']), floatval($l['lon']), 
			wp_specialchars($l['title']), wp_specialchars($l['link']), 
			wp_specialchars($l['date']), wp_specialchars($l['excerpt'])
			) . "\nmap.addOverlay(marker);\n"; 
		}
	}
?>
	//]]>
	</script>
<?php
}

// ==================================================
private function targeted_locations($center_lat, $center_lon, $zoom) {
	$loc[0] = array();
	$range_w = 0.06; // ad-hoc value
	$range_h = 0.04; // ad-hoc value
	$lower_lat = $center_lat - $range_h;
	$upper_lat = $center_lat + $range_h;
	$left_lon  = $center_lon - $range_w;
	$right_lon = $center_lon + $range_w;
	for ($page = 1 ; ; $page++) {
		$posts = new WP_Query("paged=$page");
		if (! $posts->have_posts() || $page > 100000) {
			break;
		}
		while ($posts->have_posts()) : $posts->the_post();
			list($lat, $lon) = $this->get_LatLon();
			if ($lat && $lon) {
				if ($lat == $center_lat && $lon == $center_lon) {
					$loc[0] = $this->infowindow($lat, $lon);
				} elseif ($lat >= $lower_lat && $lat <= $upper_lat && $lon >= $left_lon  && $lon <= $right_lon) {
					$loc[] = $this->infowindow($lat, $lon);
				}
			}
		endwhile;
	}
	if (count($loc[0]) < 1) {
		array_shift($loc);
	}
	return $loc;
}

// ==================================================
private function categorized_locations($cat_id) {
	$cat_id = intval($cat_id);
	$loc = array();
	for ($page = 1 ; ; $page++) {
		$posts = new WP_Query("cat=$cat_id&paged=$page");
		if (! $posts->have_posts() || $page > 100000) {
			break;
		}
		while ($posts->have_posts()) : $posts->the_post();
			list($lat, $lon) = $this->get_LatLon();
			if ($lat && $lon) {
				$loc[] = $this->infowindow($lat, $lon);
			}
		endwhile;
	}
	return $loc;
}

// ==================================================
private function recent_locations($max_num) {
	if ($max_num < 1) {
		$max_num = 100;
	}
	$loc = array();
	for ($page = 1 ; ; $page++) {
		$posts = new WP_Query("paged=$page");
		if (! $posts->have_posts() || $page > 100000) {
			break;
		}
		while ($posts->have_posts()) : $posts->the_post();
			list($lat, $lon) = $this->get_LatLon();
			if ($lat && $lon) {
				$loc[] = $this->infowindow($lat, $lon);
				if (count($loc) >= $max_num) {
					break 2;
				}
			}
		endwhile;
	}
	return $loc;
}

// ==================================================
private function infowindow($lat, $lon) {
	$title = htmlspecialchars(get_the_title(), ENT_QUOTES);
	$link = get_permalink();
	$date = get_the_time('Y-m-d');
	$excerpt = preg_replace('/^\s+/', '', get_the_excerpt());
	$excerpt = preg_replace('/\n.*$/m', '', $excerpt);
	return compact('lat', 'lon', 'title', 'link', 'date', 'excerpt');
}

// ==================================================
} // End of class

?>