<?php
/*
Plugin Name: AmazonLink
Plugin URI: http://wppluginsj.sourceforge.jp/amazonlink/
Description: Amazon.co.jp の個別商品リンクを同一の設定で表示します。ブログのデザイン変更に簡単に対応できます。
Author: よしとも
Version: 0.5.0
Author URI: http://blog.yoshitomo.org/
*/


// This file's encode is UTF-8. And language is Japanese.


/*  Copyright 2007  Yoshitomo  (email : See http://park15.wakwak.com/%7Eyoshitomo/aboutMail.html)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
使い方：
１．プラグインディレクトリにアップロード
２．管理画面で有効化
３．投稿本文に次の形式でコードを入力。[amazon]ASIN[/amazon]
*/


if( class_exists('WpAmazonLink') )
{
	$ywal = new WpAmazonLink();
}

// メインクラス
class WpAmazonLink
{
	var $i18nDomain = 'wp_AmazonLink.yoshitomo.org';	// 国際化リソースドメイン
	var $customFieldKey = 'yo_amazon_link';				// カスタムフィールドのキー

	var $_options;										// オプションクラスインスタンス

	/**
	 * コンストラクタ
	 *
	 * @param void
	 * @return object クラスオブジェクト
	 */
	function WpAmazonLink()
	{
		// i18n
		load_plugin_textdomain($this->i18nDomain);

		// オプションの初期化
		$this->_loadOption($this->customFieldKey);

		// Hooks
		add_action('admin_menu', array(&$this, '_addPage'));
		add_action('admin_head', array(&$this, '_addAdminCssLink'));
		add_action('the_content', array(&$this, '_replaceCode'));

	}

	/**
	 * 記事本文中のコードを個別商品リンクHTMLコードに置換する
	 *
	 * @param string $content 記事本文データ
	 * @return string 置換処理の終わった記事本文データ
	 */
	function _replaceCode($content)
	{
		global $post;

		// パラメーターによる上書き
//		$this->_optionOverwrite($param);

		$htmlCode = '<iframe src="http://rcm-jp.amazon.co.jp/e/cm?o=9&p=8&l=as1&asins=$1';

		// トラッキング ID
		// t	トラッキングID
		if ( $this->_getOption('tracking_id') )
		{
			$htmlCode .= '&t='.$this->_getOption('tracking_id');
		}
		else
		{
			$htmlCode .= '&t=zatunenbase-22';
		}

		// 商品イメージ
		// IS2	大きいイメージを利用する　オン：1　オフ：なし
		// IS1	通常のイメージを利用する　オン：なし　オフ：1
		switch ( $this->_getOption('image') )
		{
			case 'normal':
				$htmlCode .= '&IS1=1';
				break;
			default:
				$htmlCode .= '&IS2=1';
		}

		// テキストカラー
		// fc1	テキストカラー：色コード
		if ( $this->_getOption('fc') )
		{
			$htmlCode .= '&fc1='.$this->_getOption('fc');
		}
		else
		{
			$htmlCode .= '&fc1=000000';
		}

		// リンクカラー
		// lc1	リンクカラー：色コード
		if ( $this->_getOption('lc') )
		{
			$htmlCode .= '&lc1='.$this->_getOption('lc');
		}
		else
		{
			$htmlCode .= '&lc1=0000FF';
		}

		// 背景色
		// bg1	背景の色：色コード
		if ( $this->_getOption('bc') )
		{
			$bc .= $this->_getOption('bc');
		}
		else
		{
			$bc .= 'FFFFFF';
		}
		$htmlCode .= '&bg1='.$bc;

		// リンクターゲット
		// lt1	新しいウィンドウで開く　オン：_blank　オフ：_top
		switch ( $this->_getOption('target') )
		{
			case 'top':
				$htmlCode .= '&lt1=_top';
				break;
			default: // blank
				$htmlCode .= '&lt1=_blank';
		}

		// ボーダー
		// bc1	フレームボーダーを表示する　オン：000000　オフ：背景色色コード
		switch ( $this->_getOption('border') )
		{
			case 'none':
				$htmlCode .= '&bc1='.$bc;
				break;
			default: // display
				$htmlCode .= '&bc1=000000';
		}

		// 価格の表示
		// nou	価格表示オプション　すべての価格を表示する：なし　新品の価格のみを表示する：1　価格を非表示にする：なし
		// npa	価格表示オプション　すべての価格を表示する：なし　新品の価格のみを表示する：なし　価格を非表示にする：1
		switch ( $this->_getOption('plice') )
		{
			case 'new':
				$htmlCode .= '&nou=1';
				break;
			case 'none':
				$htmlCode .= '&npa=1';
				break;
		}

		$htmlCode .= '&f=ifr" style="width: 120px; height: 240px;" marginwidth="0" marginheight="0" frameborder="0" scrolling="no"></iframe>';


//		$htmlCode = str_replace('%TRACKING_ID%', $trackingId, $htmlCode);
		$htmlCode = str_replace('&', '&amp;', $htmlCode);


		// ASINコードの置換
		$linkCode = '/\[amazon\]([a-zA-Z0-9,]+)\[\/amazon\]/';
		$replacedContent = preg_replace($linkCode, $htmlCode, $content);
		return $replacedContent;

	}


	/**
	 * 管理画面のヘッダに CSS へのリンクを追加する
	 */
	function _addAdminCssLink()
	{
		if ( $_GET['page']  and  substr_count(__FILE__, $_GET['page']) )
		{
			$dirs = explode('/', dirname(__FILE__));
			print('<link rel="stylesheet" type="text/css" href="' . get_bloginfo('wpurl') . '/wp-content/plugins/' . array_pop($dirs) . '/css/admin.css" />' . "\n");
		}
	}

	/**
	 * 管理画面にページを追加する
	 *
	 * @return void
	 */
	function _addPage()
	{
		// オプションページの追加
		if ( function_exists('add_options_page') )
		{
			add_options_page(__('AmazonLink オプション', $this->i18nDomain), __('AmazonLink', $this->i18nDomain), 8, basename(__FILE__), array(&$this, '_optionPage'));
		}
	}

	/**
	 * 管理画面メニューのオプションページ
	 *
	 * @return void
	 */

	function _optionPage()
	{

		switch ( $_POST['op'] )
		{
			case 'set_option':
				// 強制的にエスケープ処理が入るので、使用する直前にアンエスケープしてやる
				foreach ( $_POST as $web_post_name => $web_post_value )
				{
					$_POST[$web_post_name] = stripslashes($web_post_value);
				}

				$this->_setOption('tracking_id', $_POST['tracking_id']);
				$this->_setOption('target', $_POST['target']);
				$this->_setOption('border', $_POST['border']);
				$this->_setOption('image', $_POST['image']);
				$this->_setOption('plice', $_POST['plice']);
				$this->_setOption('lc', $_POST['lc']);
				$this->_setOption('fc', $_POST['fc']);
				$this->_setOption('bc', $_POST['bc']);
				$this->_saveOption($this->customFieldKey, 'Plugin "AmazonLink"');
				break;
			case 'reset_option':
				$this->_resetOption($this->customFieldKey);
				break;
			default: // not submited
		}

		// リンクターゲット
		$select_target = array();
		switch ( $this->_getOption('target') )
		{
			case 'top':
				$select_target['top'] = ' checked="checked"';
				break;
			default: // blank
				$select_target['blank'] = ' checked="checked"';
		}

		// ボーダー
		$select_border = array();
		switch ( $this->_getOption('border') )
		{
			case 'none':
				$select_border['none'] = ' checked="checked"';
			default: // show
				$select_border['show'] = ' checked="checked"';
		}

		// 商品イメージ
		$select_image = array();
		switch ( $this->_getOption('image') )
		{
			case 'normal':
				$select_image['normal'] = ' checked="checked"';
			default: // large
				$select_image['large'] = ' checked="checked"';
		}

		// 価格の表示
		$select_plice = array();
		switch ( $this->_getOption('plice') )
		{
			case 'new':
				$select_plice['new'] = ' checked="checked"';
				break;
			case 'none':
				$select_plice['none'] = ' checked="checked"';
				break;
			default: // all
				$select_plice['all'] = ' checked="checked"';
		}

		// 色
		if ( $this->_getOption('lc') == '' )
		{
			$this->_setOption('lc', '0000FF');
		}
		if ( $this->_getOption('bc') == '' )
		{
			$this->_setOption('bc', 'FFFFFF');
		}
		if ( $this->_getOption('fc') == '' )
		{
			$this->_setOption('fc', '000000');
		}


		// プラグインオプション画面のコード出力
?>
<div class="wrap" id="AmazonLink">
<h2><?php _e('設定', $this->i18nDomain); ?></h2>
<form action="<?php echo $_SERVER['REQUEST_URI']; ?>" method="post">
<fieldset>
<legend><?php _e('トラッキング ID', $this->i18nDomain); ?></legend>
<p><?php _e('Amazon アソシエイトのリンクで使用するトラッキング ID です。空欄の場合は作者のものが使用されます。', $this->i18nDomain); ?></p>
<dl>
	<dt><label for="tracking_id"><?php _e('トラッキング ID', $this->i18nDomain); ?></label><dt>
	<dd><input type="text" name="tracking_id" id="tracking_id" value="<?php echo htmlspecialchars($this->_getOption('tracking_id')); ?>" /></dd>
</dl>
</fieldset>

<fieldset>
<legend><?php _e('リンクターゲット', $this->i18nDomain); ?></legend>
<p><?php _e('リンクをクリックしたときの開き先。', $this->i18nDomain); ?></p>
<ul>
	<li>
	<input type="radio" name="target" id="target_blank" value="blank"<?php echo $select_target['blank']; ?> /><label for="target_blank"><?php _e('新規ウィンドウ（デフォルト）', $this->i18nDomain); ?></label>
	</li>
	<li>
	<input type="radio" name="target" id="target_top" value="top"<?php echo $select_target['top']; ?> /><label for="target_top"><?php _e('同じウィンドウ', $this->i18nDomain); ?></label>
	</li>
</ul>
</fieldset>

<fieldset>
<legend><?php _e('ボーダー', $this->i18nDomain); ?></legend>
<p><?php _e('個別商品リンクにボーダー（枠線）をつけるかどうか。', $this->i18nDomain); ?></p>
<ul>
	<li>
		<input type="radio" name="border" id="border_show" value="show"<?php echo $select_border['show']; ?> />
		<label for="border_show"><?php _e('ボーダーあり（デフォルト）', $this->i18nDomain); ?></label>
	</li>
	<li>
		<input type="radio" name="border" id="border_none" value="none"<?php echo $select_border['none']; ?> />
		<label for="border_none"><?php _e('ボーダーなし', $this->i18nDomain); ?></label>
	</li>
</ul>
</fieldset>

<fieldset>
<legend><?php _e('商品イメージ', $this->i18nDomain); ?></legend>
<p><?php _e('表示する商品のイメージに大きなものを使用するかどうか。', $this->i18nDomain); ?></p>
<ul>
	<li>
		<input type="radio" name="image" id="image_large" value="large"<?php echo $select_image['large']; ?> />
		<label for="image_large"><?php _e('大きなイメージ（デフォルト）', $this->i18nDomain); ?></label>
	</li>
	<li>
		<input type="radio" name="image" id="image_normal" value="normal"<?php echo $select_image['normal']; ?> />
		<label for="image_normal"><?php _e('通常のサイズ', $this->i18nDomain); ?></label>
	</li>
</ul>
</fieldset>

<fieldset>
<legend><?php _e('価格の表示', $this->i18nDomain); ?></legend>
<p><?php _e('商品の価格表示方法です。', $this->i18nDomain); ?></p>
<ul>
	<li>
		<input type="radio" name="plice" id="plice_all" value="all"<?php echo $select_plice['all']; ?> />
		<label for="plice_all"><?php _e('すべての価格を表示する（デフォルト）', $this->i18nDomain); ?></label>
	</li>
	<li>
		<input type="radio" name="plice" id="plice_new" value="new"<?php echo $select_plice['new']; ?> />
		<label for="plice_new"><?php _e('新品の価格のみ表示', $this->i18nDomain); ?></label>
	</li>
	<li>
		<input type="radio" name="plice" id="plice_none" value="none"<?php echo $select_plice['none']; ?> />
		<label for="plice_none"><?php _e('価格は表示しない', $this->i18nDomain); ?></label>
	</li>
</ul>
</fieldset>

<fieldset>
<legend><?php _e('色', $this->i18nDomain); ?></legend>
<p><?php _e('個別商品リンク各部の色を、6桁の16進数表現で指定します。', $this->i18nDomain); ?></p>
<dl>
	<dt><label for="bc"><?php _e('背景色', $this->i18nDomain); ?></label></dt>
	<dd>#<input type="text" name="bc" id="bc" value="<?php echo htmlspecialchars($this->_getOption('bc')); ?>" /></dd>
	<dt><label for="fc"><?php _e('テキストカラー', $this->i18nDomain); ?></label></dt>
	<dd>#<input type="text" name="fc" id="fc" value="<?php echo htmlspecialchars($this->_getOption('fc')); ?>" /></dd>
	<dt><label for="lc"><?php _e('リンクカラー', $this->i18nDomain); ?></label></dt>
	<dd>#<input type="text" name="lc" id="lc" value="<?php echo htmlspecialchars($this->_getOption('lc')); ?>" /></dd>
</dl>
</fieldset>

<p class="submit">
<input type="submit" value="<?php _e('設定を更新する &raquo;', $this->i18nDomain); ?>" />
</p>
<input class="button" type="hidden" name="op" value="set_option" />
</form>
<form action="<?php echo $_SERVER['REQUEST_URI']; ?>" method="post">
<p class="submit">
<input class="button" id="deletepost" type="submit" value="<?php _e('設定をリセットする &raquo;', $this->i18nDomain); ?>" />
</p>
<input type="hidden" name="op" value="reset_option" />
</form>
</div>
<?php
	}


// ========== 共通オプション処理関数群　ここから ==========
/**
 * [前提]
 * 　オプションを保持する変数の名前は _options とする。
 * 　外部からのアクセスは拒否（private）とする。そのため、関数名は _ を頭につける（PHPの習慣）。
 * 　ほかのプラグインでも使用できるように、データ加工を目的とした処理は入れない。
 */

	/**
	 * オプションデータをデータベースから読み込む
	 *
	 * @param string $name オプション名
	 * @return int 初期化後のオプションの数
	 *
	 */
	function _loadOption($name)
	{
		$this->_options = get_option($name);
		if ( count($this->_options) )
		{
			$this->_setOption('is_loaded', true);
		}
		else
		{
			$this->_setOption('is_loaded', false);
		}
	}

	/**
	 * オプションデータをデータベースに保存する
	 *
	 * @param string $name オプション名
	 * @param string desc オプションの説明
	 * @return int 初期化後のオプションの数
	 *
	 */
	function _saveOption($name, $desc = '')
	{
		if ( get_option($name) )
		{
			update_option($name, $this->_options);
		}
		else
		{
			add_option($name, $this->_options, $desc);
		}
	}

	/**
	 * 自分自身のプラグインオプション値を得る
	 *
	 * @param string $name オプション名
	 * @return mixed オプション値
	 *
	 */
	function _getOption($name)
	{
		return $this->_options[$name];
	}

	/**
	 * 自分自身のすべてのプラグインオプション値を得る
	 *
	 * @return mixed オプション値
	 *
	 */
	function _getAllOptions()
	{
		return $this->_options;
	}

	/**
	 * 自分自身のプラグインオプション値を設定する
	 *
	 * @param string $name オプション名
	 * @param mixed $value 値
	 * @return void
	 *
	 */
	function _setOption($name, $value)
	{
		$this->_options[$name] = $value;
	}

	/**
	 * 自分自身のプラグインオプション値をクリアする
	 *
	 * @return void
	 *
	 */
	function _resetOption($name)
	{
		delete_option($name);
		$this->_options = array();
	}


	/**
	 * パラメーターによる上書き
	 *
	 * @param string $param パラメーター
	 * @return void
	 *
	 */
	function _optionOverwrite($param = '')
	{
		// パラメーターオプションの初期化
		if ( $param != '' )
		{
			foreach ( explode('&', $param) as $option )
			{
				list($name, $value) = explode('=', $option);
				$this->_setOption($name, $value);
			}
		}
	}

// ========== 共通オプション処理関数群　ここまで ==========

} // class AmazonLink End

?>