<?php
/* ==================================================
 *   Ktai Admin Comments
 *   based on wp-admin/edit.php,edit-form-comments.php of WP 2.3
   ================================================== */

require_once dirname(__FILE__) . '/admin.php';
$parent_file = 'edit-comments.php';
$submenu_file = 'edit-comments.php';

wp_reset_vars(array('action'));
if (isset($_POST['deletecomment'])) {
	$action = 'deletecomment';
}
switch($action) {
case 'editcomment':
	$comment = (int) $_GET['c'];
	if (! $comment = get_comment($comment)) {
		Ktai_Style::ks_die(__('Oops, no comment with this ID.'));
	}
	if (! current_user_can('edit_post', $comment->comment_post_ID)) {
		Ktai_Style::ks_die(__('You are not allowed to edit comments on this post.'));
	}
	$title = __('Edit Comment');
	include dirname(__FILE__) . '/admin-header.php';
	$comment = get_comment_to_edit($comment);
	$submitbutton_text = __('Edit Comment &raquo;');
	$toprow_title = sprintf(__('Editing Comment # %s'), $comment->comment_ID);
	$form_action = 'editedcomment';
	$form_extra = "<input type='hidden' name='comment_ID' value='" . $comment->comment_ID . "' /><input type='hidden' name='comment_post_ID' value='" . $comment->comment_post_ID . "' />";
?>
<h2><?php echo $toprow_title; ?></h2>
<form name="post" action="comment.php" method="post">
<input type="hidden" name="<?php echo KS_SESSION_NAME; ?>" value="<?php $KS_Admin->the_sid() ?>" /><input type="hidden" name="charset_detect" value="文字化け防止のためエンコーディング判別文字列" />
<?php wp_nonce_field('update-comment_' . $comment->comment_ID) ?>
<input type="hidden" name="user_ID" value="<?php echo (int) $user_ID ?>" />
<input type="hidden" name="action" value="<?php echo $form_action; ?>" /><?php echo $form_extra; ?>
<div><?php _e('Name:') ?><br />
<input type="text" name="newcomment_author" size="25" value="<?php echo attribute_escape( $comment->comment_author ); ?>" /><br />
<?php _e('URL:') ?><br />
<input type="text" name="newcomment_author_url" size="35" value="<?php echo attribute_escape( $comment->comment_author_url ); ?>" /><br />
<?php _e('Comment') ?><br />
<textarea rows="6" cols="100%" name="content"><?php echo $comment->comment_content ?></textarea><br />
<input type="submit" name="editcomment" value="<?php echo $submitbutton_text ?>" /><input name="referredby" type="hidden" value="<?php echo $KS_Admin->get_referer(); ?>" /><br />
<?php _e('Comment Status') ?><br />
<input name="comment_status" type="radio" value="1" <?php checked($comment->comment_approved, '1'); ?> /> <?php _e('Approved') ?>
<input name="comment_status" type="radio" value="0" <?php checked($comment->comment_approved, '0'); ?> /> <?php _e('Moderated') ?>
<input name="comment_status" type="radio" value="spam" <?php checked($comment->comment_approved, 'spam'); ?> /> <?php _e('Spam') ?><br />
<input name="deletecomment" type="submit" value="<?php _e('Delete this comment') ?>" />
<input type="hidden" name="c" value="<?php echo $comment->comment_ID ?>" />
<input type="hidden" name="p" value="<?php echo $comment->comment_post_ID ?>" />
<input type="hidden" name="noredir" value="1" />
</div>
</form>
<?php
	$referer = $KS_Admin->get_referer();
	if ($referer) {
		echo '<div><img localsrc="64" alt="' . __('&lt;-', 'ktai_style') . '" />' . sprintf(__('Back to <a href="%s">the previous page</a>.', 'ktai_style'), attribute_escape($referer)) . '</div>';
	}
	break;
case 'cdc':
case 'mac':
	$comment = (int) $_GET['c'];
	$formaction   = ('cdc' == $action) ? 'deletecomment'   : 'approvecomment';
	$nonce_action = ('cdc' == $action) ? 'delete-comment_' : 'approve-comment_';
	$nonce_action .= $comment;
	if (! $comment = get_comment_to_edit($comment)) {
		Ktai_Style::ks_die(__('Oops, no comment with this ID.') . sprintf(' <a href="%s">' . __('Go back') . '</a>', $KS_Admin->add_sid('edit-comments.php')), '', FALSE);
	}
	if (! current_user_can('edit_post', $comment->comment_post_ID)) {
		Ktai_Style::ks_die('cdc' == $action ? __('You are not allowed to delete comments on this post.') : __('You are not allowed to edit comments on this post, so you cannot approve this comment.'));
	}
	include dirname(__FILE__) . '/admin-header.php';
	if ('spam' == $_GET['dt']) {
		$message = __('You are about to mark the following comment as spam:');
	} elseif ('cdc' == $action) {
		$message = __('You are about to delete the following comment:');
	} else {
		$message = __('You are about to approve the following comment:');
	}
	echo '<p><font color="red">' . __('Caution:') . $message . '</font><br />' . __('Are you sure you want to do that?') . '</p>';
?>
<form action="edit-comments.php" method="get"><input type="hidden" name="<?php echo KS_SESSION_NAME; ?>" value="<?php $KS_Admin->the_sid() ?>" /><div><input type="submit" value="<?php _e('No'); ?>" /></div></form>
<form action="comment.php" method="get"><input type="hidden" name="<?php echo KS_SESSION_NAME; ?>" value="<?php $KS_Admin->the_sid() ?>" />
<?php wp_nonce_field($nonce_action); ?>
<input type="hidden" name="action" value="<?php echo $formaction; ?>" />
<?php if ('spam' == $_GET['dt']) { ?>
<input type="hidden" name="dt" value="spam" />
<?php } ?>
<input type="hidden" name="p" value="<?php echo $comment->comment_post_ID; ?>" />
<input type="hidden" name="c" value="<?php echo $comment->comment_ID; ?>" />
<input type="hidden" name="noredir" value="1" />
<div><input type="submit" value="<?php _e('Yes'); ?>" /></div>
</form>
<dl><dt><img localsrc="<?php comment_type(68, 112, 112); ?>" alt="[<?php comment_type(__('Comment'), __('Trackback'), __('Pingback')); ?>] " /><?php comment_author(); ?><img localsrc="46" alt=" @ " /><font color="<?php echo ks_option('ks_date_color'); ?>"><?php ks_comment_datetime(); ?></font></dt><dd><?php 
	if ($comment->comment_author_email) { 
		?><img localsrc="108" alt="" /><font color="olive"><?php comment_author_email(); ?></font><br /><?php
	}
	if ($comment->comment_author_url && 'http://' != $comment->comment_author_url) {
		?><img localsrc="112" alt="" /><font color="olive"><?php comment_author_url(); ?></font><br /><?php 
	}
	comment_excerpt(); ?></dd></dl>
<?php
	break;
case 'deletecomment':
	$comment = (int) $_REQUEST['c'];
	check_admin_referer('delete-comment_' . $comment);
	if ( isset($_REQUEST['noredir']) ) {
		$noredir = true;
	} else {
		$noredir = false;
	}
	if (! $comment = get_comment($comment) ) {
		 Ktai_Style::ks_die(__('Oops, no comment with this ID.') . sprintf(' <a href="%s">'.__('Go back').'</a>!', $KS_Admin->add_sid('edit-comments.php')), '', FALSE);
	}
	if (! current_user_can('edit_post', $comment->comment_post_ID) ) {
		Ktai_Style::ks_die(__('You are not allowed to edit comments on this post.'));
	}
	if ( 'spam' == $_REQUEST['dt'] ) {
		wp_set_comment_status($comment->comment_ID, 'spam');
	} else {
		wp_delete_comment($comment->comment_ID);
	}
	if (($KS_Admin->get_referer() != '') && (false == $noredir)) {
		$KS_Admin->redirect($KS_Admin->get_referer());
	} else {
		$KS_Admin->redirect(ks_admin_url(FALSE) .'edit-comments.php');
	}
	exit();
	break;
case 'unapprovecomment':
	$comment = (int) $_GET['c'];
	check_admin_referer('unapprove-comment_' . $comment);
	if (isset($_GET['noredir'])) {
		$noredir = true;
	} else {
		$noredir = false;
	}
	if ( ! $comment = get_comment($comment) ) {
		Ktai_Style::ks_die(__('Oops, no comment with this ID.') . sprintf(' <a href="%s">'.__('Go back').'</a>!', $KS_Admin->add_sid('edit-comments.php')), '', FALSE);
	}
	if ( !current_user_can('edit_post', $comment->comment_post_ID) ) {
		Ktai_Style::ks_die(__('You are not allowed to edit comments on this post, so you cannot disapprove this comment.'));
	}
	wp_set_comment_status($comment->comment_ID, "hold");
	if (($KS_Admin->get_referer() != "") && (false == $noredir)) {
		$KS_Admin->redirect($KS_Admin->get_referer());
	} else {
		$KS_Admin->redirect(ks_admin_url(FALSE) .'edit-comments.php?p=' . (int) $comment->comment_post_ID);
	}
	exit();
	break;
case 'approvecomment':
	$comment = (int) $_GET['c'];
	check_admin_referer('approve-comment_' . $comment);
	if (isset($_GET['noredir'])) {
		$noredir = true;
	} else {
		$noredir = false;
	}
	if (! $comment = get_comment($comment)) {
		Ktai_Style::ks_die(__('Oops, no comment with this ID.') . sprintf(' <a href="%s">'.__('Go back').'</a>!', $KS_Admin->add_sid('edit-comments.php')), '', FALSE);
	}
	if (! current_user_can('edit_post', $comment->comment_post_ID)) {
		Ktai_Style::ks_die(__('You are not allowed to edit comments on this post, so you cannot approve this comment.'));
	}
	wp_set_comment_status($comment->comment_ID, "approve");
	if (get_option("comments_notify") == true) {
		wp_notify_postauthor($comment->comment_ID);
	}
	if (($KS_Admin->get_referer() != "") && (false == $noredir)) {
		$KS_Admin->redirect($KS_Admin->get_referer());
	} else {
		$KS_Admin->redirect(ks_admin_url(FALSE) .'edit-comments.php?p=' . (int) $comment->comment_post_ID);
	}
	exit();
	break;
case 'editedcomment':
	$comment_ID = (int) $_POST['comment_ID'];
	$comment_post_ID = (int) $_POST['comment_post_id'];
	check_admin_referer('update-comment_' . $comment_ID);
	$KS_Admin->edit_comment();
	$location = ( empty($_POST['referredby']) ? "edit-comments.php?p=$comment_post_ID" : $_POST['referredby'] );
	$location = apply_filters('comment_edit_redirect', $location, $comment_ID);
	$KS_Admin->redirect($location);
	exit();
	break;
default:
	break;
} // end switch
include dirname(__FILE__) . '/admin-footer.php';
exit();
?>