<?php
/* ͕h~̂߂̓{ꕶłB
   ̃\[Xt@C Shift_JIS ŕۑĂ܂B
   Above is a Japanese strings to avoid charset mis-understanding.
   This source file is saved with Shift_JIS. */

/* ==================================================
 *   Ktai_Service_imode class
   ================================================== */

class Ktai_Service_imode extends Ktai_Services {

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	$this->user_agent = $user_agent;
	$this->operator   = 'DoCoMo';
	$this->charset    = 'SJIS-win';
	return;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function replace_smiley($buffer) {
	$smiles = array(
		'icon_smile.gif'     => '&#63893;',
		'icon_biggrin.gif'   => '&#xE72A;',
		'icon_sad.gif'       => '&#63896;',
		'icon_surprised.gif' => '&#63914;', // impact
		'icon_eek.gif'       => '&#xE757;', 
		'icon_confused.gif'  => '&#xE72B;',
		'icon_cool.gif'      => '&#xE752;',
		'icon_mad.gif'       => '&#63894;',
		'icon_razz.gif'      => '&#xE728;',
		'icon_neutral.gif'   => '&#xE725;',
		'icon_wink.gif'      => '&#xE729;',
		'icon_lol.gif'       => '&#xE728;',
		'icon_redface.gif'   => '&#xE726;',
		'icon_cry.gif'       => '&#xE72D;',
		'icon_evil.gif'      => '&#xE724;',
		'icon_twisted.gif'   => '&#xE724;',
		'icon_rolleyes.gif'  => '&#xE720;',
		'icon_exclaim.gif'   => '&#63911;',
		'icon_question.gif'  => '&#63912;',
		'icon_idea.gif'      => '&#63904;',
		'icon_arrow.gif'     => '&#63835;',
		'icon_mrgreen.gif'   => '&#xE753;',
	);
	return parent::replace_smiley($buffer, $smiles);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 * Reference: http://www.nttdocomo.co.jp/service/imode/make/content/pictograph/basic/
 *            http://www.au.kddi.com/ezfactory/tec/spec/3.html
 */
public function convert_char($buffer) {
	$chars = array (
		'1'   => '&#xE737;', // warning (!)
		'2'   => '&#63911;', // exclamation (!)
		'3'   => '?',        // question (?)
		'4'   => '&#63878;', // question (Q)
		'5'   => '',       // left triangle
		'6'   => '',       // right triangle
		'7'   => '',       // double left triangle
		'8'   => '',       // double right triangle
		'15'  => '&#63811;', // moon (3days)
		'16'  => '&#63651;', // thunder
		'25'  => '&#xE71F;', // watch
		'29'  => '',       // up arrow
		'30'  => '',       // down arrow
		'32'  => '',       // down triangle
		'33'  => '',       // up triangle
		'34'  => '',       // double down triangle
		'35'  => '',       // double up triangle
		'42'  => '&#63736;', // up-left arrow
		'43'  => '&#63735;', // down-right arrow
		'44'  => '&#63647;', // sun
		'45'  => '&#63668;', // baseball
		'46'  => '&#63838;', // clock
		'48'  => '&#xE713;', // bell (chapel)
		'50'  => '&#63829;', // face (female)
		'51'  => '&#63889;', // heart
		'52'  => '&#63698;', // bar (martini)
		'53'  => '&#xE741;', // four-leaf clover
		'54'  => '&#xE732;', // trade mark (TM)
		'55'  => '~',       // multiply (cross)
		'56'  => '&#63722;', // note
		'61'  => '~',       // cross
		'63'  => '',       // right arrow
		'64'  => '',       // left arrow
		'65'  => '&#63697;', // magcup (tea room)
		'68'  => '&#63893;', // smile
		'69'  => '',       // star
		'70'  => '&#63705;', // up-right arrow
		'71'  => '&#63817;', // down-left arrow
		'72'  => '&#xE71B;', // jewelry
		'74'  => '&#63813;', // dog
		'75'  => '',       // star
		'76'  => '&#63903;', // spark
		'77'  => '&#63904;', // lamp
		'80'  => '&#63829;', // face (male)
		'81'  => '&#xE731;', // copyright mark (C)
		'82'  => '&#xE736;', // registered mark
		'83'  => '&#63715;', // briefcase
		'85'  => '&#63720;', // telephone (fixed)
		'86'  => '&#63722;', // pop up memo
		'88'  => '',       // up triangle
		'89'  => '',       // down triangle
		'94'  => '&#63714;', // camera
		'95'  => '&#63649;', // rain
		'96'  => '&#63671;', // american football??
		'97'  => '&#63716;', // book
		'98'  => '&#xE72F;', // keep out sign
		'99'  => '&#63694;', // traffic signal
		'100' => '&#63716;', // book
		'101' => '&#63716;', // book
		'102' => '&#63716;', // book
		'103' => '&#63722;', // document
		'104' => '&#63702;', // scissors
		'105' => '&#63722;', // daily calender
		'106' => '&#63711;', // ticket
		'107' => '&#63648;', // cloud
		'108' => '&#63863;', // mail envelope
		'109' => '&#63866;', // money
		'110' => '&#63704;', // movie/video camera
		'111' => '&#63704;', // handheld video camera
		'112' => '&#63684;', // home
		'113' => '&#61529;', // flower (tulip)
		'116' => '&#63730;', // glasses / eye
		'118' => '&#63870;', // next item /return mark
		'119' => '&#63873;', // magnifier (search)
		'120' => '&#63869;', // key
		'124' => '&#63701;', // shoe (high-heel)
		'125' => '&#63679;', // sedan (car)
		'140' => '',       // leftside finger
		'141' => '',       // rightside finger
		'143' => '&#xE730;', // clip
		'144' => '&#63718;', // present box
		'146' => '&#63696;', // knife and fork
		'149' => '&#63826;', // pen
		'151' => '&#63863;', // envelope
		'152' => '&#xE718;', // spanner
		'155' => '&#63720;', // telephone (handset)
		'156' => '&#63685;', // factory
		'161' => '&#63721;', // mobile phone
		'168' => '&#63683;', // air plane
		'169' => '&#63815;', // boat (ship)
		'172' => '&#63676;', // electric train
		'176' => '&#63712;', // smoking
		'177' => '&#63713;', // no smoking
		'178' => '&#63740;', // wheel chair
		'179' => '[t}[N]', // beginner driver mark
		'180' => '&#63879;', // one
		'181' => '&#63880;', // two
		'182' => '&#63881;', // three
		'183' => '&#63882;', // four
		'184' => '&#63883;', // five
		'185' => '&#63884;', // six
		'186' => '&#63885;', // seven
		'187' => '&#63886;', // eight
		'188' => '&#63887;', // nine
		'190' => '&#63652;', // storm
		'191' => '&#63650;', // snowball
		'192' => '&#63655;', // Aries (Ram)
		'193' => '&#63656;', // Taurus (Bull)
		'194' => '&#63657;', // Gemini (Twins)
		'195' => '&#63658;', // Cancer (Crab)
		'196' => '&#63659;', // Leo (Lion)
		'197' => '&#63660;', // Virgo (Virgin)
		'198' => '&#63661;', // Libra (Scales)
		'199' => '&#63662;', // Scorpius (Scorpion)
		'200' => '&#63663;', // Sagittarius (Archer)
		'201' => '&#63664;', // Capricornus (Goat)
		'202' => '&#63665;', // Aquarius (Water Bearer)
		'203' => '&#63666;', // Pisces (Fishes)
		'204' => '[֎g]', // Ophiuchus (Serpent Bearer)
		'205' => '&#63689;', // Automatic Teller Machine
		'206' => '&#63691;', // convenience store
		'207' => '&#63695;', // toilet
		'208' => '&#63693;', // parking
		'209' => '&#63681;', // bus stop
		'210' => '&#63875;', // location simble (parabola antenna)
		'211' => '&#63682;', // anchor (port)
		'212' => '&#63688;', // bank
		'213' => '&#63692;', // gas station
		'215' => '&#xE71D;', // bicycle
		'216' => '&#63681;', // bus
		'217' => '&#63678;', // shinkansen (bullet train)
		'218' => '&#xE733;', // marathon
		'219' => '&#63671;', // football (soccer)
		'220' => '&#63670;', // tennis
		'221' => '&#xE712;', // snow board
		'222' => '&#63674;', // checker flag
		'223' => '&#63706;', // amusement park
		'224' => '&#63900;', // spa
		'226' => '&#63824;', // movie (clapper board)
		'227' => '&#63831;', // night scene
		'233' => '&#xE715;', // doller bag
		'234' => '&#63816;', // christmas tree
		'235' => '&#xE748;', // cherry blossom
		'239' => '&#xE74A;', // short cake
		'244' => '&#xE749;', // onigiri (rise ball)
		'245' => '&#63699;', // hamberger (fast food)
		'251' => '&#63814;', // cat
		'257' => '&#63893;', // laugh face
		'258' => '&#63894;', // angry face
		'259' => '&#63896;', // sad face
		'260' => '&#63897;', // tired face
		'261' => '&#63910;', // Sleepy (Zzz)
		'262' => '&#63905;', // angry
		'263' => '&#xE72E;', // tear
		'264' => '&#xE728;', // bleah
		'265' => '&#63891;', // heart break
		'266' => '&#63892;', // double hearts
		'268' => '&#63907;', // bomb
		'273' => '&#63902;', // kiss mark
		'278' => '&#63652;', // flower circle
		'279' => '&#xE734;', // secret
		'281' => '&#63906;', // punch
		'282' => '&#63917;', // dashing
		'287' => '&#xE727;', // ok hand sign
		'288' => '&#63723;', // TV set
		'289' => '&#63703;', // microphone (kara-oke)
		'290' => '&#xE70F;', // wallet
		'291' => '', // musical note
		'294' => '&#63707;', // music
		'295' => '&#xE710;', // rouge
		'299' => '&#63867;', // free
		'300' => '&#63725;', // CD/DVD
		'303' => '&#63903;', // updated
		'305' => '&#63653;', // fog
		'306' => '&#63669;', // golf
		'307' => '&#63673;', // basket ball
		'309' => '&#63708;', // art
		'310' => '&#63709;', // performance
		'311' => '&#63710;', // event (circus)
		'312' => '&#63717;', // ribbon
		'313' => '&#63719;', // birthday
		'314' => '&#63727;', // spade mark (cards)
		'315' => '&#63728;', // diamond mark (cards)
		'316' => '&#63729;', // pam mark (cards)
		'317' => '&#63730;', // eyes
		'318' => '&#63731;', // ear
		'319' => '&#63733;', // scissors (hands)
		'320' => '&#63734;', // paper (hands)
		'321' => '&#63808;', // new moon
		'322' => '&#63809;', // eclipsed moon
		'323' => '&#63810;', // half moon
		'324' => '&#63872;', // clear button
		'325' => '&#63888;', // zero
		'326' => '&#63920;', // ok
		'327' => '&#63897;', // very tired face
		'333' => '&#xE74C;', // ramen (donburi)
		'334' => '&#63874;', // new
		'337' => '&#xE716;', // personal computer
		'339' => '&#xE748;', // rose
		'340' => '&#xE713;', // church
		'341' => '&#63677;', // subway
		'342' => '&#xE740;', // Mt.Fuji
		'343' => '&#63707;', // music
		'354' => '&#xE71A;', // crown
		'358' => '&#xE747;', // read leaves
		'375' => '&#63686;', // post office
		'376' => '&#63687;', // hospital
		'377' => '&#xE73E;', // school
		'378' => '&#63690;', // hotel
		'379' => '&#63682;', // ship
		'380' => '&#xE738;', // NG / prohibited for U-18
		'381' => '[|i.]',    // anntena mark
		'382' => '[cool]',   // cool
		'383' => '[]',     // discount mark
		'384' => '[T]',     // service mark
		'385' => '&#63868;', // ID mark
		'386' => '&#xE73B;', // full mark
		'387' => '&#xE739;', // vacant mark
		'388' => '[w]',     // reserved mark
		'389' => '[c]',     // in-business mark
		'390' => '',       // upside finger
		'391' => '',       // downside finger
		'393' => '&#63721;', // manner mode
		'394' => '&#63721;', // power off
		'395' => '&#63722;', // make a memo
		'400' => '&#xE74B;', // tokkkuri,ochoko
		'401' => '&#63699;', // beer (cheers)
		'410' => '&#63702;', // hair salon
		'414' => '&#63726;', // heart mark (cards)
		'421' => '&#63672;', // ski
		'422' => '',       // oval
		'423' => '&#xE71E;', // green tea
		'424' => '&#xE74D;', // bread
		'434' => '&#xE745;', // apple
		'715' => '&#xE751;', // fish
		'728' => '&#63737;', // foot print
		'729' => '&#63738;', // shoe
		'803' => '&#63890;', // swing heart
		'804' => '&#xE74F;', // chick
		'805' => '&#xE711;', // jeans
		'806' => '&#xE717;', // love letter
		'810' => '&#xE73F;', // tidal wave
		'811' => '&#xE746;', // twin leave
		'812' => '&#xE74E;', // snail
		'817' => '&#63732;', // rock (hands)
		'\\d+' => '',      // (catch all)
	);
	$pat = preg_replace('/^(.*)$/', '!<img localsrc="$1"( alt="([^\\\\"]|\\\\")*?")? ?/?>!', array_keys($chars));
	$buffer = preg_replace($pat, $chars, $buffer);
	return $buffer;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_pre_split($buffer) {
//	$buffer = preg_replace('#<img src="([^>]*?)\.png"#', '<img src="\\1.gif"', $buffer);
	return parent::shrink_pre_split($buffer);
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Service_imode_mova class
   ================================================== */

class Ktai_Service_imode_mova extends Ktai_Service_imode {

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	$this->type       = 'mova';
	preg_match('!1\.0/([-_.a-zA-Z0-9]+)(/c(\d+)(/\w+)*?(/ser(\w+))?)?!', $user_agent, $specs);
	$this->term_name  = $specs[1];
	$this->term_ID    = @$specs[6];
	$this->page_size  = 5000;
	$this->cache_size = ($specs[3] > 0) ? intval($specs[3]) * 1024 : 5120;
	$this->preamble   = '';
	return;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_post_split($buffer) {
	$buffer = preg_replace('#\s*</(li|dt|dd)>\s*#', '', $buffer);
	$buffer = preg_replace('!<([-~_= a-zA-Z0-9%.,:;\'"#*/+]+?) ?/>!', '<$1>', $buffer); //"
	return parent::shrink_post_split($buffer);
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Service_imode_FOMA class
   ================================================== */

class Ktai_Service_imode_FOMA extends Ktai_Service_imode {

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	$this->type       = 'FOMA';
	preg_match('!2\.\d ([-_.a-zA-Z0-9]+)\(c(\d+)(;\w+)*?(;ser(\w+);icc(\w+))?\)!', $user_agent, $specs);
	$this->term_name  = $specs[1];
	$this->term_ID    = @$specs[5];
	$this->sub_ID     = @$specs[6];; // use SIM ID for user ID
	$this->page_size  = 10000;
	$this->cache_size = ($specs[2] > 0) ? intval($specs[2]) * 1024 : 102400;
	$this->preamble   = '<?xml version="1.0" encoding="__CHARSET__">
<!DOCTYPE html PUBLIC "-//i-mode group (ja)//DTD XHTML i-XHTML(Locale/Ver.=ja/1.0) 1.0//EN" "i-xhtml_4ja_10.dtd">';
	return;
}

// ===== End of class ====================
}
?>