<?php
/* ͕h~̂߂̓{ꕶłB
   ̃\[Xt@C Shift_JIS ŕۑĂ܂B
   Above is a Japanese strings to avoid charset mis-understanding.
   This source file is saved with Shift_JIS. */

/* ==================================================
 *   Ktai_Service_EZweb class
   ================================================== */

class Ktai_Service_EZweb extends Ktai_Services {
	// http://www.au.kddi.com/ezfactory/tec/spec/4_4.html
	static public $devID_to_name = array(
		"ST34" => array("W62SA", 1), 
		"PT33" => array("W61PT", 1), 
		"MA33" => array("W61P", 1), 
		"CA3A" => array("W61CA", 1), 
		"KC3D" => array("W61K", 1), 
		"SA3B" => array("W54SA", 1), 
		"SH34" => array("W61SH", 1), 
		"SN3C" => array("W54S", 1), 
		"TS3H" => array("W56T", 1), 
		"TS3G" => array("W55T", 1), 
		"HI3B" => array("W53H", 1), 
		"KC3B" => array("W53K", 1), 
		"ST33" => array("INFOBAR 2", 1), 
		"KC3E" => array("W44K II (Camera Less)", 1), 
		"SN3B" => array("W53S", 1), 
		"CA39" => array("W53CA", 1), 
		"ST32" => array("W53SA", 1), 
		"TS3E" => array("W54T", 1), 
		"SH33" => array("W52SH", 1), 
		"CA38" => array("W52CA", 1), 
		"MA32" => array("W52P", 1), 
		"SN3A" => array("W52S", 1), 
		"TS3D" => array("W53T", 1), 
		"SA3A" => array("W52SA", 1), 
		"HI3A" => array("W52H", 1), 
		"KC3A" => array("MEDIA SKIN", 1), 
		"SH32" => array("W51SH", 1), 
		"SN39" => array("W51S", 1), 
		"TS3C" => array("W52T", 1), 
		"TS3B" => array("W51T", 1), 
		"SA39" => array("W51SA", 1), 
		"HI39" => array("W51H", 1), 
		"CA37" => array("W51CA", 1), 
		"MA31" => array("W51P", 1), 
		"KC39" => array("W51K", 1), 
		"TS39" => array("DRAPE", 1), 
		"TS3A" => array("W47T", 1), 
		"SN38" => array("W44S", 1), 
		"KC38" => array("W44K/K II", 1), 
		"SA38" => array("W43SA", 1), 
		"TS38" => array("W45T", 1), 
		"CA35" => array("W43CA", 1), 
		"HI38" => array("W43H/H II", 1), 
		"SN37" => array("W43S", 1), 
		"KC37" => array("W43K", 1), 
		"ST31" => array("W42SA", 1), 
		"SH31" => array("W41SH", 1), 
		"CA34" => array("W42CA", 1), 
		"HI37" => array("W42H", 1), 
		"TS37" => array("W44T/T II/T III", 1), 
		"TS35" => array("neon", 1), 
		"TS36" => array("W43T", 1), 
		"SN36" => array("W42S", 1), 
		"KC36" => array("W42K", 1), 
		"KC35" => array("W41K", 1), 
		"SA36" => array("W41SA", 1), 
		"TS34" => array("W41T", 1), 
		"HI36" => array("W41H", 1), 
		"CA33" => array("W41CA", 1), 
		"SN34" => array("W41S", 1), 
		"HI34" => array("PENCK", 1), 
		"SA35" => array("W33SA/SA II", 1), 
		"TS33" => array("W32T", 1), 
		"SA34" => array("W32SA", 1), 
		"KC34" => array("W32K", 1), 
		"HI35" => array("W32H", 1), 
		"SN33" => array("W32S", 1), 
		"SN35" => array("W32S", 1), 
		"CA32" => array("W31CA", 1), 
		"TS32" => array("W31T", 1), 
		"SN32" => array("W31S", 1), 
		"KC33" => array("W31K/K II", 1), 
		"SA33" => array("W31SA/SA II", 1), 
		"SA32" => array("W22SA", 1), 
		"HI33" => array("W22H", 1), 
		"CA31" => array("W21CA/CA II", 1), 
		"TS31" => array("W21T", 1), 
		"SA31" => array("W21SA", 1), 
		"SN31" => array("W21S", 1), 
		"KC32" => array("W21K", 1), 
		"HI32" => array("W21H", 1), 
		"KC31" => array("W11K", 1), 
		"HI31" => array("W11H", 1), 
		"CA36" => array("E03CA", 1), 
		"SA37" => array("E02SA", 1), 
		"ST2C" => array("Sweets cute", 0), 
		"ST29" => array("Sweets pure", 0), 
		"CA28" => array("G'zOne TYPE-R", 0), 
		"ST26" => array("Sweets", 0), 
		"ST25" => array("talby", 0), 
		"ST22" => array("INFOBAR", 0), 
		"KC2A" => array("A5528K", 0), 
		"SA2A" => array("A5527SA", 0), 
		"KC29" => array("A5526K", 0), 
		"ST2D" => array("A5525SA", 0), 
		"TS2D" => array("A5523T", 0), 
		"SA29" => array("A5522SA", 0), 
		"KC28" => array("A5521K", 0), 
		"ST2A" => array("A5520SA/SA II", 0), 
		"ST28" => array("A5518SA", 0), 
		"TS2C" => array("A5517T", 0), 
		"TS2B" => array("A5516T", 0), 
		"KC27" => array("A5515K", 0), 
		"ST27" => array("A5514SA", 0), 
		"CA27" => array("A5512CA", 0), 
		"TS2A" => array("A5511T", 0), 
		"TS29" => array("A5509T", 0), 
		"ST24" => array("A5507SA", 0), 
		"TS28" => array("A5506T", 0), 
		"SA27" => array("A5505SA", 0), 
		"TS27" => array("A5504T", 0), 
		"SA26" => array("A5503SA", 0), 
		"KC24" => array("A5502K", 0), 
		"KC25" => array("A5502K", 0), 
		"TS26" => array("A5501T", 0), 
		"CA26" => array("A5407CA", 0), 
		"CA25" => array("A5406CA", 0), 
		"ST23" => array("A5405SA", 0), 
		"SN25" => array("A5404S", 0), 
		"CA24" => array("A5403CA", 0), 
		"SN24" => array("A5402S", 0), 
		"CA23" => array("A5401CA II", 0), 
		"CA23" => array("A5401CA", 0), 
		"ST21" => array("A5306ST", 0), 
		"KC22" => array("A5305K", 0), 
		"TS24" => array("A5304T", 0), 
		"HI24" => array("A5303H II", 0), 
		"HI23" => array("A5303H", 0), 
		"CA22" => array("A5302CA", 0), 
		"TS23" => array("A5301T", 0), 
		"SA22" => array("A3015SA", 0), 
		"PT22" => array("A3016PT", 0), 
		"PT21" => array("A1405PT", 0), 
		"SN29" => array("A1404S/S II", 0), 
		"KC26" => array("A1403K/B01K", 0), 
		"SN27" => array("A1402S", 0), 
		"SN28" => array("A1402S II (Camera Less)", 0), 
		"SN26" => array("A1402S", 0), 
		"KC23" => array("A1401K", 0), 
		"SA28" => array("A1305SA", 0), 
		"TS25" => array("A1304T II", 0), 
		"TS25" => array("A1304T II", 0), 
		"TS25" => array("A1304T (Camera Less)", 0), 
		"SA25" => array("A1303SA", 0), 
		"SA24" => array("A1302SA", 0), 
		"SN23" => array("A1301S", 0), 
		"ST14" => array("A1014ST", 0), 
		"SN21" => array("A3014S", 0), 
		"TS22" => array("A3013T", 0), 
		"CA21" => array("A3012CA", 0), 
		"SA21" => array("A3011SA", 0), 
		"SN22" => array("A1101S", 0), 
		"KC14" => array("A1012K II", 0), 
		"KC14" => array("A1012K", 0), 
		"ST13" => array("A1011ST", 0), 
		"MA21" => array("C3003P", 0), 
		"KC21" => array("C3002K", 0), 
		"HI21" => array("C3001H", 0), 
		"SN17" => array("C1002S", 0), 
		"SY15" => array("C1001SA", 0), 
		"CA14" => array("C452CA", 0), 
		"HI14" => array("C451H", 0), 
		"TS14" => array("C415T", 0), 
		"KC13" => array("C414K II", 0), 
		"KC13" => array("C414K", 0), 
		"SN15" => array("C413S", 0), 
		"SN16" => array("C413S", 0), 
		"SY14" => array("C412SA", 0), 
		"ST12" => array("C411ST", 0), 
		"TS13" => array("C410T", 0), 
		"CA13" => array("C409CA", 0), 
		"MA13" => array("C408P", 0), 
		"HI13" => array("C407H", 0), 
		"SN13" => array("C406S", 0), 
		"SY13" => array("C405SA", 0), 
		"SN12" => array("C404S", 0), 
		"SN14" => array("C404S", 0), 
		"ST11" => array("C403ST", 0), 
		"DN11" => array("C402DE", 0), 
		"SY12" => array("C401SA", 0), 
		"KCTE" => array("TK51", 0), 
		"TST9" => array("TT51", 0), 
		"KCU1" => array("TK41", 0), 
		"SYT5" => array("TS41", 0), 
		"KCTD" => array("TK40", 0), 
		"TST8" => array("TT32", 0), 
		"TST7" => array("TT31", 0), 
		"KCTC" => array("TK31", 0), 
		"SYT4" => array("TS31", 0), 
		"KCTB" => array("TK23", 0), 
		"KCTA" => array("TK22", 0), 
		"TST6" => array("TT22", 0), 
		"KCT9" => array("TK21", 0), 
		"TST5" => array("TT21", 0), 
		"TST4" => array("TT11", 0), 
		"KCT8" => array("TK12", 0), 
		"SYT3" => array("TS11", 0), 
		"KCT7" => array("TK11", 0), 
		"MIT1" => array("TD11", 0), 
		"MAT3" => array("TP11", 0), 
		"KCT6" => array("TK05", 0), 
		"TST3" => array("TT03", 0), 
		"KCT5" => array("TK04", 0), 
		"KCT4" => array("TK03", 0), 
		"SYT2" => array("TS02", 0), 
		"MAT1" => array("TP01", 0), 
		"MAT2" => array("TP01", 0), 
		"TST2" => array("TT02", 0), 
		"KCT3" => array("TK0K", 0), 
		"KCT2" => array("TK02", 0), 
		"KCT1" => array("TK01", 0), 
		"TST1" => array("TT01", 0), 
		"SYT1" => array("TS01", 0), 
		);

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	$this->theme      = ks_option('ks_theme_ezweb');
	$this->user_agent = $user_agent;
	$this->operator   = 'KDDI';
	$this->sub_ID     = @$_SERVER['HTTP_X_UP_SUBNO'];
	$this->charset    = 'SJIS-win';
	$this->mime_type  = 'text/html';
	$this->preamble   = '<?xml version="1.0" encoding="__CHARSET__"?>
<!DOCTYPE html PUBLIC "-//OPENWAVE//DTD XHTML 1.0//EN" "http://www.openwave.com/DTD/xhtml-basic.dtd">';
	$this->require_id_msg = __("ERROR: Please configure to send you EZ number (subscriber ID).\nGo au one top &gt; au customer support &gt; Apply/Change &gt; EZ number sending preference.", 'ktai_style');
	return;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function replace_smiley($buffer) {
	$smiles = array(
		'icon_smile.gif'     => "\xf6\x49", // 257
		'icon_biggrin.gif'   => "\xf3\xa1", // 454
		'icon_sad.gif'       => "\xf3\x94", // 441
		'icon_surprised.gif' => "\xf7\xf5", // 350
		'icon_eek.gif'       => "\xf3\x9e", // 451
		'icon_confused.gif'  => "\xf3\x97", // 444
		'icon_cool.gif'      => "\xf3\x58", // 382
		'icon_mad.gif'       => "\xf6\x4a", // 258
		'icon_razz.gif'      => "\xf6\xc0", // 264
		'icon_neutral.gif'   => "\xf3\x93", // 440
		'icon_wink.gif'      => "\xf7\xf3", // 348
		'icon_lol.gif'       => "\xf4\x6b", // 789
		'icon_redface.gif'   => "\xf7\xf4", // 349 (446 is better?)
		'icon_cry.gif'       => "\xf6\x4b", // 259
		'icon_evil.gif'      => "\xf6\xc8", // 277 
		'icon_twisted.gif'   => "\xf6\xc8", // 277
		'icon_rolleyes.gif'  => "\xf3\x95", // 442
		'icon_exclaim.gif'   => "\xf6\x5a", // 2
		'icon_question.gif'  => "\xf6\x5b", // 3
		'icon_idea.gif'      => "\xf6\x4e", // 77
		'icon_arrow.gif'     => "\xf7\x6e", // 63
		'icon_mrgreen.gif'   => "\xf4\x85", // 814
	);
	return parent::replace_smiley($buffer, $smiles);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function convert_char($buffer) {
	$chars = array (
		'1'   => "\xf6\x59", // warning (!)
		'2'   => "\xf6\x5a", // exclamation (!)
		'3'   => "\xf6\x5b", // question (?)
		'4'   => "\xf7\x48", // question (Q)
		'5'   => "\xf7\x49", // left triangle
		'6'   => "\xf7\x4a", // right triangle
		'7'   => "\xf7\x4b", // double left triangle
		'8'   => "\xf7\x4c", // double right triangle
		'9'   => "\xf7\x4d", // small rectangle 1 (orange)
		'10'  => "\xf7\x4e", // small rectangle 2 (violet)
		'11'  => "\xf7\x4f", // information simble
		'12'  => "\xf6\x9a", // wine glass
		'13'  => "\xf6\xea", // loud speaker
		'14'  => "\xf7\x96", // doller sign
		'15'  => "\xf6\x5e", // moon (3days)
		'16'  => "\xf6\x5f", // thunder
		'17'  => "\xf7\x50", // middle rectangle 1 (orange)
		'18'  => "\xf7\x51", // middle rectangle 2 (pink)
		'19'  => "\xf7\x52", // middle rhombic 1 (light blue)
		'20'  => "\xf7\x53", // middle rhombic 2 (yellow)
		'21'  => "\xf7\x54", // large rectangle 1 (orange)
		'22'  => "\xf7\x55", // large rectangle 2 (pink)
		'23'  => "\xf7\x56", // small circle 1 (green)
		'24'  => "\xf7\x57", // small circle 2 (red)
		'25'  => "\xf7\x97", // watch
		'26'  => "\xf7\x58", // plus sign
		'27'  => "\xf7\x59", // minus sign
		'28'  => "\xf7\x5a", // star mark 1
		'29'  => "\xf7\x5b", // up arrow
		'30'  => "\xf7\x5c", // down arrow
		'31'  => "\xf7\x5d", // forbidden sign (circle and slash)
		'32'  => "\xf7\x5e", // down triangle
		'33'  => "\xf7\x5f", // up triangle
		'34'  => "\xf7\x60", // double down triangle
		'35'  => "\xf7\x61", // double up triangle
		'36'  => "\xf7\x62", // big rhombic 1 (blue)
		'37'  => "\xf7\x63", // big rhombic 2 (red)
		'38'  => "\xf7\x64", // bigger rectangle 1 (orange)
		'39'  => "\xf7\x65", // bigger rectangle 2 (violet)
		'40'  => "\xf7\x66", // big circle 1 (green)
		'41'  => "\xf7\x67", // big circle 2 (red)
		'42'  => "\xf7\x68", // up-left arrow
		'43'  => "\xf7\x69", // down-right arrow
		'44'  => "\xf6\x60", // sun
		'45'  => "\xf6\x93", // baseball
		'46'  => "\xf7\xb1", // clock
		'47'  => "\xf6\x61", // moon 2 w/face
		'48'  => "\xf6\xeb", // bell (chapel)
		'49'  => "\xf7\x7c", // pushpin
		'50'  => "\xf6\xd3", // face (female)
		'51'  => "\xf7\xb2", // heart
		'52'  => "\xf6\x9b", // bar (martini)
		'53'  => "\xf6\xec", // four-leaf clover
		'54'  => "\xf7\x6a", // trade mark (TM)
		'55'  => "\xf7\x6b", // multiply (cross)
		'56'  => "\xf7\x7d", // document 1 (paper)
		'57'  => "\xf7\x98", // sand clock 1
		'58'  => "\xf6\x54", // sand clock 2
		'59'  => "\xf7\x7e", // floppy disk 1
		'60'  => "\xf6\x62", // snow cristal
		'61'  => "\xf7\x6c", // cross sign 1
		'62'  => "\xf7\x6d", // cross sign 2 (w/rectanble)
		'63'  => "\xf7\x6e", // right arrow
		'64'  => "\xf7\x6f", // left arrow
		'65'  => "\xf6\x9c", // magcup (tea room)
		'66'  => "\xf7\x70", // divide sign
		'67'  => "\xf7\x80", // calendar
		'68'  => "\xf6\xd4", // smile
		'69'  => "\xf6\x63", // star
		'70'  => "\xf7\x71", // up-right arrow
		'71'  => "\xf7\x72", // down-left arrow
		'72'  => "\xf6\xed", // jewelry
		'73'  => "\xf7\x73", // checkmark 1
		'74'  => "\xf6\xb8", // dog (poodle)
		'75'  => "\xf6\x40", // star 3
		'76'  => "\xf6\x44", // spark
		'77'  => "\xf6\x4e", // lamp
		'78'  => "\xf6\xb9", // bird
		'79'  => "\xf7\xac", // folder 1 (closed)
		'80'  => "\xf6\xd5", // face (male)
		'81'  => "\xf7\x74", // copyright mark (C)
		'82'  => "\xf7\x75", // registered mark
		'83'  => "\xf6\x74", // briefcase
		'84'  => "\xf7\xad", // folder 2 (opened)
		'85'  => "\xf7\xb3", // telephone (fixed)
		'86'  => "\xf6\xd6", // pop up memo
		'87'  => "\xf7\x99", // credit card
		'88'  => "\xf7\x76", // up triangle
		'89'  => "\xf7\x77", // down triangle
		'90'  => "\xf7\x90", // USA flag (Stars and Stripes flag)
		'91'  => "\xf6\x75", // notebook 3
		'92'  => "\xf7\x81", // clipboard
		'93'  => "\xf7\xb4", // coffee cup
		'94'  => "\xf6\xee", // camera
		'95'  => "\xf6\x64", // rain
		'96'  => "\xf6\x94", // american football
		'97'  => "\xf7\x82", // book 1 (dark green)
		'98'  => "\xf6\x5c", // keep out sign
		'99'  => "\xf6\x42", // traffic signal
		'100' => "\xf7\x83", // book 2 (blue)
		'101' => "\xf7\x84", // book 3 (brown)
		'102' => "\xf7\x85", // book 4 (dark blue)
		'103' => "\xf7\x86", // document 2
		'104' => "\xf6\xef", // scissors
		'105' => "\xf7\x87", // daily calendar
		'106' => "\xf6\x76", // ticket
		'107' => "\xf6\x65", // cloud
		'108' => "\xf6\xfa", // mail envelope
		'109' => "\xf7\x9a", // check / money
		'110' => "\xf6\xf0", // movie/video camera
		'111' => "\xf7\x9b", // handheld video camera
		'112' => "\xf6\x84", // home
		'113' => "\xf6\xbd", // flower (tulip)
		'114' => "\xf7\x9c", // knife
		'115' => "\xf7\x9d", // video tape (VHS)
		'116' => "\xf6\xd7", // glasses / eye
		'117' => "\xf7\x78", // rotated arrow to right
		'118' => "\xf7\x78", // rotated arrow to left /return mark
		'119' => "\xf7\x79", // magnifier (search)
		'120' => "\xf6\xf2", // key
		'121' => "\xf7\x88", // notebook 1
		'122' => "\xf6\x77", // notebook 2 (opened)
		'123' => "\xf7\x9e", // volt and nut
		'124' => "\xf6\xf3", // shoe (high-heel)
		'125' => "\xf6\x8a", // car (sedan)
		'126' => "\xf7\x9f", // floppy disk 2
		'127' => "\xf7\x91", // chart (bar graph)
		'128' => "\xf7\x92", // line graph
		'129' => "\xf6\xf4", // mailbox
		'130' => "\xf7\xa0", // Maglite (flashlight)
		'131' => "\xf7\x89", // Roldex
		'132' => "\xf7\x7a", // checkmark 2 (violet)
		'133' => "\xf6\xa7", // leaf
		'134' => "\xf6\xba", // hound dog
		'135' => "\xf7\xa1", // battery
		'136' => "\xf7\z7b", // scrool
		'137' => "\xf7\x8a", // pushpin
		'138' => "\xf7\xf5", // lock
		'139' => "\xf7\xa2", // green paper
		'140' => "\xf6\xd8", // leftside finger
		'141' => "\xf6\xd9", // rightside finger
		'142' => "\xf7\x8b", // ledger
		'143' => "\xf6\x78", // clip
		'144' => "\xf6\xa8", // present box
		'145' => "\xf6\xf6", // name tag
		'146' => "\xf6\x85", // knife and fork
		'147' => "\xf7\x8c", // several books
		'148' => "\xf6\x8b", // track
		'149' => "\xf6\x79", // pen
		'150' => "\xf7\xa3", // IDO logo
		'151' => "\xf7\xae", // envelope 2
		'152' => "\xf7\xa4", // spanner
		'153' => "\xf7\xaf", // send box
		'154' => "\xf7\xb0", // recieve box
		'155' => "\xf6\xf7", // telephone (handset)
		'156' => "\xf6\x86", // factory
		'157' => "\xf7\x8d", // ruller 1 (line)
		'158' => "\xf6\x7a", // ruller 2 (triangle)
		'159' => "\xf7\x93", // graph 2
		'160' => "\xf9\x9d", // food 2 (manga meat)
		'161' => "\xf7\xa5", // mobile phone
		'162' => "\xf7\xa6", // ac connector
		'163' => "\xf6\xda", // family
		'164' => "\xf7\xa7", // link sign
		'165' => "\xf6\xf8", // package
		'166' => "\xf6\xf9", // fax machine
		'167' => "\xf6\x66", // Sunny intervals
		'168' => "\xf6\x8c", // air plane
		'169' => "\xf6\x8d", // boat (ship)
		'170' => "\xf6\xa1", // dice
		'171' => "\xf7\xa8", // newspaper
		'172' => "\xf6\x8e", // electric train
		'173' => "\xf7\xa9", // full width black
		'174' => "\xf7\xaa", // half width black
		'175' => "\xf7\xab", // quater width black
		'176' => "\xf6\x55", // smoking
		'177' => "\xf6\x56", // no smoking
		'178' => "\xf6\x57", // wheel chair
		'179' => "\xf6\x58", // beginner driver mark
		'180' => "\xf6\xfb", // one
		'181' => "\xf6\xfc", // two
		'182' => "\xf7\x40", // three
		'183' => "\xf7\x41", // four
		'184' => "\xf7\x42", // five
		'185' => "\xf7\x43", // six
		'186' => "\xf7\x44", // seven
		'187' => "\xf7\x45", // eight
		'188' => "\xf7\x46", // nine
		'190' => "\xf7\x47", // ten
		'190' => "\xf6\x41", // storm
		'191' => "\xf6\x5d", // snowball
		'192' => "\xf6\x67", // Aries (Ram)
		'193' => "\xf6\x68", // Taurus (Bull)
		'194' => "\xf6\x69", // Gemini (Twins)
		'195' => "\xf6\x6a", // Cancer (Crab)
		'196' => "\xf6\x6b", // Leo (Lion)
		'197' => "\xf6\x6c", // Virgo (Virgin)
		'198' => "\xf6\x6d", // Libra (Scales)
		'199' => "\xf6\x6e", // Scorpius (Scorpion)
		'200' => "\xf6\x6f", // Sagittarius (Archer)
		'201' => "\xf6\x70", // Capricornus (Goat)
		'202' => "\xf6\x71", // Aquarius (Water Bearer)
		'203' => "\xf6\x72", // Pisces (Fishes)
		'204' => "\xf6\x73", // Ophiuchus (Serpent Bearer)
		'205' => "\xf6\x7b", // Automatic Teller Machine
		'206' => "\xf6\x7c", // convenience store
		'207' => "\xf6\x7d", // toilet
		'208' => "\xf6\x7e", // parking
		'209' => "\xf6\x80", // bus stop
		'210' => "\xf6\x81", // location simble (parabola antenna)
		'211' => "\xf6\x82", // anchor (port)
		'212' => "\xf6\x83", // bank
		'213' => "\xf7\x8e", // gas station
		'214' => "\xf7\x8f", // map
		'215' => "\xf6\x87", // bicycle
		'216' => "\xf6\x88", // bus
		'217' => "\xf6\x89", // shinkansen (bullet train)
		'218' => "\xf6\x43", // marathon
		'219' => "\xf6\x8f", // football (soccer)
		'220' => "\xf6\x90", // tennis
		'221' => "\xf6\x91", // snow board
		'222' => "\xf6\x92", // checker flag
		'223' => "\xf6\x45", // amusement park
		'224' => "\xf6\x95", // spa
		'225' => "\xf6\x9f", // pub (japanese red lantern)
		'226' => "\xf6\x97", // movie (clapper board)
		'227' => "\xf6\x98", // night scene
		'228' => "\xf6\x99", // Tokyo Towner
		'229' => "\xf6\x46", // slot machine (777)
		'230' => "\xf6\x47", // decorative banner
		'231' => "\xf6\x9e", // winning the target
		'232' => "\xf6\x9f", // game oontroller
		'233' => "\xf6\xa0", // doller bag
		'234' => "\xf6\xa2", // christmas tree
		'235' => "\xf6\xa3", // cherry blossom
		'236' => "\xf6\xa4", // ghost
		'237' => "\xf6\xa5", // Japan flag (hinomaru)
		'238' => "\xf6\xa6", // water melon
		'239' => "\xf6\xa9", // short cake
		'240' => "\xa6\xaa", // fly pan
		'241' => "\xf6\xab", // cherry
		'242' => "\xf6\xac", // blowfish (fugu)
		'243' => "\xf6\xad", // strawberry
		'244' => "\xf6\xae", // onigiri (rise ball)
		'245' => "\xf6\xaf", // hamberger (fast food)
		'246' => "\xf6\x48", // whale
		'247' => "\xf6\xb0", // rabbit
		'248' => "\xf6\xb1", // horse
		'249' => "\xf6\xb2", // monkey
		'250' => "\xf6\xb3", // frog
		'251' => "\xf6\xb4", // cat
		'252' => "\xf6\xb5", // penguin
		'253' => "\xf6\xb6", // ant
		'254' => "\xf6\xb7", // pig
		'255' => "\xf6\xbb", // palm tree
		'256' => "\xf6\xbc", // sunflower
		'257' => "\xf6\x49", // laugh face
		'258' => "\xf6\x4a", // angry face
		'259' => "\xf6\x4b", // sad face
		'260' => "\xf6\x4c", // tired face
		'261' => "\xf6\x4d", // Sleepy (Zzz)
		'262' => "\xf6\xbe", // angry
		'263' => "\xf6\xbf", // tear
		'264' => "\xf6\xc0", // bleah
		'265' => "\xf6\x4f", // heart break
		'266' => "\xf6\x50", // double hearts
		'267' => "\xf6\x51", // spark 2
		'268' => "\xf6\x52", // bomb
		'269' => "\xf6\x53", // flame
		'270' => "\xf6\xc1", // SOS sign
		'271' => "\xf6\xc2", // biceps
		'272' => "\xf6\xc3", // heart with arrow
		'273' => "\xf6\xc4", // kiss mark
		'274' => "\xf6\xc5", // alien
		'275' => "\xf6\xc6", // naruto
		'276' => "\xf6\xc7", // footprint of dog
		'277' => "\xf6\xc8", // devil
		'278' => "\xf6\xc9", // flower circle
		'279' => "\xf6\xca", // secret
		'280' => "\xf6\xcb", // full score 100
		'281' => "\xf6\xcc", // punch
		'282' => "\xf6\xcd", // dashing
		'283' => "\xf6\xce", // ploppy
		'284' => "\xf6\xcf", // finger sign
		'285' => "\xf6\xd0", // value sign
		'286' => "\xf6\xd1", // skull
		'287' => "\xf6\xd2", // ok hand sign
		'288' => "\xf6\xd8", // TV set
		'289' => "\xf6\xdc", // microphone (kara-oke)
		'290' => "\xf6\xdd", // wallet
		'291' => "\xf6\xde", // musical note
		'292' => "\xf6\xdf", // electric guitar
		'293' => "\xf6\xe0", // violin
		'294' => "\xf6\xe1", // music (headphone)
		'295' => "\xf6\xe2", // rouge
		'296' => "\xf6\xe3", // pistol (action)
		'297' => "\xf6\xe4", // beauty salon
		'298' => "\xf7\x94", // ez mark
		'299' => "\xf7\x95", // free
		'300' => "\xf6\xe5", // CD/DVD
		'301' => "\xf6\xe6", // women's clothing
		'302' => "\xf6\xe7", // UFO
		'303' => "\xf6\xe8", // updated
		'304' => "\xf6\xe9", // syringe
		'305' => "\xf7\xb5", // fog
		'306' => "\xf7\xb6", // golf
		'307' => "\xf7\xb7", // basket ball
		'308' => "\xf7\xb8", // pager
		'309' => "\xf7\xb9", // art
		'310' => "\xf7\xba", // performance
		'311' => "\xf7\xbb", // event (circus)
		'312' => "\xf7\xbc", // ribbon
		'313' => "\xf7\xbd", // birthday
		'314' => "\xf7\xbe", // spade mark (cards)
		'315' => "\xf7\xbf", // diamond mark (cards)
		'316' => "\xf7\xcd", // pam mark (cards)
		'317' => "\xf7\xc1", // eyes
		'318' => "\xf7\xc2", // ear
		'319' => "\xf7\xc3", // scissors (hands)
		'320' => "\xf7\xc4", // paper (hands)
		'321' => "\xf7\xc5", // new moon
		'322' => "\xf7\xc6", // eclipsed moon
		'323' => "\xf7\xc7", // half moon
		'324' => "\xf7\xc8", // clear button
		'325' => "\xf7\xc9", // zero
		'326' => "\xf7\xca", // ok
		'327' => "\xf7\xcb", // very tired face
		'328' => "\xf7\xcc", // fancy (two hearts)
		'329' => "\xf7\xcd", // impact
		'330' => "\xf7\xce", // haste with sweat
		'331' => "\xf7\xcf", // ez plus
		'332' => "\xf7\xd0", // globe
		'333' => "\xf7\xd1", // ramen (donburi)
		'334' => "\xf7\xe5", // new
		'335' => "\xf6\xe6", // men's clothing
		'336' => "\xf7\xe7", // men's shoe
		'337' => "\xf7\xe8", // personal computer
		'338' => "\xf7\xe9", // radio
		'339' => "\xf7\xea", // rose
		'340' => "\xf7\xeb", // church
		'341' => "\xf7\xec", // subway
		'342' => "\xf7\xed", // Mt.Fuji
		'343' => "\xf7\xee", // music
		'344' => "\xf7\xef", // angel
		'345' => "\xf7\xf0", // tiger
		'346' => "\xf7\xf1", // bear
		'347' => "\xf7\xf2", // mouse
		'348' => "\xf7\xf3", // wink
		'349' => "\xf7\xf4", // eyes are heart
		'350' => "\xf7\xf5", // shocked
		'351' => "\xf7\xf6", // confused
		'352' => "\xf7\xf7", // octopus
		'353' => "\xf7\xf8", // rocket
		'354' => "\xf7\xf9", // crown
		'355' => "\xf7\xfa", // make a kiss
		'356' => "\xf7\xfb", // hammer
		'357' => "\xf7\xfc", // fireworks
		'358' => "\xf3\x40", // read leaves
		'359' => "\xf3\x41", // suitcase
		'360' => "\xf3\x42", // fountain
		'361' => "\xf3\x43", // camp
		'362' => "\xf3\x44", // mahjong
		'363' => "\xf3\x45", // versus sign
		'364' => "\xf3\x46", // trophy
		'365' => "\xf3\x47", // turtle
		'366' => "\xf3\x48", // Spain flag
		'367' => "\xf3\x49", // Russia flag
		'368' => "\xf3\x4a", // under construction
		'369' => "\xf3\x4b", // bath
		'370' => "\xf3\x4c", // Japanese holiday mark
		'371' => "\xf3\x4d", // evening scene
		'372' => "\xf3\x4e", // breaking egg
		'373' => "\xf3\x4f", // stock chart
		'374' => "\xf3\x50", // police officer
		'375' => "\xf3\x51", // post office
		'376' => "\xf3\x52", // hospital
		'377' => "\xf3\x53", // school
		'378' => "\xf3\x54", // hotel
		'379' => "\xf3\x55", // ship
		'380' => "\xf3\x56", // NG / prohibited for U-18
		'381' => "\xf3\x57", // anntena mark
		'382' => "\xf3\x58", // cool
		'383' => "\xf3\x59", // discount mark
		'384' => "\xf3\x5a", // service mark
		'385' => "\xf3\x5b", // ID mark
		'386' => "\xf3\x5c", // full mark
		'387' => "\xf3\x5d", // vacant mark
		'388' => "\xf3\x5e", // reserved mark
		'389' => "\xf3\x5f", // in-business mark
		'390' => "\xf3\x60", // upside finger
		'391' => "\xf3\x61", // downside finger
		'392' => "\xf3\x62", // augury (crystal ball)
		'393' => "\xf3\x63", // manner mode
		'394' => "\xf3\x64", // power off
		'395' => "\xf3\x65", // make a memo
		'396' => "\xf3\x66", // neck tie
		'397' => "\xf3\x67", // hibiscus
		'398' => "\xf3\x68", // bouquet
		'399' => "\xf3\x69", // cactus
		'400' => "\xf3\x6a", // tokkkuri,ochoko
		'401' => "\xf3\x6b", // beer (cheers)
		'402' => "\xf3\x6c", // celebration
		'403' => "\xf3\x6d", // medicine (capsule)
		'404' => "\xf3\x6e", // baloon
		'405' => "\xf3\x6f", // cracker
		'406' => "\xf3\x70", // eznavigation
		'407' => "\xf3\x71", // hat
		'408' => "\xf3\x72", // long boot
		'409' => "\xf3\x73", // nail
		'410' => "\xf3\x74", // hair salon
		'411' => "\xf3\x75", // barber
		'412' => "\xf3\x76", // Japanese dress
		'413' => "\xf3\x77", // bikini
		'414' => "\xf3\x78", // heart mark (cards)
		'415' => "\xf3\x79", // shining heart
		'416' => "\xf3\x7a", // heart (blue)
		'417' => "\xf3\x7b", // heart (green)
		'418' => "\xf3\x7c", // heart (yellow)
		'419' => "\xf3\x7d", // heart (purple)
		'420' => "\xf3\x7e", // shining stars
		'421' => "\xf3\x80", // ski
		'422' => "\xf3\x81", // oval
		'423' => "\xf3\x82", // green tea
		'424' => "\xf3\x83", // bread
		'425' => "\xf3\x84", // soft cream
		'426' => "\xf3\x85", // fried potate
		'427' => "\xf3\x86", // dumpling cake
		'428' => "\xf3\x87", // rise cracker
		'429' => "\xf3\x88", // boiled rise
		'430' => "\xf3\x89", // spaghetti
		'431' => "\xf3\x8a", // curry
		'432' => "\xf3\x8b", // oden
		'433' => "\xfe\x8c", // sushi
		'434' => "\xf3\x8d", // apple
		'435' => "\xf3\x8e", // orange
		'436' => "\xf3\x8f", // tomato
		'437' => "\xf3\x90", // eggplant
		'438' => "\xf3\x91", // box lunch (bento)
		'439' => "\xf3\x92", // Japanese nabe (pan meal)
		'440' => "\xf3\x93", // face (fu)
		'441' => "\xf3\x94", // face (sad)
		'442' => "\xf3\x95", // face (win)
		'443' => "\xf3\x96", // face (failed)
		'444' => "\xf3\x97", // face (puzzled)
		'445' => "\xf3\x98", // face (sleepy)
		'446' => "\xf3\x99", // face (hashful)
		'447' => "\xf3\x9a", // face (ghastly)
		'448' => "\xf3\x9b", // face (got cold)
		'449' => "\xf3\x9c", // face (fever)
		'450' => "\xf3\x9d", // face (leer)
		'451' => "\xf3\x9e", // face (amazed)
		'452' => "\xf3\x9f", // face (rushed)
		'453' => "\xf3\xa0", // musical score
		'454' => "\xf3\xa1", // face (smile)
		'455' => "\xf3\xa2", // face (kissing)
		'456' => "\xf3\xa3", // face (light kiss)
		'457' => "\xf3\xa4", // nose
		'458' => "\xf3\xa5", // mouth
		'459' => "\xf3\xa6", // sorry
		'460' => "\xf3\xa7", // clap
		'461' => "\xf3\xa8", // ok finger sign
		'462' => "\xf3\xa9", // booing
		'463' => "\xf3\xaa", // bye-bye
		'464' => "\xf3\xab", // No Good
		'465' => "\xf3\xac", // OK arm sign
		'466' => "\xf3\xad", // apologize
		'467' => "\xf3\xae", // couple
		'468' => "\xf3\xaf", // bunny
		'469' => "\xf3\xb0", // trumpet
		'470' => "\xf3\xb1", // billiard
		'471' => "\xf3\xb2", // swimming
		'472' => "\xf3\xb3", // fire engine
		'473' => "\xf3\xb4", // ambulance
		'474' => "\xf3\xb5", // patrol car
		'475' => "\xf3\xb6", // roller coaster
		'476' => "\xf3\xb7", // kadomatsu
		'477' => "\xf3\xb8", // hinamatsu
		'478' => "\xf3\xb9", // graduation celemony
		'479' => "\xf3\xba", // enrollment celemony
		'480' => "\xf3\xbb", // koinobori
		'481' => "\xf3\xbc", // umbrella
		'482' => "\xf3\xbd", // bride
		'483' => "\xf3\xbe", // shaved ice
		'484' => "\xf3\xbf", // sparkler
		'485' => "\xf3\xc0", // uivalve shell
		'486' => "\xf3\xc1", // wind bell
		'487' => "\xf3\xc2", // halloween
		'488' => "\xf3\xc3", // moon viewing
		'489' => "\xf3\xc4", // Santa Claus
		'490' => "\xf3\xc5", // shooting star
		'491' => "\xf3\xc6", // rainbow
		'492' => "\xf3\xc7", // hotel 2
		'493' => "\xf3\xc8", // sunrise
		'494' => "\xf3\xc9", // top hat
		'495' => "\xf3\xca", // department store
		'496' => "\xf3\xcb", // Japanese castle
		'497' => "\xf3\xcc", // Europian castle
		'498' => "\xf3\xcd", // factory 2
		'499' => "\xf3\xce", // France flag
		'500' => "\xf7\xd2", // Openwave
		'501' => "\xf7\xd3", // locked
		'502' => "\xf7\xd4", // upper case
		'503' => "\xf7\xd5", // lower case
		'504' => "\xf7\xd6", // number
		'505' => "\xf7\xd7", // symbols
		'506' => "\xf7\xd8", // accepted
		'507' => "\xf7\xd9", // checkbox
		'508' => "\xf7\xda", // edit (pen)
		'509' => "\xf7\xdb", // radio button
		'510' => "\xf7\xdc", // magnifier
		'511' => "\xf7\xdd", // back
		'512' => "\xf7\xde", // bookmark
		'513' => "\xf7\xdf", // end
		'514' => "\xf7\xe0", // home
		'515' => "\xf7\xe1", // inbox 1
		'516' => "\xf7\xe2", // marked
		'517' => "\xf7\xe3", // private
		'518' => "\xf7\xe4", // reload
		'700' => "\xf3\xcf", // Germany flag
		'701' => "\xf3\xd0", // Italy flag
		'702' => "\xf3\xd1", // UK flag
		'703' => "\xf3\xd2", // China flag
		'704' => "\xf3\xd3", // Korea flag
		'705' => "\xf3\xd4", // white lady
		'706' => "\xf3\xd5", // Chinese man
		'707' => "\xf3\xd6", // Asian Indian
		'708' => "\xf3\xd7", // grandfather
		'709' => "\xf3\xd8", // grandmother
		'710' => "\xf3\xd9", // baby
		'711' => "\xf3\xda", // construction worker
		'712' => "\xf3\xdb", // princess
		'713' => "\xf3\xdc", // dolphin
		'714' => "\xf3\xdd", // dancing
		'715' => "\xf3\xde", // fish
		'716' => "\xf3\xdf", // caterpillar
		'717' => "\xf3\xe0", // elephant
		'718' => "\xf3\xe1", // koala
		'719' => "\xf3\xe2", // cow
		'720' => "\xf3\xe3", // snake
		'721' => "\xf3\xe4", // hen
		'722' => "\xf3\xe5", // little swine
		'723' => "\xf3\xe6", // camel
		'724' => "\xf3\xe7", // blood type A
		'725' => "\xf3\xe8", // blood type B
		'726' => "\xf3\xe9", // blood type O
		'727' => "\xf3\xea", // blood type AB
		'728' => "\xf3\xeb", // foot print
		'729' => "\xf3\xec", // shoe (sneaker)
		'730' => "\xf3\xed", // flag
		'731' => "\xf3\xee", // curved up arrow
		'732' => "\xf3\xef", // curved down arrow
		'733' => "\xf3\xf0", // !?
		'734' => "\xf3\xf1", // !!
		'735' => "\xf3\xf2", // rotation sign
		'736' => "\xf3\xf3", // melon
		'737' => "\xf3\xf4", // pineapple
		'738' => "\xf3\xf5", // grape
		'739' => "\xf3\xf6", // banana
		'740' => "\xf3\xf7", // corn
		'741' => "\xf3\xf8", // mushroom
		'742' => "\xf3\xf9", // chestnut
		'743' => "\xf3\xfa", // peach
		'744' => "\xf3\xfb", // baked sweet potato
		'745' => "\xf3\xfc", // pizza
		'746' => "\xf4\x40", // turky leg
		'747' => "\xf4\x41", // start festival
		'748' => "\xf4\x42", // tropical drink
		'749' => "\xf4\x43", // dragon
		'750' => "\xf4\x44", // piano
		'751' => "\xf4\x45", // surfin
		'752' => "\xf4\x46", // fishing
		'753' => "\xf4\x47", // bowling
		'754' => "\xf4\x48", // namahage (devil's face)
		'755' => "\xf4\x49", // long-nose-goblin
		'756' => "\xf4\x4a", // panda
		'757' => "\xf4\x4b", // bleah
		'758' => "\xf4\x4c", // big's nose
		'759' => "\xf4\x4d", // flower
		'760' => "\xf4\x4e", // icecream
		'761' => "\xf4\x4f", // dounut
		'762' => "\xf4\x50", // cookie
		'763' => "\xf4\x51", // chocolate
		'764' => "\xf4\x52", // candy (packed)
		'765' => "\xf4\x53", // candy w/bar
		'766' => "\xf4\x54", // blind monkey
		'767' => "\xf4\x55", // mute monkey
		'768' => "\xf4\x56", // deaf monkey
		'769' => "\xf4\x57", // volcano
		'770' => "\xf4\x58", // heart w/ribbon
		'771' => "\xf4\x59", // ABC sign
		'772' => "\xf4\x5a", // pudding
		'773' => "\xf4\x5b", // bee
		'774' => "\xf4\x5c", // ladybug
		'775' => "\xf4\x5d", // hony pod
		'776' => "\xf4\x5e", // green apple
		'777' => "\xf4\x5f", // bank note with feather
		'778' => "\xf4\x60", // dizzy sign
		'779' => "\xf4\x61", // face (fancy angry)
		'780' => "\xf4\x62", // cat (fancy angry)
		'781' => "\xf4\x63", // milky way
		'782' => "\xf4\x64", // cat (kissing)
		'783' => "\xf4\x65", // cat (smile)
		'784' => "\xf4\x66", // mailing
		'785' => "\xf4\x67", // cat (tears and laugh)
		'786' => "\xf4\x68", // face (tears and laugh)
		'787' => "\xf4\x69", // cat (eyes are heart)
		'788' => "\xf4\x6a", // cat (big cry)
		'789' => "\xf4\x6b", // face (big cry)
		'790' => "\xf4\x6c", // cat (tears)
		'791' => "\xf4\x6d", // face (tears)
		'792' => "\xf4\x6e", // cat (firmly)
		'793' => "\xf4\x6f", // party dress
		'794' => "\xf4\x70", // Moyai stone statue
		'795' => "\xf4\x71", // station
		'796' => "\xf4\x72", // Japanese playing cards (hanafuda)
		'797' => "\xf4\x73", // Joker
		'798' => "\xf4\x74", // fryed shrimp
		'799' => "\xf4\x75", // email icon
		'800' => "\xf4\x76", // walking person
		'801' => "\xf4\x77", // lamp of patrol car
		'802' => "\xf4\x78", // ezmovie
		'803' => "\xf4\x79", // swing heart
		'804' => "\xf4\x7a", // chick
		'805' => "\xf4\x7b", // jeans
		'806' => "\xf4\x7c", // love letter
		'807' => "\xf4\x7d", // cycling arrow
		'808' => "\xf4\x7e", // horizontal both arrow
		'809' => "\xf4\x80", // vertical both arrow
		'810' => "\xf4\x81", // tidal wave
		'811' => "\xf4\x82", // twin leave
		'812' => "\xf4\x83", // snail
		'813' => "\xf4\x84", // cat (big smile)
		'814' => "\xf4\x85", // face (big smile)
		'815' => "\xf4\x86", // C mail icon
		'816' => "\xf4\x87", // herb
		'817' => "\xf4\x88", // rock (hands)
		'818' => "\xf4\x89", // number sign (#)
		'819' => "\xf4\x8a", // character (hands up)
		'820' => "\xf4\x8b", // character (banzai)
		'821' => "\xf4\x8c", // character (crestrallen)
		'822' => "\xf4\x8d", // character (fancy angry)
	);
	$pat = preg_replace('/^(.*)$/', '!<img localsrc="$1"( alt="[^"\\\\\\\\]*?(\\\\\\\\.[^"\\\\\\\\]*)*")? ?/?>!', array_keys($chars));
	$buffer = preg_replace($pat, $chars, $buffer);
	$buffer = preg_replace('!(<img localsrc="[^"\\\\]*?(\\\\.[^"\\\\]*)*")( alt="[^"\\\\]*?(\\\\.[^"\\\\]*)*")? ?/?>!', '$1>', $buffer); // catch all
	$entities = array(
		'&spades;' => "\xf7\xbe", // spade mark
		'&#9824;'  => "\xf7\xbe", // spade mark
		'&clubs;'  => "\xf7\xcd", // pam mark
		'&#9827;'  => "\xf7\xcd", // pam mark
		'&hearts;' => "\xf3\x78", // heart
		'&#9829;'  => "\xf3\x78", // heart
		'&#9825;'  => "\xf7\xb2", // white heart
		'&diams;'  => "\xf7\xbf", // diamond mark
		'&#9830;'  => "\xf7\xbf", // diamond mark
	);
	$buffer = str_replace(array_keys($entities), $entities, $buffer);
	return parent::convert_char($buffer);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_pre_split($buffer) {
	$buffer = preg_replace('!<(b|i|em|strong)>(.*?)</\\1>!', '$2', $buffer);
	return parent::shrink_pre_split($buffer);
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Service_EZweb_HDML class
   ================================================== */

class Ktai_Service_EZweb_HDML extends Ktai_Service_EZweb {

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	$this->type = 'HDML';
	preg_match('!^UP\.Browser/\d\.\d+-([A-Za-z0-9]+) !', $user_agent, $specs);
	$dev_ID = $specs[1];
	$this->term_name = @parent::$devID_to_name[$dev_ID][0];
	$this->flat_rate = @parent::$devID_to_name[$dev_ID][1];
	if (! $this->term_name) {
		$this->term_name = "(Unknown au device:$dev_ID)";
		$this->flat_rate = 0;
	}
	$this->page_size  = 7500;
	$this->cache_size = 49152;
	return;
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Service_EZweb_WAP2 class
   ================================================== */

class Ktai_Service_EZweb_WAP2 extends Ktai_Service_EZweb {

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	$this->type = 'WAP2.0';
	preg_match('!^KDDI-([A-Za-z0-9]+) !', $user_agent, $specs);
	$dev_ID = $specs[1];
	$this->term_name = @parent::$devID_to_name[$dev_ID][0];
	$this->flat_rate = @parent::$devID_to_name[$dev_ID][1];
	if (! $this->term_name) {
		$this->term_name = "(Unknown au device:$dev_ID)";
		$this->flat_rate = 1;
	}
	$this->page_size  = 9000;
	$this->cache_size = 102400;
	return;
}

// ===== End of class ====================
}
?>