<?php
/*
 lightpop.php

 Usage:
  <script type="text/javascript" src="lightpop.php?js"></script>
  <link rel="stylesheet" href="lightpop.php?css" type="text/css" media="screen" />
  <script type="text/javascript">LightPop.show(URL, Width, Height);</script>

 Caution:
  Only the same domain is effective to URL. 

 License:
  Released under the GPL license
  http://www.gnu.org/copyleft/gpl.html
*/

if(strstr($_SERVER['PHP_SELF'], 'lightpop.php')) {
  $plugin_uri = dirname($_SERVER['PHP_SELF'])."/";

  // Echo Dynamic JavaScript (.js)
  if (isset($_GET['js'])) {
    header("Content-Type:text/javascript"); ?>
/*
  lightpop JS
  by wokamoto - http://dogmap.jp

  Released under the GPL license
   http://www.gnu.org/copyleft/gpl.html
*/

if (!window.LightPop) {

  var LightPop = {
    // getPageScroll()
    // Returns array with x,y page scroll values.
    // Core code from - quirksmode.org
    getPageScroll: function(){
      var xScroll,yScroll;
      if (window.pageYOffset) {
        xScroll = window.pageXOffset;
        yScroll = window.pageYOffset;
      } else if (document.documentElement && document.documentElement.scrollTop){
        // Explorer 6 Strict
        xScroll = document.documentElement.scrollLeft;
        yScroll = document.documentElement.scrollTop;
      } else if (document.body) {
        // all other Explorers
        xScroll = document.body.scrollLeft;
        yScroll = document.body.scrollTop;
      }
      arrayPageScroll = new Array(xScroll,yScroll);
      return arrayPageScroll;
    },

    // getPageSize()
    // Returns array with page width, height and window width, height
    // Core code from - quirksmode.org
    getPageSize: function(){
      var xScroll, yScroll;
      if (window.innerHeight && window.scrollMaxY) {
        xScroll = document.body.scrollWidth;
        yScroll = window.innerHeight + window.scrollMaxY;
      } else if (document.body.scrollHeight > document.body.offsetHeight){
        // all but Explorer Mac
        xScroll = document.body.scrollWidth;
        yScroll = document.body.scrollHeight;
      } else {
        // Explorer Mac...would also work in Explorer 6 Strict, Mozilla and Safari
        xScroll = document.body.offsetWidth;
        yScroll = document.body.offsetHeight;
      }
      var windowWidth, windowHeight;
      if (window.innerHeight) {
        // all except Explorer
        windowWidth = window.innerWidth;
        windowHeight = window.innerHeight;
      } else if (document.documentElement && document.documentElement.clientHeight) {
        // Explorer 6 Strict Mode
        windowWidth = document.documentElement.clientWidth;
        windowHeight = document.documentElement.clientHeight;
      } else if (document.body) {
        // other Explorers
        windowWidth = document.body.clientWidth;
        windowHeight = document.body.clientHeight;
      }	
      // for small pages with total height less then height of the viewport
      pageHeight = (yScroll < windowHeight) ? windowHeight : yScroll;
      // for small pages with total width less then width of the viewport
      pageWidth = (xScroll < windowWidth) ? windowWidth : xScroll;

      arrayPageSize = new Array(pageWidth,pageHeight,windowWidth,windowHeight);
      return arrayPageSize;
    },

    // initLightpop()
    // Function runs on window load, going through link tags looking for rel="lightpop".
    // These links receive onclick events that enable the lightpop display for their targets.
    // The function also inserts html markup at the top of the page which will be used as a
    // container for the overlay pattern and the inline image.
    initLightpop: function(){
      if (!document.getElementsByTagName){ return; }
      var objBody = document.getElementsByTagName("body").item(0);

      // create overlay div and hardcode some functional styles (aesthetic styles are in CSS file)
      var objOverlay = document.createElement("div");
      objOverlay.setAttribute('id','lightpopOverlay');
      objOverlay.onclick = function () {LightPop.hide(); return false;}
      objOverlay.style.display = 'none';
      objOverlay.style.position = 'absolute';
      objOverlay.style.top = '0';
      objOverlay.style.left = '0';
      objOverlay.style.zIndex = '90';
      objOverlay.style.width = '100%';
      objBody.insertBefore(objOverlay, objBody.firstChild);

      // create lightpop div, same note about styles as above
      var objLightpop = document.createElement("div");
      objLightpop.setAttribute('id','lightpop');
      objLightpop.style.display = 'none';
      objLightpop.style.position = 'absolute';
      objLightpop.style.zIndex = '100';  
      objBody.insertBefore(objLightpop, objOverlay.nextSibling);

      // create inner div
      var objInner = document.createElement("div");
      objInner.setAttribute('id','lightpopInner');
      objLightpop.appendChild(objInner);
    },

    // show()
    // Preloads images. Pleaces new image in lightpop then centers and displays.
    show: function(u,w,h) {
      var loadingImage = '<?php echo $plugin_uri; ?>loading.gif';
      var closeButton = '<?php echo $plugin_uri; ?>close_button.gif';

      // prep objects
      var objOverlay,objLightpop,objInner;
      objOverlay = document.getElementById('lightpopOverlay');
      if (objOverlay==null) {
        LightPop.initLightpop();
        objOverlay = document.getElementById('lightpopOverlay');
      }
      objLightpop = document.getElementById('lightpop');
      objInner = document.getElementById('lightpopInner');
      objInner.innerHTML = "";

      var arrayPageSize = LightPop.getPageSize();
      var arrayPageScroll = LightPop.getPageScroll();

      var href = u.replace("&amp;","&");
      var lightpopWidth = w;
      var lightpopHeight = h;
      var lightpopTop = arrayPageScroll[1] + ((arrayPageSize[3] - 35 - lightpopHeight) / 2);
      var lightpopLeft = ((arrayPageSize[0] - 20 - lightpopWidth) / 2);

      // getKey(key) -- Gets keycode. If 'x' is pressed then it hides the lightpop.
      var getKey = function(e){
        ikeycode = (e == null) ? event.keyCode: e.which;
        key = String.fromCharCode(keycode).toLowerCase();
        if(key == 'x'){LightPop.hide();}
      }

      // listenKey()
      var listenKey = function() {document.onkeypress = getKey;}

      // pause(numberMillis)
      var pause = function(numberMillis) {
        var now = new Date();
        var exitTime = now.getTime() + numberMillis;
        while (true) {
          now = new Date();
          if (now.getTime() > exitTime){return;}
        }
      }

      // center lightpoploadingImage if it exists
      var objLoadingImageLink = document.createElement("a");
      objLoadingImageLink.setAttribute('href','#');
      objLoadingImageLink.onclick = function () {LightPop.hide(); return false;}
      objOverlay.appendChild(objLoadingImageLink);

      objLoadingImage = document.getElementById('lightpopLoadingImage');
      if (objLoadingImage==null) {
        var objLoadingImage = document.createElement("img");
        objLoadingImage.src = loadingImage;
        objLoadingImage.setAttribute('id','lightpopLoadingImage');
        objLoadingImage.style.position = 'absolute';
        objLoadingImage.style.zIndex = '150';
        objLoadingImageLink.appendChild(objLoadingImage);
        objLoadingImage.style.top = (arrayPageScroll[1] + ((arrayPageSize[3] - 17 - objLoadingImage.height) / 2) + 'px');
        objLoadingImage.style.left = (((arrayPageSize[0] - 10 - objLoadingImage.width) / 2) + 'px');
      }
      objLoadingImage.style.display = 'block';

      // set height of Overlay to take up whole page and show
      objOverlay.style.height = (arrayPageSize[1] + 'px');
      objOverlay.style.display = 'block';

      // set height of Lightpop to take up whole page and show
      objLightpop.style.width = lightpopWidth + "px";
      objLightpop.style.height = lightpopHeight + "px";
      objLightpop.style.top = (lightpopTop < 0) ? "0px" : lightpopTop + "px";
      objLightpop.style.left = (lightpopLeft < 0) ? "0px" : lightpopLeft + "px";

      // Get Video Pop
      var xmlhttp;
      try{
        try{
          xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
        }catch(e){
          xmlhttp = new XMLHttpRequest();
        }

        // XMLHttpRequest state change
        xmlhttp.onreadystatechange = function(){
          if(xmlhttp.readyState == 4) {
            if(xmlhttp.status == 200) {
              objInner.style.width = lightpopWidth + "px";
              objInner.style.height = lightpopHeight + "px";

              // create link
              var objLink = document.createElement("a");
              objLink.setAttribute('href','#');
              objLink.setAttribute('title','Click to close');
              objLink.onclick = function () {LightPop.hide(); return false;}
              objInner.appendChild(objLink);

              // create close button image
              var objCloseButton = document.createElement("img");
              objCloseButton.src = closeButton;
              objCloseButton.setAttribute('id','lightpopCloseButton');
              objCloseButton.style.position = 'absolute';
              objCloseButton.style.zIndex = '200';
              objCloseButton.style.left = (lightpopWidth - 5 ) + "px";
              objLink.appendChild(objCloseButton);

              // create xmlHttp Response
              var htmlString = xmlhttp.responseText.replace(/[\r\n]/g,'').replace(/.*<body.*?>(.*?)<\/body>.*$/, "$1");
              var objResponse = document.createElement("div");
              objResponse.setAttribute('id','lightpopInnerChild');
              objResponse.innerHTML = htmlString;
              objInner.appendChild(objResponse);

              // create keyboard message
              var objKeyboardMsg = document.createElement("div");
              objKeyboardMsg.setAttribute('id','lightpopKeyboardMsg');
              objKeyboardMsg.innerHTML = 'press <a href="#" onclick="LightPop.hide(); return false;"><kbd>x</kbd></a> to close';
              objKeyboardMsg.style.position = 'absolute';
              objKeyboardMsg.style.bottom = 5 + "px";
              objKeyboardMsg.style.right = 10 + "px";
              objInner.appendChild(objKeyboardMsg);

              objLoadingImageLink.innerHTML = '';
              objLightpop.style.display = 'block';
            }
          }
        };

        // XMLHttpRequest
        xmlhttp.open("GET", href, true);
        xmlhttp.send(null);
      }catch (e){

      }
    },

    // hide()
    hide: function(){
      // get objects
      var objOverlay,objLightpop,objInner;
      objOverlay = document.getElementById('lightpopOverlay');
      if (objOverlay==null) {
        initLightpop();
        objOverlay = document.getElementById('lightpopOverlay');
      }
      objLightpop = document.getElementById('lightpop');
      objInner = document.getElementById('lightpopInner');
      objInnerChild = document.getElementById('lightpopInnerChild');

      // hide lightpop and overlay
      objOverlay.style.display = 'none';
      objLightpop.style.display = 'none';

      // make select boxes visible
      selects = document.getElementsByTagName("select");
      for (i = 0; i != selects.length; i++) {selects[i].style.visibility = "visible";}

      // disable keypress listener
      document.onkeypress = '';
    }
  }
}
<?php

  // Echo Dynamic CSS (.css)
  } elseif (isset($_GET['css'])) {
    header("Content-Type:text/css"); ?>
#lightpop {background-color:#eee;border-bottom:2px solid #666;border-right:2px solid #666;padding:10px;}
#lightpop img {border:none;clear:both;}
#lightpopDetails {font-size:0.8em;padding-top:0.4em;}
#lightpopCaption {float:left;}
#lightpopKeyboardMsg {float:right;}

#closeButton {float:right;margin-top:5px;margin-right:5px;}

#lightpopOverlay {background-image:url('overlay.png');}
#lightpopOverlay img {border:none;}
* html #lightpopOverlay {background-color:transparent;background-image:url(blank.gif);filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src="<?php echo $plugin_uri; ?>overlay.png", sizingMethod="scale");}
<?php
  }
}
?>
