<?php
/*
Plugin Name: VideoPop Plus
Plugin URI: http://wppluginsj.sourceforge.jp/videopop-plus/
Description: Add links to your posts and pages that open Videos in a popup window. Upload & administration via the WP admin panel
Version: 0.5.5
Author: wokamoto
Author URI: http://dogmap.jp/

 Released under the GPL license
  http://www.gnu.org/copyleft/gpl.html

 this plugin based on
  VideoPop v.1.3.1(http://www.lynk.de/wordpress/videopop/)
  thanks to Marcus Grellert.

*/

@ini_set("max_execution_time","5000");

load_plugin_textdomain('videopop_plus','wp-content/plugins/videopop_plus');

/*
* function getVideoPopObject()
*/
require("videopop_link.php");

// =============
// CLASS

class VideoPopPlusController {
 var $plugin_name = 'videopop_plus';
 var $plugin_uri,$data_txt,$vids;
 var $options = array();
 var $videosizes = array();
 var $note,$error,$blog_charset;
 var $admin_option,$admin_manage;
 var $wpLightpop_enable = false;

 /*
 * Constructor
 */
 function VideoPopPlusController() {
  $wkoptions = get_option($this->plugin_name." Options");
  if (!is_array($wkoptions)) {
   //----- Options default Value -----
   // User Level Permission -- Subscriber = 0,Contributor = 1,Author = 2,Editor= 7,Administrator = 9
   // Set the user level the user needs to have (at least) to manage/upload/delete videos
   $this->options['user_lvl'] = "7";

   // Show Option
   // "lightpop" or "modalbox" or "popup"
   $this->options['show_option'] = "lightpop";

   // data directory
   $this->options['data_dir'] = "wp-content/videopop/";

   // flvplayer
   $this->options['flvplayer'] = (file_exists(dirname(__FILE__).'/mediaplayer.swf') ? 'mediaplayer.swf' : 'flvplayer.swf');

   // class name
   $this->options['class_name'] = "";
   $this->options['class_name_with_type'] = "0";

   update_option($this->plugin_name." Options", $this->options);

  } else {
   if (!array_key_exists('user_lvl', $wkoptions)) {$wkoptions['user_lvl'] = "7";}
   if (!array_key_exists('show_option', $wkoptions)) {$wkoptions['show_option'] = "lightpop";}
   if (!array_key_exists('data_dir', $wkoptions)) {$wkoptions['data_dir'] = "wp-content/videopop/";}
   if (!array_key_exists('flvplayer', $wkoptions)) {$wkoptions['flvplayer'] = (file_exists(dirname(__FILE__).'/mediaplayer.swf') ? 'mediaplayer.swf' : 'flvplayer.swf');}
   if (!array_key_exists('class_name', $wkoptions)) {$wkoptions['class_name'] = "";}
   if (!array_key_exists('class_name_with_type', $wkoptions)) {$wkoptions['class_name_with_type'] = "0";}
   $this->options = $wkoptions;
  }

  $this->plugin_uri = get_settings('siteurl').'/wp-content/plugins/'.$this->plugin_name;
  $this->data_txt   = ABSPATH.$this->options['data_dir'].'videopopdata.txt';

  // Defaults
  $this->note = '';
  $this->error = 0;
  $this->blog_charset = get_settings('blog_charset');
  $this->admin_option = basename(__FILE__);
  $this->admin_manage = 'manage_VideoPop_Files';

  $this->videosizes = array(
     160 => array('width' => 160, 'height' => 120),
     320 => array('width' => 320, 'height' => 240),
     640 => array('width' => 640, 'height' => 480),
     719 => array('width' => 720, 'height' => 252),
     450 => array('width' => 450, 'height' => 120),
     480 => array('width' => 480, 'height' => 260),
     720 => array('width' => 720, 'height' => 405),
     721 => array('width' => 720, 'height' => 390)
  );

  // wp-lightpop active?
  foreach (get_option("active_plugins") as $val) {
   if (preg_match('/wp\-lightpop\.php/i', $val)) {$this->wpLightpop_enable = true;}
  }

//  // Open file and fill array with unserialized data
//  $this->vids = unserialize(file_get_contents($this->data_txt));
 }

 /*
 * Handles Add/strips slashes to the given array
 */
 function stripArray($array) {
  if(is_array($array)) {
   // If already slashed, strip.
   foreach($array as $key => $value) {$slashed_array[$key] = stripslashes($value);}
  } else {
   return $array;
  }
  return $slashed_array;
 }

 /*
 * Remove dir and all its contents
 */
 function removeDir($dir) {
  if($objs = glob($dir."/*")){
   foreach($objs as $obj) {is_dir($obj)? rmdir($obj) : unlink($obj);}
  }
  rmdir($dir);
 }

 /*
 * Check/Create folder/files
 */
 function checkDir() {
  if(file_exists($this->data_txt)) {
   return true;
  } else {
   if(!is_writable(ABSPATH.'wp-content/')) {
    $this->note .= __("To use <strong>VideoPop+</strong>, the directory <strong>&quot;wp-content&quot;</strong> within your WordPress installation on your webserver must be writeable.<br /><br />To change permission, use a FTP program to access your websever and right-click on the directory <strong>&quot;wp-content&quot;</strong>.<br /> Tick all boxes that say &quot;Write&quot; or set the permission to <strong>777</strong>.", 'videopop_plus');
    $this->error++;
    return false;
   }

   // Create directory
   if(!file_exists(ABSPATH.$this->options['data_dir'])) {
    if(mkdir(ABSPATH.$this->options['data_dir'],0777)!=true) {
     $this->note .= __("The VideoPop+ directory couldn't be created with &quot;mkdir()&quot; on your server. The function could be disabled by your webhost or another restriction is in place. Ask your host.", 'videopop_plus');
     $this->error++;
     return false;
    }
   }

   // Write default file
   $handle = fopen($this->data_txt, 'w');
   if($handle==false) {
    $this->note .= __("The VideoPop+ files couldn't be created with &quot;fopen()&quot; on your server. The function could be disabled by your webhost or another restriction is in place. Ask your host.", 'videopop_plus');
    $this->error++;
    return false;
   } else {
    fwrite($handle,'N;');
    fclose($handle);
    return true;
   }
  }//else
 }//func

 /**
 * Validates form first input
 */
 function valInput() {
  switch(TRUE) {
  case (empty($_POST['lynkvp_name'])):
   $this->note .= __('Please enter a Name.', 'videopop_plus');
   return FALSE; break;
  case (empty($_FILES['lynkvp_file']['size']) && empty($_POST['lynkvp_url'])):
   $this->note .= __('Please choose a Video or enter an URL.', 'videopop_plus');
   return FALSE; break;
  case (empty($_POST['lynkvp_type'])):
   $this->note .= __('Please choose a Video Type.', 'videopop_plus');
   return FALSE; break;
  case ($_POST['lynkvp_size']==0):
   $this->note .= __('Please select a Size.', 'videopop_plus');
   return FALSE; break;
  default:
   return TRUE; break;
  }
 }

 /**
 * returns selected if value in POST array
 */
 function setOptionSelected($option,$value) {
  if (($option == $value)) {
   return ' selected="selected"';
  } else {
   return '';
  }
 }

 /**
 * returns selected if value in POST array
 */
 function getTypeSelect() {
  $retval  = '<tr>';
  $retval  .= ' <td>'.__('Video type', 'videopop_plus').':</td><td><select name="lynkvp_type">';
  $retval  .= ' <option value="0"'.$this->setOptionSelected($_POST['lynkvp_type'],'0').'>'.__('Select video type', 'videopop_plus').'</option>';
  $retval  .= ' <option value="asf"'.$this->setOptionSelected($_POST['lynkvp_type'],'asf').'>.asf</option>';
  $retval  .= ' <option value="avi"'.$this->setOptionSelected($_POST['lynkvp_type'],'avi').'>.avi</option>';
  $retval  .= ' <option value="mp4"'.$this->setOptionSelected($_POST['lynkvp_type'],'mp4').'>.mp4</option>';
  $retval  .= ' <option value="mpg"'.$this->setOptionSelected($_POST['lynkvp_type'],'mpg').'>.mpg</option>';
  $retval  .= ' <option value="mov"'.$this->setOptionSelected($_POST['lynkvp_type'],'mov').'>.mov</option>';
  $retval  .= ' <option value="rm"'.$this->setOptionSelected($_POST['lynkvp_type'],'rm').'>.rm</option>';
  $retval  .= ' <option value="swf"'.$this->setOptionSelected($_POST['lynkvp_type'],'swf').'>.swf</option>';

  if (file_exists(dirname(__FILE__).'/'.$this->options['flvplayer'])) {
   $retval  .= ' <option value="flv"'.$this->setOptionSelected($_POST['lynkvp_type'],'flv').'>.flv</option>';
  }

  $retval  .= ' <option value="wmv"'.$this->setOptionSelected($_POST['lynkvp_type'],'wmv').'>.wmv</option>';
  $retval  .= ' <option value="3gp"'.$this->setOptionSelected($_POST['lynkvp_type'],'3gp').'>.3gp</option>';
  $retval  .= ' </select></td>';
  $retval  .= '</tr>';

  return $retval;
 }

 function insertEditorJs() {
  echo '<script type="text/javascript">'."\n";
  echo 'function vpInsertAtCursor(myField, myValue) {'."\n";
  echo ' var win = window;'."\n";
  echo ' if ( win.tinyMCE ) {'."\n";
  echo '  if (!win) {win = top};'."\n";
  echo '  var tinyMCE = win.tinyMCE;'."\n";
  echo '  richedit = ( typeof tinyMCE == "object" && tinyMCE.configs.length > 0 );'."\n";
  echo '  if ( richedit ) {'."\n";
  echo '   tinyMCE.execCommand("mceInsertContent",false,myValue);'."\n";
  echo '  }else{'."\n";
  echo '   win.edInsertContent(win.edCanvas);'."\n";
  echo '  }'."\n";
  echo ' } else {'."\n";
  echo '  if (document.selection) {'."\n";
  echo '   myField.value += myValue;'."\n";
  echo '  } else if (myField.selectionStart || myField.selectionStart == "0") {'."\n";
  echo '   var startPos = myField.selectionStart;'."\n";
  echo '   var endPos = myField.selectionEnd;'."\n";
  echo '   myField.value = myField.value.substring(0, startPos)+ myValue + myField.value.substring(endPos, myField.value.length);'."\n";
  echo '  } else {'."\n";
  echo '   myField.value += myValue;'."\n";
  echo '  }'."\n";
  echo ' }'."\n";
  echo '}'."\n";
  echo 'function vpEditCode(vp_id,vp_size,vp_name,vp_caption,vp_inline) {';
  echo ' return \'[videopop vid=\' + vp_id + \' vsize=\' + vp_size +\' vtitle="\' + vp_name + \'"\' + (vp_inline==true?\' vinline=true\':\'\') + \']\' + vp_caption + \'[/videopop]\';';
  echo '}'."\n";
  echo '</script>'."\n";
 }//func

 /*
 * Set Videopop Script
 */
 function addWpHead($unused) {
  if (!(is_404() || is_page())) {
   $out = '';
   switch($this->options['show_option']) {
   case "lightpop":
    if (!$this->wpLightpop_enable) {
     $out .= '<link rel="stylesheet" href="'.$this->plugin_uri.'/lightpop/lightpop.php?css" type="text/css" media="screen" />'."\n";
    }
    break;

   case "modalbox":
    if (file_exists(dirname(__FILE__).'/modalbox.js') && file_exists(dirname(__FILE__).'/modalbox.css')) {
     $out .= '<link rel="stylesheet" href="'.$this->plugin_uri.'/modalbox.css" type="text/css" media="screen" />'."\n";
    }
    break;

   case "popup":
   case "inline":
   default:
    break;
   }
   echo $out;
  }
 }//func

 function addWpFooter($unused) {
  if (!(is_404() || is_page())) {
   $out = '';
   switch($this->options['show_option']) {
   case "lightpop":
    if ($this->wpLightpop_enable) {
     $arrLigtpop_options = get_option("wp-lightpop Options");
     $lightpop_option = $arrLigtpop_options['lightpop_option'];
     $out .= '<script type="text/javascript">';
     $out .= "(function(jQuery){";
     $out .= "if(jQuery.isFunction(jQuery.fn.lightpop)){";
     $out .= "var l = ".$lightpop_option.";";
     if ($this->options['class_name'] == "") {
      $out .= "jQuery('a[@href*=videopop.php]').lightpop(l);";
     } elseif ($this->options['class_name_with_type'] == "0") {
      $out .= "jQuery('a.".$this->options['class_name']."').lightpop(l);";
     } else {
      $out .= "jQuery('a[@class^=".$this->options['class_name']."]').lightpop(l);";
     }
     $out .= "}})(jQuery);";
     $out .= "</script>"."\n";
     unset($arrLigtpop_options);
    } else {
     $out .= '<script type="text/javascript" src="'.$this->plugin_uri.'/lightpop/lightpop.php?js"></script>'."\n";
     $out .= '<script type="text/javascript">';
     $out .= "function VideoPop(vpsize,vpid){";
     $out .= " url = '".$this->plugin_uri."/videopop.php?vid='+vpid;";
     $out .= " if (window.LightPop){";
     $out .= " xwidth = vpsize+110; xheight = Math.round(vpsize/1.3)+74;";
     $out .= " LightPop.show(url, xwidth, xheight);";
     $out .= " } else {";
     $out .= " xwidth = vpsize+110; xheight = (vpsize/1.3)+94;";
     $out .= " lvp = window.open(url,'','top=100,left=100,status=0,location=0,width='+xwidth+',height='+xheight+'');";
     $out .= " lvp.focus();";
     $out .= " }";
     $out .= "}";
     $out .= "</script>"."\n";
    }
    break;

   case "modalbox":
    if (file_exists(dirname(__FILE__).'/modalbox.js') && file_exists(dirname(__FILE__).'/modalbox.css')) {
     $out .= '<script type="text/javascript" src="'.$this->plugin_uri.'/modalbox.js"></script>'."\n";
    }
    $out .= '<script type="text/javascript">';
    $out .= "function VideoPop(vpsize,vpid){";
    $out .= " if (window.Modalbox){";
    $out .= " url = '".$this->plugin_uri."/videopop.php';";
    $out .= " xwidth = vpsize+110; xheight = Math.round(vpsize/1.3)+124;";
    $out .= " xoptions = {title: 'VideoPop', width: xwidth, height: xheight, params: {vid: vpid}};";
    $out .= " Modalbox.show(url, xoptions);";
    $out .= " } else {";
    $out .= " url = '".$this->plugin_uri."/videopop.php?vid='+vpid;";
    $out .= " xwidth = vpsize+110; xheight = (vpsize/1.3)+94;";
    $out .= " lvp = window.open(url,'','top=100,left=100,status=0,location=0,width='+xwidth+',height='+xheight+'');";
    $out .= " lvp.focus();";
    $out .= " }";
    $out .= "}";
    $out .= "</script>"."\n";
    break;

   case "popup":
    $out .= '<script type="text/javascript">';
    $out .= "function VideoPop(vpsize,vpid){";
    $out .= " url = '".$this->plugin_uri."/videopop.php?vid='+vpid;";
    $out .= " xwidth = vpsize+110; xheight = (vpsize/1.3)+94;";
    $out .= " lvp = window.open(url,'','top=100,left=100,status=0,location=0,width='+xwidth+',height='+xheight+'');";
    $out .= " lvp.focus();";
    $out .= "}";
    $out .= "</script>"."\n";
    break;

   case "inline":
    break;

   default:
    break;
   }
   echo $out;
  }
 }//func

 /*
 * Content Filter
 */
 function addContentFilter($content) {
  global $wpdb, $id, $page;

  $link_format = '';
  $inline = false;
  switch($this->options['show_option']) {
  case "lightpop":
   if ($this->wpLightpop_enable) {
    $link_format = '<a href="%1$s&amp;%3$s" title="%2$s"%5$s>%4$s</a>';
   } else {
    $link_format = '<a href="%1$s" title="%2$s" onclick="javascript:VideoPop(%3$d,\'%1$d\');return false;"%5$s>%4$s</a>';
   }
   break;
  case "modalbox":
  case "popup":
   $link_format = '<a href="%1$s" title="%2$s" onclick="javascript:VideoPop(%3$d,\'%1$d\');return false;"%5$s>%4$s</a>';
   break;
  case "inline":
   $inline = true;
   break;
  default:
   $link_format = '<a href="%1$s" title="%2$s"%5$s>%4$s</a>';
   break;
  }

  $wkClassName = "";
  if (array_key_exists('class_name', $this->options) && $this->options['class_name'] != "") {
   $wkClassName = ' class="'.$this->options['class_name'].'%s"';
  }

  // VideoPop+ tag found
  if (strstr(strtolower($content),'[/videopop]')) {
   $content = mb_convert_encoding($content, "UTF-8", $this->blog_charset);

   // Open file and fill array with unserialized data
   if (!is_array($this->vids)) {$this->vids = unserialize(file_get_contents($this->data_txt));}

   $pattern = '/\[videopop(.*)\](.*)\[\/videopop\]/i';
   $matches = '';

   if(preg_match_all($pattern, $content, $matches)) {

    for ($i=0; $i<count($matches[0]); $i++) {
     // get options
     $options = explode(" v",$matches[1][$i]);
     $vid = 0;
     $vsize = 320;
     for ($j=0; $j<count($options); $j++) {
      if (strstr(strtolower($options[$j]),'id')) {
        $vid = preg_replace('/id=(.*)/i', '$1', $options[$j]);
      } elseif (strstr(strtolower($options[$j]),'inline')) {
        $inline = strstr(strtolower($options[$j]),'true') != false;
      }
     }

     $vtitle = $this->vids[$vid]['lynkvp_name'];
     $vsize = $this->vids[$vid]['lynkvp_size'];
     $vtype = $this->vids[$vid]['lynkvp_type'];
     if ($vtitle == "") {$vtitle = $matches[2][$i];}
     if (array_key_exists('class_name_with_type', $this->options) && $this->options['class_name_with_type'] == "1") {
      $vclass = sprintf($wkClassName,"-".$vtype);
     } else {
      $vclass = sprintf($wkClassName,"");
     }

     $search_strings[$i] = '/' . preg_quote($matches[0][$i], '/') . '/';
     if (!$inline) {
      $src = "";
      if (!$this->wpLightpop_enable) {
       $src = $this->plugin_uri.'/videopop.php?vid='.$vid;
      } else {
       if(!empty($this->vids[$vid]['lynkvp_url'])) {
        $src = 'http://'.$this->vids[$vid]['lynkvp_url'];
       } elseif(file_exists(ABSPATH.$this->options['data_dir'].$this->vids[$vid]['lynkvp_id'].'.'.$this->vids[$vid]['lynkvp_type'])) {
        $src = get_settings('siteurl')."/".$this->options['data_dir'].$this->vids[$vid]['lynkvp_id'].'.'.$this->vids[$vid]['lynkvp_type'];
       }
      }
      $sizes = 'width='.$this->videosizes[$vsize]['width'].'&amp;height='.$this->videosizes[$vsize]['height'];
      $replace_strings[$i]  = sprintf($link_format, $src, $vtitle, $sizes, $matches[2][$i], $vclass);
     } elseif ($vclass != "") {
      $replace_strings[$i]  = sprintf('<div%s>%s<br clear="all" />%s</div>', $vclass, getVideoPopObject($vid, false, $this->options['flvplayer'], '', $this->videosizes), $matches[2][$i]);
     } else {
      $replace_strings[$i]  = sprintf('%s<br clear="all" />%s', getVideoPopObject($vid, false, $this->options['flvplayer'], '', $this->videosizes), $matches[2][$i]);
     }
    }

    $content = preg_replace($search_strings, $replace_strings, $content);
   }
   $content = mb_convert_encoding($content, $this->blog_charset, "UTF-8");
  }

  // VideoPop tag found
  if (strstr(strtolower($content),'class="lynkvp"')) {
   $content = mb_convert_encoding($content, "UTF-8", $this->blog_charset);

   // Open file and fill array with unserialized data
   if (!is_array($this->vids)) {$this->vids = unserialize(file_get_contents($this->data_txt));}

   $pattern = '/<a href="javascript:lynkVideoPop\(([0-9]*),\'([0-9]*)\'\);" class="lynkvp">(.*)<\/a>/i';
   $matches = '';

   if(preg_match_all($pattern, $content, $matches)) {
    for ($i=0; $i<count($matches[0]); $i++) {
     // get options
     $vid = $matches[2][$i];

     $vtitle = $this->vids[$vid]['lynkvp_name'];
     $vsize = $this->vids[$vid]['lynkvp_size'];
     $vtype = $this->vids[$vid]['lynkvp_type'];
     if ($vtitle == "") {$vtitle = $matches[3][$i];}
     if ($vsize == "") {$vsize = $matches[1][$i];}
     if (array_key_exists('class_name_with_type', $this->options) && $this->options['class_name_with_type'] == "1") {
      $vclass = sprintf($wkClassName,"-".$vtype);
     } else {
      $vclass = sprintf($wkClassName,"");
     }

     $search_strings[$i] = '/' . preg_quote($matches[0][$i], '/') . '/';
     if (!$inline) {
      $replace_strings[$i]  = sprintf($link_format, $vid, $vtitle, $vsize, $matches[3][$i], $vclass);
     } elseif ($vclass != "") {
      $replace_strings[$i]  = sprintf('<div%s>%s<br clear="all" />%s</div>', $vclass, getVideoPopObject($vid, false, $this->options['flvplayer'], '', $this->videosizes), $matches[3][$i]);
     } else {
      $replace_strings[$i]  = sprintf('%s<br clear="all" />%s', getVideoPopObject($vid, false, $this->options['flvplayer'], '', $this->videosizes), $matches[3][$i]);
     }

    }
    $content = preg_replace($search_strings, $replace_strings, $content);
   }

   $content = mb_convert_encoding($content, $this->blog_charset, "UTF-8");
  }

  return $content;
 }//func

 /*
 * Add js to admin head
 */
 function adminHead() {
  echo '<script type="text/javascript">';
  echo "function VideoPop(vpsize,vpid){";
  echo " url = '".$this->plugin_uri."/videopop.php?vid='+vpid;";
  echo " xwidth = vpsize+110; xheight = (vpsize/1.3)+94;";
  echo " lvp = window.open(url,'','top=100,left=100,status=0,location=0,width='+xwidth+',height='+xheight+'');";
  echo " lvp.focus();";
  echo "}";
  echo "</script>"."\n";
 }//func

 /*
 * Display option page body
 */
 function optionPage() {
  $out = $uninstall = '';

  // Check write permissions
  if($this->checkDir()) {
   if(isset($_POST['options_update'])) {      // options update

    // strip slashes array
    $_POST = $this->stripArray($_POST);

    $this->options['user_lvl'] = $_POST['vp_userlevel'];
    $this->options['show_option'] = $_POST['vp_show'];
    //$this->options['data_dir'] = $_POST['vp_datadir'];
    //$this->options['flvplayer'] = $_POST['vp_flvplayer'];
    $this->options['class_name'] = $_POST['vp_classname'];
    $this->options['class_name_with_type'] = $_POST['vp_classwithtype'];
    update_option($this->plugin_name." Options", $this->options);

    $_POST = '';
    $this->note .= __('<strong>Done!</strong>', 'videopop_plus');

   } elseif(isset($_POST['uninst'])) {         // uninstall
    $this->removeDir(ABSPATH.$this->options['data_dir']);
    $this->note .= __('All files and folders have (probably) been deleted. Now click <strong>Plugins</strong> in the admin panel above and <b>Deactivate</b> the VideoPop plugin.', 'videopop_plus');
    $this->error++;
    error_reporting(0);
   }
  }

  // Add Options
  $out .= '<div class="wrap">'."\n";
  $out .= '<h2>'.__('VideoPop+ Options', 'videopop_plus').'</h2><br />'."\n";
  $out .= '<form method="post" id="update_options" action="'.get_settings('siteurl')."/wp-admin/admin.php?page=".$this->admin_option.'">'."\n";
  $out .= '<table>'."\n";

  // Add User Level
  //  Permission -- Subscriber = 0, Contributor = 1, Author = 2, Editor = 7, Administrator = 9
  $out .= '<tr>'."\n";
  $out .= '<td><strong>'.__('User Level', 'videopop_plus').'</strong></td>';
  $out .= '<td><select name="vp_userlevel">';
  $out .= '<option value="0"'.$this->setOptionSelected($this->options['user_lvl'],'0').'>'.__('subscriber', 'videopop_plus').'</option>';
  $out .= '<option value="1"'.$this->setOptionSelected($this->options['user_lvl'],'1').'>'.__('contributor', 'videopop_plus').'</option>';
  $out .= '<option value="2"'.$this->setOptionSelected($this->options['user_lvl'],'2').'>'.__('author', 'videopop_plus').'</option>';
  $out .= '<option value="7"'.$this->setOptionSelected($this->options['user_lvl'],'7').'>'.__('editor', 'videopop_plus').'</option>';
  $out .= '<option value="9"'.$this->setOptionSelected($this->options['user_lvl'],'9').'>'.__('administrator', 'videopop_plus').'</option>';
  $out .= '</select>&nbsp;</td>';
  $out .= '<td>'.__('Set the user level the user needs to have (at least) to manage/upload/delete videos', 'videopop_plus').'</td>'."\n";
  $out .= '</tr>'."\n";
  //$out .= '<p>'.__('User Level Permission -- Subscriber = 0, Contributor = 1, Author = 2, Editor = 7, Administrator = 9', 'videopop_plus').'<br /></p>'."\n";

  // Add Method of display
  $out .= '<tr>'."\n";
  $out .= '<td><strong>'.__('Method of display', 'videopop_plus').'</strong></td>';
  $out .= '<td><select name="vp_show">';
  $out .= '<option value="popup"'.$this->setOptionSelected($this->options['show_option'],'popup').'>'.__('Pop up', 'videopop_plus').'</option>';
  $out .= '<option value="lightpop"'.$this->setOptionSelected($this->options['show_option'],'lightpop').'>'.__('LightPop', 'videopop_plus').'</option>';
  $out .= '<option value="modalbox"'.$this->setOptionSelected($this->options['show_option'],'modalbox').'>'.__('ModalBox', 'videopop_plus').'</option>';
  $out .= '<option value="inline"'.$this->setOptionSelected($this->options['show_option'],'inline').'>'.__('In line', 'videopop_plus').'</option>';
  $out .= '<option value="none"'.$this->setOptionSelected($this->options['show_option'],'none').'>'.__('The effect none', 'videopop_plus').'</option>';
  $out .= '</select>&nbsp;</td>';
  $out .= '<td>'.__('Please select it from &quot;Pop up&quot;, &quot;LightPop&quot;, &quot;ModalBox&quot;, &quot;In line&quot;, and &quot;The effect none&quot;.', 'videopop_plus');
  $out .= '<br />'.__("<strong>Attention:</strong> When &quot;ModalBox&quot; is selected, the installation of <a href='http://wildbit.com/demos/modalbox/' title='ModalBox - An easy way to create popups and wizards'>ModalBox.js</a> is separately needed.", 'videopop_plus').'</td>'."\n";
  $out .= '</tr>'."\n";

  //// Add Data Directory Setting
  //$out .= '<tr>'."\n";
  //$out .= '<td><strong>'.__('Data Directory', 'videopop_plus').'</strong></td>';
  //$out .= '<td><input type="text" name="vp_datadir" value="'.$this->options['data_dir'].'"/></td>';
  //$out .= '<td>'.__('Please set the data directory.', 'videopop_plus').'</td>'."\n";
  //$out .= '</tr>'."\n";

  // Add Class Name Setting
  $out .= '<tr>'."\n";
  $out .= '<td><strong>'.__('Class name of the link tag', 'videopop_plus').'</strong></td>';
  $out .= '<td><input type="text" name="vp_classname" value="'.$this->options['class_name'].'"/>&nbsp;</td>';
  $out .= '<td>'.__('Please set the class name of the link tag.', 'videopop_plus').'</td>'."\n";
  $out .= '</tr>'."\n";
  $out .= '<tr>'."\n";
  $out .= '<td></td>';
  $out .= '<td colspan="2"><select name="vp_classwithtype">';
  $out .= '<option value="0"'.$this->setOptionSelected($this->options['class_name_with_type'],'0').'>'.__('Without File Type', 'videopop_plus').'</option>';
  $out .= '<option value="1"'.$this->setOptionSelected($this->options['class_name_with_type'],'1').'>'.__('With File Type', 'videopop_plus').'</option>';
  $out .= '</select>&nbsp;</td>';
  $out .= '</tr>'."\n";

  $out .= '</table>'."\n";

  // Add Update Button
  $out .= '<div style="text-align:right"><input type="submit" name="options_update" value="'.__('Update Options', 'videopop_plus').'" class="button" style="font-size:11px;" /></div>';
  $out .= '</form></div>'."\n";

  // About the file of the video of the FLV form
  $out .= '<div class="wrap">'."\n";
  $out .= '<h2>'.__('About the file of the video of the FLV form', 'videopop_plus').'</h2><br />'."\n";
  $out .= '<p>'.__("It comes to be able to treat the file of the FLV form by preserving free <a href='http://www.jeroenwijering.com/?item=Flash_Video_Player&amp;' title='JW FLV Player'>JW FLV Player</a> in the same to plug-in directory. ", 'videopop_plus').'</p>'."\n";
  $out .= '</div>'."\n";

  // Add uninstall
  $out .= '<div class="wrap">'."\n";
  $out .= '<h2>'.__('Uninstall', 'videopop_plus').'</h2><br />'."\n";
  $out .= '<p>'.__('If you want to keep your videos and the popup functionality of your links but want to get rid of the additional menus in the control panel, just deactivate the plugin.<br />For a complete uninstall including all uploaded videos use the uninstall button.', 'videopop_plus').'</p>'."\n";
  $out .= '<div style="text-align:right"><form method="post" id="uninstall" action="'.get_settings('siteurl')."/wp-admin/admin.php?page=".$this->admin_option.'"><input type="submit" name="uninst" value="'.__('Uninstall VideoPop+', 'videopop_plus').'" onclick="javascript:check=confirm(\''.__('You are about to delete all your settings and Videos! The links you created with VideoPop will not work after uninstall! Proceed with uninstall?', 'videopop_plus').'\');if(check==false) return false;" class="button" style="font-size:11px;" /></form></div></div>'."\n";

  // Note snuff
  if(!empty($this->note)) {
   $this->note  = '<div id="message" class="updated fade"><p>'.$this->note.'</p></div>'."\n";
  }

  // If any error, dont display body
  if($this->error>0) {$out = '';}

  // Output
  echo $this->note."\n";
  echo $out."\n";
 }//func

 /*
 * Display manage page body
 */
 function manageVideoPopPlusFiles() {
  // Check write permissions
  if($this->checkDir()) {

   // IF Video is uploaded
   if(isset($_POST['lynkvp_upload']) AND $this->valInput()) {
    // defaults
    $vid_url = '';
    $vid_file = '';
    $vid_id = time(); // use timestamp for unique id

    if(is_uploaded_file($_FILES['lynkvp_file']['tmp_name'])) {
     // Save file
     $vid_file = $vid_id.'.'.$_POST['lynkvp_type']; // filename+extension

     if(!move_uploaded_file($_FILES['lynkvp_file']['tmp_name'],ABSPATH.$this->options['data_dir'].$vid_file)) {
      $this->note .= __("The file couldn't be saved on your server", 'videopop_plus');
     }
    } elseif(!empty($_POST['lynkvp_url'])) {
     $vid_url = ltrim($_POST['lynkvp_url'],'http://');
    }

    // Open file and fill array with unserialized data
    if (!is_array($this->vids)) {$this->vids = unserialize(file_get_contents($this->data_txt));}

    // Add data to array
    $this->vids[$vid_id]['lynkvp_id'] = $vid_id;
    $this->vids[$vid_id]['lynkvp_filename'] = $vid_file;
    $this->vids[$vid_id]['lynkvp_url'] = $vid_url;
    $this->vids[$vid_id]['lynkvp_type'] = $_POST['lynkvp_type'];
    $this->vids[$vid_id]['lynkvp_size'] = $_POST['lynkvp_size'];
    $this->vids[$vid_id]['lynkvp_name'] = $_POST['lynkvp_name'];
    $this->vids[$vid_id]['lynkvp_caption'] = $_POST['lynkvp_caption'];

    // Save ser. array
    $handle = fopen($this->data_txt, 'w');
    fwrite($handle,serialize($this->vids));
    fclose($handle);

    $_POST = '';
    $this->note .= __('<strong>Done!</strong>', 'videopop_plus');

   } elseif(isset($_POST['lynkvp_edit2'])) {
    if(empty($_POST['lynkvp_name'])) {
     $this->note .= __('Please edit again and enter a name.', 'videopop_plus');
     $_POST = '';

    } elseif(isset($_POST['lynkvp_type']) && empty($_POST['lynkvp_type'])) {
     $this->note .= __('Please edit again and select a video type.', 'videopop_plus');
     $_POST = '';

    } elseif(isset($_POST['lynkvp_url']) && empty($_POST['lynkvp_url']) ) {
     $this->note .= __('Please edit again and enter an URL.', 'videopop_plus');
     $_POST = '';

    } else {
     // Open file and fill array with unserialized data
     if (!is_array($this->vids)) {$this->vids = unserialize(file_get_contents($this->data_txt));}
     $vid_id = $_POST['lynkvp_editid'];

     // Add data to array
     $this->vids[$vid_id]['lynkvp_id'] = $vid_id;
     $this->vids[$vid_id]['lynkvp_filename'] = $_POST['lynkvp_filename'];
     $this->vids[$vid_id]['lynkvp_url'] = $_POST['lynkvp_url'];
     $this->vids[$vid_id]['lynkvp_type'] = $_POST['lynkvp_type'];
     $this->vids[$vid_id]['lynkvp_size'] = $_POST['lynkvp_size'];
     $this->vids[$vid_id]['lynkvp_name'] = $_POST['lynkvp_name'];
     $this->vids[$vid_id]['lynkvp_caption'] = $_POST['lynkvp_caption'];

     // Save ser. array
     $handle = fopen($this->data_txt, 'w');
     fwrite($handle,serialize($this->vids));
     fclose($handle);

     $this->note .= __('<strong>Done!</strong>', 'videopop_plus');

     $_POST = array();
    }

   } elseif(isset($_POST['lynkvp_del'])) {
    // Open file and fill array with unserialized data
    if (!is_array($this->vids)) {$this->vids = unserialize(file_get_contents($this->data_txt));}
    $a_id = array_flip($_POST['lynkvp_del']);

    // Remove Video
    @unlink(ABSPATH.$this->options['data_dir'].$this->vids[$a_id[__('delete', 'videopop_plus')]]['lynkvp_filename']);

    foreach($this->vids as $key=>$value) {
     if($key!=$a_id[__('delete', 'videopop_plus')]) {$a_vids2[$key] = $value;}
    }

    // Save ser. images
    $handle = fopen($this->data_txt, 'w');
    fwrite($handle,serialize($a_vids2));
    fclose($handle);

    $this->note .= __('<strong>Done!</strong>', 'videopop_plus');

   }

   // IF edit
   if(isset($_POST['lynkvp_edit'])) {
    // Video ID
    $a_id = array_flip($_POST['lynkvp_edit']);

    // Open file and fill array with unserialized data
    if (!is_array($this->vids)) {$this->vids = unserialize(file_get_contents($this->data_txt));}

    // Populate POST
    $_POST = $this->vids[$a_id[__('edit', 'videopop_plus')]];

    // strip slashes array
    $_POST = $this->stripArray($_POST);

    $out .= '<div class="wrap" style="text-align:left;">'."\n";
    $out .= '<h2>'.__('Video Edit', 'videopop_plus').'</h2>'."\n";

    $out .= '<form method="post" action="'.get_settings('siteurl')."/wp-admin/admin.php?page=".$this->admin_manage.'" enctype="multipart/form-data">'."\n";
    $out .= '<input type="hidden" name="lynkvp_type" value="'.$_POST['lynkvp_type'].'" />'."\n";

    $out .= '<table border="0" cellpadding="2" cellspacing="0">'."\n";

    $out .= '<tr>'."\n";
    $out .= '<td>'.__('Name','videopop_plus').':</td>'."\n";
    $out .= '<td><input type="text" name="lynkvp_name" value="'.$_POST['lynkvp_name'].'" /></td>'."\n";
    $out .= '</tr>'."\n";

    $out .= '<tr>'."\n";
    $out .= '<td>'.__('Caption','videopop_plus').':</td>'."\n";
    $out .= '<td><input type="text" name="lynkvp_caption" value="'.$_POST['lynkvp_caption'].'" /></td>'."\n";
    $out .= '</tr>'."\n";

    if(!empty($_POST['lynkvp_url'])) {
     $out .= '<tr>'."\n";
     $out .= '<td>'.__('URL', 'videopop_plus').':</td>'."\n";
     $out .= '<td>http://<input type="text" name="lynkvp_url" value="'.$_POST['lynkvp_url'].'" style="width:400px;" /></td>'."\n";
     $out .= '</tr>'."\n";

     $out .= $this->getTypeSelect()."\n";

    } else {
     $out .= '<tr>'."\n";
     $out .= '<td>'.__('Video type', 'videopop_plus').':</td>'."\n";
     $out .= '<td>'.$_POST['lynkvp_type'].'</td>'."\n";
     $out .= '</tr>'."\n";
    }

    $out .= '</table>'."\n";

    $out .= '<br />'."\n";
    $out .= '<input type="hidden" name="lynkvp_size" value="'.$_POST['lynkvp_size'].'" />'."\n";
    $out .= '<input type="hidden" name="lynkvp_editid" value="'.$_POST['lynkvp_id'].'" />'."\n";
    $out .= '<input type="hidden" name="lynkvp_filename" value="'.$_POST['lynkvp_filename'].'" />'."\n";
    $out .= '<input type="submit" name="lynkvp_edit2" value="'.__('edit', 'videopop_plus').'" />'."\n";
    $out .= '</form>'."\n";
    $out .= '</div>'."\n";

   } else {
    // BLOCK Upload
    $out .= '<div class="wrap" style="text-align:left;">'."\n";
    $out .= '<h2>'.__('Video Upload', 'videopop_plus').'</h2>'."\n";

    $out .= '<form method="post" action="'.get_settings('siteurl')."/wp-admin/admin.php?page=".$this->admin_manage.'" enctype="multipart/form-data">'."\n";

    $out .= '<table border="0" cellpadding="2" cellspacing="0">'."\n";

    $out .= '<tr>'."\n";
    $out .= '<td>'.__('Name', 'videopop_plus').':</td><td><input type="text" name="lynkvp_name" value="'.$_POST['lynkvp_name'].'" /></td>'."\n";
    $out .= '</tr>'."\n";

    $out .= '<tr>'."\n";
    $out .= '<td>'.__('Caption', 'videopop_plus').':</td><td><input type="text" name="lynkvp_caption" value="'.$_POST['lynkvp_caption'].'" /></td>'."\n";
    $out .= '</tr>'."\n";

    $out .= '<tr>'."\n";
    $out .= '<td>'.__('Choose video', 'videopop_plus').':</td><td><input type="file" name="lynkvp_file" />&nbsp;&nbsp;&nbsp;'."\n";
    $out .= __('<strong>or</strong>', 'videopop_plus').' &nbsp;&nbsp;'.__('URL', 'videopop_plus').':&nbsp;&nbsp;http://<input type="text" name="lynkvp_url" style="width:400px;" value="'.$_POST['lynkvp_url'].'" /></td>'."\n";
    $out .= '</tr>'."\n";

    $out .= $this->getTypeSelect()."\n";

    $out .= '<tr>'."\n";
    $out .= '<td>'.__('Size', 'videopop_plus').':</td><td><select name="lynkvp_size">'."\n";
    $out .= '<option value="0"'.$this->setOptionSelected($_POST['lynkvp_size'],'0').'>'.__('Select size', 'videopop_plus').'</option>'."\n";
    $out .= '<!-- Video sizes, one each line -->'."\n";
    $out .= '<option value="160"'.$this->setOptionSelected($_POST['lynkvp_size'],'160').'>'.$this->videosizes[160]['width'].' x '.$this->videosizes[160]['height'].'</option>'."\n";
    $out .= '<option value="320"'.$this->setOptionSelected($_POST['lynkvp_size'],'320').'>'.$this->videosizes[320]['width'].' x '.$this->videosizes[320]['height'].'</option>'."\n";
    $out .= '<option value="640"'.$this->setOptionSelected($_POST['lynkvp_size'],'640').'>'.$this->videosizes[640]['width'].' x '.$this->videosizes[640]['height'].'</option>'."\n";
    $out .= '<option value="719"'.$this->setOptionSelected($_POST['lynkvp_size'],'719').'>'.$this->videosizes[719]['width'].' x '.$this->videosizes[719]['height'].'</option>'."\n";
    $out .= '<option value="450"'.$this->setOptionSelected($_POST['lynkvp_size'],'450').'>'.$this->videosizes[450]['width'].' x '.$this->videosizes[450]['height'].' [16:9 - 1.78:1]</option>'."\n";
    $out .= '<option value="480"'.$this->setOptionSelected($_POST['lynkvp_size'],'480').'>'.$this->videosizes[480]['width'].' x '.$this->videosizes[480]['height'].'</option>'."\n";
    $out .= '<option value="720"'.$this->setOptionSelected($_POST['lynkvp_size'],'720').'>'.$this->videosizes[720]['width'].' x '.$this->videosizes[720]['height'].' [16:9 - 1.78:1]</option>'."\n";
    $out .= '<option value="721"'.$this->setOptionSelected($_POST['lynkvp_size'],'721').'>'.$this->videosizes[721]['width'].' x '.$this->videosizes[721]['height'].' [16:9 - 1.85:1]</option>'."\n";
    $out .= '</select></td>'."\n";
    $out .= '</tr>'."\n";

    $out .= '</table>'."\n";

    $out .= '<br />'."\n";
    $out .= '<input type="submit" name="lynkvp_upload" class="button" value="'.__('Upload', 'videopop_plus').'" />'."\n";
    $out .= '</form>'."\n";
    $out .= '</div>'."\n";
   }

   // ---------
   // ALWAYS DISPLAYED

   // BLOCK Your Videos
   $out .= '<div class="wrap" style="text-align:left;">'."\n";
   $out .= '<h2>'.__('My Videos', 'videopop_plus').'</h2>'."\n";
   $out .= '<form method="post" action="'.get_settings('siteurl')."/wp-admin/admin.php?page=".$this->admin_manage.'">'."\n";

   // Open file and fill array with unserialized data
   if (!is_array($this->vids)) {$this->vids = unserialize(file_get_contents($this->data_txt));}

   // If any vids uploaded
   if(is_array($this->vids)) {
    // add JS to manage page;
    $this->adminHead();

    $this->vids = array_reverse($this->vids);

    $link_format = '<a href="'.$this->plugin_uri.'/videopop.php?vid=%1$d" title="%2$s" onclick="javascript:VideoPop(%3$d,\'%1$d\');return false;">%4$s</a>';
    $out .= '<table class="stats">';
    $out .= '<thead><tr>'."\n";
    $out .= '<th>'.__('Name', 'videopop_plus').'</th>'."\n";
    $out .= '<th>'.__('Video type', 'videopop_plus').'</th>'."\n";
    $out .= '<th></th>'."\n";
    $out .= '<th></th>'."\n";
    $out .= '</tr></thead>'."\n";

    $class = "";
    $out .= '<tbody>'."\n";
    foreach($this->vids as $key => $a_value) {
     // strip slashes
     $a_value = $this->stripArray($a_value);

     $src = '../wp-content/videopop/'.$a_value['lynkvp_filename'];
     $is_type = '';
     if(!empty($a_value['lynkvp_url'])) {
      $src = 'http://'.$a_value['lynkvp_url'];
      $is_type = '<span style="font-size:10px;">URL</span>';
     }

     $out .= '<tr'.$class.'>'."\n";
     $out .= '<td>'.sprintf($link_format, $a_value['lynkvp_id'], $a_value['lynkvp_title'], $a_value['lynkvp_size'], $a_value['lynkvp_name']).'&nbsp;&nbsp;</td>'."\n";
     $out .= '<td>'.$a_value['lynkvp_type'].'&nbsp;&nbsp;</td>'."\n";
     $out .= '<td>'.$is_type.'&nbsp;&nbsp;</td>'."\n";
     $out .= '<td><input type="submit" value="'.__('delete', 'videopop_plus').'" name="lynkvp_del['.$a_value['lynkvp_id'].']" onclick="javascript:check=confirm(\''.__('The links you created will not work anymore. Delete?', 'videopop_plus').'\');if(check==false) return false;" class="button" style="font-size:10px;" />&nbsp;&nbsp;&nbsp;<input type="submit" value="'.__('edit', 'videopop_plus').'" name="lynkvp_edit['.$a_value['lynkvp_id'].']" class="button" style="font-size:10px;" /></td>'."\n";
     $out .= '</tr>'."\n";
     $class = ($class=='' ? ' class="alt"' : '');
    }
    $out .= '</tbody>'."\n";
    $out .= '</table>'."\n";
   }

   $out .= '</form>'."\n";
   $out .= '</div>'."\n";
  }

  // Note snuff
  if(!empty($this->note)) {
   $this->note  = '<div id="message" class="updated fade"><p>'.$this->note.'</p></div>'."\n";
  }

  // If any error, dont display body
  if($this->error>0) {$out = '';}

  // Output
  echo $this->note."\n";
  echo $out."\n";
 }//func

 /*
 * Menu on the write pages
 */
 function edit_form_advanced() {
  global $post_ID;

  // Open file and fill array with unserialized data
  if (!is_array($this->vids)) {$this->vids = unserialize(file_get_contents($this->data_txt));}

  // If any vids uploaded
  if(is_array($this->vids)) {
   $this->vids = array_reverse($this->vids);

   $link_format = '<a href="'.$this->plugin_uri.'/videopop.php?vid=%1$d" title="%2$s" onclick="javascript:VideoPop(%3$d,\'%1$d\');return false;">%4$s</a>';

   $out .= '<table>';
   $out .= '<tr>'."\n";
   $out .= '<th>'.__('Name', 'videopop_plus').'</th>'."\n";
   $out .= '<th>'.__('Video type', 'videopop_plus').'</th>'."\n";
   $out .= '<th></th>'."\n";
   $out .= '<th>'.__('In line', 'videopop_plus').'</th>'."\n";
   $out .= '<th></th>'."\n";
   $out .= '</tr>'."\n";

   foreach($this->vids as $key => $a_value) {
    // strip slashes
    $a_value = $this->stripArray($a_value);

    $src = '../wp-content/videopop/'.$a_value['lynkvp_filename'];
    $is_type = '';
    if(!empty($a_value['lynkvp_url'])) {
     $src = 'http://'.$a_value['lynkvp_url'];
     $is_type = '<span style="font-size:10px;">URL</span>';
    }

    $out .= '<tr>'."\n";
    $out .= '<td>'.sprintf($link_format, $a_value['lynkvp_id'], $a_value['lynkvp_title'], $a_value['lynkvp_size'], $a_value['lynkvp_name']).'&nbsp;&nbsp;</td>'."\n";
    $out .= '<td>'.$a_value['lynkvp_type'].'&nbsp;&nbsp;</td>'."\n";
    $out .= '<td>'.$is_type.'&nbsp;&nbsp;</td>'."\n";
    $out .= '<td><center><input type="checkbox" name="inline_'.$a_value['lynkvp_id'].'" value="" /></center></td>'."\n";
    $out .= '<td><input type="submit" value="'.__('Add to Editor', 'videopop_plus').'" name="insert_'.$a_value['lynkvp_id'].'" onclick="javascript:vpInsertAtCursor(document.post.content, vpEditCode(\''.$a_value['lynkvp_id'].'\', \''.$a_value['lynkvp_size'].'\', \''.$a_value['lynkvp_name'].'\', \''.$a_value['lynkvp_caption'].'\', (inline_'.$a_value['lynkvp_id'].'.checked==true?true:false)));return false;" class="button" style="font-size:10px;" /></td>'."\n";
    $out .= '</tr>'."\n";
   }
   $out .= '</table>'."\n";
  }

  $edit_html = '
   <div class="dbx-b-ox-wrapper">
    <fieldset id="videopop-plus" class="dbx-box">
     <div class="dbx-h-andle-wrapper">
      <h3 class="dbx-handle">'.__('My Videos', 'videopop_plus').'</h3>
     </div>
     <div class="dbx-c-ontent-wrapper">
      <div class="dbx-content">
'.$out.'
      </div>
     </div>
    </fieldset>
   </div>
   <div class="dbx-b-ox-wrapper">
   </div>';
  echo $edit_html;
 }//func

 /*
 * Add menu item to WP admin panel
 */
 function addAdminMenu() {
  // Upload and Adminstration
  add_options_page(__('VideoPop+', 'videopop_plus'), __('VideoPop+', 'videopop_plus'), 9, $this->admin_option, array($this,'optionPage'));
  add_submenu_page('edit.php', __('My Videos', 'videopop_plus'), __('My Videos', 'videopop_plus'), $this->options['user_lvl'], $this->admin_manage, array($this,'manageVideoPopPlusFiles'),1);

  // add Menu on the Write Pages
  add_action('dbx_post_advanced', array($this, 'edit_form_advanced'));
  add_action('dbx_page_advanced', array($this, 'edit_form_advanced'));

  // add JS to admin_head
  if (strstr($_SERVER['PHP_SELF'], 'post.php') OR strstr($_SERVER['PHP_SELF'], 'page-new.php') OR strstr($_SERVER['PHP_SELF'], 'post-new.php') OR strstr($_SERVER['PHP_SELF'], 'page.php')){
   add_action('admin_head',array($this,'adminHead'));
   add_action('admin_head',array($this,'insertEditorJs'));
  }
 }

 function addjQueryJs() {
  wp_enqueue_script('jquery');
 }
}//class

// Go, Go, Go!
$VideoPopPlus = & new VideoPopPlusController();

add_action('admin_menu', array(&$VideoPopPlus,'addAdminMenu'));
add_action('admin_print_scripts', array(&$VideoPopPlus,'addjQueryJs'));

add_action('wp_head',array(&$VideoPopPlus, 'addWpHead'));
add_action('wp_footer',array(&$VideoPopPlus, 'addWpFooter'), 1000);

add_filter('the_content',array(&$VideoPopPlus, 'addContentFilter'));

unset($VideoPopPlus);
?>