<?php

/******************************************************************************
 * THIS FILE IS CALLED ONLY.
 *****************************************************************************/
include_once('wp-tmkm-amazon-function.php');
$amazonparse = & new GetAmazonXmlParse();

/******************************************************************************
 * INITIALIZE
 *****************************************************************************/
$AssociatesID = 'tomokametei-22';
$output = '';
$associatesid = !empty($_GET['AID']) ? $_GET['AID'] : $AssociatesID;

$html_head =
		'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">' .
		'<html xmlns="http://www.w3.org/1999/xhtml" lang="ja">' .
		'<head>' .
		'<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />' .
		'<title>wp-tmkm-amazon( WordPress Plugin ) Amazon Search</title>' .
		'<link rel="stylesheet" href="tmkm-amazon-search.css" type="text/css" />' .
		'</head>' .
		'<body>';

$html_foot = '</body></html>';

$search_action	= '<form action="wp-tmkm-amazon-search.php?AID=' . $associatesid . '" method="GET">';
$search_option	= '<p style="display: inline;"><a id="searchpagetop">Amazon 検索</a></p>&nbsp;' .
				'<select name="SearchIndex">' .
				'	<option name="SearchIndex" value="Blended">Amazon.co.jp</option>' .
				'	<option name="SearchIndex" value="Books">和書</option>' .
				'	<option name="SearchIndex" value="ForeignBooks">洋書</option>' .
				'	<option name="SearchIndex" value="Music">音楽</option>' .
				'	<option name="SearchIndex" value="MusicTracks">サウンドトラック</option>' .
				'	<option name="SearchIndex" value="Classical">クラシック</option>' .
				'	<option name="SearchIndex" value="DVD">DVD</option>' .
				'	<option name="SearchIndex" value="VideoGames">ゲーム</option>' .
				'	<option name="SearchIndex" value="Electronics">エレクトロニクス</option>' .
				'	<option value="Kitchen">ホーム &amp; キッチン</option>' .
				'	<option value="Toys">おもちゃ &amp; ホビー</option>' .
				'	<option value="SportingGoods">スポーツ</option>' .
				'	<option value="HealthPersonalCare">ヘルス &amp; ビューティー</option>' .
				'</select>';
$search_field_d	= '<input type="text" size="20" maxlength="50" value="" name="keyword" />&nbsp;<input type="submit" value="Go" />';
$search_mode	= '<input type="hidden" name="mode" value="search" /></form>';


/******************************************************************************
 * MAIN ROUTINE
 *****************************************************************************/
if( isset( $_GET['Page'] ) ){
	$PageNum = (int) $_GET['Page'];
	if( 0==$PageNum ){
		$PageNum = 1;
	}
}else{
	$PageNum = 1;
}

if( ( $_GET['mode'] ) == 'search' ){
	if( ( $_GET['keyword'] ) != '' ){

		if( !empty( $_GET['keyword'] ) ) { $keyword = $_GET['keyword']; }
		$keyword = rawurlencode( $keyword );
		$searchindex = !empty( $_GET['SearchIndex'] ) ? $_GET['SearchIndex'] : 'Blended';

		$responsegroup = 'Images,Small';
		$AmazonXml = $amazonparse->getamazonxml( $associatesid, $keyword, 'plural', $searchindex, $responsegroup ); // --- Call Amazon XML function ---

		$display_keyword = rawurldecode($keyword);
		$search_field_s	= '<input type="text" size="20" maxlength="50" value="' . $display_keyword . '" name="keyword" />&nbsp;<input type="submit" value="Go" />';
		$search_form = $search_action . $search_option . $search_field_s . $search_mode;

		echo $html_head;
		echo $search_form;

		// DEBUG
/*		echo '<pre>';
		print_r($AmazonXml);
		echo '</p>';
*/		// DEBUG

		if( false === $AmazonXml ){  // Amazon function was returned false, so AWS is down
			echo '<p>アマゾンのサーバでエラーが起こっているかもしれません。一度ページを再読み込みしてみてください。</p>';
		}else{ // Amazon function returned XML data

			$status = $AmazonXml["ItemSearchResponse"]["Items"]["Request"];

			if( $status["IsValid"] == 'False' ){ // Request is invalid
				echo '<p>与えられたリクエストが正しくありません</p>';
			}else{ // results were found, so display the products
	
				// --- Display the product data returned from the XML ---
				$item = $AmazonXml["ItemSearchResponse"]["Items"]["Item"];
				$totalresults = (int)$AmazonXml["ItemSearchResponse"]["Items"]["TotalResults"];
				$totalpages =  (int)$AmazonXml["ItemSearchResponse"]["Items"]["TotalPages"];

				if( $totalresults == 0 ){ // no result was found
					echo '「' . $display_keyword . '」の検索結果が見つかりませんでした。';
				} elseif( $totalresults == 1 ) { // one result was found
					echo '<h1>「' .$display_keyword. '」の検索結果は ' .$totalresults. ' 件です。</h1>';

					$smallimage = $amazonparse->get_goods_image($item,'small');
					if( $smallimage == '' ){ $smallimage = './amazon_noimg_small.png'; }
					$itemcount = $i + 1;
	
					$url = $amazonparse->get_amazon_text($item,'url');
					$Title = $amazonparse->get_amazon_text($item,'title');
					$ASIN = $amazonparse->get_amazon_text($item,'asincode');

					$output .=
						'<div id="amazon-search-result"><h1>' . $itemcount . '.</h1><p>' .
						'<!-- product image --><img src="' . $smallimage . '" border="0" alt="" />' .
						'<!-- product name -->' . $Title . '<br />' .
						'<!-- ASIN CODE --><strong>[tmkm-amazon]' . $ASIN . '[/tmkm-amazon]</strong><br />' .
						'<!-- Amazon Link --><a href="' . $url . '" target="_blank">Amazon で詳細をみる</a>' .
						'</p></div>';

				} else { // results were found
					echo '<h1>「' .$display_keyword. '」の検索結果は ' .count($item). ' 件です。</h1>';

					// --- Pagenation ---
/*					$PageCount = (int)( count( $item ) / 10 );
					if( $PageCount > 1){
						echo '<strong>Page:</strong> ';
						for( $k=1; $k<=$PageCount; $k++ ){
							if( $k==$PageNum ){
								echo $k. ' ';
							} else {
								echo '<strong><a href="?mode=search&keyword=' . $keyword .  '&Page=' .$k. '">' .$k. '</a></strong> ';
							}
							if( $PageCount != $k ){ echo '| '; }
						}
					}
*/
					// --- Display the product data returned from the XML ---

					//DEBUG
/*					echo '<pre>';
					print_r($item);
					echo '<p>CountItems : ' . count($item) . '</p>';
					echo '</pre>';
*/					//DEBUG
		
					/**
					* Loop through each <Details> tag.
					* Assign each piece of data you want to use on your template to a variable, and then
					* echo that variable to display it on your site.
					*/

					for( $i=0; $i<count($item); $i++ ) {
//					for( $i=( $PageCount-1 )*10; $i<$PageCount*10-1; $i++ ) {
						$smallimage = $amazonparse->get_goods_image($item[$i],'small');
						if( $smallimage == '' ){ $smallimage = './amazon_noimg_small.png'; }
						$itemcount = $i + 1;
		
						$url = $amazonparse->get_amazon_text($item[$i],'url');
						$Title = $amazonparse->get_amazon_text($item[$i],'title');
						$ASIN = $amazonparse->get_amazon_text($item[$i],'asincode');

						$output .=
							'<div id="amazon-search-result"><h1>' . $itemcount . '.</h1><p>' .
							'<!-- product image --><img src="' . $smallimage . '" border="0" alt="" />' .
							'<!-- product name -->' . $Title . '<br />' .
							'<!-- ASIN CODE --><strong>[tmkm-amazon]' . $ASIN . '[/tmkm-amazon]</strong><br />' .
							'<!-- Amazon Link --><a href="' . $url . '" target="_blank">Amazon で詳細をみる</a>' .
							'</p></div>';
					}

				}
			}
		}
		echo $output;
		echo '<p><a href="#searchpagetop">↑ このページの TOP へ</a></p>';
		echo $html_foot;


	} else {

		echo $html_head;
		echo "<p>No Keyword.</p>";
		echo '<a href="wp-tmkm-amazon-search.php">Back To Search</p>';
		echo $html_foot;

	}


} else {
		$search_form = $search_action . $search_option . $search_field_d . $search_mode;
		echo $html_head;
		echo $search_form;
		echo $html_foot;
}

?>