<?php
/*
Plugin Name: insertyahoomap
Plugin URI: http://wppluginsj.sourceforge.jp/insertyahoomap/
Description: yahooの地図を挿入する。
Version: 1.3.0
Author: Takahiro Yamada
Author URI: http://www.syshawa.co.jp/blog/insertyahoomap-plugin/
*/
/*  Copyright 2009 Takahiro Yamada (email : taka@syshawa.co.jp)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
// 直接実行拒否用
if (ABSPATH == "ABSPATH") { exit(); }

/*********************************************************************
   パラメタの追加
 *********************************************************************/
add_option('insertyahoomap_appid');
add_option('insertyahoomap_select_map_width');
add_option('insertyahoomap_select_map_height');
add_option('insertyahoomap_map_width');
add_option('insertyahoomap_map_height');
add_option('insertyahoomap_map_pos');
add_option('insertyahoomap_map_layer');
add_option('insertyahoomap_map_datum');
add_option('insertyahoomap_default_category');

/*********************************************************************
   共通変数定義
 *********************************************************************/
define('INSERTYAHOOMAPURL', get_option('siteurl') . '/wp-content/plugins/insertyahoomap/');

/*********************************************************************
   パラメタ管理
 *********************************************************************/
// パラメタ管理用のメニュー作成のため、管理メニューに追加するフック
add_action('admin_menu', 'insertyahoomap_menu');
// パラメタ管理用のメニュー作成のため、管理メニューに追加するフック関数
function insertyahoomap_menu() {
	add_options_page('YahooMap挿入用オプション設定', 'YahooMap挿入の設定', 'administrator', 'insertyahoomap-options.php', 'insertyahoomap_options_page');
}
// パラメタ管理用のページ作成のための関数
function insertyahoomap_options_page() {
//コンテンツファイルインクルード
	include('insertyahoomap-options.php');
}

/*********************************************************************
   メディアボタン表示
 *********************************************************************/
// メディアボタン表示のため追加するフック
add_action('media_buttons', 'insertyahoomap_media_buttons', 100);
// メディアボタン表示のため追加するフック関数
function insertyahoomap_media_buttons() {
//コンテンツファイルインクルード
	include('insertyahoomap-media_buttons.php');
}

/*********************************************************************
   YahooMap挿入ウィンドウ作成
 *********************************************************************/
// YahooMap挿入ウィンドウ作成のため追加するフック
add_action('media_upload_insertyahoomap', 'insertyahoomap_media_upload');
// YahooMap挿入ウィンドウ作成のため追加するフック関数
function insertyahoomap_media_upload() {
	wp_iframe('insertyahoomap_media_upload_form');
}
function insertyahoomap_media_upload_form() {
//コンテンツファイルインクルード
	include('insertyahoomap-media_upload.php');
}

/*********************************************************************
   ヘッダー挿入
 *********************************************************************/
// ヘッダー挿入のため追加するフック
add_action('wp_head','insertyahoomap_head', 100);
// ヘッダー挿入のため追加するフック関数
function insertyahoomap_head() {
//コンテンツファイルインクルード
	include('insertyahoomap-head.php');
}
// ヘッダー挿入のため追加するフック
add_action('admin_head', 'insertyahoomap_admin_head', 100);
// ヘッダー挿入のため追加するフック関数
function insertyahoomap_admin_head() {
//コンテンツファイルインクルード
	include('insertyahoomap-admin_head.php');
}

/*********************************************************************
   ショートコード変換
 *********************************************************************/
// ショートコード変換のため追加するフック
add_shortcode('insertyahoomap','insertyahoomap_shortcode');
// ショートコード変換のため追加するフック関数
function insertyahoomap_shortcode($atts) {
//コンテンツファイルインクルード
	include('insertyahoomap-shortcode.php');
	return $out;
}

?>
