<?php
header('Cache-Control: no-cache, must-revalidate');
header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
header('Content-Type: text/plain; charset=UTF-8');

include_once('../../../wp-config.php');
include_once('../../../wp-includes/class-snoopy.php');
$Snoopy = new Snoopy();

// 設定値の取得
$option = get_option('yo_amazon_link');


// リクエストURLの作成
$api_interface = 'http://webservices.amazon.co.jp/onca/xml';
$access_key_id = $option['accessKeyId'];
$secret_access_key = $option['secretAccessKey'];

// パラメーターの設定
$param = array();
$params['Service'] = 'AWSECommerceService';
$params['AssociateTag'] = $option['trackingId'];
$params['AWSAccessKeyId'] = $access_key_id;
$params['Version'] = '2009-07-01';
switch ( $_GET['Operation'] )
{
	case 'ItemLookup':								// ItemLookup
		$params['Operation'] = 'ItemLookup';
		$params['ResponseGroup'] = rfc3986_urlencode('Request,ItemAttributes,Small,Images,SalesRank,Reviews');
		$params['ItemId'] = rfc3986_urlencode($_GET['ItemId']);
		break;
	case 'ItemSearch':								// ItemSearch
	default:
		$params['Operation'] = 'ItemSearch';
		$params['ResponseGroup'] = rfc3986_urlencode('Request,ItemAttributes,Small,Images');
		$params['SearchIndex'] = rfc3986_urlencode($_GET['SearchIndex']);
		$params['Keywords'] = rfc3986_urlencode($_GET['Keywords']);
		$params['ItemPage'] = rfc3986_urlencode($_GET['ItemPage']);
		if ( $_GET['SearchIndex'] != 'Blended' )
		{
			$params['Sort'] = 'salesrank';
		}
}
$params['Timestamp'] = rfc3986_urlencode(gmdate('Y-m-d\TH:i:s\Z'));
ksort($params);

// パラメーターリスト
$param_list = array();
foreach ( $params as $key => $value )
{
	$param_list[] = $key . '=' . $value;
}

// 正規化パラメーター文字列
$canonical_string_param = implode('&', $param_list);

// 署名の作成
$parsed_url = parse_url($api_interface);
$string_to_sign = 'GET' . "\n" . $parsed_url['host'] . "\n" . $parsed_url['path'] . "\n" . $canonical_string_param;
$signature = base64_encode(hash_hmac('sha256', $string_to_sign, $secret_access_key, true));


// リクエスト
$url = $api_interface . '?' . $canonical_string_param . '&Signature=' . rfc3986_urlencode($signature);
$Snoopy->fetch($url);

// レスポンス表示
print $Snoopy->results;


//RFC3986に合わせ、チルダを除外したURLエンコードをする
// Product Advertising API のURLエンコードは RFC3986 準拠
function rfc3986_urlencode($string)
{
	return str_replace('%7E', '~', rawurlencode($string));
}
?>