/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Properties;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.WrapperProcess;
import org.tanukisoftware.wrapper.WrapperProcessConfig;
import org.tanukisoftware.wrapper.WrapperServiceException;
import org.tanukisoftware.wrapper.WrapperWin32Service;
import org.tanukisoftware.wrapper.event.WrapperControlEvent;
import org.tanukisoftware.wrapper.event.WrapperEvent;
import org.tanukisoftware.wrapper.event.WrapperEventListener;
import org.tanukisoftware.wrapper.test.DeadLockBase;
import org.tanukisoftware.wrapper.test.DeadlockPrintStream;
import org.tanukisoftware.wrapper.test.Main;

public abstract class AbstractActionApp
implements WrapperEventListener {
    private static String c_encoding = System.getProperty("sun.jnu.encoding");
    private DeadlockPrintStream m_out;
    private DeadlockPrintStream m_err;
    private Thread m_runner = new Thread(Main.getRes().getString("WrapperActionTest_Runner")){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                if (AbstractActionApp.this.m_users) {
                    System.out.println(Main.getRes().getString("The current user is: {0}", (Object)WrapperManager.getUser((boolean)AbstractActionApp.this.m_groups)));
                    System.out.println(Main.getRes().getString("The current interactive user is: {0}", (Object)WrapperManager.getInteractiveUser((boolean)AbstractActionApp.this.m_groups)));
                }
                Class clazz = class$org$tanukisoftware$wrapper$test$AbstractActionApp == null ? AbstractActionApp.class$("org.tanukisoftware.wrapper.test.AbstractActionApp") : class$org$tanukisoftware$wrapper$test$AbstractActionApp;
                synchronized (clazz) {
                    try {
                        (class$org$tanukisoftware$wrapper$test$AbstractActionApp == null ? AbstractActionApp.class$("org.tanukisoftware.wrapper.test.AbstractActionApp") : class$org$tanukisoftware$wrapper$test$AbstractActionApp).wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    };
    private Thread m_consoleRunner;
    private boolean m_ignoreControlEvents;
    private boolean m_users;
    private boolean m_groups;
    private boolean m_nestedExit;
    private long m_eventMask = -1L;
    private int m_slowSeconds = 0;
    private String m_serviceName = "testWrapper";
    private String m_consoleTitle = "Java Service Wrapper";
    private String m_childCommand = "ls";
    private boolean m_childDetached = true;

    protected AbstractActionApp() {
        this.m_runner.setDaemon(true);
        this.m_runner.start();
    }

    public void fired(WrapperEvent event) {
        System.out.println(Main.getRes().getString("Received event: {0}", (Object)event));
        if (event instanceof WrapperControlEvent) {
            System.out.println(Main.getRes().getString("  Consume and ignore."));
            ((WrapperControlEvent)event).consume();
        }
    }

    protected boolean ignoreControlEvents() {
        return this.m_ignoreControlEvents;
    }

    protected boolean isNestedExit() {
        return this.m_nestedExit;
    }

    protected void setEventMask(long eventMask) {
        this.m_eventMask = eventMask;
    }

    protected void setSlowSeconds(int slowSeconds) {
        this.m_slowSeconds = slowSeconds;
    }

    protected void setServiceName(String serviceName) {
        this.m_serviceName = serviceName;
    }

    protected void setConsoleTitle(String consoleTitle) {
        this.m_consoleTitle = consoleTitle;
    }

    protected void setChildParams(String childCommand, boolean childDetached) {
        this.m_childCommand = childCommand;
        this.m_childDetached = childDetached;
    }

    protected void prepareSystemOutErr() {
        this.m_out = new DeadlockPrintStream(System.out);
        System.setOut(this.m_out);
        this.m_err = new DeadlockPrintStream(System.err);
        System.setErr(this.m_err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doAction(String action) {
        if (action.equals("stop0")) {
            WrapperManager.stop((int)0);
        } else if (action.equals("stop1")) {
            WrapperManager.stop((int)1);
        } else if (action.equals("exit0")) {
            System.exit(0);
        } else if (action.equals("exit1")) {
            System.exit(1);
        } else if (action.equals("nestedexit1")) {
            this.m_nestedExit = true;
            WrapperManager.stop((int)1);
        } else if (action.equals("stopimmediate0")) {
            WrapperManager.stopImmediate((int)0);
        } else if (action.equals("stopimmediate1")) {
            WrapperManager.stopImmediate((int)1);
        } else if (action.equals("stopandreturn0")) {
            WrapperManager.stopAndReturn((int)0);
        } else if (action.equals("halt0")) {
            Runtime.getRuntime().halt(0);
        } else if (action.equals("halt1")) {
            Runtime.getRuntime().halt(1);
        } else if (action.equals("restart")) {
            WrapperManager.restart();
        } else if (action.equals("restartandreturn")) {
            WrapperManager.restartAndReturn();
        } else if (action.equals("access_violation")) {
            WrapperManager.accessViolation();
        } else if (action.equals("access_violation_native")) {
            WrapperManager.accessViolationNative();
        } else if (action.equals("appear_hung")) {
            WrapperManager.appearHung();
        } else if (action.equals("appear_slow")) {
            WrapperManager.appearSlow((int)this.m_slowSeconds);
        } else if (action.equals("appear_slow_1")) {
            WrapperManager.appearSlow((int)1);
        } else if (action.equals("appear_slow_5")) {
            WrapperManager.appearSlow((int)5);
        } else if (action.equals("appear_slow_reset")) {
            WrapperManager.appearSlow((int)0);
        } else if (action.equals("deadlock")) {
            if (WrapperManager.isStandardEdition()) {
                System.out.println(Main.getRes().getString("Creating a 2-object deadlock..."));
                DeadLockBase.create2ObjectDeadlock(false, false);
            } else {
                System.out.println(Main.getRes().getString("Deadlock checks require the Standard Edition."));
            }
        } else {
            if (action.equals("outofmemory")) {
                throw new OutOfMemoryError();
            }
            if (action.equals("ignore_events")) {
                this.m_ignoreControlEvents = true;
            } else if (action.equals("dump")) {
                WrapperManager.requestThreadDump();
            } else if (action.equals("deadlock_out")) {
                System.out.println(Main.getRes().getString("Deadlocking System.out and System.err ..."));
                this.m_out.setDeadlock(true);
                this.m_err.setDeadlock(true);
            } else if (action.equals("users")) {
                if (!this.m_users) {
                    System.out.println(Main.getRes().getString("Begin polling the current and interactive users."));
                    this.m_users = true;
                } else if (this.m_groups) {
                    System.out.println(Main.getRes().getString("Stop polling for group info."));
                    this.m_groups = false;
                } else {
                    System.out.println(Main.getRes().getString("Stop polling the current and interactive users."));
                    this.m_users = false;
                }
                Class clazz = AbstractActionApp.class;
                synchronized (clazz) {
                    AbstractActionApp.class.notifyAll();
                }
            } else if (action.equals("groups")) {
                if (!this.m_users || !this.m_groups) {
                    System.out.println(Main.getRes().getString("Begin polling the current and interactive users with group info."));
                    this.m_users = true;
                    this.m_groups = true;
                } else {
                    System.out.println(Main.getRes().getString("Stop polling for group info."));
                    this.m_groups = false;
                }
                Class clazz = AbstractActionApp.class;
                synchronized (clazz) {
                    AbstractActionApp.class.notifyAll();
                }
            } else if (action.equals("console")) {
                if (this.m_consoleRunner == null) {
                    this.m_consoleRunner = new Thread("console-runner"){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            System.out.println();
                            System.out.println(Main.getRes().getString("Start prompting for actions."));
                            try {
                                BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
                                try {
                                    while (true) {
                                        System.out.println(Main.getRes().getString("Input an action ('help' for a list of actions):"));
                                        String line = r.readLine();
                                        if (line != null && !line.equals("")) {
                                            System.out.println(Main.getRes().getString("Read action: {0}", (Object)line));
                                            if (AbstractActionApp.this.doAction(line)) continue;
                                            if (!line.equals("help")) {
                                                System.out.println(Main.getRes().getString("Unknown action: {0}", (Object)line));
                                            }
                                            AbstractActionApp.printActions();
                                            continue;
                                        }
                                        System.out.println(Main.getRes().getString("Read action: <EMPTY>"));
                                    }
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                    Object var5_4 = null;
                                    System.out.println(Main.getRes().getString("Stop prompting for actions."));
                                    System.out.println();
                                    AbstractActionApp.this.m_consoleRunner = null;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var5_5 = null;
                                System.out.println(Main.getRes().getString("Stop prompting for actions."));
                                System.out.println();
                                AbstractActionApp.this.m_consoleRunner = null;
                                throw throwable;
                            }
                        }
                    };
                    this.m_consoleRunner.setDaemon(true);
                    this.m_consoleRunner.start();
                }
            } else if (action.equals("idle")) {
                System.out.println(Main.getRes().getString("Run idle."));
                this.m_users = false;
                this.m_groups = false;
                Class clazz = AbstractActionApp.class;
                synchronized (clazz) {
                    AbstractActionApp.class.notifyAll();
                }
            } else if (action.equals("properties")) {
                System.out.println(Main.getRes().getString("Dump System Properties:"));
                Properties props = System.getProperties();
                Enumeration<?> en = props.propertyNames();
                while (en.hasMoreElements()) {
                    String name = (String)en.nextElement();
                    System.out.println("  " + name + "=" + props.getProperty(name));
                }
                System.out.println();
            } else if (action.equals("configuration")) {
                System.out.println(Main.getRes().getString("Dump Wrapper Properties:"));
                Properties props = WrapperManager.getProperties();
                Enumeration<?> en = props.propertyNames();
                while (en.hasMoreElements()) {
                    String name = (String)en.nextElement();
                    System.out.println("  " + name + "=" + props.getProperty(name));
                }
                System.out.println();
            } else if (action.equals("listener")) {
                System.out.println(Main.getRes().getString("Updating Event Listeners:"));
                WrapperManager.removeWrapperEventListener((WrapperEventListener)this);
                WrapperManager.addWrapperEventListener((WrapperEventListener)this, (long)this.m_eventMask);
            } else if (action.equals("service_list")) {
                WrapperWin32Service[] services = WrapperManager.listServices();
                if (services == null) {
                    System.out.println(Main.getRes().getString("Services not supported by current platform."));
                } else {
                    System.out.println(Main.getRes().getString("Registered Services:"));
                    for (int i = 0; i < services.length; ++i) {
                        System.out.println("  " + services[i]);
                    }
                }
            } else if (action.equals("service_interrogate")) {
                try {
                    WrapperWin32Service service = WrapperManager.sendServiceControlCode((String)this.m_serviceName, (int)4);
                    System.out.println(Main.getRes().getString("Service after interrogate: {0}", (Object)service));
                }
                catch (WrapperServiceException e) {
                    e.printStackTrace();
                }
            } else if (action.equals("service_start")) {
                try {
                    WrapperWin32Service service = WrapperManager.sendServiceControlCode((String)this.m_serviceName, (int)65536);
                    System.out.println(Main.getRes().getString("Service after start: {0}", (Object)service));
                }
                catch (WrapperServiceException e) {
                    e.printStackTrace();
                }
            } else if (action.equals("service_stop")) {
                try {
                    WrapperWin32Service service = WrapperManager.sendServiceControlCode((String)this.m_serviceName, (int)1);
                    System.out.println(Main.getRes().getString("Service after stop: {0}", (Object)service));
                }
                catch (WrapperServiceException e) {
                    e.printStackTrace();
                }
            } else if (action.equals("service_user")) {
                try {
                    for (int i = 128; i < 256; i += 10) {
                        WrapperWin32Service service = WrapperManager.sendServiceControlCode((String)this.m_serviceName, (int)i);
                        System.out.println(Main.getRes().getString("Service after user code {0} : {1}", (Object)new Integer(i), (Object)service));
                    }
                }
                catch (WrapperServiceException e) {
                    e.printStackTrace();
                }
            } else if (action.equals("console_title")) {
                if (!WrapperManager.isWindows()) {
                    System.out.println(Main.getRes().getString("Setting the console title not supported on UNIX platforms."));
                }
                WrapperManager.setConsoleTitle((String)this.m_consoleTitle);
            } else if (action.equals("child_exec")) {
                this.doExec(this.m_childCommand, this.m_childDetached);
            } else if (action.equals("gc")) {
                System.out.println(Main.getRes().getString("Begin GC..."));
                System.gc();
                System.out.println(Main.getRes().getString("GC complete."));
            } else if (action.equals("is_professional")) {
                System.out.println(Main.getRes().getString("Professional Edition: ") + WrapperManager.isProfessionalEdition());
            } else if (action.equals("is_standard")) {
                System.out.println(Main.getRes().getString("Standard Edition: ") + WrapperManager.isStandardEdition());
            } else if (action.startsWith("exec ") && action.length() > 5) {
                String command = action.substring(5);
                this.doExec(command, false);
            } else if (action.startsWith("exec_detached ") && action.length() > 14) {
                String command = action.substring(14);
                this.doExec(command, true);
            } else {
                return false;
            }
        }
        return true;
    }

    private static Thread handleInputStream(final InputStream is, final String encoding, String pid, String pipeName) {
        final String label = Main.getRes().getString("  Process #{0} {1}", (Object)pid, (Object)pipeName);
        Thread runner = new Thread("exec_runner_" + pipeName + "_" + pid){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    BufferedReader br = new BufferedReader(new InputStreamReader(is, encoding));
                    try {
                        String line;
                        while ((line = br.readLine()) != null) {
                            System.out.println(label + ": " + line);
                        }
                    }
                    finally {
                        br.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        runner.start();
        return runner;
    }

    private void doExec(String command, boolean detached) {
        try {
            String type;
            WrapperProcessConfig processConfig = new WrapperProcessConfig();
            processConfig.setDetached(detached);
            if (command.startsWith("FORK_EXEC ")) {
                processConfig.setStartType(2);
                type = "FORK_EXEC";
                command.substring(10);
            } else if (command.startsWith("POSIX_SPAWN ")) {
                processConfig.setStartType(1);
                type = "POSIX_SPAWN";
                command.substring(12);
            } else if (command.startsWith("VFORK_EXEC ")) {
                processConfig.setStartType(3);
                type = "VFORK_EXEC";
                command.substring(11);
            } else if (command.startsWith("DYNAMIC ")) {
                processConfig.setStartType(4);
                type = "DYNAMIC";
                command.substring(8);
            } else {
                type = "DYNAMIC";
            }
            if (detached) {
                System.out.println(Main.getRes().getString("Execute Detached Child Process with type {0}: {1}", (Object)type, (Object)command));
            } else {
                System.out.println(Main.getRes().getString("Execute Managed Child Process: with type {0}: {1}", (Object)type, (Object)command));
            }
            final WrapperProcess process = WrapperManager.exec((String)command, (WrapperProcessConfig)processConfig);
            final String pid = Integer.toString(process.getPID());
            System.out.println(Main.getRes().getString("  Process #{0} launched.", (Object)pid));
            final Thread outRunner = AbstractActionApp.handleInputStream(process.getInputStream(), c_encoding, pid, "stdout");
            final Thread errRunner = AbstractActionApp.handleInputStream(process.getErrorStream(), c_encoding, pid, "stderr");
            Thread runner = new Thread("exec_runner_process_" + pid){

                public void run() {
                    try {
                        outRunner.join();
                        errRunner.join();
                        System.out.println(Main.getRes().getString("  Process #{0} terminated with exitCode={1}", (Object)pid, (Object)Integer.toString(process.waitFor())));
                    }
                    catch (Throwable t) {
                        System.out.println(Main.getRes().getString("  Process #{0} unexpected error: {1} ", (Object)pid, (Object)t.getMessage()));
                        t.printStackTrace();
                    }
                }
            };
            runner.start();
        }
        catch (Throwable t) {
            System.out.println(Main.getRes().getString("Failed to launch child process: {0}", (Object)t.getMessage()));
            t.printStackTrace();
        }
    }

    protected static void printActions() {
        System.err.println("");
        System.err.println(Main.getRes().getString("[ACTIONS]"));
        System.err.println(Main.getRes().getString("   help                     : Shows this help message"));
        System.err.println(Main.getRes().getString("  Actions which should cause the Wrapper to exit cleanly:"));
        System.err.println(Main.getRes().getString("   stop0                    : Calls WrapperManager.stop(0)"));
        System.err.println(Main.getRes().getString("   exit0                    : Calls System.exit(0)"));
        System.err.println(Main.getRes().getString("   stopimmediate0           : Calls WrapperManager.stopImmediate(0)"));
        System.err.println(Main.getRes().getString("   stopandreturn0           : Calls WrapperManager.stopAndReturn(0)"));
        System.err.println(Main.getRes().getString("  Actions which should cause the Wrapper to exit in an error state:"));
        System.err.println(Main.getRes().getString("   stop1                    : Calls WrapperManager.stop(1)"));
        System.err.println(Main.getRes().getString("   exit1                    : Calls System.exit(1)"));
        System.err.println(Main.getRes().getString("   nestedexit1              : Calls System.exit(1) within WrapperListener.stop(1) callback"));
        System.err.println(Main.getRes().getString("   stopimmediate1           : Calls WrapperManager.stopImmediate(1)"));
        System.err.println(Main.getRes().getString("  Actions which should cause the Wrapper to restart the JVM:"));
        System.err.println(Main.getRes().getString("   access_violation_native  : Calls WrapperManager.accessViolationNative()"));
        System.err.println(Main.getRes().getString("   appear_hung              : Calls WrapperManager.appearHung()"));
        System.err.println(Main.getRes().getString("   halt0                    : Calls Runtime.getRuntime().halt(0)"));
        System.err.println(Main.getRes().getString("   halt1                    : Calls Runtime.getRuntime().halt(1)"));
        System.err.println(Main.getRes().getString("   restart                  : Calls WrapperManager.restart()"));
        System.err.println(Main.getRes().getString("   restartandreturn         : Calls WrapperManager.restartAndReturn()"));
        System.err.println(Main.getRes().getString("  Additional Tests:"));
        System.err.println(Main.getRes().getString("   appear_slow_1            : Calls WrapperManager.appearSlow(1)"));
        System.err.println(Main.getRes().getString("   appear_slow_5            : Calls WrapperManager.appearSlow(5)"));
        System.err.println(Main.getRes().getString("   appear_slow_reset        : Calls WrapperManager.appearSlow(0) to return to normal"));
        System.err.println(Main.getRes().getString("   deadlock                 : Executes some deadlocking code to test deadlock detection"));
        System.err.println(Main.getRes().getString("   outofmemory              : Simulates an OutOfMemoryError being thrown"));
        System.err.println(Main.getRes().getString("   ignore_events            : Makes this application ignore control events."));
        System.err.println(Main.getRes().getString("   dump                     : Calls WrapperManager.requestThreadDump()"));
        System.err.println(Main.getRes().getString("   deadlock_out             : Deadlocks the JVM's System.out and err streams."));
        System.err.println(Main.getRes().getString("   users                    : Start polling the current and interactive users."));
        System.err.println(Main.getRes().getString("   groups                   : Start polling the current and interactive users with groups."));
        System.err.println(Main.getRes().getString("   console                  : Prompt for actions in the console."));
        System.err.println(Main.getRes().getString("   idle                     : Do nothing just run in idle mode."));
        System.err.println(Main.getRes().getString("   properties               : Dump all System Properties to the console."));
        System.err.println(Main.getRes().getString("   configuration            : Dump all Wrapper Configuration Properties to the console."));
        System.err.println(Main.getRes().getString("   gc                       : Perform a GC sweep."));
        System.err.println(Main.getRes().getString("   is_professional          : Displays whether or not this is a Professional Edition Wrapper."));
        System.err.println(Main.getRes().getString("   is_standard              : Displays whether or not this is at least a Standard Edition Wrapper."));
        if (WrapperManager.isProfessionalEdition()) {
            System.err.println(Main.getRes().getString("   exec <cmd>               : Executes a managed child process."));
            System.err.println(Main.getRes().getString("   exec_detached <cmd>      : Executes a detached child process."));
        }
        System.err.println("");
    }

    static {
        if (c_encoding == null && (c_encoding = System.getProperty("file.encoding")) == null) {
            c_encoding = "Cp1252";
        }
    }
}

