/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper;

import org.tanukisoftware.wrapper.WrapperManager;

public final class WrapperPropertyUtil {
    public static String getStringProperty(String name, String defaultValue) {
        String val = WrapperManager.getProperties().getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    public static boolean getBooleanProperty(String name, boolean defaultValue) {
        String val = WrapperPropertyUtil.getStringProperty(name, null);
        if (val != null) {
            if (val.equalsIgnoreCase("TRUE")) {
                return true;
            }
            if (val.equalsIgnoreCase("FALSE")) {
                return false;
            }
        }
        return defaultValue;
    }

    public static int getIntProperty(String name, int defaultValue) {
        String val = WrapperPropertyUtil.getStringProperty(name, null);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long getLongProperty(String name, long defaultValue) {
        String val = WrapperPropertyUtil.getStringProperty(name, null);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private WrapperPropertyUtil() {
    }
}

