CREATE TABLE nform_main (
  seq int(10)  unsigned NOT NULL auto_increment, 
  type varchar(50) NOT NULL default '',
  ctime int(10) unsigned NOT NULL,
  PRIMARY KEY  (seq),
  KEY type (type),
  KEY ctime (ctime)
) TYPE=MyISAM;

CREATE TABLE nform_data (
  seq int(10)  unsigned NOT NULL, 
  type varchar(50) NOT NULL default '',
  lang varchar(20) NOT NULL default '',
  charset varchar(20) NOT NULL default '',
  status int,
  utime int(10) unsigned NOT NULL,
  body text,
  env text,
  KEY seq (seq),
  KEY type (type),
  KEY status (status),
  KEY lang (lang),
  KEY charset (charset),
  KEY utime (utime)
) TYPE=MyISAM;

CREATE TABLE nform_backup (
  seq int(10)  unsigned NOT NULL,
  type varchar(50) NOT NULL default '',
  lang varchar(20) NOT NULL default '',
  charset varchar(20) NOT NULL default '',
  status int,
  utime int(10) unsigned NOT NULL,
  body text,
  env text,
  KEY seq (seq)
) TYPE=MyISAM;

CREATE TABLE nform_item (
  seq int(10) unsigned NOT NULL default '0',
  type varchar(50) NOT NULL default '',
  lang varchar(20) NOT NULL default '',
  charset varchar(20) NOT NULL default '',
  status int,
  utime int(10) unsigned NOT NULL,
  item varchar(200) NOT NULL default '',
  value varchar(200) NOT NULL default '',
  KEY seq (seq),
  KEY type (type),
  KEY lang (lang),
  KEY charset (charset),
  KEY status (status),
  KEY item (item),
  KEY value (value),
  KEY utime (utime)
) TYPE=MyISAM;

CREATE TABLE nform_integer (
  seq int(10) unsigned NOT NULL default '0',
  type varchar(50) NOT NULL default '',
  lang varchar(20) NOT NULL default '',
  charset varchar(20) NOT NULL default '',
  status int,
  utime int(10) unsigned NOT NULL,
  item varchar(200) NOT NULL default '',
  value mediumint(8) ,
  KEY seq (seq),
  KEY type (type),
  KEY lang (lang),
  KEY charset (charset),
  KEY status (status),
  KEY item (item),
  KEY value (value),
  KEY utime (utime)
) TYPE=MyISAM;

CREATE TABLE nform_real (
  seq int(10) unsigned NOT NULL default '0',
  type varchar(50) NOT NULL default '',
  lang varchar(20) NOT NULL default '',
  charset varchar(20) NOT NULL default '',
  status int,
  utime int(10) unsigned NOT NULL,
  item varchar(200) NOT NULL default '',
  value real ,
  KEY seq (seq),
  KEY type (type),
  KEY lang (lang),
  KEY charset (charset),
  KEY status (status),
  KEY item (item),
  KEY value (value),
  KEY utime (utime)
) TYPE=MyISAM;

CREATE TABLE nform_text (
  seq int(10) unsigned NOT NULL default '0',
  type varchar(50) NOT NULL default '',
  lang varchar(20) NOT NULL default '',
  charset varchar(20) NOT NULL default '',
  status int,
  utime int(10) unsigned NOT NULL,
  item varchar(200) NOT NULL default '',
  value text,
  KEY seq (seq),
  KEY type (type),
  KEY lang (lang),
  KEY charset (charset),
  KEY status (status),
  KEY item (item),
  KEY utime (utime)
) TYPE=MyISAM;


CREATE TABLE nform_binary (
  seq int(10) unsigned NOT NULL default '0',
  type varchar(50) NOT NULL default '',
  lang varchar(20) NOT NULL default '',
  charset varchar(20) NOT NULL default '',
  status int,
  utime int(10) unsigned NOT NULL,
  item varchar(200) NOT NULL default '',
  value longblob,
  KEY seq (seq),
  KEY type (type),
  KEY lang (lang),
  KEY charset (charset),
  KEY status (status),
  KEY item (item),
  KEY utime (utime)
) TYPE=MyISAM;


CREATE TABLE nform_relation (
  relation int(10) unsigned NOT NULL default '0',
  context varchar(200) NOT NULL default '',
  utime int(10) unsigned NOT NULL,
  a int unsigned NOT NULL default '0',
  b int unsigned NOT NULL default '0',
  KEY a (a),
  KEY b (b),
  KEY relation (relation),
  KEY context (context),
  KEY utime (utime)
) TYPE=MyISAM;

CREATE TABLE nform_horizontal (
  seq int(10) unsigned NOT NULL default '0',
  type varchar(50) NOT NULL default '',
  lang varchar(20) NOT NULL default '',
  charset varchar(20) NOT NULL default '',
  status int,
  utime int(10) unsigned NOT NULL,
  v01 varchar(100) NOT NULL default '',
  v02 varchar(100) NOT NULL default '',
  v03 varchar(100) NOT NULL default '',
  v04 varchar(100) NOT NULL default '',
  v05 varchar(100) NOT NULL default '',
  v06 varchar(100) NOT NULL default '',
  v07 varchar(100) NOT NULL default '',
  v08 varchar(100) NOT NULL default '',
  v09 varchar(100) NOT NULL default '',
  v10 varchar(100) NOT NULL default '',
  v11 varchar(100) NOT NULL default '',
  v12 varchar(100) NOT NULL default '',
  v13 varchar(100) NOT NULL default '',
  v14 varchar(100) NOT NULL default '',
  v15 varchar(100) NOT NULL default '',
  v16 varchar(100) NOT NULL default '',
  v17 varchar(100) NOT NULL default '',
  v18 varchar(100) NOT NULL default '',
  v19 varchar(100) NOT NULL default '',
  v20 varchar(100) NOT NULL default '',
  i01 mediumint(8),
  i02 mediumint(8),
  i03 mediumint(8),
  i04 mediumint(8),
  i05 mediumint(8),
  f01 float,
  f02 float,
  f03 float,
  f04 float,
  f05 float,
  t01 text,
  t02 text,
  t03 text,
  KEY seq (seq),
  KEY type (type),
  KEY lang (lang),
  KEY charset (charset),
  KEY status (status),
  KEY utime (utime)
) TYPE=MyISAM;


