/*fBW^tB^݌vE̓vO 1990-01-16 @m@ w */
/* Converted Turbo Pascal to C by p2c.
 * Modified by mac@research.co.jp (Shigeru makino)
 * Copyleft by Hiroshi Ochi, Shigeru makino.
 */

static char *RcsId = "$Id: digfil.c,v 1.1.1.1 2003/08/01 21:57:43 mac Exp $";

#include <stdio.h>
#include <math.h>

#include "digfil.h"

#ifndef M_PI
#	define M_PI 3.14159265358979323846
#endif

#define true 1
#define false 0

extern void             ErrDisp();
extern void             TextDisp();

/**-----------------------------------------**/
/**          function錾@@             **/
/**-----------------------------------------**/
/* pΐ */
double
log_(x)
double                  x;
{
    return (log(x) / log(10.0));
}


/* ǨvZ */
double
fac(n)
int                     n;
{
    double                  ans;
    if (n == 0)
	return 1.0;
    else {
	ans = (double) n;
	while (--n > 1) {
	    ans *= (double) n;
	}
	return (ans);
    }
}


/* PxbZ֐ */
double
bes(x)
double                  x;
{
    double                  s, c, y;
    int                     i;
    double                  TEMP;

    if (x == 0)
	return 1.0;
    else {
	s = 1.0;
	for (i = 1; i <= 25; i++) {
	    y = 0.25 * x * x;
	    TEMP = fac(i);
	    c = exp(i * log(y)) / (TEMP * TEMP);
	    s += c;
	}
	return s;
    }
}


/**--------------------------------**/
/**        葱錾            **/
/**--------------------------------**/
/* /////////////////////   f|^͂̕   ////////////////////////// */

/*------------------------------*/
/*    tB^̎葱    */
/*------------------------------*/
void
order_lh()
{
 /* tB^(LPF,HPF) */
    double                  df, qs, qp, q, D;
    int                     N1;

    df = fabs(fa1[0] - fc1[0]);
    qs = exp(-0.05 * AMIN * log(10.0));
    qp = (exp(0.05 * AMAX * log(10.0)) - 1) / (exp(0.05 * AMAX * log(10.0)) + 1);
    if (qs < qp)
	q = qs;
    else
	q = qp;
    KA = -20 * log_(q);
    if (KA <= 21)
	D = 0.9222;
    else
	D = (KA - 7.95) / 14.36;
    N1 = (int) (D * fs / df) + 2;
    if ((N1 & 1) == 0) {
	nDet = N1 + 1;
    }
    else {
	nDet = N1;
    }

    L = (nDet - 1) / 2.0;
}


void
order_b()
{
 /* tB^(BPF,BRF) */
    double                  df, f1, f2, qs, qp, q, D;
    int                     N1;

    f1 = fabs(fa1[0] - fc1[0]);
    f2 = fabs(fa2[0] - fc2[0]);
    if (f1 <= f2)
	df = f1;
    else
	df = f2;
    qs = exp(-0.05 * AMIN * log(10.0));
    qp = (exp(0.05 * AMAX * log(10.0)) - 1) / (exp(0.05 * AMAX * log(10.0)) + 1);
    if (qs < qp)
	q = qs;
    else
	q = qp;
    KA = -20 * log_(q);
    if (KA <= 21)
	D = 0.9222;
    else
	D = (KA - 7.95) / 14.36;
    N1 = (int) (D * fs / df) + 2;
    if ((N1 & 1) == 0) {
	nDet = N1 + 1;
    }
    else {
	nDet = N1;
    }

    L = (nDet - 1.0) / 2;
}


/*--------------------------------*/
/*  CpX̌vZ̎葱  */
/*--------------------------------*/
void
lpf_impulse()
{
 /* LPF̃CpX̌vZ */
    double                  wc;
    double                  kL;
    register int            k;

    wc = (fa1[0] + fc1[0]) / fs;
    for (k = 0; k < nDet; k++) {
	if (k != L) {
	    kL = (double) (k - L) * M_PI;
	    hn1[k] = sin(kL * wc) / kL;
	}
	else
	    hn1[k] = wc;
    }
}


void
hpf_impulse()
{
 /* HPF̃CpX̌vZ */
    double                  wc;
    double                  kL;
    register int            k;

    wc = (fc1[0] + fa1[0]) / fs;
    for (k = 0; k < nDet; k++) {
	if (k != L) {
	    kL = (double) (k - L) * M_PI;
	    hn1[k] = (sin(kL) - sin(kL * wc)) / kL;
	}
	else
	    hn1[k] = 1 - wc;
    }
}


void
bpf_impulse()
{
 /* BPF̃CpX̌vZ */
    double                  wc1, wc2, f, f1, f2;
    double                  kL, wwf;
    register int            k;

    f1 = fc1[0] - fa1[0];
    f2 = fa2[0] - fc2[0];
    if (f1 >= f2)
	f = f2;
    else
	f = f1;
    f /= 2.0;
    wc1 = (fc1[0] - f) * 2.0 / fs;
    wc2 = (fc2[0] + f) * 2.0 / fs;
    wwf = wc2 - wc1;
    for (k = 0; k < nDet; k++) {
	if (k != L) {
	    kL = (double) (k - L) * M_PI;
	    hn1[k] = (sin(kL * wc2) - sin(kL * wc1)) / kL;
	}
	else
	    hn1[k] = wwf;
    }
}


void
brf_impulse()
{
 /* BRF̃CpX̌vZ */
    double                  wc1, wc2, f, f1, f2;
    double                  kL, wwf;
    register int            k;

    f1 = fa1[0] - fc1[0];
    f2 = fc2[0] - fa2[0];
    if (f1 >= f2)
	f = f2;
    else
	f = f1;
    f /= 2.0;
    wc1 = (fc1[0] + f) * 2.0 / fs;
    wc2 = (fc2[0] - f) * 2.0 / fs;
    wwf = wc1 - wc2 + 1.0;
    for (k = 0; k < nDet; k++) {
	if (k != L) {
	    kL = (double) (k - L) * M_PI;
	    hn1[k] = (sin(kL * wc1) - sin(kL * wc2) + sin(kL)) / kL;
	}
	else
	    hn1[k] = wwf;
    }
}


/*-----------------*/
/*  ֐̎葱 */
/*-----------------*/
void
kaiser_window()
{
 /* JCU|֐ */
    double                  v, w, I0, I1;
    int                     k, t, Nd;
    double                  TEMP;

    Nd = (nDet - 1) / 2;
    if (KA <= 21.0)
	v = 0.0;
    else {
	if (21.0 < KA && KA <= 50.0)
	    v = 0.5842 * exp(0.4 * log(KA - 21)) + 0.07886 * (KA - 21);
	else
	    v = 0.1102 * (KA - 8.7);
    }
    I1 = bes(v);
    for (k = 0; k <= Nd; k++) {
	TEMP = k * 2.0 / (nDet - 1);
	w = v * sqrt(1 - TEMP * TEMP);
	I0 = bes(w);
	ak[k] = I0 / I1;
    }
    for (k = 0; k <= Nd; k++) {
	hn2[Nd - k] = hn1[Nd - k] * ak[k];
	hn2[Nd + k] = hn1[Nd + k] * ak[k];
	t = nDet - k - 1;
	hn2[t] = hn2[k];
    }
}


/*-----------------------------------*/
/*  ehqtB^݌vC|` */
/*-----------------------------------*/
void
fir_design()
{
    register int            k;

    switch (Type) {

	case LPF:			/* koěvZ */
	    if (fs / 2.0 < fa1[0]) {
		ErrDisp("illegal param: fs/2 < fa1 !\n");
		normal = -1;
		return;
	    }
	    else if (fa1[0] <= fc1[0]) {
		ErrDisp("illegal param: fa1 <= fc1 !\n");
		normal = -1;
		return;
	    }
	    order_lh();
	    if (nDet >= MAXDT_FIR)
		goto ManyDET;
	    lpf_impulse();
	    break;

	case HPF:			/* goěvZ */
	    if (fs / 2.0 < fc1[0]) {
		ErrDisp("illegal param: fs/2 < fc1 !\n");
		normal = -1;
		return;
	    }
	    else if (fc1[0] <= fa1[0]) {
		ErrDisp("illegal param: fc1 <= fa1 !\n");
		normal = -1;
		return;
	    }
	    order_lh();
	    if (nDet >= MAXDT_FIR)
		goto ManyDET;
	    hpf_impulse();
	    break;

	case BPF:			/* aoěvZ */
	    if (fs / 2.0 < fa2[0]) {
		ErrDisp("illegal param: fs/2 < fa2 !\n");
		normal = -1;
		return;
	    }
	    else if (fa2[0] <= fc2[0]) {
		ErrDisp("illegal param: fa2 <= fc2 !\n");
		normal = -1;
		return;
	    }
	    else if (fc2[0] <= fc1[0]) {
		ErrDisp("illegal param: fc2 <= fc1 !\n");
		normal = -1;
		return;
	    }
	    else if (fc1[0] <= fa1[0]) {
		ErrDisp("illegal param: fc1 <= fa1 !\n");
		normal = -1;
		return;
	    }
	    order_b();
	    if (nDet >= MAXDT_FIR)
		goto ManyDET;
	    bpf_impulse();
	    break;

	case BRF:			/* aqěvZ */
	    if (fs / 2.0 < fc2[0]) {
		ErrDisp("illegal param: fs/2 < fc2 !\n");
		normal = -1;
		return;
	    }
	    else if (fc2[0] <= fa2[0]) {
		ErrDisp("illegal param: fc2 <= fa2 !\n");
		normal = -1;
		return;
	    }
	    else if (fa2[0] <= fa1[0]) {
		ErrDisp("illegal param: fa2 <= fa1 !\n");
		normal = -1;
		return;
	    }
	    else if (fa1[0] <= fc1[0]) {
		ErrDisp("illegal param: fa1 <= fc1 !\n");
		normal = -1;
		return;
	    }
	    order_b();
	    if (nDet >= MAXDT_FIR)
		goto ManyDET;
	    brf_impulse();
	    break;
	default:
	    ErrDisp("Select LPF/HPF/BPF/BRF !\n");
	    normal = -1;
	    break;
    }
    kaiser_window();
    return;

ManyDET:
    ErrDisp("too many determination !\n");
    normal = -1;
    return;
}


void
cmplx_op(a, b, op, c)
complex                 a, b;
operation               op;
complex                *c;
{
 /* f̎lZTu[` */
    double                  t;

    switch (op) {

	case add:
	    c->re = a.re + b.re;
	    c->im = a.im + b.im;
	    break;

	case sub:
	    c->re = a.re - b.re;
	    c->im = a.im - b.im;
	    break;

	case mult:
	    c->re = a.re * b.re - a.im * b.im;
	    c->im = a.re * b.im + a.im * b.re;
	    break;

	case dv:
	    t = b.re * b.re + b.im * b.im;
	    c->re = (a.re * b.re + a.im * b.im) / t;
	    c->im = (a.im * b.re - a.re * b.im) / t;
	    break;
    }
}


typedef double          parameter[MAXDT_IIR];
typedef double          parm[MAXDT_IIR][3];
typedef long            pare[5];

#define I               1


/* Local variables for IIR_filter: */
parameter               Pim, Pre, X, Y, W, Z;
parm                    P, SD, SN;
double                  OMEG, PM, nx, WC, Wb, Wo, L, chealph, chealphi;
double                  alph, alphi, c_chealphi, c_chealph;
double                  keisu, chekei;
complex                 chepole[MAXDT_IIR], ichesi[MAXDT_IIR];
double                  chere[MAXDT_IIR], cheim[MAXDT_IIR];
complex                 para;
long                    pa, kq;

/* /////////              Part of Bilinear transform          ////////// */
void
B_MAIN()
{
    long                    k;
    double                  M, Na;

    h = 1.0;
    for (k = 1; k <= nDet; k++) {
	M = SN[k - 1][I - 1] * L * L;
	Na = 1 / (SD[k - 1][I - 1] * L * L + SD[k - 1][I]
	    * L + SD[k - 1][I + 1]);
	b[k][I] = 2 * Na * (SD[k - 1][I + 1]
	    - SD[k - 1][I - 1] * L * L);
	b[k][I + 1] = Na * (SD[k - 1][I - 1] * L * L
	    - SD[k - 1][I] * L + SD[k - 1][I + 1]);
	a[k][I] = M + SN[k - 1][I] * L + SN[k - 1][I + 1];
	a[k][I + 1] = 2 * (SN[k - 1][I + 1] - M);
	a[k][I + 2] = M - SN[k - 1][I] * L + SN[k - 1][I + 1];
	h *= Na;
    }
}

/*------------- Bilinear transform case by bpf,brf---------------------*/
void
S_Z2()
{
/*
  L = 2 * fs;
*/
    L = 2.0;
    h = 1.0;
    B_MAIN();
}

/*------------- Bilinear transform case by lpf,hpf --------------------*/
void
S_Z1()
{
/*
  L = 2 * fs;
*/
    L = 2.0;
    h = 1.0;
    if ((nDet & 1) == false) {
	nDet /= 2;
	B_MAIN();
    }
    else {
	nDet = (nDet - 1) / 2 + 1;
	B_MAIN();
    }
}

/*---------------------------------------------------------------------*/
void
rootmult()
{
    double                  theta;
    complex                 para2, rWb, rWo, he, he2;
    double                  TEMP, TEMP1;

    cmplx_op(para, para, mult, &para2);
    rWb.re = Wb * Wb;
    rWb.im = 0.0;
    cmplx_op(rWb, para2, dv, &he2);
    rWo.re = 4 * Wo;
    rWo.im = 0.0;
    cmplx_op(he2, rWo, sub, &he2);
    X[kq - 1] = he2.re;
    Y[kq - 1] = he2.im;
    he.re = Wb;
    he.im = 0.0;
    cmplx_op(he, para, dv, &he);
    if (X[kq - 1] >= 0) {
	theta = atan(Y[kq - 1] / X[kq - 1]);
	TEMP = X[kq - 1];
	TEMP1 = Y[kq - 1];
	W[kq * 2 - 2] =
	    (he.re + sqrt(sqrt(TEMP * TEMP + TEMP1 * TEMP1)) * cos(theta / 2)) / 2;
	TEMP = X[kq - 1];
	TEMP1 = Y[kq - 1];
	Z[kq * 2 - 2] =
	    (he.im + sqrt(sqrt(TEMP * TEMP + TEMP1 * TEMP1)) * sin(theta / 2)) / 2;
	TEMP = X[kq - 1];
	TEMP1 = Y[kq - 1];
	W[kq * 2 - 1] =
	    (he.re - sqrt(sqrt(TEMP * TEMP + TEMP1 * TEMP1)) * cos(theta / 2)) / 2;
	TEMP = X[kq - 1];
	TEMP1 = Y[kq - 1];
	Z[kq * 2 - 1] =
	    (he.im - sqrt(sqrt(TEMP * TEMP + TEMP1 * TEMP1)) * sin(theta / 2)) / 2;
    }
    else {
	theta = atan(Y[kq - 1] / X[kq - 1]);
	TEMP = X[kq - 1];
	TEMP1 = Y[kq - 1];
	W[kq * 2 - 2] =
	    (he.re - sqrt(sqrt(TEMP * TEMP + TEMP1 * TEMP1)) * sin(theta / 2)) / 2;
	TEMP = X[kq - 1];
	TEMP1 = Y[kq - 1];
	Z[kq * 2 - 2] =
	    (he.im + sqrt(sqrt(TEMP * TEMP + TEMP1 * TEMP1)) * cos(theta / 2)) / 2;
	TEMP = X[kq - 1];
	TEMP1 = Y[kq - 1];
	W[kq * 2 - 1] =
	    (he.re + sqrt(sqrt(TEMP * TEMP + TEMP1 * TEMP1)) * sin(theta / 2)) / 2;
	TEMP = X[kq - 1];
	TEMP1 = Y[kq - 1];
	Z[kq * 2 - 1] =
	    (he.im - sqrt(sqrt(TEMP * TEMP + TEMP1 * TEMP1)) * cos(theta / 2)) / 2;
    }
}

/* ////////       aqȅꍇ̋t`FrVFt̕q       ///////// */
void
iche_form7()
{
    long                    k;
    double                  pater;
    double                  TEMP, TEMP1, TEMP2;

    for (k = 1; k <= pa; k++) {
	if (k == 1) {
	    TEMP = ichesi[k - 1].im;
	    TEMP1 = chepole[k - 1].re;
	    TEMP2 = chepole[k - 1].im;
	    pater = TEMP * TEMP / (TEMP1 * TEMP1 + TEMP2 * TEMP2);
	    SN[k * 2 - 2][I - 1] = 1 * (keisu / chekei) * pater;
	    SN[k * 2 - 2]
		[I] = -2 * W[k * 2 - 2] * (keisu / chekei) * pater;
	    TEMP = W[k * 2 - 2];
	    TEMP1 = Z[k * 2 - 2];
	    SN[k * 2 - 2][I + 1] = (TEMP * TEMP + TEMP1 * TEMP1) *
		(keisu / chekei) * pater;
	}
	else {
	    TEMP = ichesi[k - 1].im;
	    TEMP1 = chepole[k - 1].re;
	    TEMP2 = chepole[k - 1].im;
	    pater = TEMP * TEMP / (TEMP1 * TEMP1 + TEMP2 * TEMP2);
	    SN[k * 2 - 2][I - 1] = 1 * pater;
	    SN[k * 2 - 2][I] = -2 * W[k * 2 - 2] * pater;
	    TEMP = W[k * 2 - 2];
	    TEMP1 = Z[k * 2 - 2];
	    SN[k * 2 - 2][I + 1] = (TEMP * TEMP + TEMP1 * TEMP1) * pater;
	}
	SN[k * 2 - 1][I - 1] = 1.0;
	SN[k * 2 - 1][I] = -2 * W[k * 2 - 1];
	TEMP = W[k * 2 - 1];
	TEMP1 = Z[k * 2 - 1];
	SN[k * 2 - 1][I + 1] = TEMP * TEMP + TEMP1 * TEMP1;
    }
}

/*-------------------- Sub routine form6 for lpf_d2--------------------*/
void
iche_form6()
{
    long                    k;

    for (k = 1; k <= pa; k++) {
	kq = k;
	para.re = ichesi[kq - 1].re;
	para.im = ichesi[kq - 1].im;
	rootmult();
    }
}

/*----------- Transform frequency denominator case by BRF -------------*/
void
icheNBR()
{
    long                    k, at;

    if ((nDet & 1) == false) {
	pa = nDet / 2;
	iche_form6();
	iche_form7();
	return;
    }
    pa = (nDet - 1) / 2;
    iche_form6();
    iche_form7();
    k = nDet;
    at = (k + 1) / 2;
    if (nDet == 1) {
	SN[k - 1][I - 1] = 1.0;		/* /(-chepole[at].re) */
	SN[k - 1][I] = 0.0;
	SN[k - 1][I + 1] = Wo;		/* /(-chepole[at].re) */
	return;
    }
    SN[k - 1][I - 1] = 1 / -chepole[at - 1].re;
    SN[k - 1][I] = 0.0;
    SN[k - 1][I + 1] = Wo / -chepole[at - 1].re;
}

/* ////////////////   aqe֕ϊꍇ̕q   ///////////////// */
void
NBRF()
{
    long                    k;
    double                  par, par1;
    double                  TEMP, TEMP1;

    for (k = 1; k <= pa; k++) {
	if (Mtd == BTW) {
	    TEMP = Pre[k - 1];
	    TEMP1 = Pim[k - 1];
	    par = TEMP * TEMP + TEMP1 * TEMP1;
	    SN[k * 2 - 2]
		[I - 1] = 1 / par * exp(1.0 / (nDet * 2) * log(alphi));
	    SN[k * 2 - 2][I] = 0.0;
	    SN[k * 2 - 2]
		[I + 1] = Wo / par * exp(1.0 / (nDet * 2) * log(alphi));
	    SN[k * 2 - 1][I - 1] = 1 * exp(1.0 / (nDet * 2) * log(alphi));
	    SN[k * 2 - 1][I] = 0.0;
	    SN[k * 2 - 1]
		[I + 1] = Wo * exp(1.0 / (nDet * 2) * log(alphi));
	}
	else {
	    TEMP = chepole[k - 1].re;
	    TEMP1 = chepole[k - 1].im;
	    par1 = TEMP * TEMP + TEMP1 * TEMP1;
	    SN[k * 2 - 2][I - 1] = 1 / par1;
	    SN[k * 2 - 2][I] = 0.0;
	    SN[k * 2 - 2][I + 1] = Wo / par1;
	    SN[k * 2 - 1][I - 1] = 1.0;
	    SN[k * 2 - 1][I] = 0.0;
	    SN[k * 2 - 1][I + 1] = Wo;
	}
    }
}

/*------------ Transform frequency numerator case by BRF --------------*/
void
NBR()
{
    long                    k, at;

    if ((nDet & 1) == false) {		/* ̏ꍇ */
	pa = nDet / 2;
	NBRF();
	if (Mtd == CHV) {
	    SN[1][0] *= keisu;
	    SN[1][2] *= keisu;
	}
	return;
    }
    pa = (nDet - 1) / 2;
    NBRF();
    k = nDet;
    at = (k + 1) / 2;
    if (Mtd == BTW) {
	SN[k - 1]
	    [I - 1] = 1 / Pre[at - 1] * exp(1.0 / (nDet * 2) * log(alphi));
	SN[k - 1][I + 1] = Wo / Pre[at - 1] *
	    exp(1.0 / (nDet * 2) * log(alphi));
	SN[k - 1][I] = 0.0;
	return;
    }
    SN[k - 1][I - 1] = 1 / -chepole[at - 1].re * keisu;
    SN[k - 1][I + 1] = Wo / -chepole[at - 1].re * keisu;
    SN[k - 1][I] = 0.0;

 /* ̏ꍇ */
}

/*---------------------------------------------------------------------*/
void
rootmult1()
{
    double                  theta;
    complex                 para2, he, he2, rWb, rWo;
    double                  TEMP, TEMP1;

    cmplx_op(para, para, mult, &para2);
    rWb.re = Wb * Wb;
    rWb.im = 0.0;
    cmplx_op(para2, rWb, mult, &he2);
    rWo.re = 4 * Wo;
    rWo.im = 0.0;
    cmplx_op(he2, rWo, sub, &he2);
    X[kq - 1] = he2.re;
    Y[kq - 1] = he2.im;
    he.re = para.re * Wb;
    he.im = para.im * Wb;
    if (X[kq - 1] >= 0) {
	theta = atan(Y[kq - 1] / X[kq - 1]);
	TEMP = X[kq - 1];
	TEMP1 = Y[kq - 1];
	W[kq * 2 - 2] =
	    (he.re + sqrt(sqrt(TEMP * TEMP + TEMP1 * TEMP1)) * cos(theta / 2)) / 2;
	TEMP = X[kq - 1];
	TEMP1 = Y[kq - 1];
	Z[kq * 2 - 2] =
	    (he.im + sqrt(sqrt(TEMP * TEMP + TEMP1 * TEMP1)) * sin(theta / 2)) / 2;
	TEMP = X[kq - 1];
	TEMP1 = Y[kq - 1];
	W[kq * 2 - 1] =
	    (he.re - sqrt(sqrt(TEMP * TEMP + TEMP1 * TEMP1)) * cos(theta / 2)) / 2;
	TEMP = X[kq - 1];
	TEMP1 = Y[kq - 1];
	Z[kq * 2 - 1] =
	    (he.im - sqrt(sqrt(TEMP * TEMP + TEMP1 * TEMP1)) * sin(theta / 2)) / 2;
    }
    else {
	theta = atan(Y[kq - 1] / X[kq - 1]);
	TEMP = X[kq - 1];
	TEMP1 = Y[kq - 1];
	W[kq * 2 - 2] =
	    (he.re - sqrt(sqrt(TEMP * TEMP + TEMP1 * TEMP1)) * sin(theta / 2)) / 2;
	TEMP = X[kq - 1];
	TEMP1 = Y[kq - 1];
	Z[kq * 2 - 2] =
	    (he.im + sqrt(sqrt(TEMP * TEMP + TEMP1 * TEMP1)) * cos(theta / 2)) / 2;
	TEMP = X[kq - 1];
	TEMP1 = Y[kq - 1];
	W[kq * 2 - 1] =
	    (he.re + sqrt(sqrt(TEMP * TEMP + TEMP1 * TEMP1)) * sin(theta / 2)) / 2;
	TEMP = X[kq - 1];
	TEMP1 = Y[kq - 1];
	Z[kq * 2 - 1] =
	    (he.im - sqrt(sqrt(TEMP * TEMP + TEMP1 * TEMP1)) * cos(theta / 2)) / 2;
    }
}

/* ////////       aoȅꍇ̋t`FrVFt̕q       ///////// */
void
iche_form5()
{
    long                    k;
    double                  TEMP, TEMP1;

    for (k = 1; k <= pa; k++) {
	if (k == 1) {
	    SN[k * 2 - 2][I - 1] = 1 * (keisu / chekei);
	    SN[k * 2 - 2]
		[I] = -2 * W[k * 2 - 2] * (keisu / chekei);
	    TEMP = W[k * 2 - 2];
	    TEMP1 = Z[k * 2 - 2];
	    SN[k * 2 - 2]
		[I + 1] = (TEMP * TEMP + TEMP1 * TEMP1) * (keisu / chekei);
	}
	else {
	    SN[k * 2 - 2][I - 1] = 1.0;
	    SN[k * 2 - 2][I] = -2 * W[k * 2 - 2];
	    TEMP = W[k * 2 - 2];
	    TEMP1 = Z[k * 2 - 2];
	    SN[k * 2 - 2][I + 1] = TEMP * TEMP + TEMP1 * TEMP1;
	}
	SN[k * 2 - 1][I - 1] = 1.0;
	SN[k * 2 - 1][I] = -2 * W[k * 2 - 1];
	TEMP = W[k * 2 - 1];
	TEMP1 = Z[k * 2 - 1];
	SN[k * 2 - 1][I + 1] = TEMP * TEMP + TEMP1 * TEMP1;
    }
}

/*------------------ Sub routine fortm4 for lpf_d1 ---------------------*/
void
iche_form4()
{
    long                    k;

    for (k = 1; k <= pa; k++) {
	kq = k;
	para.re = ichesi[kq - 1].re;
	para.im = ichesi[kq - 1].im;
	rootmult1();
    }
}

/*----- Transform frequency denominator coefficient case of bpf -------*/
void
icheNBP()
{
    long                    k;

    if ((nDet & 1) == false) {
	pa = nDet / 2;
	iche_form4();
	iche_form5();
	return;
    }
    pa = (nDet - 1) / 2;
    iche_form4();
    iche_form5();
    k = nDet;
    if (nDet == 1)
	SN[k - 1][I] = Wb * chepole[0].re;
    else
	SN[k - 1][I] = Wb;
    SN[k - 1][I - 1] = 0.0;
    SN[k - 1][I + 1] = 0.0;
}

/* ////////////////   aoe֕ϊꍇ̕q   ///////////////// */
void
NBPF()
{
    long                    k;

    for (k = 1; k <= pa; k++) {
	if (Mtd == BTW) {
	    SN[k * 2 - 2]
		[I] = Wb * exp(1.0 / (nDet * 2) * log(alphi));
	    SN[k * 2 - 1]
		[I] = Wb * exp(1.0 / (nDet * 2) * log(alphi));
	}
	else {
	    SN[k * 2 - 2][I] = Wb;
	    SN[k * 2 - 1][I] = Wb;
	}
	SN[k * 2 - 2][I - 1] = 0.0;
	SN[k * 2 - 2][I + 1] = 0.0;
	SN[k * 2 - 1][I - 1] = 0.0;
	SN[k * 2 - 1][I + 1] = 0.0;
    }
}

/*------------ Transform frequency numerator case by BPF --------------*/
void
NBP()
{
    long                    k;

    if ((nDet & 1) == false) {		/* ̏ꍇ */
	pa = nDet / 2;
	NBPF();
	if (Mtd == CHV)
	    SN[0][1] *= keisu;
	return;
    }
    pa = (nDet - 1) / 2;
    NBPF();
    k = nDet;
    if (Mtd == BTW)
	SN[k - 1][I] = Wb * exp(1.0 / (nDet * 2) * log(alphi));
    else
	SN[k - 1][I] = Wb * keisu;
    SN[k - 1][I - 1] = 0.0;
    SN[k - 1][I + 1] = 0.0;

 /* ̏ꍇ */
}

/* ////////////////   goe֕ϊꍇ̕q   ///////////////// */
void
NHPF()
{
    long                    k;

    for (k = 0; k < pa; k++) {
	SN[k][I - 1] = 1.0;
	SN[k][I] = 0.0;
	SN[k][I + 1] = 0.0;
    }
}

/*------------ Transform frequency numerator case by HPF --------------*/
void
NH()
{
    long                    k;

    if ((nDet & 1) == false) {
	pa = nDet / 2;
	NHPF();
	return;
    }
    pa = (nDet - 1) / 2;
    NHPF();
    k = (nDet - 1) / 2 + 1;
    SN[k - 1][I - 1] = 0.0;
    SN[k - 1][I] = 1.0;
    SN[k - 1][I + 1] = 0.0;
}

/* ////////////////   koe֕ϊꍇ̕q   ///////////////// */
void
NLPF()
{
    long                    k;

    for (k = 0; k < pa; k++) {
	SN[k][I - 1] = 0.0;
	SN[k][I] = 0.0;
	SN[k][I + 1] = WC * WC * exp(1.0 / nDet * log(alphi));
    }
}

/*------------ Transform frequency numerator case by LPF --------------*/
void
NL()
{
    long                    k;

    if ((nDet & 1) == false) {
	pa = nDet / 2;
	NLPF();
	return;
    }
    pa = (nDet - 1) / 2;
    NLPF();
    k = (nDet - 1) / 2 + 1;
    SN[k - 1][I - 1] = 0.0;
    SN[k - 1][I] = 0.0;
    SN[k - 1][I + 1] = WC * exp(1.0 / (nDet * 2) * log(1 / alph));
}

/* //////////`FrVFt̕qWikoe,goȅꍇj////////// */
void
formche_2()
{					/* WvZ */
    long                    k;
    double                  ke;
    double                  TEMP, TEMP1;

    for (k = 0; k < pa; k++) {
	TEMP = chepole[k].re;
	TEMP1 = chepole[k].im;
	ke = (TEMP * TEMP + TEMP1 * TEMP1) * keisu;
	keisu = ke;
    }
}

/*---------------------------------------------------------------------*/
void
formche_1()
{					/* t`FrVFtq̌vZ */
    long                    k;
    double                  kei;
    double                  TEMP;

    for (k = 1; k <= pa; k++) {
	ichesi[k - 1].im = 1 / cos((k * 2 - 1) * M_PI / (nDet * 2));
	ichesi[k - 1].re = 0.0;
	TEMP = ichesi[k - 1].im;
	kei = TEMP * TEMP * chekei;
	chekei = kei;
    }
}

/*---------------------------------------------------------------------*/
void
cheNLPF()
{
    long                    k;
    double                  sqp;
    double                  TEMP, TEMP1;

    chekei = 1.0;
    if ((nDet & 1) == true) {		/* ̏ꍇ */
	keisu = 1.0;
	if (Mtd == INV)
	    formche_1();
	formche_2();
	keisu *= -chepole[pa].re;
	if (Type == BPF || Type == BRF)
	    return;
	for (k = 0; k < pa; k++) {
	    TEMP = chepole[k].re;
	    TEMP1 = chepole[k].im;
	    sqp = TEMP * TEMP + TEMP1 * TEMP1;
	    if (Mtd == CHV) {		/* `FrVFťvZ */
		if (Type == LPF) {	/* LPF̏ꍇ */
		    SN[k][I - 1] = 0.0;
		    SN[k][I] = 0.0;
		    if (k + 1 == 1)
			SN[k][I + 1] = WC * WC * keisu;
		    else
			SN[k][I + 1] = WC * WC;
		}
		else {			/* HPF̏ꍇ */
		    SN[k][I] = 0.0;
		    SN[k][I + 1] = 0.0;
		    if (k + 1 == 1)
			SN[k][I - 1] = keisu / sqp;
		    else
			SN[k][I - 1] = 1 / sqp;
		}
	    }				/*---------------------*/
	    else {			/* t`FrVFťvZ */
		if (Type == LPF) {	/* LPF̏ꍇ */
		    SN[k][I] = 0.0;
		    if (k + 1 == 1) {
			SN[k][I - 1] = keisu / chekei;
			TEMP = ichesi[k].im;
			SN[k][I + 1] = WC * WC * (TEMP * TEMP) *
			    keisu / chekei;
		    }
		    else {
			SN[k][I - 1] = 1.0;
			TEMP = ichesi[k].im;
			SN[k][I + 1] = WC * WC * (TEMP * TEMP);
		    }
		}
		else {			/* HPF̏ꍇ */
		    SN[k][I - 1] = 1.0;
		    SN[k][I] = 0.0;
		    TEMP = ichesi[k].im;
		    SN[k][I + 1] = WC * WC / (TEMP * TEMP);
		}
	    }				/*---------------------*/
	}
    }
    else {				/* ̏ꍇ */
	if (Mtd == CHV)
	    keisu = 1 / sqrt(1 + alph);
	else
	    keisu = 1.0;
	if (Mtd == INV)
	    formche_1();
	formche_2();
	if (Type == BPF || Type == BRF)
	    return;
	for (k = 0; k < pa; k++) {
	    TEMP = chepole[k].re;
	    TEMP1 = chepole[k].im;
	    sqp = TEMP * TEMP + TEMP1 * TEMP1;
	    if (Mtd == CHV) {
		if (Type == LPF) {	/* LPF̏ꍇ */
		    SN[k][I - 1] = 0.0;
		    SN[k][I] = 0.0;
		    if (k + 1 == 1)
			SN[k][I + 1] = WC * WC * keisu;
		    else
			SN[k][I + 1] = WC * WC;
		}
		else {			/* HPF̏ꍇ */
		    SN[k][I] = 0.0;
		    SN[k][I + 1] = 0.0;
		    if (k + 1 == 1)
			SN[k][I - 1] = keisu / sqp;
		    else
			SN[k][I - 1] = 1 / sqp;
		}
	    }
	    else {			/* t`FrVFťvZ */
		if (Type == LPF) {	/* LPF̏ꍇ */
		    SN[k][I] = 0.0;
		    if (k + 1 == 1) {
			SN[k][I - 1] = keisu / chekei;
			TEMP = ichesi[k].im;
			SN[k][I + 1] = WC * WC * (TEMP * TEMP) *
			    keisu / chekei;
		    }
		    else {
			SN[k][I - 1] = 1.0;
			TEMP = ichesi[k].im;
			SN[k][I + 1] = WC * WC * (TEMP * TEMP);
		    }
		}
		else {			/* HPF̏ꍇ */
		    SN[k][I - 1] = 1.0;
		    SN[k][I] = 0.0;
		    TEMP = ichesi[k].im;
		    SN[k][I + 1] = WC * WC / (TEMP * TEMP);
		}
	    }
	}
    }
}

/*---------------------------------------------------------------------*/
void
cheNL()
{
    long                    k;

    if ((nDet & 1) == false) {
	pa = nDet / 2;
	cheNLPF();
    }
    else {
	pa = (nDet - 1) / 2;
	cheNLPF();
	if (Type == BPF || Type == BRF)
	    return;
	k = (nDet + 1) / 2;
	if (Type == LPF) {
	    SN[k - 1][I - 1] = 0.0;
	    SN[k - 1][I] = 0.0;
	    if (nDet == 1)
		SN[k - 1][I + 1] = WC * chepole[0].re;
	    else
		SN[k - 1][I + 1] = WC;
	}
	else {
	    SN[k - 1][I - 1] = 0.0;
	    SN[k - 1][I + 1] = 0.0;
	    if (Mtd == CHV)
		SN[k - 1][I] = 1 / -chepole[k - 1].re;
	    else
		SN[k - 1][I] = 1.0;
	}
    }
}

/* ////////////////   aqe֕ϊꍇ̕ꌈ   ///////////////// */
void
form7()
{
    long                    k;
    double                  TEMP, TEMP1;

    for (k = 1; k <= pa; k++) {
	SD[k * 2 - 2][I - 1] = 1.0;
	SD[k * 2 - 2][I] = -2 * W[k * 2 - 2];
	TEMP = W[k * 2 - 2];
	TEMP1 = Z[k * 2 - 2];
	SD[k * 2 - 2][I + 1] = TEMP * TEMP + TEMP1 * TEMP1;
	SD[k * 2 - 1][I - 1] = 1.0;
	SD[k * 2 - 1][I] = -2 * W[k * 2 - 1];
	TEMP = W[k * 2 - 1];
	TEMP1 = Z[k * 2 - 1];
	SD[k * 2 - 1][I + 1] = TEMP * TEMP + TEMP1 * TEMP1;
    }
}

/*-------------------- Sub routine form6 for lpf_d2--------------------*/
void
form6()
{
    long                    k;

    for (k = 0; k < pa; k++) {
	kq = k + 1;
	if (Mtd == BTW) {		/* Butterworth̏ꍇ */
	    para.re = Pre[k];
	    para.im = Pim[k];
	}				/*-----------------*/
	else {				/* Chebyshev,tchebyshev̏ꍇ */
	    para.re = chepole[k].re;
	    para.im = chepole[k].im;
	}				/*-----------------*/
	rootmult();
    }
}

/*----------- Transform frequency denominator case by BRF -------------*/
void
LPF_D2()
{
    long                    k, at;

    if (Mtd == BTW || Mtd == CHV) {
	Wb = fc2[I + 1] - fc1[I + 1];
	Wo = fc1[I + 1] * fc2[I + 1];
    }
    else {
	Wb = fa2[I + 1] - fa1[I + 1];
	Wo = fa1[I + 1] * fa2[I + 1];
    }
    if ((nDet & 1) == false) {
	pa = nDet / 2;
	form6();
	form7();
	return;
    }
    pa = (nDet - 1) / 2;
    form6();
    form7();
    k = nDet;
    at = (k + 1) / 2;
    if (Mtd == CHV || Mtd == INV)
	SD[k - 1][I] = Wb / -chepole[at - 1].re;
    else
	SD[k - 1][I] = Wb / Pre[at - 1];
    SD[k - 1][I - 1] = 1.0;
    SD[k - 1][I + 1] = Wo;
}

/* ////////////////   aoe֕ϊꍇ̕ꌈ   ///////////////// */
void
form4()
{
    long                    k;

    for (k = 0; k < pa; k++) {
	kq = k + 1;
	if (Mtd == BTW) {		/* Butterworth̏ꍇ */
	    para.re = Pre[k];
	    para.im = Pim[k];
	}				/*-----------------*/
	else {				/* Chebyshev,tChebyshev̏ꍇ */
	    para.re = chepole[k].re;
	    para.im = chepole[k].im;
	}				/*-----------------*/
	rootmult1();
    }
}

/*----- Transform frequency denominator coefficient case of bpf -------*/
void
LPF_D1()
{
    long                    k;

    if (Mtd == BTW || Mtd == CHV) {	/* `FrVFt̏ꍇ */
	Wb = fc2[I + 1] - fc1[I + 1];
	Wo = fc1[I + 1] * fc2[I + 1];
    }					/*------------------*/
    else {				/* t`FrVFt̏ꍇ */
	Wb = fa2[I + 1] - fa1[I + 1];
	Wo = fa1[I + 1] * fa2[I + 1];
    }					/*--------------------*/
    if ((nDet & 1) == false) {
	pa = nDet / 2;
	form4();
	form7();
	return;
    }
    pa = (nDet - 1) / 2;
    form4();
    form7();
    k = nDet;
    SD[k - 1][I - 1] = 1.0;
    SD[k - 1][I + 1] = Wo;
    if (Mtd == BTW)
	SD[k - 1][I] = Wb * exp(1.0 / (nDet * 2) * log(alphi));
    else
	SD[k - 1][I] = -Wb * chepole[(k + 1) / 2 - 1].re;
}

/* ////////////////   goe֕ϊꍇ̕ꌈ   ///////////////// */
void
form3_H()
{
    long                    k, pa;

    if ((nDet & 1) == false)
	pa = nDet / 2;
    else
	pa = (nDet - 1) / 2;
    for (k = 0; k < pa; k++) {
	SD[k][I - 1] = 1.0;
	SD[k]
	    [I] = -2 * WC * Pre[k] * exp(-1.0 / nDet * log(alphi));
	SD[k]
	    [I + 1] = WC * WC * exp(-1.0 / nDet * log(alphi));
    }
}

/*----Transform frequency denominator coefficient  case by lpf,hpf-----*/
void
LPF_DH()
{
    long                    k;

    WC = fc1[I + 1];
    if ((nDet & 1) == false) {
	form3_H();
	return;
    }
    form3_H();
    k = (nDet + 1) / 2;
    SD[k - 1][I - 1] = 0.0;
    SD[k - 1][I] = 1.0;
    SD[k - 1][I + 1] = WC * exp(-1.0 / (nDet * 2) * log(alphi));
}

/* //////////    `FrVFt̕Wigoȅꍇj   ////////// */
void
cheform3_H()
{
    long                    k, pa;
    double                  sqp, TEMP, TEMP1;

    if ((nDet & 1) == false)
	pa = nDet / 2;
    else
	pa = (nDet - 1) / 2;
    for (k = 0; k < pa; k++) {
	Pre[k] = chepole[k].re;
	Pim[k] = chepole[k].im;
	TEMP = Pre[k];
	TEMP1 = Pim[k];
	sqp = TEMP * TEMP + TEMP1 * TEMP1;
	SD[k][I - 1] = 1.0;
	SD[k][I] = -2 * WC * Pre[k] / sqp;
	SD[k][I + 1] = WC * WC / sqp;
    }
}

/*---------------------------------------------------------------------*/
void
cheLPF_DH()
{
    long                    k;

    if (Mtd == CHV)
	WC = fc1[I + 1];
    else
	WC = fa1[I + 1];
    if ((nDet & 1) == false) {		/* ̏ꍇ */
	cheform3_H();
	return;
    }
    cheform3_H();
    k = (nDet + 1) / 2;
    SD[k - 1][I - 1] = 0.0;
    SD[k - 1][I] = 1.0;
    SD[k - 1][I + 1] = -(WC / chepole[k - 1].re);

 /* ̏ꍇ */
}

/* ////////////////   koe֕ϊꍇ̕ꌈ   ///////////////// */
void
form3()
{
    long                    k;

    for (k = 0; k < pa; k++) {
	SD[k][I - 1] = 1.0;
	SD[k][I] = -2 * WC * Pre[k];
	SD[k][I + 1] = WC * WC * exp(1.0 / nDet * log(alphi));
    }
}

/*----Transform frequency denominator coefficient  case by lpf---------*/
void
LPF_DL()
{
    long                    k;

    WC = fc1[I + 1];
    if ((nDet & 1) == false) {
	pa = nDet / 2;
	form3();
	return;
    }
    pa = (nDet - 1) / 2;
    form3();
    k = (nDet - 1) / 2 + 1;
    SD[k - 1][I - 1] = 0.0;
    SD[k - 1][I] = 1.0;
    SD[k - 1][I + 1] = WC * exp(1.0 / (nDet * 2) * log(alphi));
}

/* //////////    `FrVFt̕Wikoȅꍇj   ////////// */
void
cheform3()
{
    long                    k;
    double                  sqp;
    double                  TEMP, TEMP1;

    if ((nDet & 1) == false)
	pa = nDet / 2;
    else
	pa = (nDet - 1) / 2;
    for (k = 0; k < pa; k++) {
	Pre[k] = chepole[k].re;
	Pim[k] = chepole[k].im;
	TEMP = Pre[k];
	TEMP1 = Pim[k];
	sqp = TEMP * TEMP + TEMP1 * TEMP1;
	SD[k][I - 1] = 1.0;
	SD[k][I] = -2 * WC * Pre[k];
	SD[k][I + 1] = WC * WC * sqp;
    }
}

/*---------------------------------------------------------------------*/
void
cheLPF_DL()
{
    long                    k;

    if (Mtd == CHV)
	WC = fc1[I + 1];
    else
	WC = fa1[I + 1];
    if ((nDet & 1) == false) {		/* ̏ꍇ */
	cheform3();
	return;
    }
    cheform3();
    k = (nDet + 1) / 2;
    SD[k - 1][I - 1] = 0.0;
    SD[k - 1][I] = 1.0;
    SD[k - 1][I + 1] = -WC * chepole[k - 1].re;

 /* ̏ꍇ */
}

/* ////////////////////   |pXtB^   /////////////////////// */
void
form2()
{
    long                    k;

    for (k = 0; k < pa; k++) {
	P[k][I - 1] = -2 * Pre[k];
	P[k][I] = 1 * exp(1.0 / nDet * log(alphi));
    }
}

/*---------------------- Normalized LPF -------------------------------*/
void
Norm_LPF()
{
    long                    k;

    if ((nDet & 1) == false) {
	pa = nDet / 2;
	form2();
	return;
    }
    pa = (nDet - 1) / 2;
    form2();
    k = (nDet + 1) / 2;
    P[k - 1][I - 1] = 1.0;
}

/* ////////////////////   |pX̋ɂ̐݌v   ///////////////////// */
void
Pole()
{
    long                    k;
    double                  ke, ki;

    for (k = 1; k <= nDet; k++) {
	ke = k * 2.0 - 1;
	ki = nDet * 2.0;
	Pre[k - 1] = -sin(ke / ki * M_PI) * exp(1.0 / (nDet * 2) * log(alphi));
	Pim[k - 1] = cos(ke / ki * M_PI) * exp(1.0 / (nDet * 2) * log(alphi));
    }
}

/******************    function  hypsin     ********************/
double
hypsin(x)
double                  x;
{
    double                  ex;

    ex = exp(x);
    return ((ex - 1.0 / ex) / 2.0);
}

/******************    function  hypcos     ********************/
double
hypcos(x)
double                  x;
{
    double                  ex;

    ex = exp(x);
    return ((ex + 1.0 / ex) / 2.0);
}

/********    function  archypcos     ********/
double
archypcos(x)
double                  x;
{
    return log(x + sqrt(x * x - 1));
}

/********    function  archypsin     ********/
double
archypsin(x)
double                  x;
{
    return log(x + sqrt(x * x + 1));
}

/* //////////             `FrVFt̋Ɍ                ////////// */
void
iche_po()
{
    long                    i;
    double                  sqpl;
    double                  TEMP, TEMP1;

    for (i = 0; i < nDet; i++) {
	TEMP = chepole[i].re;
	TEMP1 = chepole[i].im;
	sqpl = TEMP * TEMP + TEMP1 * TEMP1;
	chepole[i].re /= sqpl;
	chepole[i].im /= sqpl;
    }
}

/*---------------------------------------------------------------------*/
void
che_po1()
{
    long                    i;

    if ((nDet & 1) == false)
	pa = nDet / 2;
    else
	pa = (nDet - 1) / 2;
    for (i = 1; i <= pa; i++) {
	chere[i - 1] = -hypsin(archypsin(1 / sqrt(chealph)) / nDet
	    ) * sin((i * 2 - 1) * M_PI / (nDet * 2));
	cheim[i - 1] = hypcos(archypsin(1 / sqrt(chealph)) / nDet
	    ) * cos((i * 2 - 1) * M_PI / (nDet * 2));
	chepole[i - 1].re = chere[i - 1];
	chepole[i - 1].im = cheim[i - 1];
	chepole[nDet - i].re = chepole[i - 1].re;
	chepole[nDet - i].im = -chepole[i - 1].im;
    }
}

/*---------------------------------------------------------------------*/
void
chebyPole()
{
    long                    i;

    if ((nDet & 1) == false) {		/* ̏ꍇ */
	che_po1();
	if (Mtd == INV)
	    iche_po();
	return;
    }
    che_po1();
    i = (nDet + 1) / 2;
    chere[i - 1] = -hypsin(archypsin(1 / sqrt(chealph)) / nDet
	) * sin((i * 2 - 1) * M_PI / (nDet * 2));
    chepole[i - 1].re = chere[i - 1];
    chepole[i - 1].im = 0.0;
    if (Mtd == INV)
	iche_po();

 /* ̏ꍇ */
}

/* //////////////////////   At@̌蕔    ////////////////////// */
void
Alpha()
{
    alph = exp(-AMAX / 10 * log(10.0)) - 1;
    alphi = 1 / alph;
    if (Mtd == CHV) {
	chealph = alph;
	chealphi = alphi;
    }
    if (Mtd != INV)
	return;
    alph = 1 / (exp(-AMIN / 10 * log(10.0)) - 1);
    alphi = 1 / alph;
    chealph = alph;
    chealphi = alphi;
}

/* /////////////@@m̌ (aoeCaoȅꍇ)   ////////////// */
void
form1()
{
    long                    nJISU;
    double                  an, ax;

    an = AMIN / -10;
    ax = AMAX / -10;
    nx = log_((exp(an * log(10.0)) - 1) / (exp(ax * log(10.0)) - 1)
	) * (1 / (2 * log_(PM)));
    nx += 0.5;
    nJISU = (long) floor(nx + 0.5);
    nDet = nJISU;
}

/*----------------- N determination case of BPF,BRF -------------------*/
void
N1_determ()
{
    long                    nd, JI;

    PM = fa1[I];
    form1();
    JI = nDet;
    PM = fa2[I];
    form1();
    if (JI >= nDet) {
	nDet = JI;
	return;
    }
    nd = nDet;
    JI = nd;
    nDet = JI;
}

/* /////////////@@m̌ (koeCgoȅꍇ)   ////////////// */
void
N_determ()
{
    PM = OMEG;
    form1();
}

/* //////////           `FrVFt̎̌             ///////// */
void
cheform1()
{
    long                    nJISU;
    double                  an, ax;

    an = AMIN / -10;
    ax = AMAX / -10;
    c_chealph = exp(ax * log(10.0)) - 1;
    c_chealphi = 1 / chealph;
    nx = archypcos(sqrt((exp(an * log(10.0)) - 1) / c_chealph)) / archypcos(PM);
    nx += 0.5;
    nJISU = (long) floor(nx + 0.5);
    nDet = nJISU;
}

/*---------------------------------------------------------------------*/
void
cheN_determ()
{					/* koeCgoȅꍇ */
    PM = OMEG;
    cheform1();
}

/*---------------------------------------------------------------------*/
void
cheN1_determ()
{					/* aoeCaqȅꍇ */
    long                    nd, JI;

    PM = fa1[I];
    cheform1();
    JI = nDet;
    PM = fa2[I];
    form1();
    if (JI >= nDet) {
	nDet = JI;
	return;
    }
    nd = nDet;
    JI = nd;
    nDet = JI;
}

/* //////////   |pXւ̕ϊ  (aoeCaoȅꍇ)   ///////// */
void
Trans_b2()
{
    double                  par, par1, par2, par3, TEMP;

    TEMP = fa1[I + 1];
    par = TEMP * TEMP - fc1[I + 1] * fc2[I + 1];
    par1 = fa1[I + 1] * (fc2[I + 1] - fc1[I + 1]);
    TEMP = fa2[I + 1];
    par2 = TEMP * TEMP - fc1[I + 1] * fc2[I + 1];
    par3 = fa2[I + 1] * (fc2[I + 1] - fc1[I + 1]);
    if (fc1[I - 1] > fa1[I - 1]) {
	fa1[I] = par / par1;
	fa1[I] = fabs(fa1[I]);
	fa2[I] = par2 / par3;
	return;
    }
    TEMP = fa1[I + 1];
    fa1[I] = par1 / (fc1[I + 1] * fc2[I + 1] - TEMP * TEMP);
    fa1[I] = fabs(fa1[I]);
    TEMP = fa2[I + 1];
    fa2[I] = par3 / (fc1[I + 1] * fc2[I + 1] - TEMP * TEMP);
    fa2[I] = fabs(fa2[I]);
}

/* //////////   |pXւ̕ϊ  (koeCgoȅꍇ)   ///////// */
void
Trans_b1()
{
    if (fc1[I - 1] < fa1[I - 1])
	OMEG = fa1[I + 1] / fc1[I + 1];
    else {
	OMEG = -(fc1[I + 1] / fa1[I + 1]);
	OMEG = fabs(OMEG);
    }
}

/* /////////////////////   v|sO̕   ////////////////////// */
void
Prewarp()
{
    double                  pfs;

    pfs = M_PI / fs;
    fc1[I + 1] = 2.0 * tan(pfs * fc1[I - 1]);
    fa1[I + 1] = 2.0 * tan(pfs * fa1[I - 1]);
    fc2[I + 1] = 2.0 * tan(pfs * fc2[I - 1]);
    fa2[I + 1] = 2.0 * tan(pfs * fa2[I - 1]);
}


/*---------------------------------------------------------------------*/
void
IIR_filter()
{
 /*-----------------------------------*/
 /* hhqtB^݌vC|` */
 /*-----------------------------------*/
    AMAX = -AMAX;
    AMIN = -AMIN;

    if (Mtd == 0) {
	ErrDisp("Select pass band shape !\n");
	normal = -1;
	return;
    }

    switch (Type) {
	case LPF:			/* koěvZ */
	    if (fs / 2.0 < fa1[0]) {
		ErrDisp("illegal param: fs/2 < fa1 !\n");
		normal = -1;
		return;
	    }
	    else if (fa1[0] <= fc1[0]) {
		ErrDisp("illegal param: fa1 <= fc1 !\n");
		normal = -1;
		return;
	    }
	    Prewarp();
	    Trans_b1();
	    if (Mtd == BTW) {
		N_determ();
		if (nDet > MAXDT_IIR)
		    goto ManyDET;
		Alpha();
		Pole();
		Norm_LPF();
		LPF_DL();
		NL();
	    }
	    else {
		Alpha();
		cheN_determ();
		if (nDet > MAXDT_IIR)
		    goto ManyDET;
		chebyPole();
		cheLPF_DL();
		cheNL();
	    }
	    S_Z1();
	    break;

	case HPF:			/* goěvZ */
	    if (fs / 2.0 < fc1[0]) {
		ErrDisp("illegal param: fs/2 < fc1 !\n");
		normal = -1;
		return;
	    }
	    else if (fc1[0] <= fa1[0]) {
		ErrDisp("illegal param: fc1 <= fa1 !\n");
		normal = -1;
		return;
	    }
	    Prewarp();
	    Trans_b1();
	    if (Mtd == BTW) {
		N_determ();
		if (nDet > MAXDT_IIR)
		    goto ManyDET;
		Alpha();
		Pole();
		Norm_LPF();
		LPF_DH();
		NH();
	    }
	    else {
		Alpha();
		cheN_determ();
		if (nDet > MAXDT_IIR)
		    goto ManyDET;
		chebyPole();
		cheLPF_DH();
		cheNL();
	    }
	    S_Z1();
	    break;

	case BPF:			/* aoěvZ */
	    if (fs / 2.0 < fa2[0]) {
		ErrDisp("illegal param: fs/2 < fa2 !\n");
		normal = -1;
		return;
	    }
	    else if (fa2[0] <= fc2[0]) {
		ErrDisp("illegal param: fa2 <= fc2 !\n");
		normal = -1;
		return;
	    }
	    else if (fc2[0] <= fc1[0]) {
		ErrDisp("illegal param: fc2 <= fc1 !\n");
		normal = -1;
		return;
	    }
	    else if (fc1[0] <= fa1[0]) {
		ErrDisp("illegal param: fc1 <= fa1 !\n");
		normal = -1;
		return;
	    }
	    Prewarp();
	    Trans_b2();
	    if (Mtd == BTW) {
		N1_determ();
		if (nDet > MAXDT_IIR)
		    goto ManyDET;
		Alpha();
		Pole();
		Norm_LPF();
		LPF_D1();
		NBP();
	    }
	    else {
		Alpha();
		cheN1_determ();
		if (nDet > MAXDT_IIR)
		    goto ManyDET;
		chebyPole();
		LPF_D1();
		cheNL();
		if (Mtd != INV) {
		    NBP();
		}
		else {
		    icheNBP();
		}
	    }
	    S_Z2();
	    break;

	case BRF:			/* aqěvZ */
	    if (fs / 2.0 < fc2[0]) {
		ErrDisp("illegal param: fs/2 < fc2 !\n");
		normal = -1;
		return;
	    }
	    else if (fc2[0] <= fa2[0]) {
		ErrDisp("illegal param: fc2 <= fa2 !\n");
		normal = -1;
		return;
	    }
	    else if (fa2[0] <= fa1[0]) {
		ErrDisp("illegal param: fa2 <= fa1 !\n");
		normal = -1;
		return;
	    }
	    else if (fa1[0] <= fc1[0]) {
		ErrDisp("illegal param: fa1 <= fc1 !\n");
		normal = -1;
		return;
	    }
	    Prewarp();
	    Trans_b2();
	    if (Mtd == BTW) {
		N1_determ();
		if (nDet > MAXDT_IIR)
		    goto ManyDET;
		Alpha();
		Pole();
		Norm_LPF();
		LPF_D2();
		NBR();
	    }
	    else {
		Alpha();
		cheN1_determ();
		if (nDet > MAXDT_IIR)
		    goto ManyDET;
		chebyPole();
		LPF_D2();
		cheNL();
		if (Mtd != INV) {
		    NBR();
		}
		else {
		    icheNBR();
		}
	    }
	    S_Z2();
	    break;

	default:
	    ErrDisp("Select LPF/HPF/BPF/BRF !\n");
	    normal = -1;
	    return;
    }
    return;

ManyDET:
    ErrDisp("too many determination !\n");
    normal = -1;
    return;
}

#undef I


/* //////////////////////////////////////////////////////////////////// */

void
trans_iir()
{
 /* hhqtB^̓`B߂ */
    complex                 z2;
    double                  w2, w4;
    register int            i, k;

    if (normal != 0) {
	return;
    }
    for (i = 0; i <= 200; i++) {
	dk.re = 1.0;
	dk.im = 0.0;
	nk.re = 1.0;
	nk.im = 0.0;
	w2 = M_PI / 200.0 * (double) i;
	w4 = w2 * 2.0;
	z.re = cos(w2);
	z.im = -sin(w2);
	z2.re = cos(w4);
	z2.im = -sin(w4);
	for (k = 1; k <= nDet; k++) {
	    a1.re = a[k][1];
	    a1.im = 0.0;
	    a2.re = a[k][2];
	    a2.im = 0.0;
	    cmplx_op(a2, z, mult, &a2);
	    a3.re = a[k][3];
	    a3.im = 0.0;
	    cmplx_op(a3, z2, mult, &a3);
	    cmplx_op(a1, a2, add, &n1);
	    cmplx_op(a3, n1, add, &n1);
	    b1.re = b[k][1];
	    b1.im = 0.0;
	    cmplx_op(b1, z, mult, &b1);
	    b2.re = b[k][2];
	    b2.im = 0.0;
	    cmplx_op(b2, z2, mult, &b2);
	    cmplx_op(b1, b2, add, &d1);
	    d1.re += 1.0;
	    cmplx_op(n1, nk, mult, &nk);
	    cmplx_op(d1, dk, mult, &dk);
	}
	h1.re = h;
	h1.im = 0.0;
	cmplx_op(h1, nk, mult, &nk);
	den_re[i] = nk.re;
	den_im[i] = nk.im;
	num_re[i] = dk.re;
	num_im[i] = dk.im;
    }
}


void
gain_and_gdelay_frequency_characteristics()
{
    int                     f;
    double                  diffp, diffa;
    double                  ar, ai, br, bi, cr, ci;
    if (normal != 0) {
	return;
    }

    if (Style == FIR) {
	divd = (long) (nd / 2.0);
    }
    if (Style == IIR) {
	divd = 200;
    }
    bphase = 0.0;

    for (f = 0; f < divd; f++) {
	if (Style == FIR) {
	    num_re[f] = 1.0;
	    num_im[f] = 0.0;
	    ci = -den_im[f];
	    cr = den_re[f];
	    gain = sqrt(ci * ci + cr * cr);
	}
	else {
	    ar = den_re[f];
	    ai = den_im[f];
	    br = num_re[f];
	    bi = num_im[f];
	    cr = ar * br + ai * bi;
	    ci = ai * br - ar * bi;
	    gain = sqrt((ar * ar + ai * ai) / (br * br + bi * bi));
	}
	if (cr != 0) {
	    phase = atan(ci / cr);
	}
	else {
	    phase = M_PI / 2;
	}

	if ((diffp = bphase - phase) >= 0.0) {
	    if ((diffa = diffp - M_PI) > 0.0) {
		diffp = diffa;
	    }
	}
	else {
	    diffp = diffp + M_PI;
	}

	gdelay[f] = (f == 0) ? 0.0 : diffp;
	bphase = phase;

	if (gain < 1e-6)
	    gain = 1e-6;
	fgain[f] = log_(gain) * 20.0;
    }
    gdelay[0] = gdelay[1];
}

typedef struct coe_ {
    double                  a0, a1, a2;
    double                  b1, b2;
    double                  w1, w2;
    double                  L2;
}                       COE;

void Scale1D()
{
    int         i, j;
    COE         coe[MAXFIL], *pCoe;
    double      Xn, w0;

    for (i = 1; i <= nDet; i++) {
	coe[i-1].a0 = a[i][1];
	coe[i-1].a1 = a[i][2];
	coe[i-1].a2 = a[i][3];
	coe[i-1].b1 = b[i][1];
	coe[i-1].b2 = b[i][2];
        coe[i-1].w1 = coe[i-1].w2 = coe[i-1].L2 = 0.0;
    }

    for (j = 0, Xn = 1.0; j < N_LIM; j++, Xn = 0.0) {
	for (i = 0, pCoe = &coe[0]; i < nDet; i++, pCoe++) {
	    w0 = Xn - pCoe->b1 * pCoe->w1 - pCoe->b2 * pCoe->w2;
	    pCoe->L2 += w0 * w0;
	    Xn = pCoe->a0 * w0 + pCoe->a1 * pCoe->w1 + pCoe->a2 * pCoe->w2;
	    pCoe->w2 = pCoe->w1;
	    pCoe->w1 = w0;
	}
    }
    for (i = 0; i < nDet; i++) {
	coe[i].L2 = sqrt(coe[i].L2);
    }

    wsf = 1.0;
    for (i = 1; i < nDet; i++) {
	wsf *= sf[i - 1] = coe[i - 1].L2 / coe[i].L2;
    }
    wsf *= sf[nDet - 1] = h * coe[nDet - 1].L2;
}

void Scale2D()
{
    int         i, j;
    COE         coe[MAXFIL], *pCoe;
    double      Xn, w0;

    for (i = 1; i <= nDet; i++) {
	coe[i-1].a0 = a[i][1];
	coe[i-1].a1 = a[i][2];
	coe[i-1].a2 = a[i][3];
	coe[i-1].b1 = b[i][1];
	coe[i-1].b2 = b[i][2];
        coe[i-1].w1 = coe[i-1].w2 = coe[i-1].L2 = 0.0;
    }

    Xn = 1.0;
    for (j = 0; j < N_LIM; j++) {
	for (i = 0, pCoe = &coe[0]; i < nDet; i++, pCoe++) {
	    w0 = pCoe->a0 * Xn + pCoe->w1;
	    pCoe->L2 += w0 * w0;
	    pCoe->w1 = pCoe->a1 * Xn - pCoe->b1 * w0 + pCoe->w2;
	    pCoe->w2 = pCoe->a2 * Xn - pCoe->b2 * w0;
	    Xn = w0;
	}
	Xn = 0.0;
    }
    for (i = 0; i < nDet; i++) {
	coe[i].L2 = sqrt(coe[i].L2);
    }

    wsf = sf[0] = 1.0 / coe[0].L2;
    for (i = 1; i < nDet; i++) {
	wsf *= sf[i] = coe[i - 1].L2 / coe[i].L2;
    }
}

void
SpecOut(fo)
FILE                   *fo;
{
    int                     k;
    int                     ii, jj;
    char                   *stype;

    fprintf(fo, "# Filter name: %s\n", fnam);
    fprintf(fo, "# samp freq  = %e[Hz]\n", fs);

    fprintf(fo, "# ripple = %g[db], attenuation = %g[db]\n",
	AMAX, AMIN);
    fprintf(fo, "# fc1 = %g, fa1 = %g\n", fc1[0], fa1[0]);
    switch (Type) {
	case LPF:
	    stype = "Lo pass";
	    break;
	case HPF:
	    stype = "High pass";
	    break;
	case BPF:
	    stype = "Band pass";
	    fprintf(fo, "# fc2 = %g, fa2 = %g\n", fc2[0], fa2[0]);
	    break;
	case BRF:
	    stype = "Band rejection";
	    fprintf(fo, "# fc2 = %g, fa2 = %g\n", fc2[0], fa2[0]);
	    break;
    }
    fprintf(fo, "# %s type", stype);

    switch (Style) {
	case FIR:
	    fprintf(fo, " FIR filter\n");
	    fprintf(fo, "# number of determination N=%12d\n", nDet);
	    fprintf(fo, "# group delay time [ms] L=%g\n", L / fs * 1000.0);
	    fprintf(fo, "# responce for impulse\n");
	    for (k = 0; k < nDet; k++) {
		fprintf(fo, "%5d %15.6e\n", k, hn2[k]);
	    }
	    break;
	case IIR:
	    switch (Mtd) {
		case BTW:
		    stype = "Butterworth";
		    break;
		case CHV:
		    stype = "Chebyshev";
		    break;
		case INV:
		    stype = "Inverse Chebyshev";
		    break;
	    }
	    fprintf(fo, " %s IIR filter\n", stype);
	    fprintf(fo, "# number of determination\nN=%12d\n\n", nDet * 2);
	    fprintf(fo,
		"# trans func@H(Z)= * { A0(Z)/B0(Z) } * { A1(Z)/B1(Z) } * ...\n\n");
	    fprintf(fo, "#        Ai(Z) = a(i,1)*Z^0 + a(i,2)*Z^-1 + a(i,3)*Z^-2 \n");
	    fprintf(fo, "#        Bi(Z) =      1     + b(i,1)*Z^-1 + b(i,2)*Z^-2 \n\n");
	    fprintf(fo, "# overall coeffrence\nh=%g\n", h);
	    fprintf(fo, " \n");
	    for (ii = 1; ii <= nDet; ii++) {
		for (jj = 1; jj <= 3; jj++) {
		    fprintf(fo, "  a[%3d,%3d]=%12.6g", ii, jj, a[ii][jj]);
		}
		putc('\n', fo);
	    }
	    putc('\n', fo);
	    for (ii = 1; ii <= nDet; ii++) {
		for (jj = 1; jj <= 2; jj++) {
		    fprintf(fo, "  b[%3d,%3d]=%12.6g", ii-1, jj, b[ii][jj]);
		}
		putc('\n', fo);
	    }
    }
}
void
GainOut(fo)
FILE                   *fo;
{
    int                     f, divd;
    double                  deltf;

    if (Style == FIR) {
	divd = (long) (nd / 2.0);
    }
    if (Style == IIR) {
	divd = 200;
    }
    deltf = fs / divd / 2;

    fprintf(fo, "TitleText: %s: Gain vs frequency\n", fnam);
    fprintf(fo, "XUnitText: frequency [Hz]\n");
    fprintf(fo, "YUnitText: gain [dB]\n");
    for (f = 0; f < divd; f++) {
	fprintf(fo, "%e\t%e\n", (double) f * deltf, fgain[f]);
    }
}

void
GdlyOut(fo)
FILE                   *fo;
{
    int                     f, divd;
    double                  deltf;

    if (Style == FIR) {
	divd = (long) (nd / 2.0);
    }
    if (Style == IIR) {
	divd = 200;
    }
    deltf = fs / divd / 2;

    fprintf(fo, "TitleText: %s: Group delay vs frequency\n", fnam);
    fprintf(fo, "XUnitText: frequency [Hz]\n");
    fprintf(fo, "YUnitText: delay [ms]\n");
    for (f = 0; f < divd; f++) {
	fprintf(fo, "%e\t%e\n", (double) f * deltf, gdelay[f] / (2.0e-3 * M_PI * deltf));
    }
}
void
Output(fo)
FILE                   *fo;
{
    switch (Out) {
      case SPEC:
	if (D == D1) {
	    Scale1D();
	    fprintf(fo, "# Scalling for 1D\n");
	} else if (D == D2) {
	    Scale2D();
	    fprintf(fo, "# Scalling for 2D\n");
	}
	SpecOut(fo);
	break;
      case GAIN:
	GainOut(fo);
	break;
      case GDLY:
	GdlyOut(fo);
	break;
      default:
	ErrDisp("Select output item !\n");
    }
}

void
filter()
{
    char                    s[BUFSIZ];
    normal = 0;

    if (fnam[0] == '\0') {
	ErrDisp("Enter filter name\n");
	normal = -1;
	return;
    }

    switch (Style) {
	case FIR:
	    fir_design();
	    if (normal == 0) {
		sprintf(s, "number of determination N=%12d\n", nDet);
		TextDisp(s);
		sprintf(s, "group delay time [ms] L=%g\n", L / fs * 1000.0);
		TextDisp(s);
		sprintf(s, "'%s' design completed successfuly !\n",
		    fnam);
		TextDisp(s);
		fir_fft();
		gain_and_gdelay_frequency_characteristics();
	    }
	    return;
	case IIR:
	    IIR_filter();
	    if (normal == 0) {
		sprintf(s, "number of determination N=%12d\n", nDet * 2);
		TextDisp(s);
		sprintf(s, "'%s' design completed successfuly !\n",
		    fnam);
		TextDisp(s);
		trans_iir();
		gain_and_gdelay_frequency_characteristics();
	    }
	    return;
	default:
	    ErrDisp("Select FIR/IIR!\n");
	    normal = -1;
	    return;
    }
}

/* End. */
