/*
 * digfil.h
 *	Copyleft by mac@research.co.jp
 * $Id: digfil.h,v 1.1.1.1 2003/08/01 21:57:43 mac Exp $
 */
#define MAXDT_FIR 512
#define MAXDT_IIR 30
#define N_LIM 1000
#define MAXFIL 31

#ifndef M_PI
#	define M_PI 3.1415926
#endif

#define true 1
#define false 0

#define FIR 1
#define IIR 2

#define NOSCALE 0
#define D1  1
#define D2  2

#define LPF 1
#define HPF 2
#define BPF 3
#define BRF 4

#define BTW 1
#define CHV 2
#define INV 3

#define SPEC 1
#define GAIN 2
#define GDLY 3

typedef double          impulse[MAXDT_FIR + 1];
typedef double          freq[3];

typedef struct complex {
    double                  re, im;
}                       complex;

typedef enum {
    add, sub, mult, dv
}                       operation;

#ifdef MAIN

double                  a[MAXDT_IIR + 1][4], b[MAXDT_IIR + 1][4];
double                  den_re[MAXDT_FIR * 2], den_im[MAXDT_FIR * 2], num_re[MAXDT_FIR * 2], num_im[MAXDT_FIR * 2];

complex                 z, nk, dk, n1, d1, h1, a1, a2, a3, b1, b2;

double                  fs, h, gain, phase, bphase;

char                   *fnam;
double                  gdelay[MAXDT_FIR + 1];
double                  fgain[MAXDT_FIR + 1];
int                     nDet;
int                     Style, Type, Mtd;
int                     D = NOSCALE; /* added by A.S. */
int                     nd, divd;
double                  AMAX, AMIN, L, KA;
impulse                 hn1, hn2, ak;
freq                    fc1, fc2, fa1, fa2;
int                     Out;
int                     normal = -1;
double                  sf[MAXFIL + 1], wsf;
#else

extern double           a[MAXDT_IIR + 1][4], b[MAXDT_IIR + 1][4];
extern double           den_re[MAXDT_FIR * 2], den_im[MAXDT_FIR * 2], num_re[MAXDT_FIR * 2], num_im[MAXDT_FIR * 2];

extern complex          z, nk, dk, n1, d1, h1, a1, a2, a3, b1, b2;

extern double           fs, h, gain, phase, bphase;

extern char            *fnam;
extern double           gdelay[MAXDT_FIR + 1];
extern double           fgain[MAXDT_FIR + 1];
extern int              nDet;
extern int              Style, Type, Mtd;
extern int              D; /* added by A.S. */
extern int              nd, divd;
extern double           AMAX, AMIN, L, KA;
extern impulse                 hn1, hn2, ak;
extern freq             fc1, fc2, fa1, fa2;
extern int              Out;
extern int              normal;
extern double           sf[MAXFIL + 1], wsf;
#endif
