#include <stdio.h>
static char            *RcsID = "$Id: fft.c,v 1.1.1.1 2003/08/01 21:57:43 mac Exp $";

void
fft(x, a, b, n, s)
double                 *x,		/* given data */
                       *a,		/* cos transform of x */
                       *b,		/* sin transform of x */
                       *s;		/* table of sin(2*pai*i/n),
					 * i=0...n/4-1 */
int                     n;		/* size of data */
{
    double                  s1, s2, cs, sn;
    double                 *px1, *px2;
    int                     n2, n4, np;
    int                     ip, i;
    int                     k, m1, m2;
    register int            i1, i2, i3, i4, i5, i6, ipk;

    for (i = n, np = 0; i > 1; np++) {
	i >>= 1;
    }

    n = 1 << np;
    n2 = n / 2;
    n4 = n / 4;

    for (m1 = 0, m2 = 1, ip = n2;
	ip != 0;
	m1 = m2, m2 *= 2, ip /= 2) {

	for (i = 0; i < ip; i++) {

	    i1 = m2 * i;
	    i3 = i1 + n2;
	    px1 = &x[i1];
	    px2 = &x[i3];
	    a[i1] = *px1 + *px2;
	    b[i1] = *px1 - *px2;

	    if (m1 != 0) {
		i2 = i1 + m1;
		i4 = i3 + m1;
		a[i2] = x[i2];
		b[i2] = x[i4];

		for (k = 1; k < m1; k++) {
		    ipk = ip * k;
		    px1 = &x[i3 + k];
		    px2 = &x[i4 + k];
		    cs = s[n4 - ipk];
		    sn = s[ipk];
		    s1 = cs * *px1 - sn * *px2;
		    s2 = sn * *px1 + cs * *px2;

		    i5 = i1 + k;
		    i6 = i1 - k + m2;
		    px1 = &x[i5];
		    px2 = &x[i2 + k];
		    a[i5] = *px1 + s1;
		    a[i6] = *px1 - s1;
		    b[i5] = *px2 + s2;
		    b[i6] = s2 - *px2;
		}
	    }
	}

	for (i = 0; i < ip; i++) {
	    i1 = m2 * i;
	    i2 = i1 * 2;
	    i3 = i2 + m2;

	    for (k = 0; k < m2; k++) {
		i4 = i1 + k;
		x[i2 + k] = a[i4];
		x[i3 + k] = b[i4];
	    }
	}
    }
}
