 /* ehqtB^ACpX̍t[Gϊ @m@ w */
/* Converted Turbo Pascal to C by p2c.
 * Modified by mac@research.co.jp (Shigeru makino)
 * Copyleft by Hiroshi Ochi, Shigeru makino.
 */
static char            *RcsID = "$Id: fir_fft.c,v 1.1.1.1 2003/08/01 21:57:43 mac Exp $";
#include <math.h>
#include "digfil.h"
void
fir_fft()
{
    static int              init_fft = 0, ig;
    static double           c[MAXDT_FIR], s[MAXDT_FIR];
    static int              ik[MAXDT_FIR * 2];
    int                     i, j, *pik;
    int                     nc, it1, it2, it3, lf, l1, l2, mf, ka,
                            kb, ix, wp, mn, nd2;
    double                  q, xka, yka, xj;
    double                 *pcos, *psin, *px_re, *px_im, *py_re, *py_im;

    nd = MAXDT_FIR * 2;
    nd2 = nd / 2;

    if (init_fft == 0) {
	q = 2.0 * M_PI / nd;
	pcos = &c[0];
	psin = &s[0];
	for (it1 = 0; it1 < nd2; it1++) {
	    *pcos++ = cos(it1 * q);
	    *psin++ = sin(it1 * q);
	}
	for (ig = 0, i = nd; i > 1; ig++) {
	    i >>= 1;
	}

	ik[0] = 0;
	mn = nd / 2;
	nc = 1;
	for (it2 = 1; it2 <= ig; it2++) {
	    for (it3 = 0; it3 < nc; it3++)
		ik[it3 + nc] = ik[it3] + mn;
	    nc *= 2;
	    mn /= 2;
	}
	init_fft = 1;
    }

    for (i = 0, px_re = &den_re[0], px_im = &den_im[0]; i < nd; i++)
	*px_re++ = *px_im++ = 0.0;

    for (i = 0, pik = &ik[0]; i < nDet; i++) {
	den_re[*pik++] = hn2[i];
    }

    for (lf = 1, l1 = 1, wp = nd / 4; lf <= ig; lf++, wp /= 2) {
	l2 = l1;
	l1 *= 2;

	for (mf = 0; mf < l2; mf++) {
	    ka = mf;
	    while (ka < nd) {
		kb = ka + l2;
		px_re = &den_re[ka];
		px_im = &den_im[ka];
		py_re = &den_re[kb];
		py_im = &den_im[kb];
		xka = *px_re;
		yka = *px_im;
		*px_re += *py_re;
		*px_im += *py_im;
		*py_re = xka - *py_re;
		*py_im = yka - *py_im;
		ka += l1;
	    }
	}
	for (j = l1; j < nd; j += l1) {
	    ix = 0;
	    px_re = &den_re[j];
	    px_im = &den_im[j];
	    while (ix < nd2) {
		xj = *px_re;
		pcos = &c[ix];
		psin = &s[ix];
		*px_re = xj * *pcos + *px_im * *psin;
		*px_im = *px_im * *pcos - xj * *psin;
		j++;
		px_re++;
		px_im++;
		ix += wp;
	    }
	}
    }
}
