/*
 * Xdigfil : CAD of the digital filter.
 * Copyleft by mac@research.co.jp (Shigeru Makino)
 */
static char *RcsID = "$Id: xdigfil.c,v 1.2 2003/08/09 22:10:21 mac Exp $";

#define MAIN

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <sys/param.h>
#include <math.h>
#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Cardinals.h>

#include "digfil.h"
#include "none.xbm"
#include "lpf.xbm"
#include "hpf.xbm"
#include "bpf.xbm"
#include "brf.xbm"

char                   *bitmap[] = {
    none_bits,
    lpf_bits,
    hpf_bits,
    bpf_bits,
    brf_bits,
};

int                     width[] = {
    none_width,
    lpf_width,
    hpf_width,
    bpf_width,
    brf_width,
};

int                     height[] = {
    none_height,
    lpf_height,
    hpf_height,
    bpf_height,
    brf_height,
};

extern double atof();
extern void             filter();
extern void             Output();

static Pixmap           pix[5];
static char            *Xgraph;

static Widget           toplevel, Wbase;
static Widget           Wstyle, Wfir, Wiir;
static Widget           Wmtd, Wbtw, Wchv, Winv;
static Widget           Wiiropt, Wd, Wnos, W1d, W2d;  /* added by A.S. */
static Widget           Wtype, Wlpf, Whpf, Wbpf, Wbrf, Wficon;
static Widget           Wcoms, Wfs, Wrip, Watt;
static Widget           Wfrq1, Wfc1, Wfa1;
static Widget           Wfrq2, Wfc2, Wfa2;
static Widget           Wout, Witem, Wto;
static Widget           Wspec, Wgain, Wgdly, Wname;
static Widget           Wfile, Wgraph;
static Widget           Wquit;
static Widget           Wtext;

Display                *disp;
Window                  root;

void                    SelStyle();
#define FIR 1
#define IIR 2

void                    SelD();
#define NOSCALE   0
#define D1  1
#define D2  2

void                    SelType();
#define LPF 1
#define HPF 2
#define BPF 3
#define BRF 4

void                    SelMtd();
#define BTW 1
#define CHV 2
#define INV 3

void                    SelOut();
#define SPEC 1
#define GAIN 2
#define GDLY 3
static char            *sufix[4];

void                    Quit();
void                    FileOut();
void                    GraphOut();

Widget
AddToggle(name, parent, brather, callback, client_data)
String                  name;
Widget                  parent, brather;
void                    (*callback) ();
int                     client_data;
{
    Widget                  w = XtVaCreateManagedWidget(name,
	toggleWidgetClass, parent,
	NULL);
    XtAddCallback(w, XtNcallback, callback, (XtPointer) client_data);
    if (brather != NULL) {
	XawToggleChangeRadioGroup(w, brather);
    }
    return w;
}

Widget
AddButton(name, parent, callback, client_data)
String                  name;
Widget                  parent;
void                    (*callback) ();
int                     client_data;
{
    Widget                  w = XtVaCreateManagedWidget(name,
	commandWidgetClass, parent, NULL);
    XtAddCallback(w, XtNcallback, callback, (XtPointer) client_data);
    return w;
}

#define offset(entry) XtOffset(struct _app_resources *, entry)
int
main(argc, argv)
int                     argc;
char                  **argv;
{
    static String           fallback_resources[] = {
	"*showGrip: no",
	"*Toggle.Translations:	#override<Btn1Down>,<Btn1Up>:set()notify()",
	"*Text.Translations:	#override <Key>Return:no-op(RingBell)",
	"*Box.orientation: Horizontal",
	"*base.orientation: Vertical",
	"*method.mappedWhenManaged: no",
	"*d.mappedWhenManaged: no",
	"*coms.borderWidth: 0",
	"*fs.value: \000",
	"*fs.label: Samp F [Hz]",
	"*rip.value: \000",
	"*rip.label: ripple [-dB]",
	"*att.value: \000",
	"*att.label: attn [-dB]",
	"*frq1.borderWidth: 0",
	"*fc1.value: \000",
	"*fc1.label: fc1 [Hz]",
	"*fa1.value: \000",
	"*fa1.label: fa1 [Hz]",
	"*frq2.borderWidth: 0",
	"*frq2.mappedWhenManaged: no",
	"*fc2.value: \000",
	"*fc2.label: fc2 [Hz]",
	"*fa2.value: \000",
	"*fa2.label: fa2 [Hz]",
	"*out.orientation: Vertical",
	"*out.borderWidth: 0",
	"*name.value: digfil",
	"*name.label: filter name",
	"*text*scrollVertical: Always",
	"*text.height: 200",
	"*text*editType: read",
	NULL,
    };

    static XrmOptionDescRec options[] = {
	{"-graph", ".Graph", XrmoptionSepArg, NULL},
	{"-ssuf", ".Ssuf", XrmoptionSepArg, NULL},
	{"-gsuf", ".Gsuf", XrmoptionSepArg, NULL},
	{"-dsuf", ".Dsuf", XrmoptionSepArg, NULL},
    };
    static struct _app_resources {
	String                  graph, ssuf, gsuf, dsuf;
    }                       app_resources;

    static XtResource       resources[] = {
	{"graph", "Graph", XtRString, sizeof(String),
	    offset(graph), XtRString, "xgraph"},
	{"ssuf", "Ssuf", XtRString, sizeof(String),
	    offset(ssuf), XtRString, "dgf"},
	{"gsuf", "Gsuf", XtRString, sizeof(String),
	    offset(gsuf), XtRString, "frq"},
	{"dsuf", "Dsuf", XtRString, sizeof(String),
	    offset(dsuf), XtRString, "dly"},
    };

    int                     i;
    XtAppContext            app_con;

    toplevel = XtVaAppInitialize(&app_con, "XDigfil",
	options, XtNumber(options),
	&argc, argv, fallback_resources, NULL);

    XtVaGetApplicationResources(toplevel, (caddr_t) & app_resources,
	resources, XtNumber(resources), NULL);

    if (1 != argc) {
	fprintf(stderr, "unknown option <%s>\n", argv[1]);
	exit(1);
    }

    disp = XtDisplay(toplevel);
    root = RootWindowOfScreen(XtScreen(toplevel));

    Xgraph = app_resources.graph;
    sufix[SPEC] = app_resources.ssuf;
    sufix[GAIN] = app_resources.gsuf;
    sufix[GDLY] = app_resources.dsuf;

    for (i = 0; i < 5; i++) {
	pix[i] = XCreateBitmapFromData(disp, root, bitmap[i],
	    width[i], height[i]);
    }

    Wbase = XtVaCreateManagedWidget("base",
	panedWidgetClass, toplevel, NULL);

    Wstyle = XtVaCreateManagedWidget("style",
	boxWidgetClass, Wbase, NULL);
    Wfir = AddToggle("fir", Wstyle, NULL, SelStyle, FIR);
    Wiir = AddToggle("iir", Wstyle, Wfir, SelStyle, IIR);

    Wiiropt = XtVaCreateManagedWidget("iiropt",
	boxWidgetClass, Wbase, NULL);
    Wmtd = XtVaCreateManagedWidget("method",
	boxWidgetClass, Wiiropt, NULL);
    Wbtw = AddToggle("btw", Wmtd, NULL, SelMtd, BTW);
    Wchv = AddToggle("chv", Wmtd, Wbtw, SelMtd, CHV);
    Winv = AddToggle("inv", Wmtd, Wbtw, SelMtd, INV);
    Wd = XtVaCreateManagedWidget("d",
	boxWidgetClass, Wiiropt, NULL); /* added by A.S. */
    Wnos = AddToggle("No scale", Wd, NULL, SelD, NOSCALE); /* added by A.S. */
    W1d = AddToggle("1D", Wd, Wnos, SelD, D1); /* added by A.S. */
    W2d = AddToggle("2D", Wd, W1d, SelD, D2); /* added by A.S. */


    Wtype = XtVaCreateManagedWidget("type",
	boxWidgetClass, Wbase, NULL);
    Wlpf = AddToggle("lpf", Wtype, NULL, SelType, LPF);
    Whpf = AddToggle("hpf", Wtype, Wlpf, SelType, HPF);
    Wbpf = AddToggle("bpf", Wtype, Wlpf, SelType, BPF);
    Wbrf = AddToggle("brf", Wtype, Wlpf, SelType, BRF);
    Wficon = XtVaCreateManagedWidget("ICON",
	labelWidgetClass, Wtype,
	XtNbitmap, pix[0], NULL);

    Wcoms = XtVaCreateManagedWidget("coms", boxWidgetClass, Wbase, NULL);
    Wfs = XtVaCreateManagedWidget("fs", dialogWidgetClass, Wcoms, NULL);
    Wrip = XtVaCreateManagedWidget("rip", dialogWidgetClass, Wcoms, NULL);
    Watt = XtVaCreateManagedWidget("att", dialogWidgetClass, Wcoms, NULL);

    Wfrq1 = XtVaCreateManagedWidget("frq1", boxWidgetClass, Wbase, NULL);
    Wfc1 = XtVaCreateManagedWidget("fc1", dialogWidgetClass, Wfrq1, NULL);
    Wfa1 = XtVaCreateManagedWidget("fa1", dialogWidgetClass, Wfrq1, NULL);

    Wfrq2 = XtVaCreateManagedWidget("frq2", boxWidgetClass, Wbase, NULL);
    Wfc2 = XtVaCreateManagedWidget("fc2", dialogWidgetClass, Wfrq2, NULL);
    Wfa2 = XtVaCreateManagedWidget("fa2", dialogWidgetClass, Wfrq2, NULL);

    Wout = XtVaCreateManagedWidget("out", boxWidgetClass, Wbase, NULL);
    Wname = XtVaCreateManagedWidget("name", dialogWidgetClass, Wout, NULL);
    Witem = XtVaCreateManagedWidget("item", boxWidgetClass, Wout, NULL);
    Wto = XtVaCreateManagedWidget("to", boxWidgetClass, Wout, NULL);

    Wspec = AddToggle("spec", Witem, NULL, SelOut, SPEC);
    Wgain = AddToggle("gain", Witem, Wspec, SelOut, GAIN);
    Wgdly = AddToggle("gdly", Witem, Wspec, SelOut, GDLY);

    Wfile = AddButton("file", Wto, FileOut, NULL);
    Wgraph = AddButton("xgraph", Wto, GraphOut, NULL);
    Wquit = AddButton("quit", Wbase, Quit, NULL);

    Wtext = XtVaCreateManagedWidget("text",
	asciiTextWidgetClass, Wbase, NULL);

    XtRealizeWidget(toplevel);
    XtAppMainLoop(app_con);

    return 0;
}

void
TextDisp(str)
char                   *str;
{
    Arg			    arg;
    XawTextEditType	    edit_mode;
    XawTextPosition         pos;
    XawTextBlock            tb;

    pos = XawTextGetInsertionPoint(Wtext);
    tb.firstPos = 0;
    tb.length = strlen(str);
    tb.ptr = str;
    tb.format = FMT8BIT;

    XtSetArg (arg, XtNeditType, &edit_mode);
    XtGetValues (Wtext, &arg, ONE);
    XtSetArg (arg, XtNeditType, XawtextEdit);
    XtSetValues (Wtext, &arg, ONE);

    XawTextReplace(Wtext, pos, pos, &tb);
    XawTextSetInsertionPoint(Wtext, pos + tb.length);

    XtSetArg (arg, XtNeditType, edit_mode);
    XtSetValues (Wtext, &arg, ONE);
}

void
ErrDisp(str)
char                   *str;
{
    TextDisp(str);
    TextDisp("Try again !\n");
    XBell(disp, 0);
}

void
Quit(widget, client_data, call_data)
Widget                  widget;
XtPointer               client_data, call_data;
{
    XtDestroyApplicationContext(XtWidgetToApplicationContext(widget));
    exit(0);
}

#define isChanged(x,y) if (x != y){x = y;changed = 1;}
static double
GetValue(w)
Widget                  w;
{
    String                  Str;

    Str = XawDialogGetValueString(w);
    return (atof(Str));
}

int
SetVal()
{
    static int              OldStyle = -1, OldType = -1, OldMtd = -1;
    static double           Oldfc1 = 0.0, Oldfa1 = 0.0;
    static double           Oldfc2 = 0.0, Oldfa2 = 0.0;
    static double           Oldfs = 0.0, Oldamax = 0.0;
    static double           Oldamim = 0.0;
    static char		    Oldfnam[MAXPATHLEN] = { 0 };
    int                     changed;

    changed = 0;
    isChanged(OldStyle, Style);
    isChanged(OldType, Type);
    isChanged(OldMtd, Mtd);

    fc1[0] = GetValue(Wfc1);
    isChanged(Oldfc1, fc1[0]);

    fa1[0] = GetValue(Wfa1);
    isChanged(Oldfa1, fa1[0]);

    fc2[0] = GetValue(Wfc2);
    isChanged(Oldfc2, fc2[0]);

    fa2[0] = GetValue(Wfa2);
    isChanged(Oldfa2, fa2[0]);

    fs = GetValue(Wfs);
    isChanged(Oldfs, fs);

    AMAX = GetValue(Wrip);
    isChanged(Oldamax, AMAX);

    AMIN = GetValue(Watt);
    isChanged(Oldamim, AMIN);

    fnam = XawDialogGetValueString(Wname);
    if (strncmp(Oldfnam, fnam, MAXPATHLEN) != 0) {
	changed = 1;
	strncpy(Oldfnam, fnam, MAXPATHLEN);
    }

    return (changed);
}

void
SelStyle(w, client_data)
Widget                  w;
XtPointer               client_data;
{
    if ((Style = (int) client_data) == IIR) {
/*	XtMapWidget(Wiiropt); *//* added by A.S. */
	XtMapWidget(Wmtd);
	XtMapWidget(Wd); /* added by A.S. */
    }
    else {
/*	XtUnmapWidget(Wiiropt);*/ /* added by A.S. */
	XtUnmapWidget(Wmtd);
	XtUnmapWidget(Wd); /* added by A.S. */
    }
}

void
SelType(w, client_data)
Widget                  w;
XtPointer               client_data;
{
    Arg                     args[2];
    char                   *sel;

    switch (Type = (int) client_data) {
	case BPF:
	case BRF:
	    XtMapWidget(Wfrq2);
	    break;
	case LPF:
	case HPF:
	default:
	    XtUnmapWidget(Wfrq2);
	    break;
    }
    XtSetArg(args[0], XtNbitmap, pix[Type]);
    XtSetValues(Wficon, args, ONE);
}

void
SelMtd(w, client_data)
Widget                  w;
XtPointer               client_data;
{
    Mtd = (int) client_data;
}

void
SelD(w, client_data)
Widget                  w;
XtPointer               client_data;
{
    D = (int) client_data;
}

void
SelOut(w, client_data)
Widget                  w;
XtPointer               client_data;
{
    Out = (int) client_data;
}

void
FileOut()
{
    FILE                   *fo;
    char                    s[MAXPATHLEN + 20];
    char                    name[MAXPATHLEN];

    if (SetVal() != 0) {
	filter();
    }
    if (normal != 0) {
	ErrDisp("No valid data.\n");
	return;
    }
    else {
	sprintf(name, "%s.%s", fnam, sufix[Out]);
    }

    if ((fo = fopen(name, "w")) == NULL) {
	sprintf(s, "Can't open %s\n", fnam);
	ErrDisp(s);
    }
    else {
	Output(fo);
	sprintf(s, "\nSave %s\n", fnam);
	TextDisp(s);
	fclose(fo);
    }
}

void
GraphOut()
{
    FILE                   *fo;
    char                    s[MAXPATHLEN + 20];

    if (SetVal() != 0) {
	filter();
    }
    if (normal != 0) {
	ErrDisp("No valid data.\n");
	return;
    }
    else if (Out == 0) {
	ErrDisp("Output item isn't selected\n");
	return;
    }
    else if (Out == SPEC) {
	sprintf(s, "Can't show 'Spec' on xgraph\n");
	ErrDisp(s);
    }
    else if ((fo = popen(Xgraph, "w")) == NULL) {
	sprintf(s, "Can't exec %s\n", Xgraph);
	ErrDisp(s);
    }
    else {
	Output(fo);
	fclose(fo);
    }
}
