/*
 * df_gplt : XDigfil-gnuplot interface
 * Copyleft by mac@research.co.jp (Shigeru Makino)
 */
 static char *RcsID = "$Id: df_gplt.c,v 1.2 2003/08/09 22:10:21 mac Exp $";
#define MAIN

#include <stdio.h>
#include <ctype.h>
#include <sys/param.h>
#include <math.h>
#include <errno.h>
#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Cardinals.h>

static char             fnam[MAXPATHLEN];
static FILE            *pgraph = NULL;
static char            *Xgraph;

static Widget           toplevel, Wbase;
static Widget           Wam;
static Widget           Wauto, Wmanu;
static Widget           Wdraw, Wplot, Wquit;
static Widget           Wdim;
static Widget           WminX, WmaxX, WminY, WmaxY;

int                     AutoManu;
double                  MinX, MaxX, MinY, MaxY;

#define LLEN 80
char                    Title[LLEN], XUnit[LLEN], YUnit[LLEN];
void                    Quit();
void                    Draw();
void                    PostDraw();
void                    GetData();

#define AUTO 1
#define MANU 2
void                    SelAutoManu();

Widget
AddToggle(name, parent, brather, callback, client_data)
String                  name;
Widget                  parent, brather;
void                    (*callback) ();
int                     client_data;
{
    Widget                  w = XtVaCreateManagedWidget(name,
	toggleWidgetClass, parent,
	NULL);
    XtAddCallback(w, XtNcallback, callback, (XtPointer) client_data);
    if (brather != NULL) {
	XawToggleChangeRadioGroup(w, brather);
    }
    return w;
}


Widget
AddButton(name, parent, callback, client_data)
String                  name;
Widget                  parent;
void                    (*callback) ();
int                     client_data;
{
    Widget                  w = XtVaCreateManagedWidget(name,
	commandWidgetClass, parent, NULL);
    XtAddCallback(w, XtNcallback, callback, (XtPointer) client_data);
    return w;
}

#define offset(entry) XtOffset(struct _app_resources *, entry)
int
main(argc, argv)
int                     argc;
char                  **argv;
{
    static String           fallback_resources[] = {
	"*showGrip: no",
	"*Toggle.Translations:	#override<Btn1Down>,<Btn1Up>:set()notify()",
	"*Text.Translations:	#override <Key>Return:no-op(RingBell)",
	"*am.orientation: Horizontal",
	"*dim.mappedWhenManaged: no",
	"*minx.value: \000",
	"*minx.label: Min X [Hz]",
	"*maxx.value: \000",
	"*maxx.label: Max X [Hz]",
	"*miny.value: \000",
	"*miny.label: Min Y",
	"*maxy.value: \000",
	"*maxy.label: Max Y",
	NULL,
    };

    static XrmOptionDescRec options[] = {
	{"-graph", ".Graph", XrmoptionSepArg, NULL},
    };
    static struct _app_resources {
	String                  graph;
    }                       app_resources;

    static XtResource       resources[] = {
	{"graph", "Graph", XtRString, sizeof(String),
	    offset(graph), XtRString, "/usr/local/bin/gnuplot"},
    };

    XtAppContext            app_con;

    toplevel = XtVaAppInitialize(&app_con, "Df_Gplt",
	options, XtNumber(options),
	&argc, argv, fallback_resources, NULL);

    XtVaGetApplicationResources(toplevel, (caddr_t) & app_resources,
	resources, XtNumber(resources), NULL);

    if (1 != argc) {
	fprintf(stderr, "unknown option <%s>\n", argv[1]);
	exit(1);
    }

    Xgraph = app_resources.graph;

    GetData();
    if ((pgraph = popen(Xgraph, "w")) == NULL) {
	fprintf(stderr, "Can't exec %s\n", Xgraph);
    }

    Wbase = XtVaCreateManagedWidget("base",
	panedWidgetClass, toplevel, NULL);

    Wdraw = AddButton("draw", Wbase, Draw, NULL);
    Wplot = AddButton("plot", Wbase, PostDraw, NULL);

    Wam = XtVaCreateManagedWidget("am",
	boxWidgetClass, Wbase, NULL);
    Wauto = AddToggle("auto", Wam, NULL, SelAutoManu, AUTO);
    Wmanu = AddToggle("manu", Wam, Wauto, SelAutoManu, MANU);

    Wdim = XtVaCreateManagedWidget("dim",
	boxWidgetClass, Wbase, NULL);

    WminX = XtVaCreateManagedWidget("minx", dialogWidgetClass, Wdim, NULL);
    WmaxX = XtVaCreateManagedWidget("maxx", dialogWidgetClass, Wdim, NULL);
    WminY = XtVaCreateManagedWidget("miny", dialogWidgetClass, Wdim, NULL);
    WmaxY = XtVaCreateManagedWidget("maxy", dialogWidgetClass, Wdim, NULL);

    Wquit = AddButton("quit", Wbase, Quit, NULL);

    XtRealizeWidget(toplevel);
    XtAppMainLoop(app_con);

    return 0;
}


void
Quit(widget, client_data, call_data)
Widget                  widget;
XtPointer               client_data, call_data;
{
    if (pgraph != NULL) {
	fclose(pgraph);
    }
    unlink(fnam);
    XtDestroyApplicationContext(XtWidgetToApplicationContext(widget));
    exit(0);
}

static double
GetValue(w)
Widget                  w;
{
    String                  Str;

    Str = XawDialogGetValueString(w);
    return (atof(Str));
}

void
SetVal()
{
    double                  tmp;

    MinX = GetValue(WminX);
    MaxX = GetValue(WmaxX);

    MinY = GetValue(WminY);
    MaxY = GetValue(WmaxY);
}

void
SelAutoManu(w, client_data)
Widget                  w;
XtPointer               client_data;
{
    if ((AutoManu = (int) client_data) == MANU) {
	XtMapWidget(Wdim);
    }
    else {
	XtUnmapWidget(Wdim);
    }
}


void
GetData()
{
    FILE                   *fo;
    char                    buf[BUFSIZ];
    int                     c;

    sprintf(fnam, "/tmp/xdf_tmp%04d", getpid());

    if ((fo = fopen(fnam, "w")) == NULL) {
	fprintf(stderr, "Can't open %s\n", fnam);
	exit(errno);
    }
    else {
	while (fgets(buf, BUFSIZ, stdin) != 0) {
	    if (sscanf(buf, "TitleText: %[^\n]", Title) != 0) {
		continue;
	    }
	    else if (sscanf(buf, "XUnitText: %[^\n]", XUnit) != 0) {
		continue;
	    }
	    else if (sscanf(buf, "YUnitText: %[^\n]", YUnit) != 0) {
		continue;
	    }
	    else {
		fputs(buf, fo);
		break;
	    }
	}
	while ((c = getc(stdin)) != EOF) {
	    putc(c, fo);
	}
	fclose(fo);
    }
}

#define xChg(x,y) tmp=x;x=y;y=tmp;
void Draw()
{
    double                  tmp;

    SetVal();

    if (AutoManu != MANU) {
	fprintf(pgraph, "set autoscale xy\n");
    }
    else {
	if (MinX == MaxX) {
	    fprintf(pgraph, "set autoscale x\n");
	}
	else {
	    if (MinX > MaxX) {
		xChg(MinX, MaxX);
	    }
	    fprintf(pgraph, "set xrange [%le:%le]\n", MinX, MaxX);
	}
	if (MinY == MaxY) {
	    fprintf(pgraph, "set autoscale y\n");
	}
	else {
	    if (MinY > MaxY) {
		xChg(MinY, MaxY);
	    }
	    fprintf(pgraph, "set yrange [%le:%le]\n", MinY, MaxY);
	}
    }
    fprintf(pgraph, "set title '%s'\n", Title);
    fprintf(pgraph, "set xlabel '%s'\n", XUnit);
    fprintf(pgraph, "set ylabel '%s'\n", YUnit);
    fprintf(pgraph, "set nokey\n");
    fprintf(pgraph, "set term x11\n");
    fprintf(pgraph, "set out\n");
    fprintf(pgraph, "plot '%s' with lines\n", fnam);
    fflush(pgraph);
}

void PostDraw()
{
    double                  tmp;

    SetVal();

    if (AutoManu != MANU) {
	fprintf(pgraph, "set autoscale xy\n");
    }
    else {
	if (MinX == MaxX) {
	    fprintf(pgraph, "set autoscale x\n");
	}
	else {
	    if (MinX > MaxX) {
		xChg(MinX, MaxX);
	    }
	    fprintf(pgraph, "set xrange [%le:%le]\n", MinX, MaxX);
	}
	if (MinY == MaxY) {
	    fprintf(pgraph, "set autoscale y\n");
	}
	else {
	    if (MinY > MaxY) {
		xChg(MinY, MaxY);
	    }
	    fprintf(pgraph, "set yrange [%le:%le]\n", MinY, MaxY);
	}
    }
    fprintf(pgraph, "set title '%s'\n", Title);
    fprintf(pgraph, "set xlabel '%s'\n", XUnit);
    fprintf(pgraph, "set ylabel '%s'\n", YUnit);
    fprintf(pgraph, "set nokey\n");
    fprintf(pgraph, "set term post\n");
    fprintf(pgraph, "set out 'post.ps\n");
    fprintf(pgraph, "plot '%s' with lines\n", fnam);
    fflush(pgraph);
}
