/*
 * FIR digtal filter
 *	Copyleft by mac@research.co.jp 1992.
 */
static char	       *RcsID = "$Id: fir.c,v 1.1.1.1 2003/08/01 21:57:43 mac Exp $";
#include <stdio.h>
#define MAXFIL 1024

extern int              errno;

usage(argv)
char                   *argv[];
{
    fprintf(stderr, "%s: fir filter", argv[0]);
    fprintf(stderr, "\t%s filter-coeff-file <input >output\n", argv[0]);
}

main(argc, argv)
int                     argc;
char                   *argv[];
{
    FILE                   *co;
    char		    s[BUFSIZ];
    double                  coeff[MAXFIL], *pCoeff;
    double                  dbuff[MAXFIL], *pDbuffIN, *pDbuff;
    double                  sum;
    int                     ncoeff, i;

    if (argc < 1) {
	usage(argv);
    }

    if ((co = fopen(argv[1], "r")) == NULL) {
	fprintf(stderr, "%s: Can't open %s\n", argv[0], argv[1]);
	exit(errno);
    }

    while (fgets(s, BUFSIZ, co) != 0) {
	if (s[0] == '#') {
	    continue;
	}
	sscanf(s, "%*le %le", &coeff[ncoeff]);
	if (ncoeff < MAXFIL) {
	    ncoeff++;
	}
	else {
	    break;
	}
    }
    fclose(co);

    pDbuffIN = dbuff;

    while (scanf("%le", pDbuffIN) != EOF) {
	pDbuff = pDbuffIN;
	if (++pDbuffIN > &dbuff[MAXFIL - 1]) {
	    pDbuffIN = dbuff;
	}

	for (sum = 0.0, pCoeff = coeff, i = 0; i < ncoeff; pCoeff++, i++) {
	    sum += *pCoeff * *pDbuff;
	    if (--pDbuff < dbuff) {
		pDbuff = &dbuff[MAXFIL - 1];
	    }
	}
	printf("%15.6e\n", sum);
    }
}
