/*
 * IIR 1D type integer digtal filter.
 *	Copyright by mac@research.co.jp 1992.
 */
static char            *RcsID = "$Id: iir1Di.c,v 1.1.1.1 2003/08/01 21:57:43 mac Exp $";
#include <stdio.h>
#define MAXFIL 31

#define INT short

extern int              errno;

typedef struct coe_ {
    INT                     a0, a1, a2;
    INT                     ah0, ah1, ah2;
    INT                     b1, b2;
    INT                     bh1, bh2;
}                       COE;
typedef struct coew_ {
    INT                     w1, w2;
}                       COEW;

void
usage(argv)
char                   *argv[];
{
    fprintf(stderr, "%s: 1D iir filter", argv[0]);
    fprintf(stderr, "\t%s filter-coeff-file <input >output\n", argv[0]);
}

#define NLONG 0x8000L
#define FINT ((double)NLONG)
INT
imul(x, xh, y)
INT                     x, xh, y;
{
    INT                     tmp;

    tmp = (INT) (((long) (x) * (long) (y)) / NLONG);
    switch (xh) {
	case 1:
	    tmp += y;
	    break;
	case -1:
	    tmp -= y;
	    break;
    }
    return (tmp);
}


void
main(argc, argv)
int                     argc;
char                   *argv[];
{
    FILE                   *co;
    char                    s[BUFSIZ];
    COE                     coe[MAXFIL], *pCoe;
    COEW                    coew[MAXFIL], *pCoew;
    double                  Xn, h, a0, a1, a2;
    INT                     iX, w0;
    int                     nDet, i, n1;

    if (argc < 1) {
	usage(argv);
    }

    if ((co = fopen(argv[1], "r")) == NULL) {
	fprintf(stderr, "%s: Can't open %s\n", argv[0], argv[1]);
	exit(errno);
    }

    while (fgets(s, BUFSIZ, co) != 0) {
	if (s[0] == '#') {
	    continue;
	}
	if (sscanf(s, "N=%d", &nDet) == 1) {
	    nDet /= 2;
	    continue;
	}
	else if (sscanf(s, "h=%le", &h) == 1) {
	    continue;
	}
	else if (
		sscanf(s,
		    " a\[%d,%*d]=%le a\[%*d,%*d]=%le a\[%*d,%*d]=%le",
		&n1, &a0, &a1, &a2) == 4) {

	    if (--n1 < MAXFIL) {
		pCoe = &coe[n1];
		pCoew = &coew[n1];
		pCoe->ah0 = (INT) a0;
		pCoe->a0 = (INT) (FINT * (a0 - pCoe->ah0));
		pCoe->ah1 = (INT) a1;
		pCoe->a1 = (INT) (FINT * (a1 - pCoe->a1));
		pCoe->ah2 = (INT) a2;
		pCoe->a2 = (INT) (FINT * (a2 - pCoe->ah2));
		pCoew->w1 = pCoew->w2 = 0;
	    }
	    else {
		fprintf(stderr, "too many data\n");
		exit(1);
	    }
	}
	else if (
		sscanf(s,
		    " b\[%d,%*d]=%le b\[%*d,%*d]=%le",
		&n1, &a1, &a2) == 3) {

	    if (--n1 < MAXFIL) {
		pCoe = &coe[n1];
		pCoe->bh1 = (INT) a1;
		pCoe->b1 = (INT) (FINT * (a1 - pCoe->bh1));
		pCoe->bh2 = (INT) a2;
		pCoe->b2 = (INT) (FINT * (a2 - pCoe->bh2));
	    }
	    else {
		fprintf(stderr, "too many data\n");
		exit(1);
	    }
	}
	else {
	    continue;;
	}
    }
    fclose(co);

    while (scanf("%le", &Xn) != EOF) {

	iX = (INT) FINT        *Xn;
	for (i = 0, pCoe = &coe[0], pCoew = &coew[0];
	    i < nDet; i++, pCoe++, pCoew++) {
	    w0 = iX
		- imul(pCoe->b1, pCoe->bh1, pCoew->w1)
		- imul(pCoe->b2, pCoe->bh2, pCoew->w2);
	    iX = imul(pCoe->a0, pCoe->ah0, w0)
		+ imul(pCoe->a2, pCoe->ah2, pCoew->w2)
		+ imul(pCoe->a1, pCoe->ah1, pCoew->w1);
	    pCoew->w2 = pCoew->w1;
	    pCoew->w1 = w0;
	}
	printf("%15.6e\n", iX * h / FINT);
    }
}
