/*
 * IIR 1D type digtal filter.
 *	Copyleft by mac@research.co.jp 1992.
 */
static char            *RcsID = "$Id: iir1Dr.c,v 1.1.1.1 2003/08/01 21:57:43 mac Exp $";
#include <stdio.h>
#include <math.h>
#define MAXFIL 31

extern int              errno;

typedef struct coe_ {
    double                  a0, a1, a2;
    double                  b1, b2;
    double                  maxw, maxx;
    double                  w1, w2;
}                       COE;


void
usage(argv)
char                   *argv[];
{
    fprintf(stderr, "%s: 1D iir filter", argv[0]);
    fprintf(stderr, "\t%s filter-coeff-file <input >output\n", argv[0]);
}

void
main(argc, argv)
int                     argc;
char                   *argv[];
{
    FILE                   *co;
    char                    s[BUFSIZ];
    COE                     coe[MAXFIL], *pCoe;
    double                  Xn, h, a0, a1, a2, w0;
    double                  wmaxw, wmaxx;
    int                     nDet, i, n1;

    if (argc < 1) {
	usage(argv);
    }

    if ((co = fopen(argv[1], "r")) == NULL) {
	fprintf(stderr, "%s: Can't open %s\n", argv[0], argv[1]);
	exit(errno);
    }

    while (fgets(s, BUFSIZ, co) != 0) {
	if (s[0] == '#') {
	    continue;
	}
	if (sscanf(s, "N=%d", &nDet) == 1) {
	    nDet /= 2;
	    continue;
	}
	else if (sscanf(s, "h=%le", &h) == 1) {
	    continue;
	}
	else if (
		sscanf(s,
		    " a\[%d,%*d]=%le a\[%*d,%*d]=%le a\[%*d,%*d]=%le",
		&n1, &a0, &a1, &a2) == 4) {

	    if (--n1 < MAXFIL) {
		pCoe = &coe[n1];
		pCoe->a0 = a0;
		pCoe->a1 = a1;
		pCoe->a2 = a2;
		pCoe->w1 = pCoe->w2 = 0.0;
	    }
	    else {
		fprintf(stderr, "too many data\n");
		exit(1);
	    }
	}
	else if (
		sscanf(s,
		    " b\[%d,%*d]=%le b\[%*d,%*d]=%le",
		&n1, &a1, &a2) == 3) {

	    if (--n1 < MAXFIL) {
		pCoe = &coe[n1];
		pCoe->b1 = a1;
		pCoe->b2 = a2;
	    }
	    else {
		fprintf(stderr, "too many data\n");
		exit(1);
	    }
	}
	else {
	    continue;;
	}
    }
    fclose(co);

    while (scanf("%le", &Xn) != EOF) {

	for (i = 0, pCoe = &coe[0]; i < nDet; i++, pCoe++) {
	    w0 = Xn - pCoe->b1 * pCoe->w1 - pCoe->b2 * pCoe->w2;
	    if (pCoe->maxw < (wmaxw = fabs(w0))) {
		pCoe->maxw = wmaxw;
	    }
	    Xn = pCoe->a0 * w0 + pCoe->a1 * pCoe->w1 + pCoe->a2 * pCoe->w2;
	    if (pCoe->maxx < (wmaxx = fabs(Xn))) {
		pCoe->maxx = wmaxx;
	    }
	    pCoe->w2 = pCoe->w1;
	    pCoe->w1 = w0;
	}
    }
    for (i = 0, pCoe = &coe[0]; i < nDet; i++, pCoe++) {
	printf("n = %d, w0 =%16g, Xn =%16g\n", i, pCoe->maxw, pCoe->maxx);
    }
}
