/*
 * Scalling program for IIR digtal filter.
 *	Copyleft by mac@research.co.jp 1992.
 */
static char            *RcsID = "$Id: scale.c,v 1.1.1.1 2003/08/01 21:57:43 mac Exp $";
#include <stdio.h>
#include <math.h>

#define MAXFIL 31
#define N_LIM 1000

#define TYPE1D 1
#define TYPE2D 2

extern int              errno;

typedef struct coe_ {
    double                  a0, a1, a2;
    double                  b1, b2;
    double                  w1, w2;
    double                  L2;
}                       COE;


void
usage(argv)
char                   *argv[];
{
    fprintf(stderr, "%s: iir filter scalling program", argv[0]);
    fprintf(stderr, "\t%s {1|2} < filter-coeff-file >output\n", argv[0]);
}

void
main(argc, argv)
int                     argc;
char                   *argv[];
{
    FILE                   *co, *fo;
    char                    s[BUFSIZ];
    COE                     coe[MAXFIL], *pCoe;
    double                  sf[MAXFIL + 1], wsf;
    double                  Xn, h, a0, a1, a2, w0;
    int                     type, nDet, i, j, n1;

#ifdef DEBUG
    FILE                   *db;
    db = fopen("scalDB", "w");
#endif

    if (argc < 1) {
	usage(argv);
    }

    co = stdin;
    fo = stdout;

    type = atoi(argv[1]);

    fprintf(fo, "# Scalling for %s\n", (type == TYPE1D) ? "1D" : "2D");
    while (fgets(s, BUFSIZ, co) != 0) {
	if (s[0] == '#') {
	    fputs(s, fo);
	    continue;
	}
	if (sscanf(s, "N=%d", &nDet) == 1) {
	    nDet /= 2;
	    fputs(s, fo);
	    continue;
	}
	else if (sscanf(s, "h=%le", &h) == 1) {
	    continue;
	}
	else if (
		sscanf(s,
		    " a\[%d,%*d]=%le a\[%*d,%*d]=%le a\[%*d,%*d]=%le",
		&n1, &a0, &a1, &a2) == 4) {

	    if (--n1 < MAXFIL) {
		pCoe = &coe[n1];
		pCoe->a0 = a0;
		pCoe->a1 = a1;
		pCoe->a2 = a2;
		pCoe->w1 = pCoe->w2 = pCoe->L2 = 0.0;
	    }
	    else {
		fprintf(stderr, "too many data\n");
		exit(1);
	    }
	}
	else if (
		sscanf(s,
		    " b\[%d,%*d]=%le b\[%*d,%*d]=%le",
		&n1, &a1, &a2) == 3) {

	    if (--n1 < MAXFIL) {
		pCoe = &coe[n1];
		pCoe->b1 = a1;
		pCoe->b2 = a2;
	    }
	    else {
		fprintf(stderr, "too many data\n");
		exit(1);
	    }
	}
	else {
	    continue;
	}
    }
    fclose(co);


    if (type == TYPE1D) {
	for (j = 0, Xn = 1.0; j < N_LIM; j++, Xn = 0.0) {

	    for (i = 0, pCoe = &coe[0]; i < nDet; i++, pCoe++) {
		w0 = Xn - pCoe->b1 * pCoe->w1 - pCoe->b2 * pCoe->w2;
		pCoe->L2 += w0 * w0;
#ifdef DEBUG
		fprintf(db, "%d %g @N%d\n", j, w0, i);
#endif
		Xn = pCoe->a0 * w0 + pCoe->a1 * pCoe->w1 + pCoe->a2 * pCoe->w2;
		pCoe->w2 = pCoe->w1;
		pCoe->w1 = w0;
	    }
	}
	for (i = 0; i < nDet; i++) {
	    coe[i].L2 = sqrt(coe[i].L2);
	}

	wsf = 1.0;
	for (i = 1; i < nDet; i++) {
	    wsf *= sf[i - 1] = coe[i - 1].L2 / coe[i].L2;
	}
	wsf *= sf[nDet - 1] = h * coe[nDet - 1].L2;
	h /= wsf;
    }
    else {

	Xn = 1.0;
	for (j = 0; j < N_LIM; j++) {
	    for (i = 0, pCoe = &coe[0]; i < nDet; i++, pCoe++) {
		w0 = pCoe->a0 * Xn + pCoe->w1;
		pCoe->L2 += w0 * w0;
		pCoe->w1 = pCoe->a1 * Xn - pCoe->b1 * w0 + pCoe->w2;
		pCoe->w2 = pCoe->a2 * Xn - pCoe->b2 * w0;
		Xn = w0;
#ifdef DEBUG
		fprintf(db, "%d %g @N%d\n", j, w0, i);
#endif
	    }
	    Xn = 0.0;
	}
	for (i = 0; i < nDet; i++) {
	    coe[i].L2 = sqrt(coe[i].L2);
	    fprintf(stderr, "%d %e\n", i, coe[i].L2);
	}

	wsf = sf[0] = 1.0 / coe[0].L2;
	for (i = 1; i < nDet; i++) {
	    wsf *= sf[i] = coe[i - 1].L2 / coe[i].L2;
	}
	fprintf(stderr, "wsf=%e\n", wsf);
	h /= wsf;
    }
    fprintf(fo, "h=%e\n", h);
    for (i = 0, pCoe = &coe[0]; i < nDet; i++, pCoe++) {
	j = i + 1;
	wsf = sf[i];
#ifdef DEBUG
	fprintf(stderr, "sf[%d] = %g\n", i, wsf);
#endif
	fprintf(fo, "  a[%3d, 1]=%12.6g", j, pCoe->a0 * wsf);
	fprintf(fo, "  a[%3d, 2]=%12.6g", j, pCoe->a1 * wsf);
	fprintf(fo, "  a[%3d, 3]=%12.6g\n", j, pCoe->a2 * wsf);
    }
    putc('\n', fo);
    for (i = 0, pCoe = &coe[0]; i < nDet; i++, pCoe++) {
	j = i + 1;
	fprintf(fo, "  b[%3d, 2]=%12.6g", j, pCoe->b1);
	fprintf(fo, "  b[%3d, 3]=%12.6g\n", j, pCoe->b2);
    }
}
