#include "xtext.h"

int parse_xlfd_No(char *xlfd,char *target,int no)
{
	char *p;
	int i,flag;

	if(xlfd == NULL) return -1;

	i = 0;
	flag = 0;
	for(p=xlfd;*p;p++){
		if(*p == '-'){
			flag++;
			continue;
		}
		if(flag == no) *(target + (i++)) = *p;
	}
	*(target + i) = *p;

	return i;
}
static int _parse_xlfd(char *xlfd,char *foundry,char *family,char *other)
{
	char *p;
	int i,NO;

	i = 0;
	NO = 0;
	for(p=xlfd;*p;p++){

		if(*p == '-'){
			if(NO == 0){
				i = 0;
				NO++;
				continue;
			}else if(NO == 1){
				*(foundry + i) = '\0';
				i = 0;
				NO++;
				continue;

			}else if(NO == 2){
				*(family + i) = '\0';
				i = 0;
				NO++;
			}

		}
		if(NO == 1) *(foundry + (i++)) = *p;
		if(NO == 2) *(family + (i++)) = *p;
		if(NO == 3) *(other + (i++)) = *p;
	}
	*(other + i) = '\0';

	return 0;
}
static xtext_font_t * _xlfd_data_match(xtext_font_t *head,char *name)
{
	xtext_font_t *xfd;

	for(xfd=head;xfd!=NULL;xfd=xfd->next){

		if(strcmp(xfd->name,name) == 0) return xfd;
	}

	return NULL;
}
static xtext_efont_t * _xlfd_enc_alloc()
{
	xtext_efont_t *xed;

	xed = (xtext_efont_t *)malloc(sizeof(xtext_efont_t));
	xed->name[0] = '\0';

	return xed;
}
static void _xlfd_enc_add(xtext_efont_t **head,xtext_efont_t **tail,xtext_efont_t *im)
{
        if(*tail){
                im->next = NULL;
                im->prev = *tail;

               (*tail)->next = im;
                *tail = im;
        }else{
                im->next = NULL;
                im->prev = NULL;

                *tail = im;
                *head = im;
        }
}
static xtext_font_t * _xlfd_data_alloc()
{
	xtext_font_t *xfd;

	xfd = (xtext_font_t *)malloc(sizeof(xtext_font_t));
	xfd->name[0] = '\0';
	xfd->head = NULL;
	xfd->tail = NULL;

	return xfd;
}
static void _xlfd_data_add(xtext_font_t **head,xtext_font_t **tail,xtext_font_t *im)
{
        if(*tail){
                im->next = NULL;
                im->prev = *tail;

               (*tail)->next = im;
                *tail = im;
        }else{
                im->next = NULL;
                im->prev = NULL;

                *tail = im;
                *head = im;
        }
}
static void _xlfd_data_insert_1(xtext_font_t **head,xtext_font_t **tail,char *name)
{
	xtext_font_t *xfd;

	xfd = (xtext_font_t *)_xlfd_data_alloc();
	strcpy(xfd->name,name);
	_xlfd_data_add(head,tail,xfd);

	return;
}
static void _xlfd_data_insert_2(xtext_font_t **head,xtext_font_t **tail,char *name0,char *name1)
{
	xtext_font_t *xfd;

	xfd = (xtext_font_t *)_xlfd_data_alloc();
	strcpy(xfd->name,name0);

	_xlfd_data_insert_1(&(xfd->head),&(xfd->tail),"-*-*-*--*-*-*-*-*-*-*-*");
	_xlfd_data_insert_1(&(xfd->head),&(xfd->tail),name1);

	_xlfd_data_add(head,tail,xfd);
}
static void _xlfd_data_insert_3(xtext_font_t **head,xtext_font_t **tail,char *name0,char *name1,char *name2)
{
	xtext_font_t *xfd;

	xfd = (xtext_font_t *)_xlfd_data_alloc();
	strcpy(xfd->name,name0);

	_xlfd_data_insert_2(&(xfd->head),&(xfd->tail),"*","-*-*-*--*-*-*-*-*-*-*-*");
	_xlfd_data_insert_2(&(xfd->head),&(xfd->tail),name1,name2);

	_xlfd_data_add(head,tail,xfd);
}
static void _xlfd_enc_insert(xtext_efont_t **head,xtext_efont_t **tail,char *enc)
{
	xtext_efont_t *xed;

	for(xed = *head;xed!=NULL;xed=xed->next){
		if(strcmp(xed->name,enc) == 0) break;
	}

	if(xed == NULL){
		xed = (xtext_efont_t *)_xlfd_enc_alloc();
		strcpy(xed->name ,enc);
		_xlfd_enc_add(head,tail,xed);
	}

}
int xtext_xlfd_create(xtext_font_t **head,xtext_font_t **tail,char *xlfd_str)
{
	xtext_font_t *foundry_d;
	xtext_font_t *family_d;

	char foundry[50];
	char family[50];
	char other[80];

	_parse_xlfd(xlfd_str,foundry,family,other);

	if((foundry_d = (xtext_font_t *)_xlfd_data_match(*head,foundry)) != NULL){
		if((family_d = (xtext_font_t *)_xlfd_data_match(foundry_d->head,family)) != NULL){

			_xlfd_data_insert_1(&(family_d->head),&(family_d->tail),other);
		}else{
			_xlfd_data_insert_2(&(foundry_d->head),&(foundry_d->tail),family,other);
		}
	}else{
		_xlfd_data_insert_3(head,tail,foundry,family,other);
	}

	return 0;
}
int xtext_xlfd_getenco(xtext_efont_t **head,xtext_efont_t **tail,char *xlfd_str)
{
	char enc[50];

	_xlfd_enc_insert(head,tail,"*");
	if(parse_xlfd_No(xlfd_str,enc,13) > 0){

		_xlfd_enc_insert(head,tail,enc);
	}

	return 0;
}
int xtext_xlfd_free(xtext_font_t *head)
{
	xtext_font_t *xfd,*xfd1;

	if(head == NULL) return -1;

	for(xfd=head;xfd!=NULL;xfd=xfd1){
		xfd1 = xfd->next;

		if(xfd->head != NULL) xtext_xlfd_free(xfd->head);

		free(xfd);
	}

	return 0;
}
int xtext_xlfd_free_e(xtext_efont_t *head)
{
	xtext_efont_t *xed,*xed1;

	if(head == NULL) return -1;

	for(xed=head;xed!=NULL;xed=xed1){
		xed1 = xed->next;
		free(xed);
	}

	return 0;
}
int xtext_font_J2E(char *j_font,char *e_font)
{
	char size[5];

	if(parse_xlfd_No(j_font,size,7) <= 0) return -1;

	sprintf(e_font,"-*-*-*-*-*--%s-*-*-*-*-*-iso8859-*",size);

	return 0;
}



		
