/********************************
 * 2005/3/28
 * *****************************/

#include "xtext.h"

#include <stdarg.h>
#include <locale.h>

#define debug 0
char *XJP_CTRL_STR[] = {
                "",
                "",
                "",
                "",
                "ɽ",
                "",
                "",
                ""
};
char *XJP_MESSAGE[] = {
        "ˡ Ϥߤޤ",
        "¸ʸˤ̵ѥǤ",
        "٤Ϥޤ줿޽ϡޤ",
        "¸ޤ",
	"ǡ顼ȯޤ",
        "ե륨顼ȯޤ",
	"Level",
};
char *SEIKEI_LEVEL = NULL;
char *SELECTOR_BACKGROUND_COLOR = NULL;
char *SELECTOR_FOREGROUND_COLOR = NULL;
char *SELECTOR_SELECTFONT_COLOR = NULL;
static int NPC = 0;

extern int opterr;
extern int optind;
extern char *optarg;
extern int getopt(int argc,char * const * argv,const char * pattern);

static Display *disp;
static Window root;
static my_window_t main_win;

static xtext_siori_t *siori_head = NULL, *siori_tail = NULL;
static sub_window_t *book_head = NULL,*book_tail = NULL,*bh;
static sub_window_t *si_head = NULL,*si_tail = NULL;
static sub_window_t *help_head = NULL, *help_tail = NULL;
static ctl_window_t *ctl_head = NULL, *ctl_tail = NULL;

static IBUF_T *line_head = NULL, *line_tail = NULL;
static offset_data_t *offset_head = NULL, *offset_tail = NULL;
static offset_data_t *off_head = NULL, *off_tail = NULL;
static page_data_t *char_p;

static char_data_t char_d = {
		-1,
		-1,
		-1,
		-1,
		-1,
		-1,
		-1,
		-1,
		-1,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL	
};
static xtext_conf_t xconf_default = {
	500,
	400,
	"lavender",
	"Black",
	"gray60",
	"SteelBlue",
	"SteelBlue",
	"White",
	"RoyalBlue4",
	"snow",
	"salmon4",
	"-misc-fixed-*-*-*-*-14-*-*-*-*-*-*-*",
	"-misc-fixed-*-*-*-*-14-*-*-*-*-*-iso8859-*",
	"-misc-*-*-*-*-*-12-*-*-*-*-*-*-*",
	"/home/***/***/book/",
	"-misc-*-*-*-*-*-10-*-*-*-*-*-*-*",
	0,
	1,
	1,
	1,
	1,
	0,
	0,
	1,
	"Down",
	"Up",
	"h",
	"space",
	"s",
	"q",
	"f",
	"Tab",
	"k",
	"c",
	"p"	
};
static xtext_conf_t xconf;

static void _usage()
{
	fprintf(stderr,"\n");
	fprintf(stderr,"    %s  Version : %s\n\n",XTEXT_NAME,XTEXT_VERSION);
	fprintf(stderr,"Usage:	xtext [option] filename\n\n");
	fprintf(stderr,"[option]\n");
	fprintf(stderr,	
"   -h       Help Message (This Message)\n \
  -d <dir>   Book Directory\n \
  -f <file>  Book(.txt|.zip) Path\n \
  -a <num>   Window Width\n \
  -b <num>   Window Height\n \
  -c <str>   Main Window-Color (X11 Color_Name)\n \
  -e <str>   Main Font-Color (X11 Color_Name)\n \
  -g <str>   Ruby Font-Color (X11 Color_Name)\n \
  -i <str>   Message Font-Color (X11 Color_Name)\n \
  -j <str>   Message Window-Color (X11 Color_Name)\n \
  -k <str>   Main Font_Name (Xlfd format)\n \
  -l <str>   Sub Font_Name (Xlfd format)\n \
  -m <str>   1Byte Font_Name (xlfd format)\n \
  -n <str>   Ruby Font_Name (xlfd format)\n \
  -o         Use Xft ?\n \
  -p <num>   Line Space (Pixel)\n \
  -q <num>   Row Space (Pixel)\n \
  -r         Display Book_Title ?\n \
					 ");
	fprintf(stderr,"\n");

	exit(1);
}	


static void _set_title(Window win,char *str)
{
	if(str == NULL) return;
	/*
	XTextProperty ct;
	XmbTextListToTextProperty(disp,&str,1,XCompoundTextStyle,&ct);
	XSetWMName(disp,win,&ct);
	*/

	XStoreName(disp,win,str);
}
static void _set_win()
{
	XSetWindowBackground(disp,main_win.win,main_win.bg_pixel);
	XSetWindowBackground(disp,main_win.cwin,main_win.bg_pixel);
	XSetWindowBackground(disp,main_win.mwin,main_win.bg_pixel);

	XClearWindow(disp,main_win.win);
	XClearWindow(disp,main_win.cwin);
	XClearWindow(disp,main_win.mwin);
}
static void _x_init()
{
	iconv_t con;

	setlocale(LC_ALL,"");
	con = iconv_open("UTF-8","EUC-JP");
	SEIKEI_LEVEL = (char *)euc2utf8(con,XJP_MESSAGE[6],strlen(XJP_MESSAGE[6]));
	iconv_close(con);

	disp = XOpenDisplay(NULL);
	root = DefaultRootWindow(disp);
	main_win.cmap = DefaultColormap(disp,0);
	main_win.visual = DefaultVisual(disp,0);

	main_win.gc = XCreateGC(disp,root,0,0);
	main_win.bgc = XCreateGC(disp,root,0,0);
	main_win.fgc = XCreateGC(disp,root,0,0);
	main_win.rfgc = XCreateGC(disp,root,0,0);
	main_win.rubi_gc = XCreateGC(disp,root,0,0);
	main_win.sgc = XCreateGC(disp,root,0,0);

	XSetLineAttributes(disp,main_win.sgc,1,LineSolid,CapButt,JoinMiter);

}
static void _x_drawable()
{
	XSetWindowAttributes att;
	Atom a1,a2,a3;
	char temp[50];
	int w,h;

	main_win.width = xconf.main_window_width;
	main_win.height = xconf.main_window_height;

	w = main_win.width;
	h = main_win.height;


	main_win.win = XCreateSimpleWindow(disp,root,0,0,w,h,0,0,0);
	a1 = XInternAtom(disp,"WM_DELETE_WINDOW",False);
	XSelectInput(disp,main_win.win,	ExposureMask|StructureNotifyMask|ButtonPressMask|KeyPressMask);
	XSetWMProtocols(disp,main_win.win,&a1,1);

	main_win.mwin = XCreateSimpleWindow(disp,root,0,0,w/2,50,0,0,0);
	a2 = XInternAtom(disp,"WM_DELETE_WINDOW",False);
	XSelectInput(disp,main_win.mwin,ExposureMask|StructureNotifyMask);
	XSetWMProtocols(disp,main_win.win,&a2,1);

	main_win.cwin = XCreateSimpleWindow(disp,main_win.win,0,0,50,200,0,0,0);
	a3 = XInternAtom(disp,"WM_DELETE_WINDOW",False);
	att.backing_store = Always;
	XChangeWindowAttributes(disp,main_win.cwin,CWBackingStore,&att);
	XSelectInput(disp,main_win.cwin,ExposureMask|ButtonPressMask);
	XSetWMProtocols(disp,main_win.win,&a3,1);
	XSetTransientForHint(disp,main_win.cwin,main_win.win); 
	XUnmapWindow(disp,main_win.cwin);
	/*
	XMapWindow(disp,main_win.cwin);
	*/

	XMapWindow(disp,main_win.win);
	if(xconf.chuki) XMapRaised(disp,main_win.mwin);

	_set_title(main_win.mwin,"Message");
	sprintf(temp,"Welcome %s Version %s",XTEXT_NAME,XTEXT_VERSION);
	_set_title(main_win.win,temp);

#if HAVE_LIBXFT
	main_win.draw = XftDrawCreate(disp,main_win.win,main_win.visual,main_win.cmap);
#endif
}
static void _set_col()
{
	XColor bg0,bg1;
	XColor fg0,fg1;
	XColor menu_font_color0,menu_font_color1;
	XColor menu_window_color0,menu_window_color1;
	XColor rubi_fg0,rubi_fg1;
	XColor shadow_fg0,shadow_fg1;

	XAllocNamedColor(disp,main_win.cmap,xconf.main_font_color,&fg1,&fg0);
	XAllocNamedColor(disp,main_win.cmap,xconf.main_window_color,&bg1,&bg0);
	XAllocNamedColor(disp,main_win.cmap,xconf.menu_font_color,&menu_font_color1,&menu_font_color0);
	XAllocNamedColor(disp,main_win.cmap,xconf.menu_window_color,&menu_window_color1,&menu_window_color0);
	XAllocNamedColor(disp,main_win.cmap,xconf.rubi_font_color,&rubi_fg1,&rubi_fg0);
	XAllocNamedColor(disp,main_win.cmap,xconf.main_shadow_color,&shadow_fg1,&shadow_fg0);

	XSetForeground(disp,main_win.gc,fg1.pixel);
	XSetForeground(disp,main_win.bgc,bg1.pixel);
	XSetForeground(disp,main_win.fgc,menu_font_color1.pixel);
	XSetForeground(disp,main_win.rfgc,menu_window_color1.pixel);
	XSetForeground(disp,main_win.rubi_gc,rubi_fg1.pixel);
	XSetForeground(disp,main_win.sgc,shadow_fg1.pixel);

	XSetBackground(disp,main_win.gc,bg1.pixel);
	XSetBackground(disp,main_win.bgc,fg1.pixel);
	XSetBackground(disp,main_win.fgc,menu_window_color1.pixel);
	XSetBackground(disp,main_win.rfgc,menu_font_color1.pixel);

	main_win.fg_pixel = fg1.pixel;
	main_win.bg_pixel = bg1.pixel;
	main_win.menu_fg_pixel = menu_font_color1.pixel;
	main_win.menu_bg_pixel = menu_window_color1.pixel;


#if HAVE_LIBXFT
	XftColorAllocName(disp,main_win.visual,main_win.cmap,xconf.main_window_color,&(main_win.bg_color));
	main_win.bg_color.color.alpha = 0xFFFF;

	XftColorAllocName(disp,main_win.visual,main_win.cmap,xconf.main_font_color,&(main_win.fg_color));
	main_win.fg_color.color.alpha = 0xFFFF;

	XftColorAllocName(disp,main_win.visual,main_win.cmap,xconf.rubi_font_color,&(main_win.rubi_color));
	main_win.rubi_color.color.alpha = 0xCCCC;
#endif

	SELECTOR_BACKGROUND_COLOR = (char *)xconf.select_window_color;
	SELECTOR_FOREGROUND_COLOR = (char *)xconf.select_font_color;
	SELECTOR_SELECTFONT_COLOR = (char *)xconf.select_font_background_color;
}
static void _set_fnt()
{
	char font_str[200],font_e[100];
	char **miss,*def;
	int n_miss;

	xtext_font_J2E(xconf.main_font_j,font_e);
	sprintf(font_str,"%s,%s",xconf.main_font_j,font_e);
	main_win.fs = XCreateFontSet(disp,font_str,&miss,&n_miss,&def);

	main_win.fs_e = XCreateFontSet(disp,xconf.main_font_e,&miss,&n_miss,&def);

	xtext_font_J2E(xconf.main_font_s,font_e);
	sprintf(font_str,"%s,%s",xconf.main_font_s,font_e);
	main_win.fs_s = XCreateFontSet(disp,font_str,&miss,&n_miss,&def);

	xtext_font_J2E(xconf.rubi_font,font_e);
	sprintf(font_str,"%s,%s",xconf.rubi_font,font_e);
	main_win.rubi_fs = XCreateFontSet(disp,font_str,&miss,&n_miss,&def);

#if HAVE_LIBXFT
	main_win.font = XftFontOpenXlfd(disp,0,xconf.main_font_j);
	main_win.font_e = XftFontOpenXlfd(disp,0,xconf.main_font_e);
	main_win.font_s = XftFontOpenXlfd(disp,0,xconf.main_font_s);
	main_win.font_rubi = XftFontOpenXlfd(disp,0,xconf.rubi_font);
#endif

	xtext_offt_set(offset_head,offset_tail,xconf,&off_head,&off_tail);
	xtext_set_offset(line_head,line_tail,off_head);

}
static void _set_utl()
{
	main_win.title_on = xconf.title_on;
	main_win.anti = xconf.anti;
	main_win.kinsc = xconf.kinsc;
	main_win.page_on = xconf.page_on;
}
static void _set_chr()
{
	char_d.xpad = xconf.line_space != -1 ? xconf.line_space:0;
	char_d.ypad = xconf.row_space != -1 ? xconf.row_space:0;
}
static void _set_xconf_data()
{
	_set_utl();
	_set_col();
	_set_win();
	_set_fnt();
	_set_chr();

	return ;
}
static page_data_t * _get_page_data(page_data_t *head,int no)
{
	page_data_t *p;

	for(p=head;p!=NULL;p=p->next){
		if(p->next == NULL) return p;

		if(no >= p->char_no && no < p->next->char_no) return p;
	}

	return head;
}
static page_data_t *_set_redraw_text()
{
	if(line_head == NULL) return NULL;

	xtext_Init_Text(disp,&main_win,line_head,&char_d);

	char_p = _get_page_data(char_d.head,NPC);


	return char_p;
}
static int _init_book_data(char *book_name,int n)
{
	iconv_t con;
	char *utf8;
	unsigned char title[256];

#if debug
fprintf(stderr,"main_bookname : %s %d\n",book_name,n);
#endif

	NPC = n;

	if(line_head != NULL) ibuf_data_free(line_head,line_tail);
	if(char_d.book != NULL) free(char_d.book);

	con = iconv_open("UTF-8","EUC-JP");
	char_d.book = (book_data_t *)malloc(sizeof(book_data_t));

	line_head = NULL;
	line_tail = NULL;
	if(itextGetTextData(book_name,title,&line_head,&line_tail,xconf.ruby_on)<0) return -1;
	xtext_set_offset(line_head,line_tail,off_head);

#if debug
fprintf(stderr,"main_booktitle : %s\n",title);
#endif
	utf8 = (char *)euc2utf8(con,title,strlen(title));

	strcpy(char_d.book->book_path,book_name);
	strcpy(char_d.book->book_title,title);
	strcpy(char_d.book->book_title_utf8,utf8);

	char_p = (page_data_t *)_set_redraw_text();

	XStoreName(disp,main_win.win,book_name);

	if(utf8) free(utf8);
	iconv_close(con);

	return 0;

}
static int _help_book_data()
{
	char *result;

	xtextHelpData2Sub(&help_head,&help_tail,&xconf);

	if((result = xtextSubWindow(disp,main_win,help_head,help_tail))==NULL) return -1;

	if(strcmp(result,XJP_OK) == 0) return 1;

	return 0;
}
int _select_book_data(char *book_dir)
{
	char *book_path;

#if debug
fprintf(stderr,"main_selectdir : %s\n",book_dir);
#endif
	xtextBookData2Sub(&book_head,&book_tail,book_dir);
	if(book_head == NULL){
		xtextSubWindow_Message(disp,main_win,XJP_MESSAGE[1]);
		return -1;
	}

	if((book_path = (char *)xtextSubWindow(disp,main_win,book_head,book_tail)) == NULL)
		return -1;

	if(strcmp(book_path,XJP_CANCEL) == 0) return -1;
#if debug
fprintf(stderr,"main_selectpath : %s\n",book_dir);
#endif
       	_init_book_data(book_path,0);

	return 1;

}
static int _siori_book_data()
{
	char *book_path;
	xtext_siori_t *si;

	xtextSioriData2Sub(&si_head,&si_tail,siori_head);
	if(si_head == NULL){
		xtextSubWindow_Message(disp,main_win,XJP_MESSAGE[2]);
		return -1;
	}

	if((book_path = (char *)xtextSubWindow(disp,main_win,si_head,si_tail)) == NULL) return -1;

	if(strcmp(book_path,XJP_CANCEL) == 0) return 1;

	for(si=siori_head;si!=NULL;si=si->next){
		if(strcmp(si->book_path,book_path)==0){
			_init_book_data(book_path,si->NPC);
			break;
		}
	}

	return 1;
}
static int _quit_cwin()
{
	return 0;
}
static int _hide_cwin()
{
	return 1;
}
static int _button_cwin(XEvent ev)
{
	ctl_window_t *ct;
	int x,y;
	int loop = 1;

	x = ev.xbutton.x;
	y = ev.xbutton.y;

	for(ct=ctl_head;ct!=NULL;ct=ct->next){
		if(ct->xpos0 < x && x < ct->xpos1 && ct->ypos0 < y && y < ct->ypos1){
			loop = ct->func();
			break;
		}
	}

	return loop;
}
static int _expose_cwin()
{
	ctl_window_t *ct;
	XRectangle ink,log;
	int x,y,w,h;
	int ctl_max;
	int xpad = 2,i;

	ctl_max = sizeof(XJP_CTRL_STR) / sizeof(char *);
	XmbTextExtents(main_win.fs_s,XJP_CTRL_STR[0],strlen(XJP_CTRL_STR[0]),&ink,&log);
	w = log.width ;
	h = log.height;
	x = 0; 
	y = 0;
	XMoveResizeWindow(disp,main_win.cwin,x,y,w * (ctl_max+xpad),h+2);
	XClearWindow(disp,main_win.cwin);

	for(ct=ctl_head,i=0;ct!=NULL;ct=ct->next,i++){
		ct->xpos0 = i * (w + xpad);
		ct->xpos1 = ct->xpos0 + w;
		ct->ypos0 = 0;
		ct->ypos1 = h;
		XmbDrawString(disp,main_win.cwin,main_win.fs_s,main_win.rubi_gc,ct->xpos0,ct->ypos1,ct->name,strlen(ct->name));
	}

	return 1;
}
static int _expose_win()
{
	if((NPC = xtext_Draw_Text(disp,&main_win,line_head,&char_d,char_p)) < 0) xtext_Draw_Help(disp,&main_win,&xconf);
	return 1;
}
static int _configure_win(XEvent ev)
{
	if(main_win.width != ev.xconfigure.width || main_win.height != ev.xconfigure.height){
		main_win.width = xconf.main_window_width = ev.xconfigure.width;
		main_win.height = xconf.main_window_height = ev.xconfigure.height;
		char_p = (page_data_t *)_set_redraw_text();
	}
	return 1;
}
static int _menu_win()
{
	_select_book_data(xconf.book_dir);
	xtext_siori_data_write(&siori_head,&siori_tail);
	return 1;
}
static int _conf_win()
{
	if(_help_book_data()){
		_set_xconf_data();
		char_p = (page_data_t *)_set_redraw_text();
	}
	return 1;
}
static int _bookmark_win()
{
   	if(xtext_siori_data_mark(&siori_head,&siori_tail,char_d.book->book_path,char_d.book->book_title,NPC) < 0) return -1;;
	xtextSubWindow_Message(disp,main_win,XJP_MESSAGE[0]);

	return 1;
}
static int _next_win()
{
	if(line_head == NULL || char_p->next == NULL) return -1;
	char_p = char_p->next;
	NPC = xtext_Draw_Text(disp,&main_win,line_head,&char_d,char_p);

	return 1;
}
static int _prev_win()
{
	if(line_head == NULL || char_p->prev == NULL) return -1;
	char_p = char_p->prev;
	NPC = xtext_Draw_Text(disp,&main_win,line_head,&char_d,char_p);

	return 1;
}
static int _title_key_win()
{
	xconf.title_on = xconf.title_on ? 0 : 1;
	_set_utl();
	NPC = xtext_Draw_Text(disp,&main_win,line_head,&char_d,char_p);

	return 1;
}
static int _page_key_win()
{
	xconf.page_on = xconf.page_on ? 0 : 1;
	_set_utl();
	NPC = xtext_Draw_Text(disp,&main_win,line_head,&char_d,char_p);

	return 1;
}
static int _kinsc_win()
{
	if(xconf.kinsc++ >= 2) xconf.kinsc = 0;
	_set_utl();
	char_p = (page_data_t *)_set_redraw_text();
	NPC = xtext_Draw_Text(disp,&main_win,line_head,&char_d,char_p);

	return 1;
}
static int _chuki_win()
{
	if(xconf.chuki){
		xconf.chuki = 0;
		XUnmapWindow(disp,main_win.mwin);
	}else{
		xconf.chuki = 1;
		XMapRaised(disp,main_win.mwin);
	}

	return 1;
}
static int _xtext_mwin_event(XEvent ev)
{
	int loop = 1;

	switch(ev.type){
		case Expose:
			xtextDrawChuMessage(disp,&main_win,&char_d);
		break;
	}

	return loop;
}
static int _xtext_cwin_event(XEvent ev)
{
	int loop = 1;

	switch(ev.type){
		case Expose:
			_expose_cwin();
		break;
		case ButtonPress:
			loop = _button_cwin(ev);
		break;
	}

	return loop;
}
static int _xtext_main_event(XEvent ev)
{
	char *keyname;

	switch(ev.type){
		case Expose:
			_expose_win();
			_expose_cwin();
		break;
		case ConfigureNotify:
			_configure_win(ev);
		break;
		case ButtonPress:
			if(ev.xbutton.button == 1){
				_next_win();
			}else if(ev.xbutton.button == 2){
				_menu_win();
			}else if(ev.xbutton.button == 3){
				_prev_win();
			}
		break;
		case KeyPress:
			keyname = (char *)XKeysymToString(XLookupKeysym(&ev.xkey,0)); 

			if(strcmp(keyname,xconf.menu)==0){
				_menu_win();

			}else if(strcmp(keyname,xconf.conf_page)==0){
				_conf_win();

			}else if(strcmp(keyname,xconf.book_mark)==0){
				_bookmark_win();

			}else if(strcmp(keyname,xconf.siori_menu)==0){
				_siori_book_data();

			}else if(strcmp(keyname,xconf.quit)==0){
				return 0;

			}else if(strcmp(keyname,xconf.page_next)==0){
				_next_win();

			}else if(strcmp(keyname,xconf.page_prev)==0){
				_prev_win();

			}else if(strcmp(keyname,xconf.title_key)==0){
				_title_key_win();

			}else if(strcmp(keyname,xconf.page_key)==0){
				_page_key_win();

			}else if(strcmp(keyname,xconf.kinsc_key)==0){
				_kinsc_win();

			}else if(strcmp(keyname,xconf.chuki_key)==0){
				_chuki_win();
			}
		break;
	}

	return 1;
}
static ctl_window_t *_ctl_data_alloc()
{
	ctl_window_t *ct;

	ct = (ctl_window_t *)malloc(sizeof(ctl_window_t));
	ct->name = NULL;
	ct->xpos0 = 0;
	ct->xpos1 = 0;
	ct->ypos0 = 0;
	ct->ypos1 = 0;
	ct->func = NULL;
	ct->func_data0 = NULL;

	return ct;
}
static void * _ctl_data_add(ctl_window_t **head,ctl_window_t **tail,ctl_window_t *im)
{
        if(*tail){
                im->next = NULL;
                im->prev = *tail;

                (*tail)->next = im;
                *tail = im;
        }else{
                im->next = NULL;
                im->prev = NULL;

                *tail = im;
                *head = im;
        }
        return NULL;
}
static void _set_ctrl(ctl_window_t **head,ctl_window_t **tail)
{
	ctl_window_t *ct;
	int i;

	for(i=0;i<sizeof(XJP_CTRL_STR)/sizeof(char *);i++){
		ct = (ctl_window_t *)_ctl_data_alloc();
		ct->name = XJP_CTRL_STR[i];
		
		switch(i){
			case 0:
				ct->func = _hide_cwin;
				ct->func_data0 = NULL;
			break;
			case 1:
				ct->func = _bookmark_win;
				ct->func_data0 = NULL;
			break;
			case 2:
				ct->func = _menu_win;
				ct->func_data0 = NULL;
			break;
			case 3:
				ct->func = _siori_book_data;
			       	ct->func_data0 = NULL;	
			break;
			case 4:	
				ct->func = _title_key_win;
				ct->func_data0 = NULL;
			break;
			case 5:
				ct->func = _kinsc_win;
				ct->func_data0 = NULL;
			break;
			case 6:
				ct->func = _conf_win;
				ct->func_data0 = NULL;
			break;
			case 7:
				ct->func = _quit_cwin;
				ct->func_data0 = NULL;
			break;
		}
		_ctl_data_add(head,tail,ct);
	}
}
static char * _get_option(int c,char **v)
{
	int option;

	while(1){
		if((option = getopt(c,v,"a:b:c:d:e:f:g:i:j:k:l:m:no:p:qh")) == -1) break;
		switch(option){
			case 'h': _usage(); break;
			case 'f':return optarg;break;
			case 'd':strcpy(xconf.book_dir,optarg);break;
			case 'a':xconf.main_window_width = atoi(optarg);break;
			case 'b':xconf.main_window_height = atoi(optarg);break;
			case 'c':strcpy(xconf.main_window_color,optarg);break;
			case 'e':strcpy(xconf.main_font_color,optarg);break;
			case 'g':strcpy(xconf.rubi_font_color,optarg);break;
			case 'i':strcpy(xconf.menu_font_color,optarg);break;
			case 'j':strcpy(xconf.menu_window_color,optarg);break;
			case 'k':strcpy(xconf.main_font_j,optarg);break;
			case 'l':strcpy(xconf.main_font_s,optarg);break;
			case 'm':strcpy(xconf.main_font_e,optarg);break;
			case 'n':strcpy(xconf.rubi_font,optarg);break;
			case 'o':xconf.anti = 1;
			case 'p':xconf.line_space = atoi(optarg);break;
			case 'q':xconf.row_space = atoi(optarg);break;
			case 'r':xconf.title_on = 1;break;
			default: _usage(); break;
		}
	}

	return NULL;
}
int main(int argc,char *argv[])
{
	XEvent ev;
	char *opt_book_path = NULL;
	int loop = 1;

	xtext_conf_data(&xconf,xconf_default);
	xtext_offt_data(&offset_head,&offset_tail);
	xtext_siori_data_read(&siori_head,&siori_tail);

	opt_book_path = (char *)_get_option(argc,argv);
	_set_ctrl(&ctl_head,&ctl_tail);

	_x_init();
	_x_drawable();
	_set_xconf_data();

	if(opt_book_path != NULL) _init_book_data(opt_book_path,0);

	while(loop){
		while(XPending(disp)){
			XNextEvent(disp,&ev);
			if(ev.xany.window == main_win.win){
				loop = _xtext_main_event(ev);
			}else if(ev.xany.window == main_win.cwin){
				loop = _xtext_cwin_event(ev);
			}else if(ev.xany.window == main_win.mwin){
				_xtext_mwin_event(ev);
			}
		}
		usleep(500);
	}
	xtext_siori_data_write(&siori_head,&siori_tail);

	return 0;
}

