<?php
if (!defined('XOOPS_ROOT_PATH')) exit();

$mydirname = strtolower(basename(__FILE__,'.php'));
$Pluginname = ucfirst($mydirname);
if (!preg_match("/^[\w\-]+$/", $Pluginname))
{
	trigger_error('Invalid pluginName');
	exit();
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
eval('
class Xmobile'.$Pluginname.'Plugin extends XmobileBmsurveyPluginAbstract
{
	function Xmobile'.$Pluginname.'Plugin()
	{
		$this->__construct();
	}
}

class Xmobile'.$Pluginname.'PluginHandler extends XmobileBmsurveyPluginHandlerAbstract
{
	function Xmobile'.$Pluginname.'PluginHandler($db)
	{
		$this->__construct("'.$mydirname.'",$db);
	}
}
');
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
class XmobileBmsurveyPluginAbstract extends XmobilePlugin
{
	function __construct()
	{
		// call parent constructor
		XmobilePlugin::XmobilePlugin();

		// define object elements
		$this->initVar('msg_id', XOBJ_DTYPE_INT, '0', true);
		$this->initVar('msg_image', XOBJ_DTYPE_TXTBOX, '', true, 100);
		$this->initVar('subject', XOBJ_DTYPE_TXTBOX, '', true, 255);
		$this->initVar('from_userid', XOBJ_DTYPE_INT, '0', true);
		$this->initVar('to_userid', XOBJ_DTYPE_INT, '0', true);
		$this->initVar('msg_time', XOBJ_DTYPE_INT, '0', true);
		$this->initVar('msg_text', XOBJ_DTYPE_TXTAREA, '', true);
		$this->initVar('gtd_done', XOBJ_DTYPE_INT, '0', true);
		$this->initVar('gtd_attr', XOBJ_DTYPE_INT, '0', true);
		$this->initVar('remind_date', XOBJ_DTYPE_INT, '0', true);
		$this->initVar('start_date', XOBJ_DTYPE_INT, '0', true);
		$this->initVar('parent_mid', XOBJ_DTYPE_INT, '0', true);
		$this->initVar('location', XOBJ_DTYPE_TXTBOX, '', true, 255);
		$this->initVar('groupid', XOBJ_DTYPE_TXTBOX, '', true, 255);
		
		// define primary key
		$this->setKeyFields(array('msg_id'));
		$this->setAutoIncrementField('msgid');
	}
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
class XmobileBmsurveyPluginHandlerAbstract extends XmobilePluginHandler
{
	var $moduleDir = 'Bmsurvey';
	var $itemTableName = 'bmsurvey_survey';

	var $template = 'xmobile_Bmsurvey.html';


	var $item_id_fld = 'msg_id';
	var $item_title_fld = 'subject';
	var $item_description_fld = 'msg_text';
	var $item_order_fld = 'start_date';
	var $item_date_fld = 'start_date';
	var $item_uid_fld = 'to_userid';

	var $item_order_sort = 'DESC';
	var $year = null;
	var $month = null;

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function __construct($mydirname,$db)
	{
		XmobilePluginHandler::XmobilePluginHandler($db);

		$this->moduleDir = $mydirname;
		if ( preg_match("/^\D+(\d*)$/", $mydirname,$matches) ){
			$number = $matches[1];
			$this->itemTableName = 'bmsurvey_survey';
		}
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
}
?>
