<?php
/*
 * $Id: weblog_recent.php,v 1.9 2005/04/13 18:47:29 tohokuaiki Exp $
 * Copyright (c) 2003 by Jeremy N. Cowgar <jc@cowgar.com>
 * Copyright (c) 2003 by wellwine <http://wellwine.zive.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * You may not change or alter any portion of this comment or credits
 * of supporting developers from this source code or any supporting
 * source code which is considered copyrighted (c) material of the
 * original comment or credit authors.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

if( ! defined("_WEBLOG_DIRNAME") )
	define('_WEBLOG_DIRNAME', 'weblog');
/*
 * $options[0] = max results
 * $options[1] = use avatars
 * $options[2] = link to entry list
 */
function b_weblog_top_weblogs_show($options) {
    global $xoopsDB, $xoopsUser;

    $max_results = $options[0];
    $use_avatars = $options[1];
    $link_entries = $options[2];
    
    $currentuid = !empty($xoopsUser) ? $xoopsUser->getVar('uid','E') : 0;

    $block = array();
    $rank = 0;

    $sql = sprintf('SELECT b.user_id, b.created, u.uname, u.user_avatar, count(b.blog_id) as count FROM %s as b, %s as u',
                   $xoopsDB->prefix('weblog'), $xoopsDB->prefix('users'));
    $sql = sprintf('%s WHERE (b.private = \'N\' OR b.user_id=\'%d\')  AND b.user_id=u.uid GROUP BY b.user_id ORDER BY count DESC, b.created DESC',
                   $sql, $currentuid);
    $result = $xoopsDB->query($sql, $max_results, 0);

    while ($myrow = $xoopsDB->fetchArray($result)) {
        $rank++;

        // Get the user, and retrieve his avatar
        $entry = array();
        $entry['rank'] = $rank;

        // Retrieve his/her avatar
        $entry['use_avatar'] = 0;
        $entry['avatar_img'] = '';
        if ($use_avatars==1) {
            $avatar = $myrow['user_avatar'];
            if (!empty($avatar) && $avatar != 'blank.gif') {
                $entry['use_avatar'] = 1;
                $entry['avatar_img'] = sprintf('%s/uploads/%s', XOOPS_URL, $avatar);
            }
        }
        if ($link_entries==1) {
            $entry['profile_uri'] = sprintf('%s/modules/%s/index.php?user_id=%d',
                                            XOOPS_URL, _WEBLOG_DIRNAME, $myrow['user_id']);
        } else {
            $entry['profile_uri'] = sprintf('%s/userinfo.php?uid=%d', XOOPS_URL, $myrow['user_id']);
        }
        $entry['uname'] = $myrow['uname'];
        $entry['count'] = $myrow['count'];
        $block['entries'][] = $entry;
    }
    return $block;
}

/*
 * $options[0] = max results
 * $options[1] = use avatars
 * $options[2] = link to entry list
 */
function b_weblog_top_weblogs_edit($options) {
    $form  = '<table>';
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%d" /></td></tr>',
                     _MB_WEBLOG_EDIT_NUMBER_OF_ENTRIES, intval($options[0]));
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%d" /></td></tr>',
                     _MB_WEBLOG_EDIT_USE_AVATARS, intval($options[1]));
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%d" /></td></tr>',
                     _MB_WEBLOG_EDIT_LINK_TO_LIST, intval($options[2]));
    $form .= '</table>';
    return $form;
}

/*
 * $options[0] = number of entries to show
 * $options[1] = max size of the title
 * $options[2] = date format
 * $options[3] = use avatars (only in large mode)
 * $options[4] = size (1=small, 2=midium, 3=large)
 * $options[5] = link to entry list (only when author names shown)
 */
 
function b_weblog_recent_show($options) {
    global $xoopsDB, $xoopsUser, $xoopsConfig;

    $max_entries = $options[0];
    $max_size = $options[1];
    $date_format = $options[2];
    $use_avatars = $options[3];
    $block_size = $options[4];
    $link_entries = $options[5];

    $currentuid = !empty($xoopsUser) ? $xoopsUser->getVar('uid','E') : 0;
    $user_id = !empty($_GET['user_id']) ? intval($_GET['user_id']) : 0;
  
    $myts =& MyTextSanitizer::getInstance();
    $block = array();
    $sql = sprintf('SELECT b.blog_id, b.created, b.user_id, b.title, b.comments, b.reads, b.trackbacks, u.uname, u.user_avatar FROM %s as b, %s as u',
                   $xoopsDB->prefix('weblog'), $xoopsDB->prefix('users'));
    $sql = sprintf('%s WHERE ((b.private = \'N\' OR b.user_id=\'%d\') AND b.user_id=u.uid) ',
                   $sql, $currentuid);
    if( $user_id )
        $sql = sprintf('%s and b.user_id=%d' , $sql , $user_id) ;
    $sql .= ' ORDER BY b.created DESC';


    // Need to figure out how to access the module config while in a block
    //$result = $xoopsDB->query($sql, $xoopsModuleConfig['numinrecentblock'], 0);
    $result = $xoopsDB->query($sql, $max_entries, 0);
    while ($myrow=$xoopsDB->fetchArray($result)) {
        $entry = array();
        $title = $myts->makeTboxData4Show($myrow['title']);
        if ( $block_size != 3) {
            if (strlen($title) >= $max_size) {
                $title = xoops_substr($title, 0, ($max_size -1)) ;
            }
        }

        // Retrieve his/her avatar
        $entry['use_avatar'] = 0;
        $entry['avatar_img'] = '';
        if ($use_avatars==1) {
            $avatar = $myrow['user_avatar'];
            if (!empty($avatar) && $avatar != 'blank.gif') {
                $entry['use_avatar'] = 1;
                $entry['avatar_img'] = sprintf('%s/uploads/%s', XOOPS_URL, $avatar);
            }
        }

        $entry['uname'] = $myts->makeTboxData4Show($myrow['uname']);
        if ($link_entries==1) {
            $entry['profile_uri'] = sprintf('%s/modules/%s/index.php?user_id=%d',
                                            XOOPS_URL, _WEBLOG_DIRNAME, $myrow['user_id']);
        } else {
            $entry['profile_uri'] = sprintf('%s/userinfo.php?uid=%d', XOOPS_URL, $myrow['user_id']);
        }
        $entry['title'] = $title;
        $entry['entry_url'] = sprintf('%s/modules/%s/details.php?blog_id=%d',
                                      XOOPS_URL, _WEBLOG_DIRNAME, $myrow['blog_id']);
        $entry['date'] = formatTimestamp($myrow['created'], $date_format, $xoopsConfig['default_TZ']);
        $entry['comments'] = $myrow['comments'];
        $entry['trackbacks'] = $myrow['trackbacks'];
        $entry['reads'] = $myrow['reads'];
        $block['entries'][] = $entry;
    }

    $block['type'] = $block_size;
    $block['lang_title'] = _MB_WEBLOG_LANG_TITLE;
    $block['lang_author'] = _MB_WEBLOG_LANG_AUTHOR;
    $block['lang_comments'] = _MB_WEBLOG_LANG_COMMENTS;
    $block['lang_trackbacks'] = _MB_WEBLOG_LANG_TRACKBACKS;
    $block['lang_posted'] = _MB_WEBLOG_LANG_POSTED;
    $block['lang_reads'] = _MB_WEBLOG_LANG_READS;
    $block['weblogs_url'] = sprintf('%s/modules/%s/index.php', XOOPS_URL, _WEBLOG_DIRNAME);
    $block['lang_moreweblogs'] = _MB_WEBLOG_LANG_MOREWEBLOGS;
	if ($user_id > 0 ) {
	    $blogOwner = new XoopsUser($user_id);
	    $block['lang_whose'] = sprintf(_BL_ENTRIES_FOR, $blogOwner->getVar('uname','E'));
	}
/*	if ($user_id > 0 || $currentuid > 0 ) {
		$uid = ( $user_id > 0 )? $user_id : $currentuid ;
	    $blogOwner = new XoopsUser($uid);
	    $block['lang_whosentries'] = sprintf(_BL_ENTRIES_FOR, $blogOwner->getVar('uname','E'));
	} */
	 return $block;
}


function b_weblog_recent_edit($options) {
    $form  = '<table>';
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%d" /></td></tr>',
                     _MB_WEBLOG_EDIT_NUMBER_OF_ENTRIES, intval($options[0]));
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%d" /></td></tr>',
                     _MB_WEBLOG_EDIT_MAX_TITLE_LENGTH, intval($options[1]));
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%s" /></td></tr>',
                     _MB_WEBLOG_EDIT_DATE_FORMAT, $options[2]);
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%s" /></td></tr>',
                     _MB_WEBLOG_EDIT_USE_AVATARS, $options[3]);
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%s" /></td></tr>',
                     _MB_WEBLOG_EDIT_TYPE, $options[4]);
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%d" /></td></tr>',
                     _MB_WEBLOG_EDIT_LINK_TO_LIST, intval($options[5]));
    $form .= '</table>';
    return $form;
}



/*
 * $options[0] = number of users to show
 * $options[1] = number of entries to show
 * $options[2] = date format
 * $options[3] = use avatars (only in large mode)
 * $options[4] = size (1=small, 2=midium, 3=large)
 * $options[5] = what order by (Last entry time or Total Reads)
 * $options[6] = max size of the title
 */
function b_weblog_users_weblogs_show($options) {

    global $xoopsDB, $xoopsUser, $xoopsConfig ;

    $max_users = $options[0];
    $max_entries = $options[1];
    $date_format = $options[2];
    $use_avatars = $options[3];
    $block_size = $options[4];
    $order_by = $options[5];
    $max_size = $options[6];

    $currentuid = !empty($xoopsUser) ? $xoopsUser->getVar('uid','E') : 0;
  
    $myts =& MyTextSanitizer::getInstance();
    $block = array();

		// SELECT b.blog_id, b.created, b.user_id, b.title, b.comments, b.reads, u.uname, u.user_avatar FROM %s as b, %s as u'	
	// user order by reads or blog last update 
	if( $order_by == 0 ){	 // last entry time
	    $user_sql = sprintf('select user_id,uname,user_avatar,max(created) as sort_value from %s as b , %s as u where b.user_id=u.uid ', 
					$xoopsDB->prefix('weblog') , $xoopsDB->prefix('users') );
		$sort_value = _MB_WEBLOG_USERS_SORT_UPDATE ;
	}else{		// order by most reads user
	    $user_sql = sprintf('select user_id,uname,user_avatar,sum(reads) as sort_value from %s as b , %s as u where b.user_id=u.uid ', 
					$xoopsDB->prefix('weblog') , $xoopsDB->prefix('users') );
		$sort_value = _MB_WEBLOG_USERS_SORT_READS ;
	}
	$user_sql .= ' group by user_id order by sort_value desc ' ;
	
	    // Need to figure out how to access the module config while in a block
    //$result = $xoopsDB->query($sql, $xoopsModuleConfig['numinrecentblock'], 0);
    $result_user = $xoopsDB->query($user_sql, $max_users, 0);
	$users = array() ;
    while ($userrow=$xoopsDB->fetchArray($result_user)) {
		$user_id = $myts->makeTboxData4Show($userrow['user_id']) ;
		$user_sortvalue = ( $order_by == 0 ) ? date(  $date_format , $myts->makeTboxData4Show($userrow['sort_value'])  ) : $myts->makeTboxData4Show($userrow['sort_value']) ;
		$users[$user_id] = array(
				'uname' => $myts->makeTboxData4Show($userrow['uname']) ,
				'avatar_img' => sprintf( '%s/uploads/%s', XOOPS_URL, $myts->makeTboxData4Show($userrow['user_avatar']) ) ,
				'sort_value' => $user_sortvalue ,
				'profile_uri' => sprintf('%s/userinfo.php?uid=%d', XOOPS_URL, $user_id) ,
				'user_blog_uri' => sprintf('%s/modules/%s/index.php?user_id=%d', XOOPS_URL, _WEBLOG_DIRNAME , $user_id) ,
				'entries' => array() ) ;
		// get user's entries 
		$entry_sql = sprintf('select blog_id,user_id,created,title,reads,comments,trackbacks from %s where user_id=%d and (private=\'N\' or user_id=\'%d\') order by created desc ',
								 $xoopsDB->prefix('weblog') , $user_id , $currentuid );
		$result_entry = $xoopsDB->query($entry_sql , $max_entries , 0) ;
		$users[$user_id]['entry_num_plus1'] = $xoopsDB->getRowsNum($result_entry) +1  ;	// used by template rowspan
		while( $entryrow = $xoopsDB->fetchArray($result_entry) ){
	        $entry_url = sprintf('%s/modules/%s/details.php?blog_id=%d', XOOPS_URL, _WEBLOG_DIRNAME, $entryrow['blog_id']);
			$users[$user_id]['entries'][] = array(
				'created' => date( $date_format , $myts->makeTboxData4Show($entryrow['created']) ) ,
				'title' => xoops_substr($myts->makeTboxData4Show($entryrow['title']) , 0 , $max_size),
				'entry_url' => $entry_url ,
				'reads' => $myts->makeTboxData4Show($entryrow['reads']) ,
				'comments' => $myts->makeTboxData4Show($entryrow['comments']) ,
				'trackbacks' => $myts->makeTboxData4Show($entryrow['trackbacks']) 
			) ;
		}
	}
	$block['users'] =& $users ;
    $block['type'] = $block_size;
    $block['use_avatars'] = $use_avatars ;
    $block['lang_user_sort_value'] = $sort_value;
    $block['lang_title'] = _MB_WEBLOG_LANG_TITLE;
    $block['lang_entries'] = _MB_WEBLOG_LANG_ENTRIES;
    $block['lang_author'] = _MB_WEBLOG_LANG_AUTHOR;
    $block['lang_comments'] = _MB_WEBLOG_LANG_COMMENTS;
    $block['lang_trackbacks'] = _MB_WEBLOG_LANG_TRACKBACKS;
    $block['lang_posted'] = _MB_WEBLOG_LANG_POSTED;
    $block['lang_reads'] = _MB_WEBLOG_LANG_READS;
    $block['lang_moreweblogs'] = _MB_WEBLOG_LANG_MOREWEBLOGS;
    $block['weblogs_url'] = sprintf('%s/modules/%s/index.php', XOOPS_URL, _WEBLOG_DIRNAME);
    return $block;
}

function b_weblog_users_weblogs_edit($options) {
    $form  = '<table>';
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%d" /></td></tr>',
                     _MB_WEBLOG_EDIT_NUMBER_OF_USERS, intval($options[0]));
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%d" /></td></tr>',
                     _MB_WEBLOG_EDIT_NUMBER_OF_ENTRIES, intval($options[1]));
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%s" /></td></tr>',
                     _MB_WEBLOG_EDIT_DATE_FORMAT, $options[2]);
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%s" /></td></tr>',
                     _MB_WEBLOG_EDIT_USE_AVATARS, $options[3]);
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%s" /></td></tr>',
                     _MB_WEBLOG_EDIT_TYPE, $options[4]);
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%d" /></td></tr>',
                     _MB_WEBLOG_EDIT_ORDER_BY, intval($options[5]));
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%d" /></td></tr>',
                     _MB_WEBLOG_EDIT_MAX_TITLE_LENGTH, intval($options[6]));
    $form .= '</table>';
    return $form;
}


function b_weblog_recent_tb_show($options) {
    global $xoopsDB, $xoopsUser, $xoopsConfig ;

    $max_trackbacks = $options[0];
    $max_size = $options[1];
    $date_format = $options[2];
    $block_size = $options[3];

    $currentuid = !empty($xoopsUser) ? $xoopsUser->getVar('uid','E') : 0;
    $user_id = !empty($_GET['user_id']) ? intval($_GET['user_id']) : 0;
  
    $myts =& MyTextSanitizer::getInstance();
    $block = array();
	$block['trackbacks'] = array() ;
    $sql = sprintf('SELECT b.user_id, t.blog_id, if(t.tb_url!=\'\',t.tb_url,t.link) as link , t.blog_name, t.title as tb_title, t.trackback_created,b.title as entry_title FROM %s as t , %s as b',
                   $xoopsDB->prefix('weblog_trackback') ,$xoopsDB->prefix('weblog') );
    $sql = sprintf('%s WHERE t.blog_id=b.blog_id and (b.private = \'N\' OR b.user_id=\'%d\') and t.direction=\'recieved\' ',
                   $sql, $currentuid);
    if( $user_id )
        $sql = sprintf('%s and b.user_id=%d' , $sql , $user_id) ;
    $sql .= ' ORDER BY t.trackback_created DESC';


    // Need to figure out how to access the module config while in a block
    //$result = $xoopsDB->query($sql, $xoopsModuleConfig['numinrecentblock'], 0);
    $result = $xoopsDB->query($sql, $max_trackbacks, 0);
    while ($myrow=$xoopsDB->fetchArray($result)) {
        $trackback = array();
        $tb_title = $myts->makeTboxData4Show($myrow['tb_title']);
        if ( $block_size != 3) {
            if (strlen($tb_title) >= $max_size) {
                $tb_title = xoops_substr($tb_title, 0, ($max_size -1)) ;
            }
        }

        $trackback['blog_name'] = $myts->makeTboxData4Show($myrow['blog_name']);
        $trackback['link'] = $myts->makeTboxData4Show($myrow['link']);
        $trackback['tb_title'] = $tb_title;
        $trackback['entry_url'] = sprintf('%s/modules/%s/details.php?blog_id=%d',
                                      XOOPS_URL, _WEBLOG_DIRNAME, $myrow['blog_id']);
        $trackback['date'] = formatTimestamp($myrow['trackback_created'], $date_format, $xoopsConfig['default_TZ']);
        $trackback['entry_title'] = $myts->makeTboxData4Show($myrow['entry_title']);
        $block['trackbacks'][] = $trackback;
    }

    $block['type'] = $block_size;
    $block['lang_tbtitle'] = _MB_WEBLOG_LANG_TB_TITLE;
    $block['lang_entrytitle'] = _MB_WEBLOG_LANG_TB_WEBLOGTITLE;
    $block['lang_blogname'] = _MB_WEBLOG_LANG_TB_BLOGNAME;
    $block['lang_posted'] = _MB_WEBLOG_LANG_TB_POSTED;
	if ($user_id > 0 ) {
	    $blogOwner = new XoopsUser($user_id);
	    $block['lang_whose'] = sprintf(_BL_TRACKBACKS_FOR, $blogOwner->getVar('uname','E'));
	}
    return $block;
}


function b_weblog_recent_tb_edit($options) {
    $form  = '<table>';
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%d" /></td></tr>',
                     _MB_WEBLOG_EDIT_NUMBER_OF_TRACKBACKS, intval($options[0]));
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%d" /></td></tr>',
                     _MB_WEBLOG_EDIT_MAX_TITLE_LENGTH, intval($options[1]));
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%s" /></td></tr>',
                     _MB_WEBLOG_EDIT_DATE_FORMAT, $options[2]);
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%s" /></td></tr>',
                     _MB_WEBLOG_EDIT_TYPE, $options[3]);
    $form .= '</table>';
    return $form;
}


function b_weblog_recent_comment_show($options) {
    global $xoopsDB, $xoopsUser, $xoopsConfig ;

    $max_comments = $options[0];
    $max_size = $options[1];
    $date_format = $options[2];
    $block_size = $options[3];

    $currentuid = !empty($xoopsUser) ? $xoopsUser->getVar('uid','E') : 0;
    $user_id = !empty($_GET['user_id']) ? intval($_GET['user_id']) : 0;
  
    $myts =& MyTextSanitizer::getInstance();
    $block = array();
	$block['comments'] = array() ;
    $sql = sprintf('SELECT com_modified, com_uid, com_title, com_itemid, title, uname FROM %s as xc , %s as m , %s as b , %s as u' , 
                    $xoopsDB->prefix('xoopscomments') , $xoopsDB->prefix('modules') ,$xoopsDB->prefix('weblog') ,$xoopsDB->prefix('users') );
    $sql = sprintf('%s WHERE com_modid=mid and dirname=\'%s\' and (b.private = \'N\' OR b.user_id=\'%d\') and blog_id=com_itemid and com_status=2 and (com_uid=uid or com_uid=0) group by com_id',
                   $sql, _WEBLOG_DIRNAME ,$currentuid);
    if( $user_id )
        $sql = sprintf('%s and b.user_id=%d' , $sql , $user_id) ;
    $sql .= ' ORDER BY com_modified DESC';

    // Need to figure out how to access the module config while in a block
    //$result = $xoopsDB->query($sql, $xoopsModuleConfig['numinrecentblock'], 0);
    $result = $xoopsDB->query($sql, $max_comments, 0);
    while ($myrow=$xoopsDB->fetchArray($result)) {
        $comment = array();
        $com_title = $myts->makeTboxData4Show($myrow['com_title']);
        if ( $block_size != 3) {
            if (strlen($com_title) >= $max_size) {
                $com_title = xoops_substr($com_title, 0, ($max_size -1)) ;
            }
        }

        $comment['com_title'] = $com_title;
        $comment['date'] = formatTimestamp($myrow['com_modified'], $date_format, $xoopsConfig['default_TZ']);
        $comment['entry_url'] = sprintf('%s/modules/%s/details.php?blog_id=%d',
                                      XOOPS_URL, _WEBLOG_DIRNAME, $myrow['com_itemid']);
        $comment['entry_title'] = $myts->makeTboxData4Show($myrow['title']);
		$comment['com_uname'] = ( $myrow['com_uid'] == 0 ) ? $xoopsConfig['anonymous'] : $myrow['uname'] ;
		if( $myrow['com_uid'] != 0 )
			$comment['profile_uri'] = sprintf('%s/userinfo.php?uid=%d', XOOPS_URL, $myts->makeTboxData4Show($myrow['com_uid']) );
        $block['comments'][] = $comment ;
    }

    $block['type'] = $block_size;
    $block['lang_comuname'] = _MB_WEBLOG_LANG_COM_UNAME;
    $block['lang_comtitle'] = _MB_WEBLOG_LANG_COM_TITLE;
    $block['lang_entrytitle'] = _MB_WEBLOG_LANG_COM_WEBLOGTITLE;
    $block['lang_posted'] = _MB_WEBLOG_LANG_COM_POSTED;
	if ($user_id > 0 ) {
	    $blogOwner = new XoopsUser($user_id);
	    $block['lang_whose'] = sprintf(_BL_COMMENTS_FOR, $blogOwner->getVar('uname','E'));
	}
    return $block;
}


function b_weblog_recent_comment_edit($options) {
    $form  = '<table>';
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%d" /></td></tr>',
                     _MB_WEBLOG_EDIT_NUMBER_OF_COMMENTS, intval($options[0]));
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%d" /></td></tr>',
                     _MB_WEBLOG_EDIT_MAX_TITLE_LENGTH, intval($options[1]));
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%s" /></td></tr>',
                     _MB_WEBLOG_EDIT_DATE_FORMAT, $options[2]);
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%s" /></td></tr>',
                     _MB_WEBLOG_EDIT_TYPE, $options[3]);
    $form .= '</table>';
    return $form;
}



function b_weblog_recent_image_show($options) {
    global $xoopsDB, $xoopsUser, $xoopsConfig ;

	if( function_exists("gd_info") ){
		$gd_infomation = gd_info() ;
		if( substr( $gd_infomation['GD Version'] , 0 , 10 ) != 'bundled (2' )	// GD version 2 is required
			return false ;
	}

    $max_images = $options[0];
    $max_title_length = $options[1];
    $max_contents_length = $options[2];
    $date_format = $options[3];
    $block = array();
	$block['images'] = array() ;
	
    $currentuid = !empty($xoopsUser) ? $xoopsUser->getVar('uid','E') : 0;
    $user_id = !empty($_GET['user_id']) ? intval($_GET['user_id']) : 0;
 
    $myts =& MyTextSanitizer::getInstance();

	$mod_conf = array() ;
    $mod_conf_rs = $xoopsDB->query( sprintf('SELECT conf_name,conf_value from %s where conf_name=\'weblog_myalbum_thumbspath\' or conf_name=\'weblog_myalbum_photospath\' ' , $xoopsDB->prefix('config')) )  ;
	while( $conf = $xoopsDB->fetchArray($mod_conf_rs) ){
		$mod_conf[$conf['conf_name']] = $conf['conf_value'] ;
	}
	$weblog_image_url = XOOPS_URL . $mod_conf['weblog_myalbum_photospath'] ;
    $sql = sprintf('SELECT blog_id, user_id , uname, created, title, contents FROM %s as b , %s as u' , 
                   $xoopsDB->prefix('weblog') ,$xoopsDB->prefix('users') );
    $sql = sprintf('%s WHERE b.user_id=u.uid and (b.private = \'N\' OR b.user_id=\'%d\') and b.contents like \'%s\' ',
                   $sql , $currentuid , '%'.$weblog_image_url.'%' );
    if( $user_id )
        $sql = sprintf('%s and b.user_id=%d' , $sql , $user_id) ;
    $sql .= ' ORDER BY created DESC';

    // Need to figure out how to access the module config while in a block
    //$result = $xoopsDB->query($sql, $xoopsModuleConfig['numinrecentblock'], 0);
    $result = $xoopsDB->query($sql, $max_images, 0);
    while ($myrow=$xoopsDB->fetchArray($result)) {
        $image = array();
		$title = "" ;
		if( $max_title_length > 0 ){
	        $title = $myts->makeTboxData4Show($myrow['title']);
	       	if (strlen($title) >= $max_title_length)
	                $title = xoops_substr($title, 0, ($max_title_length -1)) ;
		}
		$contents = "" ;
		if( $max_contents_length > 0 ){
	        $contents = strip_tags( $myts->xoopsCodeDecode($myrow['contents']) );
	       	if (strlen($contents) >= $max_contents_length)
                $contents = xoops_substr($contents, 0, ($max_contents_length -1)) ;
		}

		$img_pattern = "/\[img( align=['\"]?)?(left|center|right)?]([^\"\(\)\?\&'<>]*)\[\/img\]/sU";
		$image['image_url'] = array() ;
        if( preg_match_all( $img_pattern  , $myrow['contents'] , $matches) ){
			$image['image_uri'] = str_replace( $mod_conf['weblog_myalbum_photospath'] , $mod_conf['weblog_myalbum_thumbspath'] , $matches[3] );		
		}
        $image['title'] = $title ;
        $image['contents'] = $contents ;
		$image['uname'] = $myrow['uname'] ;
        $image['date'] = formatTimestamp($myrow['created'], $date_format, $xoopsConfig['default_TZ']);
        $image['entry_url'] = sprintf('%s/modules/%s/details.php?blog_id=%d',
                                      XOOPS_URL, _WEBLOG_DIRNAME, $myts->makeTboxData4Show($myrow['blog_id']) );
		$image['blog_uri'] = sprintf('%s/modules/%s/index.php?user_id=%d', 
                                      XOOPS_URL, _WEBLOG_DIRNAME , $myts->makeTboxData4Show($myrow['user_id']) ) ;
        $block['images'][] = $image ;
    }
	if ($user_id > 0 ) {
	    $blogOwner = new XoopsUser($user_id);
	    $block['lang_whose'] = sprintf(_BL_ENTRY_FOR, $blogOwner->getVar('uname','E'));
	}
    return $block;
}

function b_weblog_recent_image_edit($options) {
    $form  = '<table>';
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%d" /></td></tr>',
                     _MB_WEBLOG_EDIT_NUMBER_OF_ENTRIES, intval($options[0]));
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%d" /></td></tr>',
                     _MB_WEBLOG_EDIT_MAX_TITLE_LENGTH, intval($options[1]));
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%s" /></td></tr>',
                     _MB_WEBLOG_EDIT_MAX_CONTENTS_LENGTH, $options[2]);
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%s" /></td></tr>',
                     _MB_WEBLOG_EDIT_DATE_FORMAT, $options[3]);
    $form .= '</table>';
    return $form;
}
?>