<?php
/**
 * $Id: details.php,v 1.3 2003/08/29 14:10:29 wellwine Exp $
 * Copyright (c) 2003 by Hiro SAKAI (http://wellwine.net/)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * You may not change or alter any portion of this comment or credits
 * of supporting developers from this source code or any supporting
 * source code which is considered copyrighted (c) material of the
 * original comment or credit authors.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

include('header.php');
include_once(sprintf('%s/modules/%s/class/class.weblog.php', XOOPS_ROOT_PATH, $xoopsModule->dirname()));
include_once(sprintf('%s/modules/%s/class/class.weblogcategories.php', XOOPS_ROOT_PATH, $xoopsModule->dirname()));

// obtain GET/POST parameters
$blog_id = !empty($_GET['blog_id']) ? intval($_GET['blog_id']) : 0;

// Determine the user we are retrieving the blog entries for
$currentuid = !empty($xoopsUser) ? $xoopsUser->getVar('uid','E') : 0;
$isAdmin = !empty($xoopsUser) && $xoopsUser->isAdmin($xoopsModule->mid());

// specify template
$xoopsOption['template_main'] = 'weblog_details.html';

// obtain class instances
$myts =& MyTextSanitizer::getInstance();
$weblog =& Weblog::getInstance();
$weblogcat =& WeblogCategories::getInstance();

$entryObject =& $weblog->getEntry($currentuid, $blog_id);
if (!$entryObject) {
  redirect_header(sprintf('%s/modules/%s/index.php', XOOPS_URL, $xoopsModule->dirname()), 5,
                  _BL_PRIVATE_NOTEXIST_SORRY);
  exit();
}

// wellwine for cookie begins
// Read in cookie
$weblog_read = !empty($HTTP_COOKIE_VARS[WEBLOG_COOKIE_READ]) ? unserialize($HTTP_COOKIE_VARS[WEBLOG_COOKIE_READ]) : array();
// if cookie is not set for this blog, update view count and set cookie
$curtime = time();
if ( empty($weblog_read[$blog_id]) || $weblog_read[$blog_id] + $xoopsModuleConfig['expiration'] < $curtime ) {
    $reads = $weblog->incrementReads($blog_id);
    $entryObject->setVar('reads', $reads);
}
// Update cookie
// FIXME: doesn't check if 4kB limit of cookie is exceeded!
$weblog_read[$blog_id] = $curtime;
setcookie(WEBLOG_COOKIE_READ, serialize($weblog_read), $curtime+$xoopsModuleConfig['expiration'], $weblogCookie['path'], $weblogCookie['domain'], $weblogCookie['secure']);
// wellwine for cookie ends

// Setup the user_id in the HTTP_GET so that the Notifications module will pick it up
$HTTP_GET_VARS['user_id'] = $entryObject->getVar('user_id');

// Retrieve his/her avatar
$use_avatar = 0;
$avatar_img = '';
$avatar_width = 0;
if ($xoopsModuleConfig['showavatar']) {
    $avatar = $entryObject->getVar('user_avatar', 'E');
    if (!empty($avatar) && $avatar != 'blank.gif') {
        $use_avatar = 1;
        $avatar_img = sprintf('%s/uploads/%s', XOOPS_URL, $avatar);
        $dimension = getimagesize($avatar_img);
        $avatar_width = $dimension[0];
    }
}

// Include the page header
include(XOOPS_ROOT_PATH.'/header.php');

$xoopsTpl->assign('use_avatar',$use_avatar);
$xoopsTpl->assign('avatar_img',$avatar_img);
$xoopsTpl->assign('avatar_width', $avatar_width);

$xoopsTpl->assign('title', $entryObject->getVar('title'));
$path = $weblogcat->getNicePathFromId($entryObject->getVar('cat_id'),
                                      sprintf('%s/modules/%s/index.php?',
                                              XOOPS_URL, $xoopsModule->dirname()));
//$path = $weblogcat->getCategoryPath($entryObject->getVar('cat_id'), ' > ');
$xoopsTpl->assign('category', $path);
$xoopsTpl->assign('lang_category', _BL_CATEGORY);
$xoopsTpl->assign('blog_id', $entryObject->getVar('blog_id'));
$xoopsTpl->assign('lang_author', _BL_AUTHOR);
$xoopsTpl->assign('created_date', formatTimestamp($entryObject->getVar('created'),
                                                  $xoopsModuleConfig['dateformat'],
                                                  $xoopsConfig['default_TZ']));
$xoopsTpl->assign('created_time', formatTimestamp($entryObject->getVar('created'),
                                                  $xoopsModuleConfig['timeformat'],
                                                  $xoopsConfig['default_TZ']));
$xoopsTpl->assign('uid', $entryObject->getVar('user_id'));
$xoopsTpl->assign('uname', $entryObject->getVar('uname'));
$xoopsTpl->assign('contents', $entryObject->getVar('contents', 's'));
$xoopsTpl->assign('private', $entryObject->getVar('private'));
$xoopsTpl->assign('profileUri', sprintf('%s/userinfo.php?uid=%d', XOOPS_URL, $entryObject->getVar('user_id')));
$xoopsTpl->assign('current_uid', $currentuid);
$xoopsTpl->assign('is_private', $entryObject->getVar('private') == 'Y' ? 1 : 0);
$xoopsTpl->assign('private', _BL_PRIVATE);
$xoopsTpl->assign('lang_reads', _BL_NUMBER_OF_READS);
$xoopsTpl->assign('reads', $entryObject->getVar('reads'));
$xoopsTpl->assign('edit_text', _BL_EDIT);
$xoopsTpl->assign('read_users_blog',sprintf('<a href="index.php?user_id=%d">%s</a>',
                                            $entryObject->getVar('user_id'),
                                            sprintf(_BL_READ_USERS_BLOG, $entryObject->getVar('uname'))));
$xoopsTpl->assign('provide_edit_link', ($isAdmin || $currentuid==$entryObject->getVar('user_id'))?1:0);

$xoopsTpl->assign('blog_id', $blog_id);
$xoopsTpl->assign('print_link', 'print.php?blog_id='.$blog_id);
$xoopsTpl->assign('lang_printerpage', _BL_PRINTERPAGE);
$xoopsTpl->assign('mail_link', 'mailto:?subject='.sprintf(_BL_INTARTICLE,$xoopsConfig['sitename']).'&amp;body='.sprintf(_BL_INTARTFOUND, $xoopsConfig['sitename']).':  '.XOOPS_URL.'/modules/'.$xoopsModule->dirname().'/details.php?blog_id='.$blog_id);
$xoopsTpl->assign('lang_sendstory', _BL_SENDSTORY);

$rss = sprintf('%s/modules/%s/backend_weblog.php', XOOPS_URL, $xoopsModule->dirname());
$rss .= sprintf('?user_id=%d', $entryObject->getVar('user_id'));
$xoopsTpl->assign('lang_rss', sprintf(_BL_RSS_RECENT_FOR, $entryObject->getVar('uname')));
$xoopsTpl->assign('rss_feeder', $rss);
$xoopsTpl->assign('rss_show', $xoopsModuleConfig['rssshow']);

$xoopsTpl->assign('page_title', $xoopsModule->name());
$xoopsTpl->assign('page_subtitle', sprintf(_BL_ENTRY_FOR, $entryObject->getVar('uname')));

// Include the commenting module
require XOOPS_ROOT_PATH.'/include/comment_view.php';

include(XOOPS_ROOT_PATH.'/footer.php');
?>