<?php
// $Id: xoopspoll.php,v 1.3 2003/10/23 13:16:41 wellwine Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
include_once XOOPS_ROOT_PATH.'/modules/xoopspoll/class/xoopspoll.php';
include_once XOOPS_ROOT_PATH.'/modules/xoopspoll/class/xoopspolllog.php';
include_once XOOPS_ROOT_PATH.'/modules/xoopspoll/class/xoopspolloption.php';
include_once XOOPS_ROOT_PATH.'/modules/xoopspoll/language/'.$xoopsConfig['language'].'/main.php';

function hasVoted($poll_id) {
    global $_COOKIE;
    global $xoopsUser;

    $voted_polls = (!empty($_COOKIE['voted_polls'])) ? $_COOKIE['voted_polls'] : array();
    if ( empty($voted_polls[$poll_id]) ) {
        if (is_object($xoopsUser)) {
            $uid = $xoopsUser->getVar('uid');
        } else {
            $uid = null;
        }
        if ( XoopsPollLog::hasVoted($poll_id, xoops_getenv('REMOTE_ADDR'), $uid) ) {
            setcookie("voted_polls[$poll_id]", 1, 0);
            return true;
        } else {
            return false;
        }
    } else {
        return true;
    }
}

/**
 * $opts[0] = show result if expired or voted (1=yes)
 * $opts[1] = show percent (1=yes)
 * $opts[2] = show bar (1=yes)
 */
function b_xoopspoll_show($opts)
{
    $show_result = ($opts[0]==1)?true:false;
    $show_percent = ($opts[1]==1)?true:false;
    $show_bar = ($opts[2]==1)?true:false;

    $block = array();
    $polls =& XoopsPoll::getAll(array('display=1'), true, 'weight ASC, end_time DESC');
    $count = count($polls);
    $block['lang_vote'] = _PL_VOTE;
    $block['lang_results'] = _PL_RESULTS;
    for ($i = 0; $i < $count; $i++) {
        $options_arr =& XoopsPollOption::getAllByPollId($polls[$i]->getVar('poll_id'));
        $expired = $polls[$i]->hasExpired();
        if (($expired || hasVoted($polls[$i]->getVar('poll_id'))) && $show_result) {
            $total = $polls[$i]->getVar("votes");
            foreach ($options_arr as $option) {
                if ( $total > 0 ) {
                    $percent = 100 * $option->getVar("option_count") / $total;
                } else {
                    $percent = 0;
                }
                if ( intval($percent) > 0 && $show_bar) {
                    $width = intval($percent);
                    $img = "<img src='".XOOPS_URL."/modules/xoopspoll/images/colorbars/".$option->getVar("option_color", "E")."' height='14' width='".$width."%' align='middle' alt='".intval($percent)." %' />";
                } else {
                    $img ='';
                }
                if ($show_percent) {
                    $percent = sprintf("%d%%", $percent);
                } else {
                    $percent = '';
                }
                $options[] = array('percent' => $percent, 'image' => $img, 'text' => $option->getVar('option_text'));
            }
            $poll = array('expired' => 1, 'id' => $polls[$i]->getVar('poll_id'), 'question' => $polls[$i]->getVar('question'), 'options' => $options);
        } else {
            $option_type = 'radio';
            $option_name = 'option_id';
            if ($polls[$i]->getVar('multiple') == 1) {
                $option_type = 'checkbox';
                $option_name .= '[]';
            }
            foreach ($options_arr as $option) {
                $options[] = array('id' => $option->getVar('option_id'), 'text' => $option->getVar('option_text'));
            }
            $poll = array('expired' => 0, 'id' => $polls[$i]->getVar('poll_id'), 'question' => $polls[$i]->getVar('question'), 'option_type' => $option_type, 'option_name' => $option_name, 'options' => $options);
        }
        $block['polls'][] =& $poll;
        unset($options);
        unset($poll);
    }
    return $block;
}

/**
 * $options[0] = show result if expired or voted (1=yes)
 * $options[1] = show percent (1=yes)
 * $options[2] = show bar (1=yes)
 */
function b_xoopspoll_edit($options) {
    $form  = '<table>';
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%d" /></td></tr>',
                     _BL_POLL_EDIT_SHOWRESULTS, intval($options[0]));
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%d" /></td></tr>',
                     _BL_POLL_EDIT_SHOWPERCENT, intval($options[1]));
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" name="options[]" value="%d" /></td></tr>',
                     _BL_POLL_EDIT_SHOWBAR, intval($options[2]));
    $form .= '</table>';
    return $form;
}
?>