<?php
// $Id: category_list.php,v 1.2 2005/03/29 03:47:33 ohwada Exp $

// 2005-03-28 K.OHWADA
// bug fix: pagenavi dont work correctly

// 2005-01-20 K.OHWADA
// use set_max_sortid

//================================================================
// view category list 
// created from v0.9
// 2004-12-14 K.OHWADA
//================================================================

include 'admin_header.php';

include_once $MODULE_ROOT."/class/pagenavi.php";

// class
$pagenavi = new pagenavi();

$pid = 0;
if ( isset($_GET['pid']) )  $pid = $_GET['pid'];

$pagenavi->set_max_sortid(2);
$pagenavi->set_show(50);	// 50 lines
$pagenavi->get_get_parm();
$sortid = $pagenavi->get_sortid();

$total_all = $tbl_category->getNumAll();

switch ($sortid)
{
	case 2:
		$total = $tbl_category->getNumByPid($pid);
		break;

	case 0:
	case 1:
	default:
		$total = $total_all;
		break;
}

print_top($sortid, $total_all);

// --- category list ---
if ($total > 0)
{
	$limit  = $pagenavi->get_show();
	$offset = $pagenavi->get_start($total);

	if ($offset == -1)
	{
		echo "system error: total = $total <br>\n";
		include XOOPS_ROOT_PATH.'/footer.php';
		exit();
	}

	print_start($sortid);

	switch ($sortid)
	{
		case 1:
			$cid_arr = $tbl_category->getTreeArray($limit, $offset);
			break;

		case 2:
			$cid_arr = $tbl_category->getCidArrayByPid($pid);
			break;

		case 0:
		default:
			$cid_arr = $tbl_category->getCidArrayAll($limit, $offset);
			break;

	}

	foreach ($cid_arr as $cid) 
	{
		$rec = $tbl_category->getRecordByCid($cid);

		$cid    = $rec['cid'];
		$pid    = $rec['pid'];
		$title  = $rec['title'];
		$orders = $rec['orders'];

		print_line($sortid, $cid, $title, $pid, $orders);
	}

//if 2 or more items in result, show the sort menu
	$navi = '';

	if($total > 1)
	{
		$script = "category_list.php?sortid=$sortid";

// bug fix: pagenavi dont work correctly
		$navi   = $pagenavi->build_navi($script, $total, -1, -1);

		if ($navi == -1)
		{
			echo "system error: script = $script, total = $total <br>\n";
			include XOOPS_ROOT_PATH.'/footer.php';
			exit();
		}
	}

	print_end($sortid, $navi);

}
else
{
	echo "<br />";
	echo "<font color='blue'>"._WEBLINKS_NO_CATEGORY."</font><br />";
}

xoops_cp_footer();
exit();
// --- end of main ---


//---------------------------------------------------------
// function
//---------------------------------------------------------
function print_top($sortid, $all)
{

	switch ($sortid)
	{
		case 1:
			$title = _WEBLINKS_ORDER_TREE;
			break;

		case 2:
			$title = _WEBLINKS_CAT_ORDER;
			break;

		case 0:
		default:
			$title = _WEBLINKS_ORDER_ID;
			break;
	}

	xoops_cp_header();

	echo "<h3>"._WLS_WEBLINKSCONF."</h3>\n";
	echo "<h4>"._WEBLINKS_ADMIN_CATEGORY_MANAGE."</h4>\n";
	printf(_WEBLINKS_THERE_ARE_CATEGORY, $all);
	echo "<br /><br />\n";

	echo "<table width='80%' border='0' cellspacing='1' class='outer'>";
	echo "<tr class='odd'><td>";
	echo " - <a href='index.php'>"._WEBLINKS_ADMIN_INDEX."</a>";
	echo "<br /><br />\n";
	echo " - <a href='category_manage.php'>"._WEBLINKS_ADMIN_ADDMODDEL_CATEGORY."</a>";
	echo "<br /><br />\n";
	echo " - <b>"._WEBLINKS_ADMIN_CATEGORY_LIST."</b>";
	echo "<br /><br />\n";
	echo " --- <a href='category_list.php?sortid=0'>"._WEBLINKS_ORDER_ID."</a>";
	echo "<br /><br />\n";
	echo " --- <a href='category_list.php?sortid=1'>"._WEBLINKS_ORDER_TREE."</a>";
	echo "<br /><br />\n";
	echo " --- <a href='category_list.php?sortid=2'>"._WEBLINKS_CAT_ORDER."</a>";
	echo "<br /><br />\n";
	echo"</td></tr></table>\n";

	echo "<h4>".$title."</h4>\n";

}

function print_start($sortid)
{
	echo _WEBLINKS_ADMIN_CATEGORY_NOTICE_1."<br />\n";
	echo _WEBLINKS_ADMIN_CATEGORY_NOTICE_2."<br />\n";
	echo "<br />\n";

	if ($sortid == 2)
	{
		echo "<form method='post' action='category_manage.php'>";
		echo "<input type='hidden' name='op' value='reorderCat' />";
	}

	echo "<table border='1'><tr>";
	echo "<th align='center'>"._WLS_CATEGORYID."</th>";
	echo "<th align='center'>"._WLS_PARENT."</th>";
	echo "<th align='center'>"._WLS_TITLEC."</th>";
	echo "<th align='center'>"._WEBLINKS_NUM_SUBCAT."</th>";

	if ($sortid == 2)
	{
		echo "<th align='center'>"._WEBLINKS_CAT_ORDER."</th>";
	}

	echo "</tr>\n";

}

function print_end($sortid, $navi)
{
	if ($sortid == 2)
	{
		echo "<tr>";
		echo "<td class='odd' >&nbsp;</td>";
		echo "<td class='odd' >&nbsp;</td>";
		echo "<td class='odd' >&nbsp;</td>";
		echo "<td class='odd' >&nbsp;</td>";
		echo "<td class='odd' align='center'><input type='submit' value='"._EDIT."' /></td>";
		echo "</tr>\n";
	}

	echo "</table><br />\n";

	if  ( ($sortid == 0) || ($sortid == 1) )
	{
		echo "<div align='center'>$navi</div>\n";
	}

}

function print_line($sortid, $cid, $title, $pid, $orders)
{
	global $tbl_category;

	$category_id = sprintf("%03d",$cid);

	$url_cid   = "category_manage.php?op=modCat&amp;cid=".$cid;
	$url_pid   = "category_list.php?sortid=2&amp;pid=".$pid;
	$url_pid_2 = "category_list.php?sortid=2&amp;pid=".$cid;
	$title     = htmlspecialchars($title);

	$depth   = $tbl_category->getValueByCid($cid, 'depth');
	$depth_d = str_repeat("--", $depth);
	$title   = $depth_d."&nbsp;&nbsp;<a href='$url_pid_2'>$title</a>";

	$num_sub = $tbl_category->getNumByPid($cid);

	if ($pid)
	{
		$ptitle = $tbl_category->getValueByCid($pid, 'title');
	}
	else
	{
		$ptitle = 'TOP';
	}

	$ptitle = htmlspecialchars($ptitle);
	$ptitle = "<a href='$url_pid'>$ptitle</a>";

	if ($depth == 0) 
	{
		$class   = 'head';
	}
	elseif ($depth == 1) 
	{
		$class = 'even';
	}
	else
	{
		$class = 'odd';
	}

	echo "<tr>";
	echo "<td class='$class' ><a href='$url_cid'>$category_id</a></td>";
	echo "<td class='$class' >$ptitle</td>";
	echo "<td class='$class' >$title</td>";
	echo "<td class='$class' >$num_sub</td>";

	if ($sortid == 2)
	{
		echo "<td class='$class' align='center'><input type='text' name='orders[$cid]' value='$orders' size='5' /></td>";
	}

	echo "</tr>\n";

}

?>
