<?php
// $Id: mail_users.php,v 1.1.1.1 2005/02/16 17:32:29 ohwada Exp $

//=========================================================
// mailusers
// porting from xoops mailusers.php
// 2005-01-20 K.OHWADA
//=========================================================
include 'admin_header.php';

include_once XOOPS_ROOT_PATH."/class/xoopsformloader.php";
include_once $MODULE_ROOT."/class/weblinks_mailer.php";
include_once $MODULE_ROOT."/class/pagenavi.php";

file_include_system_module_lang("admin.php", $XOOPS_LANGUAGE);
file_include_system_module_lang("admin/mailusers.php", $XOOPS_LANGUAGE);

$op = '';
if ( isset($_POST['op']) ) 
{
	$op = $_POST['op'];
}

$total = 0;
if ( isset($_POST['lid_arr']) ) 
{
	$lid_arr = $_POST['lid_arr'];
	$total   = count($lid_arr);
}

$to_email = '';
if ( isset($_POST['to_email']) ) 
{
	$to_email = $_POST['to_email'];
}

xoops_cp_header();
echo "<h3>"._WEBLINKS_ADMIN_SENDMAIL."</h3>\n";

if (( $op == "send" )&&( $total > 0 ))
{
	send_users($lid_arr);
}
elseif (( $op == "send" )&&( $to_email )) 
{
	send_mail($to_email);
}
else
{
	print_form();
}

xoops_cp_footer();
exit();


//---------------------------------------------------------
// function
//---------------------------------------------------------
function send_users($lid_arr)
{
	$MAX_USER = 50;
	$total = count($lid_arr);

	global $myts;
	$from_name  = $myts->stripSlashesGPC( $_POST['from_name'] );
	$from_email = $myts->stripSlashesGPC( $_POST['from_email'] );
	$subject    = $myts->stripSlashesGPC( $_POST['subject'] );
	$body       = $myts->stripSlashesGPC( $_POST['body'] );

// pagenavi
	$pagenavi = new pagenavi();
	$pagenavi->set_show( $MAX_USER );
	$pagenavi->set_total( $total );
	$pagenavi->get_post_parm();
	$page  = $pagenavi->get_page();
	$start = $pagenavi->get_start();
	$end   = $pagenavi->get_end();

	printf(_WEBLINKS_THERE_ARE_EMAIL, $total);
	echo "<br />\n";
	printf(_WEBLINKS_SEND_NUM, $start + 1, $end);
	echo "<br /><br />\n";

	$users = array();

	global $tbl_link;
	$lid_user_list = $tbl_link->get_lid_user_list();

	foreach ($lid_arr as $lid) 
	{
		$users[] = $lid_user_list[$lid];
	}

// mail start
	$mailer = new weblinks_mailer();
	$mailer->set_flag_send(1);

	$mailer->setFromName( $from_name );
	$mailer->setFromEmail( $from_email );
	$mailer->setSubject( $subject );
	$mailer->setBody( $body );
	$mailer->prepare();

	for ( $i=$start; $i<$end; $i++) 
	{
		$mailer->send_user( $users[$i] );
	}

	echo $mailer->getSuccess();
	echo $mailer->getErrors();
// mail end

	echo "<h4>"._AM_SENDCOMP."</h4>\n";

	if ($total > $end)
	{
		print_form_next($page, $MAX_USER, $lid_arr);
	}
	else
	{
		echo "<hr><br />\n";
		echo "<a href='index.php'>"._WEBLINKS_ADMIN_GOTO_ADMIN_INDEX."</a></br />\n";
	}
}

function send_mail($to_email)
{
	global $myts;
	$from_name  = $myts->stripSlashesGPC( $_POST['from_name'] );
	$from_email = $myts->stripSlashesGPC( $_POST['from_email'] );
	$subject    = $myts->stripSlashesGPC( $_POST['subject'] );
	$body       = $myts->stripSlashesGPC( $_POST['body'] );
	$to_email   = $myts->stripSlashesGPC( $to_email );

// mail start
	$mailer = new weblinks_mailer();

	$mailer->setFromName( $from_name );
	$mailer->setFromEmail( $from_email );
	$mailer->setSubject( $subject );
	$mailer->setBody( $body );
	$mailer->useMail();
	$mailer->setToEmails( $to_email );
	$mailer->send( true );

	echo $mailer->getSuccess();
	echo $mailer->getErrors();
// mail end

	echo "<h4>"._AM_SENDCOMP."</h4>\n";
	echo "<hr><br />\n";
	echo "<a href='index.php'>"._WEBLINKS_ADMIN_GOTO_ADMIN_INDEX."</a></br />\n";

}

function print_form()
{
	global $myts;
	global $xoops_site_name;
	global $xoops_site_email;

	global $tbl_link;
	$lid_user_list = $tbl_link->get_lid_user_list();

	$total = 0;
	if ( isset($_POST['memberslist_id']) ) 
	{
		$lid_list = $_POST['memberslist_id'];
		$total    = count( $lid_list );
	}

	if ( $total > 0 ) 
	{
		printf(_WEBLINKS_THERE_ARE_EMAIL, $total);
		echo "<br /><br />\n";
	}

	$form = new XoopsThemeForm(_AM_SENDMTOUSERS, "mailusers", "mail_users.php");

	$form->addElement( new XoopsFormHidden("op", "send") );
	$form->addElement( new XoopsFormHidden("page", 1) );

// from finduser section
	if ( $total > 0 ) 
	{
		$display_names = '';

		for ( $i=0; $i<$total; $i++ ) 
		{
			$lid = $lid_list[$i];
			$lid_hidden = new XoopsFormHidden("lid_arr[]", $lid);
			$form->addElement($lid_hidden);
			unset($lid_hidden);

			$user = $lid_user_list[$lid];

			if ( $user['name_disp'] )
			{
				$name = $myts->makeTboxData4Show( $user['name_disp'] );

				if ( $user['email_disp'] )
				{
					$name = "<a href='mailto:".$user['email_disp']."'>".$name."</a>";
				}
			}
			else
			{
				$name = "<font color='red'>---</b>";
			}

			$display_names .= $name.", ";
		}

		$display_names = substr($display_names, 0, -2);

		$users_label = new XoopsFormLabel(_AM_SENDTOUSERS2, $display_names );
		$form->addElement( $users_label );
	}
	else
	{
		$mail_to_text = new XoopsFormText(_AM_SENDTOUSERS2, "to_email", 30, 255 );
		$form->addElement(  $mail_to_text );
		$form->setRequired( $mail_to_text );
	}

	$fname_text = new XoopsFormText(_AM_MAILFNAME, "from_name", 30, 255, $xoops_site_name );
	$form->addElement($fname_text);

	$femail_text = new XoopsFormText(_AM_MAILFMAIL, "from_email", 30, 255, $xoops_site_email );
	$form->addElement($femail_text);

	$subject_caption  = _AM_MAILSUBJECT."<br /><br />";
	$subject_caption .= "<span style='font-size:x-small;font-weight:bold;'>"._AM_MAILTAGS."</span><br />";
	$subject_caption .= "<span style='font-size:x-small;font-weight:normal;'>"._WEBLINKS_MAIL_TAGS1."</span>";
	$subject_text = new XoopsFormText($subject_caption, "subject", 50, 255, get_subject() );
	$form->addElement($subject_text);
	$form->setRequired($subject_text);

	$body_caption  = _AM_MAILBODY."<br /><br />";
	$body_caption .= "<span style='font-size:x-small;font-weight:bold;'>"._AM_MAILTAGS."</span><br />";
	$body_caption .= "<span style='font-size:x-small;font-weight:normal;'>"._WEBLINKS_MAIL_TAGS1."<br />";
	$body_caption .= _WEBLINKS_MAIL_TAGS2."<br />";
	$body_caption .= _WEBLINKS_MAIL_TAGS3."<br />";
	$body_text = new XoopsFormTextArea($body_caption, "body", get_body(), 10);
	$form->addElement($body_text);
	$form->setRequired($body_text);

	$submit_button = new XoopsFormButton("", "submit", _WEBLINKS_SENDMAIL, "submit");
	$form->addElement($submit_button);

	$form->display();

}

function get_subject()
{
	global $xoops_site_name;
	return sprintf(_WEBLINKS_SUBJECT_FROM, $xoops_site_name);

}

function get_body()
{
	global $xoops_site_name;
	global $xoops_site_url;
	global $xoops_site_email;
	global $xoops_site_author;

	$hello     = sprintf(_WEBLINKS_HELLO, "{W_NAME}");
	$webmaster = _WEBLINKS_WEBMASTER;

	$text = <<<END_OF_TEXT
$hello

-----------
$xoops_site_name ({$xoops_site_url}) 
$webmaster  $xoops_site_author
$xoops_site_email
-----------
END_OF_TEXT;

	return $text;
}

function print_form_next($page, $show, $lid_arr)
{
	global $myts;
	$from_name  = $myts->makeTboxData4PreviewInForm( $_POST['from_name'] );
	$from_email = $myts->makeTboxData4PreviewInForm( $_POST['from_email'] );
	$subject    = $myts->makeTboxData4PreviewInForm( $_POST['subject'] );
	$body       = $myts->makeTareaData4PreviewInForm( $_POST['body'] );

	$action    = xoops_getenv('PHP_SELF');
	$page_next = $page + 1;
	$submit    = sprintf(_WEBLINKS_SEND_NEXT, $show);

?>
<form action='<?php echo $action; ?>' method='post'>
<input type='hidden' name='op'   value='send'>
<input type='hidden' name='page' value='<?php echo $page_next; ?>'>
<input type='hidden' name='from_name'  value='<?php echo $from_name; ?>'>
<input type='hidden' name='from_email' value='<?php echo $from_email; ?>'>
<input type='hidden' name='subject'    value='<?php echo $subject; ?>'>
<input type='hidden' name='body'       value='<?php echo $body; ?>'>
<?php

	foreach ( $lid_arr as $lid ) 
	{
		echo "<input type='hidden' name='lid_arr[]' value='$lid'>\n";
	}

?>
<input type='submit' value='<?php echo $submit; ?>'>
</form>
<?php

}

?>
