<?php
// $Id: atom.php,v 1.1.1.1 2005/02/16 17:32:27 ohwada Exp $

//=========================================================
// WebLinks Module
// build and view ATOM 
// 2004-11-28 K.OHWADA
//=========================================================

include "header.php";

include_once XOOPS_ROOT_PATH.'/class/template.php';
include_once $MODULE_ROOT."/class/rss_atom_builder.php";



//=========================================================
// use RSS/ATOM builder class
//=========================================================
class atom_builder extends rss_atom_builder
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function atom_builder()
{
	rss_atom_builder::rss_atom_builder();
}

//---------------------------------------------------------
// override
//---------------------------------------------------------
function assign_template()
{
	$feed   = $this->build_atom_feed();
	$entrys = $this->build_entrys();
	$this->assign_atom($this->xoops_tpl, $feed, $entrys);
}


//---------------------------------------------------------
// function
//---------------------------------------------------------
function build_entrys()
{
	$tbl_atomfeed =& table_atomfeed::getInstance();

	$entrys = array();

// atom id array
	$orderby = "time_modified DESC";
	$aid_arr = $tbl_atomfeed->getAidArrayByOrderby($orderby, $this->max_item, 0);

// each atom
	$count = 1;
	foreach ($aid_arr as $aid) 
	{
		$rec = $tbl_atomfeed->getRowByAid($aid);

		$rec['link']         = $rec['url'];
		$rec['dc_subject']   = $rec['site_title'];
		$rec['content_base'] = $rec['site_url'];

		$rec['modified'] = $this->iso8601_date( $rec['time_modified'] );
		$rec['issued']   = $this->iso8601_date( $rec['time_issued'] );
		$rec['created']  = $this->iso8601_date( $rec['time_created'] );
		$rec['summary']  = $this->make_summary( $rec['content'] );

		$entrys[] = $rec;
		$count ++;
	}

	return $entrys;
}

//---------------------------------------------------------
}


//---------------------------------------------------------
// main
//---------------------------------------------------------

$TEMPLATE = 'db:'.$MODULE_DIRNAME.'_atom_build.html';

$build = new atom_builder();
$build->build_template( $TEMPLATE );

exit();
// -----

?>
