<?php
// $Id: pagenavi.php,v 1.1.1.1 2005/02/16 17:32:32 ohwada Exp $

// 2005-01-20 K.OHWADA
// add get_post_parm()
// $MAX_PAGE

// 2004-12-14 K.OHWADA
// add sortid_default

//=========================================================
// class page navi
// 2004-10-20 K.OHWADA
//=========================================================

class pagenavi
{
// user parameter
	var $total;
	var $show;	// lines per page
	var $sortid_default;
	var $max_sortid;	
	var $orderbey_array;
	var $lang_array;

// GET POST parameter
	var $sortid;
	var $page_current;

// local
	var $start;
	var $end;
	var $page_last;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function pagenavi()
{
	$this->set_total( 0 );
	$this->set_show( 10 );
	$this->set_max_sortid( 0 );
	$this->set_sortid_default( 0 );

// by way of precaution
	$this->sortid       = 0;
	$this->page_last    = 1;
	$this->page_current = 1;
}

//---------------------------------------------------------
// convert
//---------------------------------------------------------
function convert_orderby_by_id($id)
{
	$id = $this->check_sortid($id);
    return  $this->orderbey_array[$id];
}

function convert_lang_by_id($id)
{
	$id = $this->check_sortid($id);
    return  $this->lang_array[$id];
}

function convert_id_by_sql($word)
{
	$word  = trim($word);
	$match = 0;

	foreach ($this->orderbey_array as $id => $value)
	{
		if ($word == $value)
		{	$match = $id;	}
	}

	return $match;
}

function check_sortid($id)
{
	$id = intval($id);

	if ($id < 0)
	{	$id = 0;	}

	if ($id > $this->max_sortid)
	{	$id = $this->max_sortid;	}

	return $id;
}

//---------------------------------------------------------
// calculation
//---------------------------------------------------------

function get_start($total=-1, $page=-1)
{
	$this->calc_page($total, $page);
	return $this->start;
}

function get_end($total=-1, $start=-1)
{
	if ($total < 0 )  $total = $this->total;
	if ($start < 0 )  $start = $this->start;

	$end = $start + $this->show;

	if ( $end > $total )
	{
		$end = $total;
	}

	$this->end = $end;
	return $end;
}

function calc_page($total=-1, $page=-1)
{
	if ($total < 0)  $total = $this->total;
	if ($page  < 0)  $page  = $this->page_current;

	$last = ceil($total / $this->show);
	if ($last < 1)
	{
		$last = 1;
	}

	if ($page < 1)
	{
		$page = 1;
	}
	elseif ($page > $last)
	{
		$page = $last;
	}

	$start = ($page - 1) * $this->show;
	$this->start = $start;

	return array($page, $last, $start);
}


//---------------------------------------------------------
// build navi
//
// script:
//   acceptable type: foo.php, foo.php?, foo.php?bar=abc
//
// sortid:
//   normal: add sortid and page
//       ex) foo.php? sortid=$sortid&amp;page=1
//   -1: dont add sortid
//       ex) foo.php? page=1
//---------------------------------------------------------

function build_navi($script, $total=-1, $page=-1, $sortid='')
{
	$MAX_PAGE  = 10;
	$page_first = 1;

	if (empty($script)) return -1;

// set script_type, if ? in script
	$type = 0;
	if ( preg_match('/\?/', $script) )
	{
		$script_arr = explode('?', $script);
		if ($script_arr[1]) $type = 1;
	}
// add ?, if not ?  in script
	else
	{
		$script .= "?";
	}

// add sortid
	if ($sortid != -1)
	{
		if ($sortid == '')  $sortid = $this->sortid;

		if ($type == 1)
		{
			$script .= "&amp;sortid=$sortid";
		}
		else
		{
			$script .= "&amp;sortid=$sortid";	
			$type    = 1;
		}
	}

// add page=
	if ($type == 1)
	{
		$script_page = $script."&amp;page=";
	}
	else
	{
		$script_page = $script."page=";	
	}

// Page Numbering
	list($page_current, $page_last, $start) = $this->calc_page($total, $page);

	$prev = $page_current - 1;
	$next = $page_current + 1;

	$half = intval( $MAX_PAGE/2);

	$start = $page_first;
	$end   = $page_last;

	if ( $page_last > ($page_current + $half) )
	{
		$start = $page_current - $half;

		if ( $start < $page_first )
		{
			$start = $page_first;
		}

		$end = $start + $MAX_PAGE;

		if ( $end > $page_last )
		{
			$end = $page_last;
		}
	}
	elseif ( $page_last > $MAX_PAGE )
	{
		$end = $page_current + $half;

		if ( $end > $page_last )
		{
			$end = $page_last;
		}

		$start = $end - $MAX_PAGE;

		if ( $start < $page_first )
		{
			$start = $page_first;
		}

	}

	$navi = '';
    if ($page_last > 1)
	{
		if ($prev > 0) 
		{
			$navi .= "<a href='$script_page$prev'><b><u>&laquo;</u></b></a>&nbsp;";
		}

		if ($start != $page_first)
		{
			$navi .= "<a href='$script_page$page_first'>[$page_first]</a>&nbsp;";
		}

		for( $i=$start; $i<=$end; $i++ ) 
		{
			if ($i == $page_current) 
			{
				$navi .= "<b>($i)</b>&nbsp;";
			} 
			else
			{
				$navi .= "<a href='$script_page$i'>$i</a>&nbsp;";
			}
		}

		if ($end != $page_last)
		{
			$navi .= "<a href='$script_page$page_last'>[$page_last]</a>&nbsp;";
		}
	
		if ( $page_last >= $next )
		{
			$navi .= "<a href='$script_page$next'><b><u>&raquo;</u></b></a>&nbsp;";
		}

	}

	return $navi;
}

//---------------------------------------------------------
// GET paramter
//---------------------------------------------------------
function get_get_parm()
{
	if( isset($_GET['sortid']) ) 
	{
		$sortid = $_GET['sortid'];
	}
	else
	{
		$sortid = $this->sortid_default;
	}

	$sortid = $this->check_sortid($sortid);

	$page = 1;
	if ( isset($_GET['page']) )
	{
		$page = intval($_GET['page']);
	}

	$this->sortid       = $sortid;
	$this->page_current = $page;

	return;
}

//---------------------------------------------------------
// POST paramter
//---------------------------------------------------------
function get_post_parm()
{
	if( isset($_POST['sortid']) ) 
	{
		$sortid = $_POST['sortid'];
	}
	else
	{
		$sortid = $this->sortid_default;
	}

	$sortid = $this->check_sortid($sortid);

	$page = 1;
	if ( isset($_POST['page']) )
	{
		$page = intval($_POST['page']);
	}

	$this->sortid       = $sortid;
	$this->page_current = $page;

	return;
}

//=========================================================
// set and get property
//=========================================================
function set_show($value)
{
	$value = intval($value);

	if ($value > 0)
	{
		$this->show = $value;
	}
	else
	{
		$this->show = 0;
	}
}

function set_total($value)
{
	$value = intval($value);

	if ($value > 0)
	{
		$this->total = $value;
	}
	else
	{
		$this->total = 0;
	}
}

function set_max_sortid($value)
{
	$value = intval($value);

	if ($value > 0)
	{
		$this->max_sortid = $value;
	}
	else
	{
		$this->max_sortid = 0;
	}

}

function set_sortid_default($value)
{
	$value = intval($value);

	if ($value < 0)
	{
		$this->sortid_default = 0;
	}
	elseif ($value > $this->max_sortid)
	{
		$this->sortid_default = $this->max_sortid;
	}
	else
	{
		$this->sortid_default = $value;
	}

}

function set_orderbey_array($max_sortid, $orderbey_array, $lang_array)
{
	$this->set_max_sortid($max_sortid);

	$this->orderbey_array = $orderbey_array;
	$this->lang_array     = $lang_array;
}

function get_show()
{
	return $this->show;
}

function get_total()
{
	return $this->total;
}

function get_sortid()
{
	return $this->sortid;
}

function get_page()
{
	return $this->page_current;
}

function get_orderby()
{
	return $this->convert_orderby_by_id( $this->sortid );
}

function get_lang()
{
	return $this->convert_lang_by_id( $this->sortid );
}

//=========================================================
// template
//=========================================================
function assign_pagenavi(&$tpl, $navi)
{
	$tpl->assign('page_navi', $navi);
}

//---------------------------------------------------------
}

?>
