<?php
// $Id: rss.php,v 1.1.1.1 2005/02/16 17:32:28 ohwada Exp $

// 2005-01-20 K.OHWADA
// bug fix: pubdate is RFC882 type

//=========================================================
// WebLinks Module
// build and view RSS 
// 2004-11-28 K.OHWADA
//=========================================================

include "header.php";

include_once XOOPS_ROOT_PATH.'/class/template.php';
include_once $MODULE_ROOT."/class/rss_atom_builder.php";


//=========================================================
// use RSS/ATOM builder class
//=========================================================
class rss_builder extends rss_atom_builder
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function atom_builder()
{
	rss_atom_builder::rss_atom_builder();
}

//---------------------------------------------------------
// override
//---------------------------------------------------------
function assign_template()
{
	$channel = $this->build_rss_channel();
	$items   = $this->build_items();
	$this->assign_rss($this->xoops_tpl, $channel, $items);
}


//---------------------------------------------------------
// function
//---------------------------------------------------------
function build_items()
{
	$tbl_atomfeed =& table_atomfeed::getInstance();

	$entrys = array();

// atom id array
	$orderby = "time_modified DESC";
	$aid_arr = $tbl_atomfeed->getAidArrayByOrderby($orderby, $this->max_item, 0);

// each atom
	$count = 1;
	foreach ($aid_arr as $aid) 
	{
		$rec = $tbl_atomfeed->getRowByAid($aid);

		$rec['link']        = $rec['url'];

// bug fix: pudate is RFC882 type
		$rec['pubdate']     = date( "r", $rec['time_issued'] );

		$rec['description'] = $this->make_summary( $rec['content'] );

		$entrys[] = $rec;
		$count ++;
	}

	return $entrys;
}

//---------------------------------------------------------
}

//---------------------------------------------------------
// main
//---------------------------------------------------------

$TEMPLATE = 'db:'.$MODULE_DIRNAME.'_rss_build.html';

$build = new rss_builder();
$build->build_template( $TEMPLATE );

exit();


?>
