<?php // vim: set ts=4 sts=4 sw=4 noet ai fdm=marker:
// $Id: bwiki_new.php,v 1.8 2004/12/01 19:24:24 ishii Exp $

// {{{ b_bwiki_edit()

function b_bwiki_edit( $options )
{
	$inputtag = sprintf("<input type='text' name='options[0]' value='%d'>", $options[0]);
	return sprintf(_MB_BWIKI_BLOCK_DISPLAY, $inputtag);
}

// }}}
// {{{ b_bwiki_recent_show()

function b_bwiki_recent_show($options)
{
	global $xoopsConfig;

	//ɽ
	$show_num = $options[0];
	$css = b_bwiki_get_css($xoopsConfig['theme_set']);
	$block = array();
	$title = 'RecentChanges';

	$script = XOOPS_URL.'/modules/bwiki/index.php';
	$recent = XOOPS_ROOT_PATH.'/modules/bwiki/cache/recent.dat';
	$recent_uri = "$script?RecentChanges";

	$lines = @file($recent);
	$recent = array_slice($lines, 0, $show_num);
	$block['title'] = _MB_BWIKI_BTITLE;
	$block['content'] = "$css<table cellspacing=0><tr><td id='mainmenu'><small>";

	$date = '';
	foreach($recent as $line)
	{
		list($time, $page) = explode("\t", trim($line));
		$_date = date('Y-m-d', $time + (9 * 3600));
		if($date != $_date)
		{
			$date = $_date;
			$block['content'] .= "<a href='{$recent_uri}' title='{$title}' class='menuSub bwiki_block_date'>{$date}</a>";
		}

		$time = b_bwiki_get_passage($time);
		$enc_page = rawurlencode($page);
		$page = htmlspecialchars($page);

		$block['content'] .=" <a href='{$script}?{$enc_page}' title='{$page} {$time}' class='menuMain bwiki_block'>{$page}</a>";
	}

	$block['content'] .= "</small></td></tr></table>";

	return $block;
}

// }}}
// {{{ b_bwiki_get_passage()

function b_bwiki_get_passage($time)
{
	static $units = array('m'=>60,'h'=>24,'d'=>1);
	
	$time = max(0,((time() - date('Z')) - $time) / 60); //minutes
	
	foreach ($units as $unit=>$card)
	{
		if ($time < $card)
		{
			break;
		}
		$time /= $card;
	}
	$time = floor($time).$unit;
	
	return "($time)";

}

// }}}
// {{{ b_bwiki_get_css()

function b_bwiki_get_css($theme_name)
{
	if($theme_name == 'default')
	{
		// {{{ default css
		$css =<<<_CSS_
			<style TYPE="text/css">
			<!--
			/* for default theme */
			td#mainmenu a:hover.bwiki_block_diff
			{
				background-color: #e6e6e6;
			}
			td#mainmenu a.bwiki_block_diff
			{
				display:inline;
				float:right;
				text-align:right;
				padding: 0;
				background-color: white;
				border: none;
			}
			td#mainmenu a:hover.bwiki_block_date
			{
				color: black;

			}
			td#mainmenu a.bwiki_block_date
			{
				color: black;
				padding: 0;
				background-color: white;
				border: none;
			}
			td#mainmenu a:hover.bwiki_block
			{
				background-color: #e6e6e6;
			}
			td#mainmenu a.bwiki_block
			{
				word-break: break-all;
				padding: 0;
				padding-left: 9px;
				background-color: white;
				border: none;
			}
			-->
			</style>
_CSS_;
		// }}}
	}
	else
	{
		// {{{ others css
		$css =<<<_CSS_
			<style TYPE="text/css">
			<!--
			/* for others theme */
			td#mainmenu a:hover.bwiki_block_diff
			{
				background-color: #e6e6e6;
			}
			td#mainmenu a.bwiki_block_diff
			{
				display:inline;
				float:right;
				text-align:right;
				padding: 0;
				border: none;
			}
			td#mainmenu a:hover.bwiki_block_date
			{
				text-decoration: none;
				padding: 0;
				font-style: normal;
			}
			td#mainmenu a.bwiki_block_date
			{
				padding: 0;
			}
			td#mainmenu a.bwiki_block
			{
				padding: 0;
				padding-left: 9px;
			}
			-->
			</style>
_CSS_;
		// }}}
	}

	return $css;
}

// }}}

?>
