<?php // vim: ts=4 sw=4 sts=4 fdm=marker ai noet:
// PukiWiki - Yet another WikiWikiWeb clone
// $Id: auth.php,v 1.6 2005/02/11 14:45:09 ishii Exp $
//
// Basic authentication related functions

// {{{ check_editable() ԽԲǽʥڡԽ褦ȤȤ

function check_editable($page, $auth_flag = TRUE, $exit_flag = TRUE)
{
	global $script, $_title_cannotedit, $_msg_unfreeze;

	if (hasEditPermission() && edit_auth($page, $auth_flag, $exit_flag) && is_editable($page))
		return TRUE;

	if (! $exit_flag) return FALSE;

	$body = $title = str_replace('$1', htmlspecialchars(strip_bracket($page)), $_title_cannotedit);

	if( ! hasEditPermission() )
	{
		$body .= "("._MI_BWIKI_NOT_ANON_WRITABLE.")";
	}else
	if (is_freeze($page)) {
		$body .= '(<a href="' . $script . '?cmd=unfreeze&amp;page=' .
			rawurlencode($page) . '">' . $_msg_unfreeze . '</a>)';
	}

	$page = str_replace('$1', make_search($page), $_title_cannotedit);

	catbody($title, $page, $body);
	exit;
}

// }}}
// {{{ check_readable() Բǽʥڡ褦ȤȤ ()

function check_readable($page, $auth_flag = TRUE, $exit_flag = TRUE)
{
	return read_auth($page, $auth_flag, $exit_flag);
}

// }}}
// {{{ edit_auth() Խǧ

function edit_auth($page, $auth_flag = TRUE, $exit_flag = TRUE)
{
	global $edit_auth, $edit_auth_pages, $_title_cannotedit;

	return $edit_auth ?  basic_auth($page, $auth_flag, $exit_flag,
		$edit_auth_pages, $_title_cannotedit) : TRUE;
}

// }}}
// {{{ read_auth() ǧ

function read_auth($page, $auth_flag = TRUE, $exit_flag = TRUE)
{
	global $read_auth, $read_auth_pages, $_title_cannotread;

	return $read_auth ?  basic_auth($page, $auth_flag, $exit_flag,
		$read_auth_pages, $_title_cannotread) : TRUE;
}

// }}}
// {{{ basic_auth() Basicǧ
// Basic authentication
function basic_auth($page, $auth_flag, $exit_flag, $auth_pages, $title_cannot)
{
	global $auth_users, $auth_method_type;
	global $_msg_auth;
	global $xoopsUser;

	// ǧȽо
	$target_str = '';
	if ($auth_method_type == 'pagename') {
		// ڡ̾ǥå
		$target_str = $page;
	} else if ($auth_method_type == 'contents') {
		// ڡʸǥå
		$target_str = join('', get_source($page));
	}

	// פѥ줿桼Υꥹ
	$user_list = array();
	foreach($auth_pages as $key=>$val)
		if (preg_match($key, $target_str))
			$user_list = array_merge($user_list, explode(',', $val));

	if (empty($user_list)) return TRUE; // No limit

	// 롼ץꥹȤ˴ޤޤ뤤줫Υ롼פǧڤOK
	if(isset($xoopsUser) && is_object($xoopsUser))
	{
		foreach($xoopsUser->_groups as $xgid)
		{
			foreach($user_list as $g)
			{
				if($xgid == $g)
				{
					return TRUE;
				}
			}
		}
	}
	else
	{
		if(in_array('3', $user_list))
		{
			return TRUE;
		}
	}

	if($exit_flag)
	{
		// ¤̵Τǥ顼ɽ
		$body = $title = str_replace('$1', htmlspecialchars(strip_bracket($page)), $title_cannot);
		$page = str_replace('$1', make_search($page), $title_cannot);
		catbody($title, $page, $body);
		exit;
	}

	return FALSE;
}

// }}}

?>
