<?php
// $Id: index.php,v 1.3 2005/06/23 11:51:52 ohwada Exp $

// 2005-06-20 K.OHWADA
// set image width & height
// add rebuild_pda.php

// 2005-06-06 K.OHWADA
// use plugin
// use ping server list
// use happy_linux_url
// add rebuild_rdf.php

//=========================================================
// What's New Module
// admin config
// 2004/08/20 K.OHWADA
//=========================================================

include '../../../include/cp_header.php';

global $xoopsDB;
$table = $xoopsDB->prefix("whatsnew_config");

$DIR_CONFIG  = XOOPS_ROOT_PATH."/modules/whatsnew/cache";
$FILE_CONFIG = "$DIR_CONFIG/conf.php";

$LIMIT_MODULE_DEFAULT  = 5;
$LIMIT_SHOW_DEFAULT    = 10;
$LIMIT_SUMMARY_DEFAULT = 1;
$MAX_SUMMARY_DEFAULT   = 250;

// set image width & height
$MAX_WIDTH_DEFALUT  = 160;
$MAX_HEIGHT_DEFAULT = 160;

xoops_cp_header();
echo "<h3>"._WHATSNEW_NAME."</h3>\n";
echo _WHATSNEW_ADMIN_DESC."<br>\n";
echo "<h4>"._WHATSNEW_MENU_CONFIG."</h4>\n";

$flag_writable = 0;
if ( is_writable($DIR_CONFIG) ) 
{
	$flag_writable = 1;
}
else
{
	echo "<h3><font color='red'>"._WHATSNEW_WARNING_NOT_WRITABLE."</font></h3>\n";
	echo "$DIR_CONFIG<br><br>\n";
}

$system_config = get_system_config();

$op = '';
if ( isset($_POST['op']) )  $op = $_POST['op'];

// post
if (($op == 'save')&&($flag_writable))
{
	$new_limit_arr = $_POST['new_limit'];
	$rss_limit_arr = $_POST['rss_limit'];

	$new_show_arr = array();
	$rss_show_arr = array();

	if ( isset($_POST['new_show']) )
	{	$new_show_arr  = $_POST['new_show'];	}

	if ( isset($_POST['rss_show']) )
	{	$rss_show_arr  = $_POST['rss_show'];	}

	$whatsnew_module = array();

	foreach ( $system_config as $system ) 
	{
		list($mid, $dirname, $name, $show) = $system;

		if ($dirname == 'system')
		{
			$name = _WHATSNEW_SYSTEM_COMMENT;
		}

		if ($show != 1 ) continue;

		$new_show  = 0;
		$rss_show  = 0;
		if ( isset($new_show_arr[$mid]) )  $new_show = 1;
		if ( isset($rss_show_arr[$mid]) )  $rss_show = 1;

		$new_limit = 0;
		$rss_limit = 0;
		if ( isset($new_limit_arr[$mid]) )
		{	$new_limit = intval($new_limit_arr[$mid]);	}
		if ( isset($rss_limit_arr[$mid]) )
		{	$rss_limit = intval($rss_limit_arr[$mid]);	}

		$whatsnew_module[$dirname]['mid']       = $mid;
		$whatsnew_module[$dirname]['name']      = $name;
		$whatsnew_module[$dirname]['new_show']  = $new_show;
		$whatsnew_module[$dirname]['new_limit'] = $new_limit;
		$whatsnew_module[$dirname]['rss_show']  = $rss_show;
		$whatsnew_module[$dirname]['rss_limit'] = $rss_limit;
	}

	list($ret,$error) = check_post();
	if ($ret == 0)
	{
		save_config($whatsnew_module);
		echo "<h4>"._WHATSNEW_CONFIG_SAVED."</h4>\n";
	}
	else
	{
		echo "<h4><font color='red'>"._WHATSNEW_ERROR_CONFIG."</font></h4>\n";
		echo "<b>$error</b><br>\n";
	}

	echo "<hr>\n";
}

// del config
elseif ($op == 'del')
{
	unlink($FILE_CONFIG);

	echo "<h4>"._WHATSNEW_CONFIG_DELETED."</h4>\n";
	echo "<hr>\n";
}

$flag_config = 0;
if ( file_exists($FILE_CONFIG) ) 
{
	$flag_config = 1;
	include $FILE_CONFIG;
}
else
{
	echo "<h3><font color='red'>"._WHATSNEW_WARNING_NOT_EXIST."</font></h3>\n";
	echo "$FILE_CONFIG<br><br>\n";

// block
	$whatsnew_new_limit_show     = $LIMIT_SHOW_DEFAULT;
	$whatsnew_new_limit_summary  = $LIMIT_SUMMARY_DEFAULT;
	$whatsnew_new_max_summary    = $MAX_SUMMARY_DEFAULT;
	$whatsnew_new_image          = 1;
	$whatsnew_new_ping           = 0;

// rss
	$whatsnew_rss_limit_show     = $LIMIT_SHOW_DEFAULT;

	$whatsnew_config['rss_max_summary'] = $MAX_SUMMARY_DEFAULT;

// image width, height
	$whatsnew_new_max_width   = $MAX_WIDTH_DEFALUT;
	$whatsnew_new_max_height  = $MAX_HEIGHT_DEFAULT;

	$whatsnew_config['site_url'] = XOOPS_URL.'/';

	$whatsnew_config['site_name']  = $xoopsConfig['sitename'];
	$whatsnew_config['site_desc']  = $xoopsConfig['slogan'];
	$whatsnew_config['site_email'] = $xoopsConfig['adminmail'];
	$slogan                        = $xoopsConfig['slogan'];

	$config_handler =& xoops_gethandler('config');
	$xoopsConfigMetaFooter =& $config_handler->getConfigsByCat(XOOPS_CONF_METAFOOTER);
	$whatsnew_config['site_author'] = $xoopsConfigMetaFooter['meta_author'];
	$meta_desc                      = $xoopsConfigMetaFooter['meta_description'];

	if ($meta_desc)
	{
		$whatsnew_config['site_desc'] = $meta_desc;
	}
	else
	{
		$whatsnew_config['site_desc'] = $slogan;
	}

	$whatsnew_config['image_logo'] = 'images/logo.gif';

// ping
	$whatsnew_ping_log  = 1;

	srand( (double)microtime()*1000000 );
	$whatsnew_ping_pass = chr( rand(97,122) ).sprintf("%06d", rand(1,999999));

// ping server list
	include_once XOOPS_ROOT_PATH."/modules/whatsnew/class/base_language.php";
	$lang = new ConvertLanguage();

	$whatsnew_ping_servers  = $lang->get_ping_server_list();
	$whatsnew_ping_servers .= XOOPS_URL."/modules/whatsnew/bin/server.php\n";
}

echo "<form action='index.php' method='post'>";
echo "<table class='outer' width='100%' ><tr>";
echo "<th align='center'>"._WHATSNEW_MID."</th>";
echo "<th align='center'>"._WHATSNEW_MNAME."</th>";
echo "<th align='center'>"._WHATSNEW_MDIR."</th>";
echo "<th align='center'>"._WHATSNEW_NEW."</th>";
echo "<th align='center'>"._WHATSNEW_RSS."</th></tr>\n";

$i = 0;
foreach ( $system_config as $system ) 
{
	list($mid, $dirname, $name, $show) = $system;

	if ($dirname == 'system')
	{
		$name .= "<br /> (". _WHATSNEW_SYSTEM_COMMENT. ")";
	}

	if ($i % 2 == 0) 
	{
		$class = 'even';
	}
	else 
	{
		$class = 'odd';
	}
	$i ++;

	echo "<tr class='$class' ><td>$mid</td><td>$name</td><td>$dirname</td>";

	if ($show) 
	{
		$module      = array();
		$new_limit   = $LIMIT_MODULE_DEFAULT;
		$rss_limit   = $LIMIT_MODULE_DEFAULT;
		$new_checked = '';
		$rss_checked = '';

		if ($flag_config)
		{
			if ( isset($whatsnew_module[$dirname]) )
			{	$module = $whatsnew_module[$dirname];	}
		
			if ( isset( $module['new_show'] ) && ($module['new_show'] == 1) )
			{	$new_checked = 'checked';	}

			if ( isset( $module['rss_show'] ) && ($module['rss_show'] == 1) )
			{	$rss_checked = 'checked';	}

			if ( isset( $module['new_show'] ) )
			{	$new_limit = $module['new_limit'];	}

			if ( isset( $module['rss_show'] ) )
			{	$rss_limit = $module['rss_limit'];	}
		}

		echo "<td align='right'>";
		echo "<input type='checkbox' name='new_show[$mid]' value='1' $new_checked>";
		echo " <input type='text' name='new_limit[$mid]' size='5' value='$new_limit'>";
		echo "</td><td align='right'>";
		echo "<input type='checkbox' name='rss_show[$mid]' value='1' $rss_checked>";
		echo " <input type='text' name='rss_limit[$mid]' size='5' value='$rss_limit'>";
		echo "</td>";
	} 
	else
	{
		echo "<td></td><td></td>";
	}

	echo "</tr>\n";
}

echo "<tr><th></th>";
echo "<th align='center'>"._WHATSNEW_ITEM."</th>";
echo "<th></th>";
echo "<th align='center'>"._WHATSNEW_NEW."</th>";
echo "<th align='center'>"._WHATSNEW_RSS."</th></tr>\n";

list($image_url, $image_width, $image_height)
	= set_image_url( $whatsnew_config['image_logo'] );

$new_image_checked = '';
if ( $whatsnew_new_image == 1 )
{	$new_image_checked = 'checked';	}

$new_ping_checked = '';
if ( $whatsnew_new_ping == 1 )
{	$new_ping_checked = 'checked';	}

$ping_log_checked = '';
if ( $whatsnew_ping_log == 1 )
{	$ping_log_checked = 'checked';	}

// set image width & height, when version up
$new_image_size_warning = '';
if ( !isset($whatsnew_new_max_width) || empty($whatsnew_new_max_width) )
{
	$whatsnew_new_max_width  = $MAX_WIDTH_DEFALUT;
	$whatsnew_new_max_height = $MAX_HEIGHT_DEFAULT;
	$new_image_size_warning = "<font color='red'>"._WHATSNEW_NEW_IMAGE_SIZE_NOT_SAVE."</font>";
}

// happy_linux_url
include_once XOOPS_ROOT_PATH."/modules/whatsnew/class/base_language.php";
$lang = new ConvertLanguage();
$happy_linux_url = $lang-> get_happy_linux_url();

?>
<tr class='even' >
<td></td><td><?php echo _WHATSNEW_LIMIT_SHOW; ?></td><td></td>
<td align='right'>
<input type='text' name='new_limit_show' size='5' value='<?php echo $whatsnew_new_limit_show; ?>'>
</td><td align='right'>
<input type='text' name='rss_limit_show' size='5' value='<?php echo $whatsnew_rss_limit_show; ?>'>
</td></tr>

<tr class='odd' >
<td></td><td><?php echo _WHATSNEW_LIMIT_SUMMARY; ?></td><td></td>
<td align=right>
<input type='text' name='new_limit_summary' size='5' value='<?php echo $whatsnew_new_limit_summary; ?>'>
</td><td align='center'>-----</td></tr>

<tr class='even' >
<td></td><td><?php echo _WHATSNEW_MAX_SUMMARY; ?></td><td></td>
<td align='right'>
<input type='text' name='new_max_summary' size='5' value='<?php echo $whatsnew_new_max_summary; ?>'>
</td><td align='right'>
<input type='text' name='rss_max_summary' size='5' value='<?php echo $whatsnew_config['rss_max_summary']; ?>'>
</td></tr>

<tr class='odd' >
<td></td><td><?php echo _WHATSNEW_NEW_IMAGE; ?></td><td></td>
<td align='right'>
<input type='checkbox' name='new_image' value='1' <?php echo $new_image_checked; ?> >
</td><td align='center'>-----</td></tr>

<tr class='even' >
<td></td><td><?php echo _WHATSNEW_NEW_IMAGE_WIDTH; ?></td>
<td><?php echo $new_image_size_warning; ?></td>
<td align='right'>
<input type='text' name='new_max_width' size='5' value='<?php echo $whatsnew_new_max_width; ?>' >
</td><td align='center'>-----</td></tr>

<tr class='odd' >
<td></td><td><?php echo _WHATSNEW_NEW_IMAGE_HEIGHT; ?></td>
<td><?php echo $new_image_size_warning; ?></td>
<td align='right'>
<input type='text' name='new_max_height' size='5' value='<?php echo $whatsnew_new_max_height; ?>' >
</td><td align='center'>-----</td></tr>

<tr class='even' >
<td></td><td><?php echo _WHATSNEW_NEW_PING; ?></td><td></td>
<td align='right'>
<input type='checkbox' name='new_ping' value='1' <?php echo $new_ping_checked; ?> >
</td><td align='center'>-----</td></tr>

<tr class='odd' >
<td></td><td><?php echo _WHATSNEW_SITE_NAME; ?><br>
<font size='-1'><?php echo _WHATSNEW_SITE_NAME_DESC; ?></font></td>
<td colspan='3'>
<input type='text' name='site_name' size='60' value='<?php echo $whatsnew_config['site_name']; ?>'>
</td></tr>

<tr class='even' >
<td></td><td><?php echo _WHATSNEW_SITE_URL; ?><br>
<font size='-1'><?php echo _WHATSNEW_SITE_URL_DESC; ?></font></td>
<td colspan='3'>
<input type='text' name='site_url' size='60' value='<?php echo $whatsnew_config['site_url']; ?>'>
<br>
atom tag: <?php echo set_site_tag( $whatsnew_config['site_url'] ); ?>
</td></tr>

<tr class='odd' >
<td></td><td><?php echo _WHATSNEW_SITE_DESC; ?><br>
<font size='-1'><?php echo _WHATSNEW_SITE_DESC_DESC; ?></font></td>
<td colspan='3'>
<input type='text' name='site_desc' size='60' value='<?php echo $whatsnew_config['site_desc']; ?>'>
</td></tr>

<tr class='even' >
<td></td><td><?php echo _WHATSNEW_SITE_AUTHOR; ?><br>
<font size='-1'><?php echo _WHATSNEW_SITE_AUTHOR_DESC; ?></font></td>
<td colspan='3'>
<input type='text' name='site_author' size='60' value='<?php echo $whatsnew_config['site_author']; ?>'>
</td></tr>

<tr class='odd' >
<td></td><td><?php echo _WHATSNEW_SITE_EMAIL; ?><br>
<font size='-1'><?php echo _WHATSNEW_SITE_EMAIL_DESC; ?></font></td>
<td colspan='3'>
<input type='text' name='site_email' size='60' value='<?php echo $whatsnew_config['site_email']; ?>'>
</td></tr>

<tr class='even' >
<td></td><td><?php echo _WHATSNEW_SITE_LOGO; ?><br>
<font size='-1'><?php echo _WHATSNEW_SITE_LOGO_DESC; ?></font></td>
<td colspan='3'>
<input type='text' name='image_logo' size='60' value='<?php echo $whatsnew_config['image_logo']; ?>'><br>
url : <?php echo $image_url ?><br>
size: <?php echo $image_width ?> x <?php echo $image_height ?> <br>
</td></tr>

<tr class='odd' >
<td></td><td><?php echo _WHATSNEW_PING_SERVERS; ?></td>
<td colspan='3'>
<textarea name='ping_servers' rows='6' cols='60' wrap='hard'>
<?php echo $whatsnew_ping_servers; ?>
</textarea>
</td></tr>

<tr class='even' >
<td></td><td><?php echo _WHATSNEW_PING_PASS; ?></td>
<td colspan='3'>
<input type='text' name='ping_pass' size='60' value='<?php echo $whatsnew_ping_pass; ?>'>
</td></tr>

<tr class='odd' >
<td></td><td><?php echo _WHATSNEW_PING_LOG; ?></td>
<td colspan='3'>
<input type='checkbox' name='ping_log' value='1' <?php echo $ping_log_checked; ?> >
</td></tr>

<tr  class='foot' >
<td></td><td></td><td colspan='3'>

<table><tr><td>
<input type='hidden' name='op' value='save'>
<input type='submit' value='<?php echo _WHATSNEW_SAVE; ?>'>
</form>
</td><td>
<form action='index.php' method='post'>
<input type='hidden' name='op' value='del'>
<input type='submit' value='<?php echo _WHATSNEW_DELETE; ?>'>
</form>
</td></tr></table>

</td></tr>
</table>
<br />

<ul>
<li><a href='rebuild_rss.php'><img src='../images/rss.png'></a> <a href='rebuild_rss.php'>(<?php echo _WHATSNEW_MENU_RSS; ?>)</a></li>
<li><a href='view_rss.php'><?php echo _WHATSNEW_VIEW_RSS; ?></a></li>
<li><a href='rebuild_atom.php'><img src='../images/atom.png'></a> <a href='rebuild_atom.php'>(<?php echo _WHATSNEW_MENU_ATOM; ?>)</a></li>
<li><a href='view_atom.php'><?php echo _WHATSNEW_VIEW_ATOM; ?></a></li>
<li><a href='rebuild_rdf.php'><img src='../images/rdf.png'></a> <a href='rebuild_rdf.php'>(<?php echo _WHATSNEW_MENU_RDF; ?>)</a></li>
<li><a href='view_rdf.php'><?php echo _WHATSNEW_VIEW_RDF; ?></a></li>
<li><a href='rebuild_pda.php'><?php echo _WHATSNEW_MENU_PDA; ?></a><br /><br /></li>
<li><a href='send_ping.php'><?php echo _WHATSNEW_MENU_PING; ?></a></li>
</ul>

<h4><a href='../index.php'><?php echo _WHATSNEW_GOTO_WHATNEW; ?></a></h4>
<hr>
<div align='right'><a href='<?php echo $happy_linux_url; ?>' target='_blank'><font size='-1'>Powered by Happy Linux</font></a></div>
<div align='right'><font size='-1'>&copy; 2004-2005, Kenichi OHWADA</font></div>
<?php

xoops_cp_footer();
exit();
// --- main end ---

function get_system_config()
{
	$module_handler =& xoops_gethandler('module');
	$module_arr     =& $module_handler->getObjects();

	$system_config = array();

	foreach ( $module_arr as $module ) 
	{
		$mid     = $module->getVar('mid');
		$name    = $module->getVar('name', 'E');
		$dirname = $module->getVar('dirname');

// add plugin
		$file_modules = XOOPS_ROOT_PATH."/modules/$dirname/include/data.inc.php";
		$file_plugin  = XOOPS_ROOT_PATH."/modules/whatsnew/plugins/$dirname/data.inc.php";

		$show = 0;
		if ( file_exists($file_modules) || file_exists($file_plugin) ) 
		{	$show = 1;	}

		$system_config[$mid] = array( $mid, $dirname, $name, $show );
	}

	return $system_config;
}

function check_post()
{
 	global $_POST;

	$flag_error = 0;
	$error      = '';

	if ( empty($_POST['site_name']) )
	{
		$flag_error = 1;
		$error .= _WHATSNEW_ERROR_SITE_NAME."<br>\n";
	}

	if ( empty($_POST['site_url']) )
	{
		$flag_error = 1;
		$error .= _WHATSNEW_ERROR_SITE_URL."<br>\n";
	}

	if ( empty($_POST['site_desc']) )
	{
		$flag_error = 1;
		$error .= _WHATSNEW_ERROR_SITE_DESC."<br>\n";
	}

	if ( empty($_POST['site_author']) )
	{
		$flag_error = 1;
		$error .= _WHATSNEW_ERROR_SITE_AUTHOR."<br>\n";
	}

	$ret = check_numeric('new_max_summary');
	if ($ret != 0)
	{
		$flag_error = 1;
		$error .= _WHATSNEW_ERROR_NEW_MAX_SUMMARY."<br>\n";
	}

	$ret = check_numeric('rss_max_summary');
	if ($ret != 0)
	{
		$flag_error = 1;
		$error .= _WHATSNEW_ERROR_RSS_MAX_SUMMARY."<br>\n";
	}

	return array($flag_error,$error);
}

function check_numeric($key)
{
 	global $_POST;

	if ( empty($_POST[$key]) )
	{
		return 1;
	}
	else
	{
		$value = $_POST[$key];
		if ( !is_numeric($value) )
		{
			return 2;
		}
		elseif ( $value < 0 )
		{
			return 3;
		}
	}

	return 0;	// OK
}

function save_config($whatsnew_module)
{
 	global $_POST;
	global $FILE_CONFIG;

	$fp = fopen($FILE_CONFIG,"w");

	fwrite($fp,"<?php \n");

	$date = date("Y/m/d H:i:s");
	fwrite($fp,"// $date \n\n");

	foreach ( $whatsnew_module as $dirname => $module) 
	{
		foreach ( $module as $key => $value ) 
		{
			$value = set_value($value);
			$data  = '$whatsnew_module'."['$dirname']['$key'] = $value;";
			fwrite($fp,"$data \n");
		}
	}

	fwrite($fp,"\n");

	write_param($fp, 'new_limit_show');
	write_param($fp, 'new_limit_summary');
	write_param($fp, 'new_max_summary');
	write_param($fp, 'new_image');
	write_param($fp, 'new_ping');
	write_param($fp, 'rss_limit_show');
	write_param($fp, 'ping_pass');
	write_param($fp, 'ping_log');

// set image width & height
	write_param($fp, 'new_max_width');
	write_param($fp, 'new_max_height');

	fwrite($fp,"\n");

	write_config($fp, 'site_name');
	write_config($fp, 'site_url');
	write_config($fp, 'site_desc');
	write_config($fp, 'site_author');
	write_config($fp, 'site_email');
	write_config($fp, 'rss_max_summary');

	write_config($fp, 'site_tag', set_site_tag($_POST['site_url']) );

	$image_logo = '';
	if ($_POST['image_logo']) $image_logo = $_POST['image_logo'];

	list($image_url, $image_width, $image_height)
		= set_image_url($image_logo);

	write_config($fp, 'image_logo',   $image_logo);
	write_config($fp, 'image_url',    $image_url);
	write_config($fp, 'image_width',  $image_width);
	write_config($fp, 'image_height', $image_height);

	fwrite($fp,"\n");

	$value = $_POST['ping_servers']; 
	$value = str_replace( "\r\n", "\n", $value ); 
	$value = str_replace( "\n\r", "\n", $value ); 
	$value = str_replace( "\r",   "\n", $value ); 
	$value = str_replace( "\n",   '\n', $value ); 
	$data = '$whatsnew_ping_servers = "'.$value.'";';

	fwrite($fp,"$data \n");
	fwrite($fp,"\n?>");

	fclose($fp);
}

function write_config($fp, $key, $value='')
{
 	global $_POST;

	if (empty($value))  $value = $_POST[$key];

	$value = set_value( $value );
	$data  = '$whatsnew_config'."['$key'] = $value;";

	fwrite($fp,"$data \n");
}

function write_param($fp, $key, $value='')
{
 	global $_POST;

	if ( empty($value) && isset($_POST[$key]) )  $value = $_POST[$key];

	$value = set_value( $value );
	$data   = '$whatsnew_'."$key = $value;";

	fwrite($fp,"$data \n");
}

function set_value($value)
{
	if ( is_numeric($value) )
	{
		if (empty($value))  $value = 0;
	}
	else
	{
		$value = "'$value'";
	}

	return $value;
}

function set_site_tag($url)
{
	$parse = parse_url($url);
	return $parse['host'];
}

function set_image_url($image_logo)
{
	$IMAGE_WIDTH_MIN  =  88;
	$IMAGE_WIDTH_MAX  = 144;
	$IMAGE_HEIGHT_MIN =  31;
	$IMAGE_HEIGHT_MAX = 400;

	$image_url    = '';
	$image_width  = 0;
	$image_height = 0;

	if ($image_logo)
	{
		$image_url  = XOOPS_URL."/$image_logo";
		$image_path = XOOPS_ROOT_PATH."/$image_logo";
	
		if ( file_exists($image_path) )
		{
			$dimention = getimagesize( $image_path );

			if (empty($dimention[0])) 
			{
				$image_width = $IMAGE_WIDTH_MIN;
			} 
			else 
			{
				$image_width = ($dimention[0] > $IMAGE_WIDTH_MAX) ? $IMAGE_WIDTH_MAX : $dimention[0];
			}

			if (empty($dimention[1])) 
			{
				$image_height = $IMAGE_HEIGHT_MIN;	
			} 
			else 
			{
				$image_height = ($dimention[1] > $IMAGE_HEIGHT_MAX) ? $IMAGE_HEIGHT_MAX : $dimention[1];
			}
		}
	}

	return array($image_url, $image_width, $image_height);
}

?>
