<?php
// $Id: server.php,v 1.1.1.2 2005/06/10 18:28:55 ohwada Exp $

// 2005-06-06 K.OHWADA
// English mode

//==========================================================
// weblogUpdates.ping server
// 2004/08/22 K.OHWADA
//==========================================================
// TO DO
// correspond other language code 
//----------------------------------------------------------

header('Server: XOOPS WhatsNew');
header('Content-Type: text/xml'); // MUST be the 1st line

// for debug
	$FLAG_LOG   = 0;
	$FLAG_DEBUG = 0;

// for japanese
	$ENCODE_USER = "EUC-JP";

// file name
	$FILE_LOG   = '../cache/ping.server.log';
	$FILE_DEBUG = '../cache/ping.server.debug.log';

// main
	if ($_SERVER["REQUEST_METHOD"] != 'POST')
	{
		send_fault(1,'request method error');
		exit();
	}

	list($ret,$blog_name,$blog_url,$error)
		 = parse_request($HTTP_RAW_POST_DATA);

	if ($ret != 0)
	{
		send_fault(1,$error);
		exit();
	}

	send_response(0,'Thanks for the ping.');
	write_log($blog_name,$blog_url);

	exit();
// --- main end ---


//---------------------------------------------------------
// parse_request
//---------------------------------------------------------
function parse_request($text)
{
	$text = convert_from_utf8($text);

	list ($methodod_name, $blog_name, $blog_url)
		= parse_ping($text);

	if ($methodod_name != 'weblogUpdates.ping')
	{
		return array(1,$blog_name,$blog_url,'unknown method');
	}

	if (empty($blog_name))
	{
		return array(1,$blog_name,$blog_url,'no blog name');
	}

	if (empty($blog_url))
	{
		return array(1,$blog_name,$blog_url,'no blog url');
	}

	return array(0,$blog_name,$blog_url,'');	// OK
}

//---------------------------------------------------------
// ping format
// http://www.xmlrpc.com/weblogsCom
//---------------------------------------------------------
// <methodCall>
//   <methodName>weblogUpdates.ping</methodName>
//   <params>
//     <param>
//       <value>blog_name</value>
//     </param>
//     <param>
//       <value>blog_url</value>
//     </param>
//   </params>
// </methodCall>
//
// some builder add string tag
// <methodCall>
//   <methodName>weblogUpdates.ping</methodName>
//   <params>
//     <param>
//       <value><string>blog_name</string></value>
//     </param>
//     <param>
//       <value><string>blog_url</string></value>
//     </param>
//   </params>
// </methodCall>
//
//---------------------------------------------------------
//   parse ping
//---------------------------------------------------------
function parse_ping($text)
{
	if (preg_match('/<methodName>(.*)<\/methodName>/is', $text, $match1))
	{
		$methodod_name = trim( $match1[1] );
	}

	preg_match_all('/<param>.*?<value>(.*?)<\/value>.*?<\/param>/is', $text, $match2);
	$arr = $match2[1];

	$param_arr = array();

	foreach ($arr as $param)
	{
		$value = trim( $param );
	
		if (preg_match('/<string>(.*)<\/string>/is', $param, $match3))
		{
			$value = trim( $match3[1] );
		}

		$param_arr[] = $value;
	}

	return array($methodod_name, $param_arr[0], $param_arr[1]);
}

//---------------------------------------------------------
//   send_response
//---------------------------------------------------------
function send_response($flerror,$message)
{
	$payload = <<<END_OF_TEXT
<?xml version="1.0" encoding="UTF-8"?>
<methodResponse>
<params>
<param>
<value><struct>
<member><name>flerror</name>
<value><boolean>$flerror</boolean></value>
</member>
<member><name>message</name>
<value><string>$message</string></value>
</member>
</struct></value>
</param>
</params>
</methodResponse>
END_OF_TEXT;

	header('Content-Length: '.strlen($payload));
	print $payload;

	write_debug($payload);
}

//---------------------------------------------------------
//   send fault response
//---------------------------------------------------------
function send_fault($fault_code,$fault_string)
{
	$payload = <<<END_OF_TEXT
<?xml version="1.0" encoding="UTF-8"?>
<methodResponse>
<fault>
<value>
<struct>
<member>
<name>faultCode</name>
<value><int>$fault_code</int></value>
</member>
<member>
<name>faultString</name>
<value><string>$fault_string</string></value>
</member>
</struct>
</value>
</fault>
</methodResponse>
END_OF_TEXT;

	header('Content-Length: '.strlen($payload));
	print $payload;

	write_debug($payload);
}

//---------------------------------------------------------
//   write_log
//---------------------------------------------------------
function write_log($blog_name,$blog_url)
{
	global $FLAG_LOG,$FILE_LOG;

	if ($FLAG_LOG != 1 ) return;

	$time = time();
	$data = "$time\t$blog_name\t$blog_url\n";

	$fp = fopen($FILE_LOG,"w");
	fwrite($fp,$data);
	fclose($fp);
}

//---------------------------------------------------------
//   write debug log
//---------------------------------------------------------
function write_debug($payload)
{
	global $HTTP_RAW_POST_DATA;
	global $FLAG_DEBUG,$FILE_DEBUG;

	if ($FLAG_DEBUG != 1 ) return;

	$today = date("Y/m/d H:i:s");

	$data = '';
	$data .= "\n";
	$data .= "=====\n";
	$data .= "$today \n";
	$data .= "REMOTE_ADDR:    {$_SERVER["SERVER_ADDR"]} \n";
	$data .= "REQUEST_METHOD: {$_SERVER["REQUEST_METHOD"]} \n";
	$data .= "--- ping ---\n";
	$data .= "$HTTP_RAW_POST_DATA\n";
	$data .= "--- response ---\n";
	$data .= "$payload\n";

	$fp = fopen($FILE_DEBUG,"w");
	fwrite($fp,$data);
	fclose($fp);
}

//---------------------------------------------------------
// convert from utf8
//---------------------------------------------------------
function convert_from_utf8($text)
{
	global $ENCODE_USER;

	if ( function_exists('mb_convert_encoding') )
	{
		$text = mb_convert_encoding( $text, $ENCODE_USER, "UTF-8" );
	}
	else
	{
		$text = utf8_decode($text);
	}

	return $text;
}

?>