<?php
// $Id: func.rss_atom_auto.php,v 1.1.1.2 2005/06/10 18:28:56 ohwada Exp $

//=========================================================
// What's New Module
// RSS / ATOM Auto Discovery
// 2004/08/10 K.OHWADA
//=========================================================

function get_rss_atom_link($html)
{
	$href_rss  = '';
	$href_atom = '';

// save all <link> tags
	preg_match_all('/<link\s+(.*?)\s*\/?>/si', $html, $match);
	$link_tag_arr = $match[1];

	$link_arr = array();
	$link_tag_count = count($link_tag_arr);

// store each <link> tags's attributes
	for($i=0; $i<$link_tag_count; $i++)
	{
		$attr_wk_arr   = array();
		$link_attr_arr = preg_split('/\s+/s', $link_tag_arr[$i]);

		foreach($link_attr_arr as $link_attr)
		{
			$link_attr_pair = preg_split('/\s*=\s*/s', $link_attr, 2);

			if( isset($link_attr_pair[0]) && isset($link_attr_pair[1]) )
			{
				$key   = $link_attr_pair[0];
				$value = $link_attr_pair[1];
				$key   = strtolower( $key );
				$value = preg_replace('/([\'"]?)(.*)\1/', '$2', $value);
				$attr_wk_arr[$key] = $value;
			}
		}

		$link_arr[$i] = $attr_wk_arr;
	}

// find the link file
	for($i=0; $i<$link_tag_count; $i++)
	{
		if (strtolower($link_arr[$i]['rel']) != 'alternate')  continue;
		if ( !isset($link_arr[$i]['href']) )  continue;

		if (empty($href_rss) && (strtolower($link_arr[$i]['type']) == 'application/rss+xml'))
		{
			$href_rss = $link_arr[$i]['href'];
		}
		elseif (empty($href_atom) && (strtolower($link_arr[$i]['type']) == 'application/atom+xml'))
		{
			$href_atom = $link_arr[$i]['href'];
		}
	}

	return array($href_rss, $href_atom);
}

//---------------------------------------------------------
// get_remote_file
//---------------------------------------------------------
function get_remote_file($url)
{
	$fp = fopen($url, "r");
	if (!$fp)	return false;

	$data = '';
	while ($d = fread($fp, 4096))
	{
		$data .= $d;
	}

	fclose($fp);

	return $data;
}

?>
