<?php

function b_xoopsgallery_newshow($options){
	$block = array();
	$image_handler =& xoops_getmodulehandler('image', 'xoopsgallery');
	$criteria = new Criteria('image_type', 'original');
	$criteria->setSort('image_created');
	$criteria->setOrder('DESC'); 
    // Collect 5* the number of random images that are to be shown...
	// this way we can make sure there is a thumbnail for all of the images put into the block.
	$myLimit = $options[0];
	$overLimit = 5*$myLimit;
	$criteria->setLimit($overLimit);
	$images =& $image_handler->getObjects($criteria, true);
	$FoundIT = false;
	$count = 0;
	$maxW = 0;
	$maxH = 0;
	foreach (array_keys($images) as $i) {
		if ($FoundIT) break;
		if (!($images[$i]->ThumbExists())) continue; // no thumbnail for this picture so go to the next...
		if (false !== $hw = getimagesize($images[$i]->getFullThumbPath())) {
			if (intval($options[1]) < $hw[0]) {
				$image['width'] = intval($options[1]);
				$image['height'] = $hw[1] * ($image['width'] / $hw[0]);
			} else {
				$image['width'] = $hw[0];
				$image['height'] = $hw[1];
			}
			if ($image['width'] > $maxW) {
				$maxW = $image['width'];
			}
			if ($image['height'] > $maxH) {
				$maxH = $image['height'];
			}
			$image['src'] = $images[$i]->getFullThumbUrl();
			$image['link'] = XOOPS_URL.'/modules/xoopsgallery/view_photo.php?xoops_imageid='.$images[$i]->getVar('image_id').'&amp;set_albumName='.$images[$i]->getVar('image_albumdir').'&amp;id='.$images[$i]->getVar('image_name');
			if (!empty($options[2])) {
				$image['created'] = formatTimestamp($images[$i]->getVar('image_created'), 's');
			} else {
				$image['created'] = '';
			}
			$block['images'][] =& $image;
			unset($image);
			$count = $count+1;
			if ($count >= $myLimit) $FoundIT = true;
		}
	}
	$block['imageWidth'] = $maxW;
	$block['imageHeight'] = $maxH;
	$block['showCreated'] = (!empty($options[2]));
	return $block;
}

function b_xoopsgallery_newedit($options) {
	$form = _MB_GALLERY_DISP."&nbsp;";
	$form .= '<input type="text" name="options[0]" value="'.intval($options[0]).'" />';
	$form .= '<br />'._MB_GALLERY_MAXW.'&nbsp;<input type="text" name="options[1]" value="'.$options[1].'" />';
	$form .= '<br />'._MB_GALLERY_SHOWDATE.'&nbsp;<input type="checkbox" name="options[2]" value="1"';
	if (!empty($options[2])) {
		$form .= ' checked="checked"';
	}
	$form .= ' />';
	return $form;
}




function b_xoopsgallery_getRandomImage($options) {
	$block = array();
	unset($images);
	$image_handler =& xoops_getmodulehandler('image', 'xoopsgallery');
	$criteria = new Criteria('image_type', 'original');
	$images =& $image_handler->getObjects($criteria, true);
	srand(time());
	shuffle($images);
    // Collect 5* the number of random images that are to be shown...
	// this way we can make sure there is a thumbnail for all of the images put into the block.
	$myLimit = $options[0];
	$overLimit = 5*$myLimit;
	$criteria->setLimit($overLimit);
	$FoundIT = false;
	$count = 0;
	$maxW = 0;
	$maxH = 0;
	foreach (array_keys($images) as $i) {
		if ($FoundIT) break;
		if (!($images[$i]->ThumbExists())) continue; // no thumbnail for this picture so go to the next...
		if (false !== $hw = getimagesize($images[$i]->getFullThumbPath())) {
			$ImageSize = $options[1];
			if (intval($ImageSize) < $hw[0]) {
				$image['width'] = intval($ImageSize);
				$image['height'] = $hw[1] * ($image['width'] / $hw[0]);
			} else {
				$image['width'] = $hw[0];
				$image['height'] = $hw[1];
			}
			if ($image['width'] > $maxW) {
				$maxW = $image['width'];
			}
			if ($image['height'] > $maxH) {
				$maxH = $image['height'];
			}
			$image['src'] = $images[$i]->getFullThumbUrl();
			$image['link'] = XOOPS_URL.'/modules/xoopsgallery/view_photo.php?xoops_imageid='.$images[$i]->getVar('image_id').'&amp;set_albumName='.$images[$i]->getVar('image_albumdir').'&amp;id='.$images[$i]->getVar('image_name');
			if (!empty($options[2])) {
				$image['created'] = formatTimestamp($images[$i]->getVar('image_created'), 's');
			} else {
				$image['created'] = '';
			}
			$block['images'][] =& $image;
			unset($image);
			$count = $count+1;
			if ($count >= $myLimit) $FoundIT = true;
		}
	}
	$block['imageWidth'] = $maxW;
	$block['imageHeight'] = $maxH;
	$block['showCreated'] = (!empty($options[2]));
	return $block;
}

function b_xoopsgallery_editRandomImage($options) {
	$form = _MB_GALLERY_DISP."&nbsp;";
	$form .= '<input type="text" name="options[0]" value="'.intval($options[0]).'" />';
	$form .= '<br />'._MB_GALLERY_MAXW.'&nbsp;<input type="text" name="options[1]" value="'.$options[1].'" />';
	$form .= '<br />'._MB_GALLERY_SHOWDATE.'&nbsp;<input type="checkbox" name="options[2]" value="1"';
	if (!empty($options[2])) {
		$form .= ' checked="checked"';
	}
	$form .= ' />';
	return $form;
}



/*
function b_xoopsgallery_getRandomImage($options) {
	global $xoopsDB;
	$result=array();
	$sql = 'SELECT image_name, image_ext, image_albumdir  FROM '.$xoopsDB->prefix('xoopsgallery_image').' WHERE image_name LIKE "%thumb" ORDER BY RAND() LIMIT 5';
	$result = $xoopsDB->query($sql);
	$thumb = $xoopsDB->fetchRow($result);
	$thumb = '/modules/xoopsgallery/cache/albums/'.$thumb[2].'/'.$thumb[0].'.'.$thumb[1];

	while(!file_exists(XOOPS_ROOT_PATH.'/'.$thumb)) {
		$thumb = $xoopsDB->fetchRow($result);
		$thumb = '/modules/xoopsgallery/cache/albums/'.$thumb[2].'/'.$thumb[0].'.'.$thumb[1];
	}
	$block['rand_image'] = $thumb;
	return $block;
}
*/



?>