<?php
/*
 * Gallery - a web based photo album viewer and editor
 * Copyright (C) 2000-2002 Bharat Mediratta
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */


// Security Check
$sensitiveList = array("gallery", "GALLERY_BASEDIR");
foreach ($sensitiveList as $sensitive) {
	if (!empty($HTTP_GET_VARS[$sensitive]) ||
	!empty($HTTP_POST_VARS[$sensitive]) ||
	!empty($HTTP_COOKIE_VARS[$sensitive]) ||
	!empty($HTTP_POST_FILES[$sensitive])) {
		print _("Security violation") ."\n";
		exit;
	}
}


require_once '../../mainfile.php';
$GALLERY_MODULENAME = "gallery";
$GALLERY_BASEDIR = XOOPS_ROOT_PATH.'/modules/xoopsgallery/';
$GALLERY_URL = XOOPS_URL . '/modules/xoopsgallery/';
$GALLERY_EMBEDDED_INSIDE = 'xoops2';
/*
 * Figure out if register_globals is on or off and save that info
 * for later
 */
$register_globals = ini_get("register_globals");
if (empty($register_globals) ||
        !strcasecmp($register_globals, "off") ||
        !strcasecmp($register_globals, "false")) {
    $gallery->register_globals = 0;
} else {
    $gallery->register_globals = 1;
}

/*
 * If register_globals is off, then extract all HTTP variables into the global
 * namespace.  
 */
if (!$gallery->register_globals) {
    extract($HTTP_GET_VARS);
    extract($HTTP_POST_VARS);
    extract($HTTP_COOKIE_VARS);
    
    foreach($HTTP_POST_FILES as $key => $value) {
	${$key."_name"} = $value["name"];
	${$key."_size"} = $value["size"];
	${$key."_type"} = $value["type"];
	${$key} = $value["tmp_name"];
    }
}

/* Load bootstrap code */
if (substr(PHP_OS, 0, 3) == 'WIN') {
	include($GALLERY_BASEDIR . "platform/fs_win32.php");
} else {
	include($GALLERY_BASEDIR . "platform/fs_unix.php");
}


if (fs_file_exists($GALLERY_BASEDIR . "config.php")) {
    global $gallery;
	include($GALLERY_BASEDIR . "config.php");
}

require($GALLERY_BASEDIR . "util.php");

/*
 * Detect if we're running under SSL and adjust the URL accordingly.
 */
if (stristr($HTTP_SERVER_VARS["HTTPS"], "on")) {
	$gallery->app->photoAlbumURL = 
		eregi_replace("^http:", "https:", $gallery->app->photoAlbumURL);
	$gallery->app->albumDirURL = 
		eregi_replace("^http:", "https:", $gallery->app->albumDirURL);
} else {
	$gallery->app->photoAlbumURL = 
		eregi_replace("^https:", "http:", $gallery->app->photoAlbumURL);
	$gallery->app->albumDirURL = 
		eregi_replace("^https:", "http:", $gallery->app->albumDirURL);
}

/* 
 * Turn off magic quotes runtime as they interfere with saving and
 * restoring data from our file-based database files
 */
set_magic_quotes_runtime(0);

/* Make sure that Gallery is set up properly */
gallerySanityCheck();

/* Load classes and session information */
require($GALLERY_BASEDIR . "classes/Album.php");
require($GALLERY_BASEDIR . "classes/Image.php");
require($GALLERY_BASEDIR . "classes/AlbumItem.php");
require($GALLERY_BASEDIR . "classes/AlbumDB.php");
require($GALLERY_BASEDIR . "classes/User.php");
require($GALLERY_BASEDIR . "classes/EverybodyUser.php");
require($GALLERY_BASEDIR . "classes/NobodyUser.php");
require($GALLERY_BASEDIR . "classes/LoggedInUser.php");
require($GALLERY_BASEDIR . "classes/UserDB.php");
require($GALLERY_BASEDIR . "classes/Comment.php");

if (!$GALLERY_NO_SESSIONS) {
    require($GALLERY_BASEDIR . "session.php");
}

include($GALLERY_BASEDIR . "classes/xoops2/UserDB.php");
include($GALLERY_BASEDIR . "classes/xoops2/User.php");

/* Load our user database (and user object) */
$gallery->userDB = new Xoops_UserDB;

if (isset($cmd)) {
  if ($cmd == "login") {
    $member_handler =& xoops_gethandler('member');
    $myts =& MyTextsanitizer::getInstance();
    $user =& $member_handler->loginUser(addslashes($myts->stripSlashesGPC($uname)), addslashes($myts->stripSlashesGPC($password)));
    if ($user) {
      $_SESSION[gallery_user] = $uname;
      $_SESSION[gallery_password] = $password;
    }
  }
  

}
/* Load their user object with their username as the key */
if ((is_object($GLOBALS['xoopsUser']) && (get_class($GLOBALS['xoopsUser']) == "xoopsuser")) || isset($_SESSION['gallery_user'])) {
	if (isset($_SESSION['gallery_user'])) 
		$gallery->session->username = $_SESSION['gallery_user'];
	else
		$gallery->session->username = $GLOBALS['xoopsUser']->getVar('uname'); 

	$gallery->user = $gallery->userDB->getUserByUsername($gallery->session->username);
}


/* If there's no specific user, they are the special Everybody user */
if (!$gallery->user) {
	$gallery->user = $gallery->userDB->getEverybody();
	$gallery->session->username = "";
}

/* Load the correct album object */
if ($gallery->session->albumName) {
	$gallery->album = new Album;
	$ret = $gallery->album->load($gallery->session->albumName);
	if (!$ret) {
		$gallery->session->albumName = "";
	} else {
		if ($gallery->album->versionOutOfDate()) {
			include($GALLERY_BASEDIR . "upgrade_album.php");
			exit;
		}
	}
}
?>