<?php
// $Id: category_manage.php,v 1.7 2006/05/24 01:15:18 ohwada Exp $

// 2006-05-15 K.OHWADA
// new handler
// add class admin_category_manage
// use token ticket

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//=========================================================
// WebLinks Module
// admin category manage
// 2004/01/14 K.OHWADA
//=========================================================

include 'admin_header.php';


//=========================================================
// class admin_category_manage
//=========================================================
class admin_category_manage extends weblinks_error
{
// class
	var $_link_edit_handler;
	var $_link_handler;
	var $_category_handler;
	var $_catlink_handler;

	var $_system;
	var $_strings;
	var $_post;
	var $_myts;
	var $_cat_form;

// local
	var $_cid;
	var $_cat_obj;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_category_manage()
{
	$this->_link_edit_handler =& weblinks_get_handler('link_edit', WEBLINKS_DIRNAME);
	$this->_link_handler      =& weblinks_get_handler('link',      WEBLINKS_DIRNAME);
	$this->_category_handler  =& weblinks_get_handler('category',  WEBLINKS_DIRNAME);
	$this->_catlink_handler   =& weblinks_get_handler('catlink',   WEBLINKS_DIRNAME);

	$this->_system   =& weblinks_system::getInstance();
	$this->_strings  =& weblinks_strings::getInstance();
	$this->_post     =& weblinks_post::getInstance();
	$this->_myts     =& MyTextSanitizer::getInstance();
	$this->_cat_form =& admin_category_form::getInstance();

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_category_manage();
	}
	return $instance;
}

//---------------------------------------------------------
// init
//---------------------------------------------------------
function init()
{
	$this->_category_handler->load();
}

function get($cid)
{
	$obj =& $this->_category_handler->get($cid);
	if ( is_object($obj) )
	{
		$this->_cid     = $cid;
		$this->_cat_obj = $obj;
		return $obj;
	}

	return false;
}

function existCat($cid)
{
	$obj =& $this->get($cid);
	if ( is_object($obj) )
	{
		return true;
	}

	return false;
}

//---------------------------------------------------------
// categoryMenu
//---------------------------------------------------------
function categoryMenu()
{
	echo "<h4>"._WEBLINKS_ADMIN_CATEGORY_MANAGE."</h4>\n";
	$total = $this->_category_handler->getCount();

	printf(_WEBLINKS_THERE_ARE_CATEGORY, $total);
    echo "<br /><br />\n";

// Add a New Main Category
	$this->_cat_form->AddMain();
    echo "<br />\n";

// Add a New Sub-Category
    if ( $total > 0 ) 
    {
		$selbox = $this->_category_handler->build_selbox(0, 0, 'pid');
		$this->_cat_form->addSub( $selbox );
		echo "<br />\n";
    }
}

//---------------------------------------------------------
// addCat
//---------------------------------------------------------
function check_pid()
{
	if ( isset($_POST['pid']) && ($_POST['pid'] != '')  )
	{
		return true;	// OK
	}
	return false;
}

function check_title()
{
	if ( isset($_POST['title']) && ($_POST['title'] != '')  )
	{
		return true;	// OK
	}
	return false;
}

function check_imgurl()
{
	$object =& new weblinks_object();

	if ( isset($_POST['imgurl']) && ($_POST['imgurl'] != '')  )
	{
		$imgurl = $_POST['imgurl'];

		if ( !$object->checkHttpStart($imgurl) )
		{
			return false;	// NG
		}
		elseif ( $object->checkJavascript($imgurl) )
		{
			return false;	// NG
		}
	}

	return true;	// OK
}

function addCat($title)
{
	$obj =& $this->_category_handler->create();
	$obj->assign_vars_post( $_POST );

	$newid = $this->_category_handler->insert($obj);
	if ( !$newid )
	{
		$this->_set_errors( $this->_category_handler->getErrors() );
		return false;
	}

	$tags = array();
	$tags['CATEGORY_NAME'] = $title;
	$tags['CATEGORY_URL'] = WEBLINKS_URL."/viewcat.php?cid=$newid";
	$notification_handler =& xoops_gethandler('notification');
	$notification_handler->triggerEvent('global', 0, 'new_category', $tags);

	return true;
}

//---------------------------------------------------------
// modCat
//---------------------------------------------------------
function modCat()
{
	$total = $this->_category_handler->get_total();

	printf(_WEBLINKS_THERE_ARE_CATEGORY, $total);
	echo "<br /><br />\n";

	$rec = $this->_cat_obj->getVarAll('e');
	$selbox = $this->_category_handler->build_selbox( $rec['pid'], 1, 'pid' );
	$this->_cat_form->ModCat($rec, $selbox);
}

function modCatS()
{
	$this->_cat_obj->assign_vars_post( $_POST );

	$ret = $this->_category_handler->update($this->_cat_obj);
	if ( !$ret )
	{
		$this->_set_errors( $this->_category_handler->getErrors() );
		return false;
	}

	return true;
}

//---------------------------------------------------------
// delCat
//---------------------------------------------------------
function delCat()
{
	$MAX_SUBCAT_DEL  = 4;
	$MAX_LINK_BELONG = 10;
	$MAX_LINK_DEL    = 10;

	$cid = $this->_post->get_post_int('cid');
	$ok  = $this->_post->get_post_int('ok');

    if ( $ok == 1 ) 
	{
		echo "<h3>"._WLS_DELCAT."</h3>\n";
	}
	else
	{
		echo "<h3 style='color: #0000ff'>"._WLS_WARNING."</h3>\n";
	}

// The specified category
	echo "<h4>"._WLS_CATEGORY."</h4>\n";

	$title_s = $this->_cat_obj->getVar('title', 's');
	echo "$cid: $title_s <br />\n";

// sub categories
	echo "<h4>"._WLS_SUBCATEGORY."</h4>\n";

	$sub_arr   = $this->_category_handler->getAllChildId($cid);

	$sub_count = count($sub_arr);
	if ($sub_count > 0)
	{
		foreach ($sub_arr as $sub) 
		{
			$obj2 = $this->_category_handler->get($sub);
			$title_s = $obj2->getVar('title', 's');
			echo "$sub: $title_s <br />\n";
		}
	}
	else
	{
		echo _WLS_SUBCATEGORY_NON."<br />\n";
	}

// limit over
	if ($sub_count > $MAX_SUBCAT_DEL)
	{
		echo "<br />\n";
		echo $this->_strings->highlight( _WLS_ERROR_MAX_SUBCAT );
		echo " ($MAX_SUBCAT_DEL) <br />\n";
		echo "<hr />\n";
		echo "<h4><a href='index.php'>"._WLS_GOTOADMIN."</a></h4>\n";
		return;
	}

// all link belonging to this category
	echo "<h4>"._WLS_LINK_BELONG."</h4>\n";

	$cid_arr    = array_merge( array($cid), $sub_arr );
	$lid_arr    = $this->_catlink_handler->get_lid_array_by_cid_array($cid_arr);
	$cid_count  = count($cid_arr);
	$link_count = count($lid_arr);
	$link_del_count = 0;

	if ($link_count > 0)
	{
		echo _WLS_LINK_BELONG_NUMBER.": ".count($lid_arr)."<br />\n";
		echo "<h4>"._WLS_LINK_MAYBE_DELETE."</h4>\n";

		if ($cid_count > 0)
		{
			echo _WLS_LINK_MAYBE_DELETE_DSC."<br /><br />\n";
		}

		foreach ($lid_arr as $lid)
		{

// get the number of the categories belonging to this link 
			$num = $this->_catlink_handler->get_count_by_lid($lid);

// the link belongs only to this category
			if ($num == 1)
			{
				$link_obj = $this->_link_handler->get($lid);

				if ( is_object($link_obj) )
				{
					$link_title_s = $link_obj->getVar('title', 's');
					echo "link: $lid: $link_title_s <br />\n";
				}
				else
				{
					$msg = "link not exist lid = $lid";
					$this->print_error($msg);
				}

				$link_del_count ++;
			}
		}

		if ($link_del_count == 0)
		{
			$this->print_warnig( _WLS_LINK_DELETE_NON );
		}
	}
	else
	{
		echo _WLS_LINK_BELONG_NON."<br />\n";
	}

// limit over
	if ($link_del_count > $MAX_LINK_DEL)
	{
		echo "<br />\n";
		echo $this->_strings->highlight( _WLS_ERROR_MAX_LINK_DEL );
		echo " ($MAX_LINK_DEL) <br />\n";
		echo "<hr />\n";
		echo "<h4><a href='index.php'>"._WLS_GOTOADMIN."</a></h4>\n";
		return;
	}

// limit over
	if ($link_count > $MAX_LINK_BELONG)
	{
		echo "<br />\n";
		echo $this->_strings->highlight( _WLS_ERROR_MAX_LINK_BELONG );
		echo " ($MAX_LINK_BELONG) <br />\n";
		echo "<hr />\n";
		echo "<h4><a href='index.php'>"._WLS_GOTOADMIN."</a></h4>\n";
		return;
	}

// excute
    if ( $ok == 1 ) 
    {
		echo "<br /><hr />\n";
		echo "<h4>"._WLS_CATEGORY_LINK_DELETE_EXCUTE."</h4>\n";

		$flag_error = false;

// sub category
		foreach ($sub_arr as $sub) 
		{
			$ret = $this->deleteCategory( $sub );
			if ( !$ret )
			{	$flag_error = true;	}
		}

		$ret = $this->deleteCategory($cid);
		if ( !$ret )
		{	$flag_error = true;	}

		echo "<h4>"._WLS_CATEGORY_LINK_DELETED."</h4>\n";

		if ($flag_error)
		{
			$this->print_error( _AM_WEBLINKS_ERROR_SOME );
		}

		echo "<hr />\n";
		return;
	}

// confirm
	else 
	{
		$this->_cat_form->DelCatOk($cid);
 		return;
    }
}

function deleteCategory($cid)
{
	$flag_error = false;

	$mid = $this->_system->get_mid();

// get the link id is belonging to this category 
	$lid_arr = $this->_catlink_handler->get_lid_array_by_cid($cid);

	foreach ($lid_arr as $lid)
	{

// get the number of the categories belonging to this link 
		$num = $this->_catlink_handler->get_count_by_lid($lid);

// delete this link, if it belongs only to this category
		if ($num == 1)
		{
			$link_obj = $this->_link_handler->get($lid);

			if ( is_object($link_obj) )
			{
				$title_s = $link_obj->getVar('title', 's');
				echo "$lid: $title_s <br />\n";
			}
			else
			{
				$flag_error = true;
				$msg = "link not exist lid = $lid ";
				$this->print_error($msg);
			}

// BUG 3095: the number of links does not change, if delete link
			$ret = $this->_link_edit_handler->del_link_vote_comm_by_lid($lid);
			if (!$ret)
			{
				$flag_error = true;
				$msg = $this->_link_edit_handler->getErrors(1);
				$this->print_error($msg);
			}
		}
	}

// delete category
	$obj = $this->_category_handler->get($cid);

	if ( is_object($obj) )
	{
		$title_s = $obj->getVar('title', 's');
		echo _WLS_CATEGORY_DELETED.": $cid: $title_s <br />\n";

		$ret = $this->_category_handler->delete($obj);
		if (!$ret)
		{
			$flag_error = true;
			$msg = $this->_category_handler->getErrors(1);
			$this->print_error($msg);
		}
	}
	else
	{
		$flag_error = true;
		$msg = "category not exist cid = $cid ";
		$this->print_error($msg);
	}

// delete comments & notifications
	xoops_notification_deletebyitem( $mid, 'category', $cid );

	if ( $flag_error ) { return false; }
	return true;
}

function check_cid()
{
	$cid = 0;
	if     ( isset($_POST['cid']) )  $cid = intval( $_POST['cid'] );
	elseif ( isset($_GET['cid']) )   $cid = intval( $_GET['cid'] );

// system error
	if (empty($cid))
	{
	    redirect_header("category_manage.php", 2, _WLS_ERROR_CATEGORY);
	    exit();
	}
}

//---------------------------------------------------------
// reorderCat
//---------------------------------------------------------
function reorderCat()
{
	$this->_clear_errors();

	$order_arr = '';
	if ( isset($_POST['orders']) )  $order_arr = $_POST['orders'];

	foreach ($order_arr as $key => $value)
	{
		$cid    = intval($key);
		$orders = intval($value);
		$obj =& $this->_category_handler->get($cid);

		if ( is_object($obj) )
		{
			$obj->setVar('orders', $orders);

			$ret = $this->_category_handler->update($obj);
			if (!$ret)
			{
				$this->_set_error( $this->_category_handler->getErrors(1) );
			}
		}
		else
		{
			$msg = "category not exist cid = $cid ";
			$this->_set_error($msg);
		}
	}

	return $this->returnExistError();
}

//---------------------------------------------------------
// print error
//---------------------------------------------------------
function print_error($msg)
{
	echo $this->_strings->highlight($msg);
	echo "<br />\n";
}

function print_warnig($msg)
{
	echo $this->_strings->highlight($msg, '#0000ff');
	echo "<br />\n";
}

//---------------------------------------------------------
// token ticket
//---------------------------------------------------------
function check_token( $name='' )
{
	$ret = $this->_cat_form->check_token($name);
	return $ret;
}

// --- class end ---
}


//=========================================================
// class admin_category_form
//=========================================================
class admin_category_form extends weblinks_form
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_category_form()
{
	$this->weblinks_form();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_category_form();
	}
	return $instance;
}

//---------------------------------------------------------
// form
//---------------------------------------------------------
function AddMain()
{
	echo $this->make_form_start( 'addMain' );
	echo $this->make_form_token();
	echo $this->make_form_hidden('op', 'addCat');
	echo $this->make_form_hidden('pid', 0);
	echo $this->make_table_start();
	echo $this->make_table_title( _WLS_ADDMAIN );

	echo $this->build_table_title();
	echo $this->build_table_lflag();
	echo $this->build_table_orders();
	echo $this->build_table_imgurl();
	echo $this->build_table_submit( _WLS_ADD );

	echo $this->make_table_end();
	echo $this->make_form_end();

}

function AddSub( $selbox )
{
	echo $this->make_form_start( 'addSub' );
	echo $this->make_form_token();
	echo $this->make_form_hidden('op', 'addCat');
	echo $this->make_table_start();
	echo $this->make_table_title( _WLS_ADDSUB );

	echo $this->build_table_title();
	echo $this->build_table_lflag();
	echo $this->build_table_orders();
	echo $this->make_table_line(_WLS_PARENT, $selbox);
	echo $this->build_table_submit( _WLS_ADD );

	echo $this->make_table_end();
	echo $this->make_form_end();

}

function ModCat($data, $selbox)
{
// BUG 2828: submit form is not displayed correctly

	$cid = $data['cid'];

	echo $this->make_form_start( 'modCat' );
	echo $this->make_form_token();
	echo $this->make_form_hidden('op', 'modCatS');
	echo $this->make_form_hidden('cid', $cid);
	echo $this->make_table_start();
	echo $this->make_table_title( _WLS_MODCAT );

	echo $this->make_table_line( _WLS_CATEGORYID, '<b>'.$cid.'</b>');
	echo $this->build_table_title( $data['title']);
	echo $this->build_table_lflag( $data['lflag'] );
	echo $this->build_table_orders( $data['orders'] );
	echo $this->make_table_line(_WLS_PARENT, $selbox);
	echo $this->build_table_imgurl( $data['imgurl'], 1 );
	echo $this->build_table_submit( _WLS_SAVE, 1, 1 );

	echo $this->make_table_end();
	echo $this->make_form_end();

}

function CategoryFormDelCat()
{
	$this->_category_handler->get_tree_array(0);
	$category = $this->_category_handler->build_selbox(0, 0, 'cid');

	$builder = new weblinks_form_extend();
	$builder->start_theme_form( _WLS_DELCAT, 'delCat' );
	$builder->add_hidden('op', 'delCat');
	$builder->add_label( _WLS_CATEGORY, $category );
	$builder->add_submit_button( '', 'post', _DELETE );
	$builder->display();

}

function DelCatOk($cid)
{
	echo $this->make_form_start( 'delCat' );
	echo $this->make_form_token();
	echo $this->make_form_hidden('op',  'delCat');
	echo $this->make_form_hidden('ok',  1);
	echo $this->make_form_hidden('cid', $cid);
	echo $this->make_table_start();
	echo $this->make_table_title(  _WLS_DELCAT );

	echo $this->build_table_submit( _DELETE, 0, 1 );

	echo $this->make_table_end();
	echo $this->make_form_end();
}

function build_table_title( $value='' )
{
	$ele = $this->make_table_form_text(_WLS_TITLEC, 'title', $value);
	return $ele;
}

function build_table_orders( $value=1 )
{
	$ele = $this->make_table_form_text(_WEBLINKS_CAT_ORDER, 'orders', $value);
	return $ele;
}

function build_table_lflag( $value=1 )
{
	$opt = array(
		_WLS_NOTLINKFLAG => 0,
		_WLS_LINKFLAG    => 1,
		);

	$ele = $this->make_table_form_radio_select(_WEBLINKS_CAT_ORDER, 'lflag', $value, $opt);
	return $ele;
}

function build_table_imgurl( $value='', $flag=0 )
{
	$imgurl_desc = _WEBLINKS_IMGURL_MAIN_DSC1;

	if ($flag)
	{
		$imgurl_desc .= "<br />\n"._WEBLINKS_IMGURL_MAIN_DSC2;
	}

	if ( empty($value) )
	{
		$value = 'http://';
	}

	$imgurl_cap  = $this->make_caption( _WEBLINKS_IMGURL_MAIN, $imgurl_desc );
	$imgurl_text = $this->make_form_text('imgurl', $value, 100, 255);

	$text  = $this->make_table_line_col($imgurl_cap);
	$text .= $this->make_table_line_col($imgurl_text, 'odd');
	return $text;
}

function build_table_submit( $value, $flag_delete=0, $flag_cancel=0 )
{
	$text = $this->make_form_submit('post', $value);

	if ( $flag_delete )
	{
		$text .= ' '.$this->make_form_submit('delete', _DELETE);
	}

	if ( $flag_cancel )
	{
		$text .= ' '.$this->make_form_cancel_button('cancel', _CANCEL);
	}

	$ele = $this->make_table_line('', $text, 'foot', 'foot');
	return $ele;
}

// --- class end ---
}


//=========================================================
// main
//=========================================================
$category_manage =& admin_category_manage::getInstance();
$post            =& weblinks_post::getInstance();

$op = 'main';
if     ( isset($_POST['delete']) )  $op = 'delete';
elseif ( isset($_POST['op']) )      $op = $_POST['op'];
elseif ( isset($_GET['op']) )       $op = $_GET['op'];

$cid   = $post->get_post_get_int('cid');
$title = $post->get_post_text('title');

$url_modcat = 'category_manage.php?op=modCat&amp;cid='.$cid;

// start
$category_manage->init();

switch ($op) 
{
case 'addCat':
	if( !$category_manage->check_token() ) 
	{
		redirect_header( "category_manage.php", 5, "Token Error");
		exit();
	}

	if ( !$category_manage->check_pid()  )
	{
	    redirect_header('category_manage.php', 5, _WLS_ERROR_CATEGORY);
		exit();
	}

	if ( !$category_manage->check_title() ) 
	{
		$msg = sprintf(_WLS_ERROR_FILL, _WLS_TITLEC);
		redirect_header('category_manage.php', 5, $msg);
		exit();
	}

	if ( !$category_manage->check_imgurl() ) 
	{
		$msg = sprintf(_WLS_ERROR_ILLEGAL, _WEBLINKS_IMGURL_MAIN);
		redirect_header('category_manage.php', 5, $msg);
		exit();
	}

	$ret = $category_manage->addCat($title);
	if ($ret)
	{
		redirect_header('category_list.php?sortid=1', 1, _WLS_NEWCATADDED);
	}
	else
	{
		xoops_cp_header();
		xoops_error("DB Error");
		echo $category_manage->getErrors(1);
		weblinks_admin_print_menu();
		xoops_cp_footer();
	}

	break;

case 'modCat':
	if ( !( $category_manage->existCat($cid) ) )
	{
		redirect_header('category_list.php', 5, _WEBLINKS_NO_CATEGORY);
		exit();
	}

	xoops_cp_header();
	weblinks_admin_print_header();
	weblinks_admin_print_menu();
	$category_manage->modCat();
	xoops_cp_footer();
	break;

case 'modCatS':
	if( !( $category_manage->check_token() ) ) 
	{
		redirect_header( $url_modcat, 5, "Token Error");
		exit();
	}

// form check
	if ( !( $category_manage->existCat($cid) ) )
	{
		redirect_header('category_list.php', 5, _WEBLINKS_NO_CATEGORY);
		exit();
	}

	if ( !$category_manage->check_title() ) 
	{
		$msg = sprintf(_WLS_ERROR_FILL, _WLS_TITLEC);
		redirect_header('category_manage.php', 5, $msg);
		exit();
	}

	if ( !$category_manage->check_imgurl() ) 
	{
		$msg = sprintf(_WLS_ERROR_ILLEGAL, _WEBLINKS_IMGURL_MAIN);
		redirect_header('category_manage.php', 5, $msg);
		exit();
	}

	$ret = $category_manage->modCatS();
	if ($ret)
	{
		redirect_header('category_list.php', 1, _WLS_DBUPDATED);
	}
	else
	{
		xoops_cp_header();
		xoops_error("DB Error");
		echo $category_manage->getErrors(1);
		weblinks_admin_print_menu();
		xoops_cp_footer();
	}

	break;

case 'delCat':
case 'delete':
	if( !( $category_manage->check_token() ) ) 
	{
		redirect_header( $url_modcat, 5, "Token Error");
		exit();
	}

	if ( !( $category_manage->existCat($cid) ) )
	{
		redirect_header('category_list.php', 5, _WEBLINKS_NO_CATEGORY);
		exit();
	}

	xoops_cp_header();
	weblinks_admin_print_header();
	weblinks_admin_print_menu();
	$category_manage->delCat();
	xoops_cp_footer();
	break;

case 'reorderCat':
	if( !( $category_manage->check_token() ) ) 
	{
		redirect_header('category_list.php', 5, "Token Error");
		exit();
	}

	$ret = $category_manage->reorderCat();
	if ($ret)
	{
		redirect_header('category_list.php', 1, _WEBLINKS_ORDERS_UPDATED);
	}
	else
	{
		xoops_cp_header();
		xoops_error("DB Error");
		echo $category_manage->getErrors(1);
		weblinks_admin_print_menu();
		xoops_cp_footer();
	}

	break;

case 'main':
default:
	xoops_cp_header();
	weblinks_admin_print_header();
	weblinks_admin_print_menu();
	$category_manage->categoryMenu();
	xoops_cp_footer();
	break;

}

exit();
// --- end of main ---

?>