<?php
// $Id: link_manage.php,v 1.8 2006/05/24 01:15:18 ohwada Exp $

// 2006-05-15 K.OHWADA
// new handler
// add class admin_link_manage
// use token ticket

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//=========================================================
// WebLinks Module
// admin link manage
// divid this file from index.php
// 2004/01/14 K.OHWADA
//=========================================================

include 'admin_header.php';


//=========================================================
// class admin_link_manage
//=========================================================
class admin_link_manage extends weblinks_error
{
	var $_votedata_handler;
	var $_broken_handler;
	var $_link_form_handler;
	var $_link_edit_handler;

	var $_system;
	var $_form;
	var $_myts;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_link_manage()
{
	$this->_votedata_handler  =& weblinks_get_handler('votedata',  WEBLINKS_DIRNAME);
	$this->_broken_handler    =& weblinks_get_handler('broken',    WEBLINKS_DIRNAME);
	$this->_link_edit_handler =& weblinks_get_handler('link_edit', WEBLINKS_DIRNAME);
	$this->_link_form_handler =& weblinks_get_handler('link_form', WEBLINKS_DIRNAME );

	$this->_system =& weblinks_system::getInstance();
	$this->_form   =& weblinks_form::getInstance();
	$this->_myts   =& MyTextSanitizer::getInstance();

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_link_manage();
	}
	return $instance;
}

//---------------------------------------------------------
// init
//---------------------------------------------------------
function init()
{
	$this->_link_edit_handler->init();
}

//---------------------------------------------------------
// addLink
//---------------------------------------------------------
function addLink()
{
	echo "<h4>"._WEBLINKS_ADMIN_ADD_LINK."</h4>\n";

	$total = $this->_link_edit_handler->getCount();

	printf(_WLS_THEREARE, $total);
    echo "<br /><br />\n";

	$this->_link_form_handler->show_admin_form('submit');
	echo "<br />\n";

}

function addLinkCheck()
{
	$ret = $this->_link_edit_handler->check_form_addlink( $_POST );
	return $ret;
}

function addLinkError()
{
	echo "<h4>"._WEBLINKS_ADMIN_ADD_LINK."</h4>\n";
	echo "<hr />\n";
	echo $this->_link_edit_handler->get_error_msg_addlink();
	echo "<hr />\n";

	$this->_link_form_handler->show_admin_form('submit_preview');
}

function addLinkS()
{
// add link & catlink
	$newid = $this->_link_edit_handler->add_link($_POST);
	if (!$newid)
	{
		$this->_set_errors( $this->_link_edit_handler->getErrors() );
		return false;
	}

// notification
	list($tags, $cid) = $this->_link_edit_handler->build_tags_addlink($newid);

	$notification_handler =& xoops_gethandler('notification');
	$notification_handler->triggerEvent('global', 0, 'new_link', $tags);
	$notification_handler->triggerEvent('category', $cid, 'new_link', $tags);

	return true;
}

//---------------------------------------------------------
// modLink
//---------------------------------------------------------
function existLink()
{
	$lid = 0;
	if ( isset($_GET['lid']) )  $lid = intval( $_GET['lid'] );

	$ret = $this->_link_edit_handler->check_exist_link($lid);
	return $ret;
}

function modLink()
{
	$lid = 0;
	if ( isset($_GET['lid']) )  $lid = intval( $_GET['lid'] );

   	echo "<h4>"._WLS_MODLINK."</h4><br />";

	$this->_link_form_handler->show_admin_form('modify', $lid);
	echo "<hr />\n";

	$totalvotes = $this->_votedata_handler->get_count_by_lid($lid);

    echo "<table width=\"100%\">\n";
    echo "<tr><td colspan=\"7\"><b>";
	printf(_WLS_TOTALVOTES,$totalvotes);
	echo "</b><br /><br /></td></tr>\n";

// Show Registered Users Votes
	$votedata_objs1 = $this->_votedata_handler->get_objects_user_by_lid($lid);
	$votes = count($votedata_objs1);

    echo "<tr><td colspan=\"7\"><br /><br /><b>";
	printf(_WLS_USERTOTALVOTES,$votes);
	echo "</b><br /><br /></td></tr>\n";
    echo "<tr><td><b>" ._WLS_USER."  </b></td><td><b>" ._WLS_IP."  </b></td><td><b>" ._WLS_RATING."  </b></td><td><b>" ._WLS_USERAVG."  </b></td><td><b>" ._WLS_TOTALRATE."  </b></td><td><b>" ._WLS_DATE."  </b></td><td align=\"center\"><b>" ._WLS_DELETE."</b></td></tr>\n";

    if ($votes == 0)
    {
		echo "<tr><td align=\"center\" colspan=\"7\">" ._WLS_NOREGVOTES."<br /></td></tr>\n";
    }

    $x=0;
    $colorswitch="dddddd";

	foreach ($votedata_objs1 as $obj)
	{
		$ratingid        = $obj->getVar('ratingid');
		$ratinguser      = $obj->getVar('ratinguser');
		$rating          = $obj->getVar('rating');
		$ratinghostname  = $obj->getVar('ratinghostname');
		$ratingtimestamp = $obj->getVar('ratingtimestamp');
		$ratingusername  = $obj->get_uname();
		$formatted_date  = $obj->get_formatted_timestamp();

		$opt_del = array(
			'op'  => 'delVote',
			'lid' => $lid,
			'rid' => $ratingid,
		);

		list($uservotes, $useravgrating) = 
			$this->_votedata_handler->calc_rating_by_uid($ratinguser);

        echo "<tr><td bgcolor=\"".$colorswitch."\">".$ratingusername."</td>";
        echo "<td bgcolor=\"$colorswitch\">".$ratinghostname."</td>";
        echo "<td bgcolor=\"$colorswitch\">$rating</td>";
        echo "<td bgcolor=\"$colorswitch\">".$useravgrating."</td>";
        echo "<td bgcolor=\"$colorswitch\">".$uservotes."</td>";
        echo "<td bgcolor=\"$colorswitch\">".$formatted_date."</td>";
        echo "<td bgcolor=\"$colorswitch\" align=\"center\"><b>";
	 	echo $this->_form->make_form_box_option( "link_manage.php", "X", $opt_del );
        echo "</b></td></tr>\n";

    	$x++;

    	if ( $colorswitch == "dddddd" )
    	{
			$colorswitch="ffffff";
    	}
    	else 
    	{
			$colorswitch="dddddd";
		}
    }

// Show Unregistered Users Votes
	$votedata_objs2 = $this->_votedata_handler->get_objects_by_lid_uid($lid, 0);
	$votes = count($votedata_objs2);

    echo "<tr><td colspan=\"7\"><b><br /><br />";
	printf(_WLS_ANONTOTALVOTES,$votes);
	echo "</b><br /><br /></td></tr>\n";
    echo "<tr><td colspan=\"2\"><b>" ._WLS_IP."  </b></td><td colspan=\"3\"><b>" ._WLS_RATING."  </b></td><td><b>" ._WLS_DATE."  </b></b></td><td align=\"center\"><b>" ._WLS_DELETE."</b></td><br /></tr>\n";

    if ( $votes == 0 ) 
    {
		echo "<tr><td colspan=\"7\" align=\"center\">" ._WLS_NOUNREGVOTES."<br /></td></tr>";
    }

    $x=0;
    $colorswitch="dddddd";

	foreach ($votedata_objs2 as $obj)
	{
		$ratingid        = $obj->getVar('ratingid');
		$ratinguser      = $obj->getVar('ratinguser');
		$rating          = $obj->getVar('rating');
		$ratinghostname  = $obj->getVar('ratinghostname');
		$ratingtimestamp = $obj->getVar('ratingtimestamp');
		$formatted_date  = $obj->get_formatted_timestamp();

		$opt_del = array(
			'op'  => 'delVote',
			'lid' => $lid,
			'rid' => $ratingid,
		);

        echo "<td colspan=\"2\" bgcolor=\"$colorswitch\">$ratinghostname</td>";
        echo "<td colspan=\"3\" bgcolor=\"$colorswitch\">$rating</td>";
        echo "<td bgcolor=\"$colorswitch\">$formatted_date</td>";
        echo "<td bgcolor=\"$colorswitch\" aling=\"center\"><b>";
	 	echo $this->_form->make_form_box_option( "link_manage.php", "X", $opt_del );

        echo "</b></td></tr>\n";

    	$x++;

    	if ( $colorswitch == "dddddd" ) 
    	{
			$colorswitch="ffffff";
    	}
    	else 
    	{
			$colorswitch="dddddd";
		}
	}

 	echo "<tr><td colspan=\"6\">&nbsp;<br /></td></tr>\n";
	echo "</table>\n";

}

function modLinkCheck()
{
	$ret = $this->_link_edit_handler->check_form_modlink_for_owner( $_POST );
	return $ret;
}

function modLinkError()
{
	echo "<h4>"._WLS_MODLINK."</h4><br />";
	echo "<hr />\n";
	echo $this->_link_edit_handler->get_error_msg_modlink();
	echo "<hr />\n";

	$this->_link_form_handler->show_admin_form('modify_preview');
}

function modLinkS()
{
	$this->_clear_errors();

	$lid = 0;
	if ( isset($_POST['lid']) )  $lid = intval( $_POST['lid'] );

// update link & catlink
	$ret = $this->_link_edit_handler->mod_link( $lid, $_POST );
	if (!$ret)
	{
		$this->_set_errors( $this->_link_edit_handler->getErrors() );
	}

// delete broken
	$broken_count = $this->_broken_handler->get_count_by_lid($lid);
	if ( $broken_count > 0 )
	{
		$ret = $this->_broken_handler->delete_by_lid($lid);
		if (!$ret)
		{
			$this->_set_errors( $this->_broken_handler->getErrors() );
		}
	}

	return $this->returnExistError();
}

//---------------------------------------------------------
// delLink
//---------------------------------------------------------
function delLink()
{
	$lid = 0;
	if     ( isset($_POST['lid']) )  $lid = intval( $_POST['lid'] );
	elseif ( isset($_GET['lid']) )   $lid = intval( $_GET['lid'] );

// BUG 3095: the number of links does not change, if delete link
	$ret = $this->_link_edit_handler->del_link_vote_comm_catlink_by_lid($lid);
	if (!$ret)
	{
		$this->_set_errors( $this->_link_edit_handler->getErrors() );
		return false;
	}

	return true;
}

//---------------------------------------------------------
// token ticket
//---------------------------------------------------------
function check_token( $name='' )
{
	return $this->_form->check_token($name);
	return $ret;
}

// --- class end ---
}

//=========================================================
// main
//=========================================================
include_once XOOPS_ROOT_PATH."/include/xoopscodes.php";
include_once XOOPS_ROOT_PATH."/class/xoopsformloader.php";

include_once WEBLINKS_ROOT_PATH."/class/weblinks_votedata_handler.php";
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_form.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_pagenavi.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_page_frame.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_sendmail.php';
include_once WEBLINKS_ROOT_PATH."/admin/modify.php";
include_once WEBLINKS_ROOT_PATH."/admin/votedata.php";

$link_manage     =& admin_link_manage::getInstance();
$modify_manage   =& admin_modify_manage::getInstance();
$votedata_manage =& admin_votedata_manage::getInstance();

// constant
$WEBLINKS_MAX_LINK_IN_DETAIL =  5;
$WEBLINKS_MAX_LINK_IN_PAGE   = 10;

$op = 'main';
if     ( isset($_POST['delete_link']) )  $op = 'delete_link';
elseif ( isset($_POST['delete_new']) )   $op = 'delete_new';
elseif ( isset($_POST['ignore']) )       $op = 'ignore';
elseif ( isset($_POST['op']) )           $op = $_POST['op'];
elseif ( isset($_GET['op']) )            $op = $_GET['op'];

// start
$link_manage->init();

switch ($op) 
{
case "addLinkS":
	if( !( $link_manage->check_token() ) ) 
	{
		redirect_header("link_list.php", 5, "Token Error");
		exit();
	}

	if ( !( $link_manage->addLinkCheck() ) )
	{
		xoops_cp_header();
		$link_manage->addLinkError();
		xoops_cp_footer();
		exit();
	}

	$ret = $link_manage->addLinkS();
	if ($ret)
	{
		redirect_header('link_list.php?sortid=1', 1, _WLS_NEWLINKADDED);
	}
	else
	{
		xoops_cp_header();
		xoops_error("DB Error");
		echo $link_manage->getErrors(1);
		weblinks_admin_print_menu();
		xoops_cp_footer();
	}

	break;

case "modLink":
	if ( !( $link_manage->existLink() ) )
	{
		redirect_header("link_list.php", 5, _WLS_ERRORNOLINK);
		exit();
	}

	xoops_cp_header();
	weblinks_admin_print_header();
	weblinks_admin_print_menu();
	$link_manage->modLink();
	xoops_cp_footer();
	break;

case "modLinkS":
	if( !( $link_manage->check_token() ) ) 
	{
		redirect_header("link_list.php", 5, "Token Error");
		exit();
	}

	if ( !( $link_manage->modLinkCheck() ) )
	{
		xoops_cp_header();
		$link_manage->modLinkError();
		xoops_cp_footer();
		exit();
	}

	$ret = $link_manage->modLinkS();
	if ($ret)
	{
		redirect_header('link_list.php', 1, _WLS_DBUPDATED);
	}
	else
	{
		xoops_cp_header();
		xoops_error("DB Error");
		echo $link_manage->getErrors(1);
		weblinks_admin_print_menu();
		xoops_cp_footer();
	}

	break;

case 'delete_link';
case "delLink":
	if( !( $link_manage->check_token() ) ) 
	{
		redirect_header("link_list.php", 5, "Token Error");
		exit();
	}

	$ret = $link_manage->delLink();
	if ($ret)
	{
		redirect_header('link_list.php', 1, _WLS_LINKDELETED);
	}
	else
	{
		xoops_cp_header();
		xoops_error("DB Error");
		echo $link_manage->getErrors(1);
		weblinks_admin_print_menu();
		xoops_cp_footer();
	}

	break;

case "listNewLinks":
	xoops_cp_header();
	weblinks_admin_print_header();
	weblinks_admin_print_menu();
	$modify_manage->listNewLinks();
	xoops_cp_footer();
	break;

case 'delete_new';
case "delNewLink":
	if( !( $link_manage->check_token() ) ) 
	{
		redirect_header("link_list.php", 5, "Token Error");
		exit();
	}

	$ret1 = $modify_manage->delNewLink();
	if ( $ret1 )
	{
		$ret2 = $modify_manage->send_refuse();
		if ( $ret2 )
		{
			$redirect = $modify_manage->get_redirect_at_new();
			redirect_header($redirect, 1, _WLS_LINKDELETED);
		}
		else
		{
			xoops_cp_header();
			xoops_error("Mailer Error");
			echo $modify_manage->getErrors(1);
			weblinks_admin_print_menu();
			xoops_cp_footer();
		}
	}
	else
	{
		xoops_cp_header();
		xoops_error("DB Error");
		echo $modify_manage->getErrors(1);
		weblinks_admin_print_menu();
		xoops_cp_footer();
	}

	break;

case "approve":
	if( !( $link_manage->check_token() ) ) 
	{
		redirect_header("link_list.php", 5, "Token Error");
		exit();
	}

	if ( !( $modify_manage->approveCheck() ) )
	{
		xoops_cp_header();
		$modify_manage->approveError();
		xoops_cp_footer();
		exit();
	}

	$ret1 = $modify_manage->approve();
	if ( $ret1 )
	{
		$ret2 = $modify_manage->send_approve();
		if ( $ret2 )
		{
			$redirect = $modify_manage->get_redirect_at_new();
			redirect_header($redirect, 1, _WLS_NEWLINKADDED);
		}
		else
		{
			xoops_cp_header();
			xoops_error("Mailer Error");
			echo $modify_manage->getErrors(1);
			weblinks_admin_print_menu();
			xoops_cp_footer();
		}
	}
	else
	{
		xoops_cp_header();
		xoops_error("DB Error");
		echo $modify_manage->getErrors(1);
		weblinks_admin_print_menu();
		xoops_cp_footer();
	}

	break;

case "listModReq":
	xoops_cp_header();
	weblinks_admin_print_header();
	weblinks_admin_print_menu();
	$modify_manage->listModReq();
	xoops_cp_footer();
	break;

case "approveModReq":
	if( !( $link_manage->check_token() ) ) 
	{
		redirect_header("link_list.php", 5, "Token Error");
		exit();
	}

	if ( !( $modify_manage->approveModReqCheck() ) )
	{
		xoops_cp_header();
		$modify_manage->approveModReqError();
		xoops_cp_footer();
		exit();
	}

	$ret = $modify_manage->approveModReq();
	if ( $ret )
	{
		$redirect = $modify_manage->get_redirect_at_mod();
		redirect_header($redirect, 1, _WLS_DBUPDATED);
	}
	else
	{
		xoops_cp_header();
		xoops_error("DB Error");
		echo $modify_manage->getErrors(1);
		weblinks_admin_print_menu();
		xoops_cp_footer();
	}

	break;

case 'ignore';
case "ignoreModReq":
	if( !( $link_manage->check_token() ) ) 
	{
		redirect_header("link_list.php", 5, "Token Error");
		exit();
	}

	$ret = $modify_manage->ignoreModReq();
	if ( $ret )
	{
		$redirect = $modify_manage->get_redirect_at_mod();
		redirect_header($redirect, 1, _WLS_MODREQDELETED);
	}
	else
	{
		xoops_cp_header();
		xoops_error("DB Error");
		echo $modify_manage->getErrors(1);
		weblinks_admin_print_menu();
		xoops_cp_footer();
	}

	break;

case "delVote":
	if( !( $link_manage->check_token() ) ) 
	{
		redirect_header("link_list.php", 5, "Token Error");
		exit();
	}

	$ret = $votedata_manage->delVote();
	if ( $ret )
	{
		redirect_header("link_list.php", 1, _WLS_VOTEDELETED);
	}
	else
	{
		xoops_cp_header();
		xoops_error("DB Error");
		echo $votedata_manage->getErrors(1);
		weblinks_admin_print_menu();
		xoops_cp_footer();
	}

	break;

case 'main':
case "addLink":
default:
	xoops_cp_header();
	weblinks_admin_print_header();
	weblinks_admin_print_menu();
	$link_manage->addLink();
	xoops_cp_footer();
	break;

}

exit();
// --- end of main ---

?>