<?php
// $Id: rss_manage.php,v 1.5 2006/05/24 01:15:19 ohwada Exp $

// 2006-05-15 K.OHWADA
// new handler
// add class admin_rss_manage
// use token ticket

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//=========================================================
// WebLinks Module
// admin RSS/ATOM manage
// 2004-11-28 K.OHWADA
//=========================================================

include 'admin_header.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_rss_atom_parser_base.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_rss_parser.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_atom_parser.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_rss_atom_collect_handler.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_link_check_handler.php';


//=========================================================
// class admin_rss_manage
//=========================================================
class admin_rss_manage
{
	var $_link_handler;
	var $_atomfeed_handler;
	var $_rss_form;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_rss_manage()
{
	$config_handler                =& weblinks_get_handler('config2_basic',  WEBLINKS_DIRNAME);
	$this->_link_handler           =& weblinks_get_handler('link',           WEBLINKS_DIRNAME);
	$this->_atomfeed_handler       =& weblinks_get_handler('atomfeed',       WEBLINKS_DIRNAME);
	$this->_atomfeed_basic_handler =& weblinks_get_handler('atomfeed_basic', WEBLINKS_DIRNAME);
	$this->_rss_form =& admin_rss_manage_form::getInstance();

	$conf = $config_handler->get_cached();
	$this->_conf_rss_limit = $conf['rss_limit'];

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_rss_manage();
	}
	return $instance;
}

//---------------------------------------------------------
// function
//---------------------------------------------------------
function get_count_rss_flag()
{
	$ret = $this->_link_handler->get_count_rss_flag();
	return $ret;
}

function print_top($total_site_rss)
{
	$total_link     = $this->_link_handler->getCount();
	$total_atomfeed = $this->_atomfeed_handler->getCount();

	$url_rss  = WEBLINKS_URL."/viewmark.php?mark=rss";
	$url_feed = WEBLINKS_URL."/viewfeed.php";

	echo "<h3>"._WEBLINKS_ADMIN_RSS_MANAGE."</h3>\n";

	echo "<table width='80%' border='0' cellspacing='1' class='outer'>";
	echo "<tr class='odd'><td>";
	echo "<ul>\n";
	echo "<li><a href='$url_rss'>"._WLS_SITE_RSS."</a> ($total_site_rss) </li>\n";
	echo "<li><a href='$url_feed'>"._WLS_ATOMFEED."</a> ($total_atomfeed)</li>\n";
	echo "</ul><br /><ul>\n";
	echo "<li><a href='#refresh'>"._WEBLINKS_ADMIN_RSS_REFRESH."</a></li>\n";
	echo "<li><a href='#clear'>"._WEBLINKS_ADMIN_RSS_CACHE_CLEAR."</a></li>\n";
	echo "</ul>\n";
	echo"</td></tr></table>\n";

	echo "<br /><br />\n";
	printf(_WLS_THEREARE, $total_link);

}

function print_form($limit, $offset)
{
	$num = $this->_conf_rss_limit;
	if ( isset($_POST['num']) )  $num = intval( $_POST['num'] );

	echo "<a name='refresh'></a>";
	echo "<h4>"._WEBLINKS_ADMIN_RSS_REFRESH."</h4>\n";
	echo _WEBLINKS_ADMIN_LINK_BROKEN_CHECK_CAUTION."<br />\n";
	$this->_rss_form->show_refresh_link($limit, $offset);
	echo "<br />\n";
	$this->_rss_form->show_refresh_site();

	echo "<a name='clear'></a>";
	echo "<h4>"._WEBLINKS_ADMIN_RSS_CACHE_CLEAR."</h4>\n";
	$this->_rss_form->show_clear_num($num);
	$this->_rss_form->show_clear_lid();
	$this->_rss_form->show_clear_all();

}

function print_form_next($limit, $offset)
{
	$this->_rss_form->show_next($limit, $offset);
}

function clear_num()
{
	$num = 0;
	if ( isset($_POST['num']) )  $num = intval( $_POST['num'] );

	$del = $this->_atomfeed_basic_handler->clear_over_num( $num );

	if ($del == 0)
	{
		echo "<font color='blue'>"._WEBLINKS_NON."</font><br />";
		return;
	}

	$text  = "<br />\n";
	$text .= "<table><tr>";
	$text .= "<tr><td>"._WEBLINKS_NUM_RSS_CLEAR_ATOMFEED."</td>";
	$text .= "<td>$del "._WEBLINKS_ADMIN_NUM."</td></tr>\n";
	$text .= "</table>\n";
	echo $text;

	return;
}

function clear_lid()
{
	$lid = 0;
	if ( isset($_POST['lid']) )  $lid = intval( $_POST['lid'] );

	$num_feed = $this->_atomfeed_handler->get_count_by_lid($lid);

// exec
	$this->clear_link_by_lid($lid);
	$this->_atomfeed_handler->delete_by_lid($lid);

	$text  = "<br /><br />\n";
	$text .= "<table><tr>";
	$text .= "<tr><td>"._WEBLINKS_NUM_RSS_CLEAR_ATOMFEED."</td>";
	$text .= "<td>$num_feed "._WEBLINKS_ADMIN_NUM."</td></tr>\n";
	$text .= "</table>\n";
	echo $text;

	return;
}

function clear_link_by_lid($lid)
{
	$lid =  intval($lid);
	$obj =& $this->_link_handler->get($lid);
	$obj->setVar('rss_update', 0);
	$obj->setVar('rss_xml',    '');
	$ret = $this->_link_handler->update($obj);
	return $ret;
}

function clear_all()
{
	$num_link_all = $this->_link_handler->getCount();

	$objs = $this->_link_handler->get_objects_rss_by_orderby();
	$num_link_clear = count($objs);

	$time_start = time();

// --- table start ---
	$time_now = $this->get_time_now();
	echo "<br />"._WEBLINKS_ADMIN_TIME_START." $time_now<br /><br />\n";

	foreach($objs as $obj)
	{
		echo ".";
		$lid = $obj->getVar('lid', 'n');
		$this->clear_link_by_lid($lid);
		$this->_atomfeed_handler->delete_by_lid($lid);
	}

// --- table end ---
	$time_now    = $this->get_time_now();
	$time_elapse = $this->get_time_elapse($time_start);

	$text  = "<br /><br />\n";
	$text .= _WEBLINKS_ADMIN_TIME_END." $time_now<br /><br />\n";
	$text .= "<table><tr>";
	$text .= "<tr><td>"._WEBLINKS_ADMIN_LINK_NUM_ALL."</td>";
	$text .= "<td>$num_link_all "._WEBLINKS_ADMIN_NUM."</td></tr>\n";
	$text .= "<tr><td>"._WEBLINKS_NUM_RSS_CLEAR_LINK."</td>";
	$text .= "<td>$num_link_clear "._WEBLINKS_ADMIN_NUM."</td></tr>\n";
	$text .= "<tr><td>"._WEBLINKS_ADMIN_TIME_ELAPSE."</td>";
	$text .= "<td>$time_elapse</td></tr>\n";
	$text .= "</table>\n";
	echo $text;

	return;
}

function get_time_now()
{
	$ret = date("Y-m-d H:i:s");
	return $ret;
}

function get_time_elapse($time_start)
{
	$time = time() - $time_start;
	$min  = intval($time/60);
	$sec  = $time - 60*$min;
	$ret  = sprintf(_WEBLINKS_ADMIN_MIN_SEC, $min, $sec);
	return $ret;
}

//---------------------------------------------------------
// token ticket
//---------------------------------------------------------
function check_token( $name='' )
{
	$ret = $this->_rss_form->check_token($name);
	return $ret;
}

// --- class end ---
}


//=========================================================
// class admin_rss_manage_form
//=========================================================
class admin_rss_manage_form extends weblinks_form
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_rss_manage_form()
{
	$this->weblinks_form();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_rss_manage_form();
	}
	return $instance;
}

//---------------------------------------------------------
// function
//---------------------------------------------------------
function show_refresh_link($limit, $offset)
{
	echo $this->make_form_start( 'refresh_link' );
	echo $this->make_form_token();
	echo $this->make_form_hidden('op', 'refresh_link');
	echo $this->make_table_start();
	echo $this->make_table_title( _WEBLINKS_ADMIN_RSS_REFRESH_LINK );

	echo $this->make_table_form_text(_WEBLINKS_ADMIN_LIMIT,  'limit',  $limit);
	echo $this->make_table_form_text(_WEBLINKS_ADMIN_OFFSET, 'offset', $offset);
	echo $this->make_table_form_submit( '', 'post', _WEBLINKS_UPDATE );

	echo $this->make_table_end();
	echo $this->make_form_end();

	echo "<br />\n";

}

function show_refresh_site()
{
	echo $this->make_form_start( 'refresh_site' );
	echo $this->make_form_token();
	echo $this->make_form_hidden('op', 'refresh_site');
	echo $this->make_table_start();
	echo $this->make_table_title( _WEBLINKS_ADMIN_RSS_REFRESH_SITE );

	echo $this->make_table_form_submit( '', 'post', _WEBLINKS_UPDATE );

	echo $this->make_table_end();
	echo $this->make_form_end();

}

function show_clear_num($num)
{
	echo $this->make_form_start( 'clear_num' );
	echo $this->make_form_token();
	echo $this->make_form_hidden('op', 'clear_num');
	echo $this->make_table_start();
	echo $this->make_table_title( _WEBLINKS_RSS_CLEAR_NUM );

	echo $this->make_table_form_text(_WEBLINKS_RSS_NUMBER, 'num', $num);
	echo $this->make_table_form_submit( '', 'post', _WEBLINKS_CLEAR );

	echo $this->make_table_end();
	echo $this->make_form_end();

}

function show_clear_lid()
{
	echo $this->make_form_start( 'clear_lid' );
	echo $this->make_form_token();
	echo $this->make_form_hidden('op', 'clear_lid');
	echo $this->make_table_start();
	echo $this->make_table_title( _WEBLINKS_RSS_CLEAR_LID );

	echo $this->make_table_form_text(_WLS_LINKID, 'lid', '');
	echo $this->make_table_form_submit( '', 'post', _WEBLINKS_CLEAR );

	echo $this->make_table_end();
	echo $this->make_form_end();
}

function show_clear_all()
{
	echo $this->make_form_start( 'clear_all' );
	echo $this->make_form_token();
	echo $this->make_form_hidden('op', 'clear_all');
	echo $this->make_table_start();
	echo $this->make_table_title( _WEBLINKS_RSS_CLEAR_ALL );

	echo $this->make_table_form_submit( '', 'post', _WEBLINKS_CLEAR );

	echo $this->make_table_end();
	echo $this->make_form_end();
}

function show_next($limit, $offset)
{
	$opt = array(
		'op'     => 'refresh',
		'limit'  => $limit,
		'offset' => $offset, 
	);

	$submit = sprintf(_WEBLINKS_ADMIN_CHECK_NEXT, $limit);

	echo $this->make_form_box_option( '', $submit, $opt );

}

// --- class end ---
}


//=========================================================
// main
//=========================================================
$link_check =& weblinks_get_handler( 'link_check', WEBLINKS_DIRNAME );
$rss_manage =& admin_rss_manage::getInstance();

xoops_cp_header();

$op = '';
if ( isset($_POST['op']) )  $op = $_POST['op'];

$limit  = 0;
$offset = 0;
if ( isset($_POST['limit']) )   $limit  = intval( $_POST['limit'] );
if ( isset($_POST['offset']) )  $offset = intval( $_POST['offset'] );

if ($limit  < 0)  $limit  = 0;
if ($offset < 0)  $offset = 0;

$total_site_rss = $rss_manage->get_count_rss_flag();
$flag_error = false;

if ($op != '')
{
	if( !( $rss_manage->check_token() ) ) 
	{
		xoops_error("Token Error");
		$flag_error = true;
	}
}

weblinks_admin_print_header();
weblinks_admin_print_menu();

$rss_manage->print_top($total_site_rss);
$rss_manage->print_form($limit, $offset);

if ( $flag_error )
{
	xoops_cp_footer();
	exit();
}

if ($op == 'refresh_link')
{
	echo "<hr />\n";
	$link_check->refresh_link($limit, $offset);

// next
	$next = $offset + $limit;
	if (($limit > 0) && ($next < $total_site_rss))
	{
		$rss_manage->print_form_next($limit, $next);
	}

	echo "<hr />\n";
}
elseif ($op == 'refresh_site')
{
	echo "<hr />\n";
	$link_check->refresh_site();
	echo "<hr />\n";
}
elseif ($op == 'clear_num')
{
	echo "<hr />\n";
	$rss_manage->clear_num();
	echo "<hr />\n";
}
elseif ($op == 'clear_lid')
{
	echo "<hr />\n";
	$rss_manage->clear_lid();
	echo "<hr />\n";
}
elseif ($op == 'clear_all')
{
	echo "<hr />\n";
	$rss_manage->clear_all();
	echo "<hr />\n";
}

xoops_cp_footer();
exit();
// --- end of main ---

?>