<?php
// $Id: weblinks_atomfeed_basic_handler.php,v 1.1 2006/05/24 01:23:56 ohwada Exp $

// 2006-05-15 K.OHWADA
// this is new file
// use new handler

//=========================================================
// WebLinks Module
// 2006-05-15 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_atomfeed_basic_handler') ) 
{

//=========================================================
// class weblinks_atomfeed_basic_handler
// this class is used by command line
// this class handle MySQL table directly
// this class does not use another class
//=========================================================
class weblinks_atomfeed_basic_handler extends weblinks_db_basic_base
{
// local
	var $_atom_obj = array();

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_atomfeed_basic_handler( $dirname )
{
	$this->weblinks_db_basic_base( $dirname, 'atomfeed' );

	$this->set_debug_sql(   WEBLINKS_DEBUG_ATOMFEED_BASIC_SQL );
	$this->set_debug_error( WEBLINKS_DEBUG_ERROR );

}

//---------------------------------------------------------
// object
//---------------------------------------------------------
function create()
{
	$this->_atom_obj = array();

	$this->set_var('aid',           0 );
	$this->set_var('lid',           0 );
	$this->set_var('site_title',   '' );
	$this->set_var('site_url',     '' );
	$this->set_var('title',        '' );
	$this->set_var('url',          '' );
	$this->set_var('entry_id',     '' );
	$this->set_var('guid',         '' );
	$this->set_var('time_modified', 0 );
	$this->set_var('time_issued',   0 );
	$this->set_var('time_created',  0 );
	$this->set_var('author_name',  '' );
	$this->set_var('author_url',   '' );
	$this->set_var('author_email', '' );
	$this->set_var('content',      '' );

}

function set_vars_array($arr)
{
	$this->set_var_array($arr, 'aid' );
	$this->set_var_array($arr, 'lid' );
	$this->set_var_array($arr, 'site_title' );
	$this->set_var_array($arr, 'site_url' );
	$this->set_var_array($arr, 'title' );
	$this->set_var_array($arr, 'url' );
	$this->set_var_array($arr, 'entry_id' );
	$this->set_var_array($arr, 'guid' );
	$this->set_var_array($arr, 'time_modified' );
	$this->set_var_array($arr, 'time_issued' );
	$this->set_var_array($arr, 'time_created' );
	$this->set_var_array($arr, 'author_name' );
	$this->set_var_array($arr, 'author_url' );
	$this->set_var_array($arr, 'author_email' );
	$this->set_var_array($arr, 'content' );

	return $this->_atom_obj;
}

function set_var_array($arr, $key)
{
	if ( isset($arr[$key]) )
	{
		$this->_atom_obj[$key] = $arr[$key];
	}
}

function set_var($key, $value)
{
	$this->_atom_obj[$key] = $value;
}

//---------------------------------------------------------
// insert
//---------------------------------------------------------
function insert( &$atom_arr )
{
	foreach ($atom_arr as $k => $v) 
	{	${$k} = $v;	}

	$sql  = 'INSERT INTO '.$this->_table.' (';
	$sql .= 'lid, ';
	$sql .= 'site_title, ';
	$sql .= 'site_url, ';
	$sql .= 'title, ';
	$sql .= 'url, ';
	$sql .= 'entry_id, ';
	$sql .= 'guid, ';
	$sql .= 'time_modified, ';
	$sql .= 'time_issued, ';
	$sql .= 'time_created, ';
	$sql .= 'author_name, ';
	$sql .= 'author_url, ';
	$sql .= 'author_email, ';
	$sql .= 'content ';
	$sql .= ') VALUES (';
	$sql .= intval($lid).', ';
	$sql .= $this->_quote($site_title).', ';
	$sql .= $this->_quote($site_url).', ';
	$sql .= $this->_quote($title).', ';
	$sql .= $this->_quote($url).', ';
	$sql .= $this->_quote($entry_id).', ';
	$sql .= $this->_quote($guid).', ';
	$sql .= intval($time_modified).', ';
	$sql .= intval($time_issued).', ';
	$sql .= intval($time_created).', ';
	$sql .= $this->_quote($author_name).', ';
	$sql .= $this->_quote($author_url).', ';
	$sql .= $this->_quote($author_email).', ';
	$sql .= $this->_quote($content).' ';
	$sql .= ')';

	if ( !$this->_query($sql) ) 
	{	return false;	}

	$newid = $this->_db->getInsertId();
	return $newid;
}

//---------------------------------------------------------
// delete
//---------------------------------------------------------
function delete_by_aid($aid)
{ 
	$sql = 'DELETE FROM '.$this->_table.' WHERE aid='.intval($aid);
	$ret = $this->_query($sql);
	return $ret;
}

function delete_by_url($url)
{ 
	$sql = 'DELETE FROM '.$this->_table.' WHERE url='.$this->_quote($url);
	$ret = $this->_query($sql);
	return $ret;
}

//---------------------------------------------------------
// get_count
//---------------------------------------------------------
function get_count_all()
{
	$sql = 'SELECT count(*) FROM '.$this->_table;
	$count = $this->get_count_by_sql($sql);
	return $count;
}

function get_count_by_url_time($url, $time)
{
	$sql = 'SELECT count(*) FROM '.$this->_table.' WHERE url='.$this->_quote($url).' AND time_modified>='.intval($time);
	$count = $this->get_count_by_sql($sql);
	return $count;
}

function get_count_by_url($url)
{
	$sql = 'SELECT count(*) FROM '.$this->_table.' WHERE url='.$this->_quote($url);
	$count = $this->get_count_by_sql($sql);
	return $count;
}

//---------------------------------------------------------
// get_aid array
//---------------------------------------------------------
function &get_aid_array_older($limit=0, $offset=0)
{
	$sql = 'SELECT aid FROM '.$this->_table.' ORDER BY time_modified ASC';
	$arr =& $this->get_first_row_by_sql($sql, $limit, $offset);
	return $arr;
}

//---------------------------------------------------------
// clear atomfeed
//---------------------------------------------------------
function clear_over_num($num)
{
	if ($num <= 0)
	{
		return 0;	// non
	}

	$total = $this->get_count_all();
	if ($total < $num)
	{
		return 0;	// non
	}

	$limit   = $total - $num;
	$aid_arr = $this->get_aid_array_older($limit);

// exec
	foreach( $aid_arr as $aid )
	{
		$this->delete_by_aid($aid);
	}

	return $limit;	// excute
}

//---------------------------------------------------------
// refresh atomfeed
//---------------------------------------------------------
function refresh($item)
{
	$url  = $this->get_var_from_item($item, 'url');
	$time = $this->get_var_from_item($item, 'time');

// return , if already exit
	$count_time = $this->get_count_by_url_time($url, $time);
	if ($count_time)  { return false; }

// delete old, if exist
	$count_url = $this->get_count_by_url($url);
	if ($count_url) 
	{
		$this->delete_by_url($url);
	}

// add new
	$this->create();
	$atom_obj = $this->set_vars_array($item);
	$ret = $this->insert( $atom_obj );

    return $ret;
}

function get_var_from_item($item, $key)
{
	if ( isset($item[$key]) )
	{
		$ret = $item[$key];
		return $ret;
	}

	return null;
}

// --- class end ---
}

// === class end ===
}

?>