<?php
// $Id: weblinks_broken_handler.php,v 1.4 2006/05/24 01:23:56 ohwada Exp $

// 2006-05-15 K.OHWADA
// new handler
// not use weblinks_module_base

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//=========================================================
// WebLinks Module
// this file contain 2 class
//   weblinks_broken 
//   weblinks_broken_handler
// 2004/01/14 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_broken_handler') ) 
{

//=========================================================
// class weblinks_broken
//=========================================================
class weblinks_broken extends weblinks_object
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_broken()
{
	$this->weblinks_object();

	$this->initVar('bid',    XOBJ_DTYPE_INT, 0, false);
	$this->initVar('lid',    XOBJ_DTYPE_INT, 0, false);
	$this->initVar('sender', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('ip',     XOBJ_DTYPE_TEXT);
}

//---------------------------------------------------------
// function
//---------------------------------------------------------
function get_uname( $usereal=0 )
{
	$uid = $this->get('sender');
	$user_handler =& xoops_gethandler('user');
	$user_obj = $user_handler->get( $uid );
	$uname = '';

	if ( is_object($user_obj) )
	{
		$uname = $user_obj->getUnameFromId( $uid, $usereal );
	}

	return $uname;
}

function get_email( $format='s' )
{
	$uid = $this->get('sender');
	$user_handler =& xoops_gethandler('user');
	$user_obj = $user_handler->get( $uid );
	$email = '';

	if ( is_object($user_obj) )
	{
		$email = $user_obj->getVar( 'email', $format );
	}

	return $email;
}

// --- class end ---
}

//=========================================================
// class weblinks_broken_handler
//=========================================================
class weblinks_broken_handler extends weblinks_object_handler
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_broken_handler( $dirname )
{
	$this->weblinks_object_handler( $dirname, 'broken', 'bid' );

	$this->set_debug_sql(   WEBLINKS_DEBUG_BROKEN_SQL );
	$this->set_debug_error( WEBLINKS_DEBUG_ERROR );

}

//---------------------------------------------------------
// delete
//---------------------------------------------------------
function delete_by_lid($lid, $force=false)
{
	$lid = intval($lid);
	$sql = 'DELETE FROM '.$this->mTable.' WHERE lid='.$lid;

	if ( !$this->query($sql, 0, 0, $force) )
	{	return false;	}

	return true;
}

//---------------------------------------------------------
// get count
//---------------------------------------------------------
function get_count_by_lid($lid)
{
	$lid = intval($lid);
	$criteria = new weblinks_criteria_compo();
	$criteria->add( new weblinks_criteria('lid', $lid, '=') );
	$ret = $this->getCount($criteria);
	return $ret;
}

function get_count_by_lid_uid($lid, $uid)
{
	$lid = intval($lid);
	$uid = intval($uid);
	$criteria = new weblinks_criteria_compo();
	$criteria->add( new weblinks_criteria('lid',    $lid, '=') );
	$criteria->add( new weblinks_criteria('sender', $uid, '=') );
	$ret = $this->getCount($criteria);
	return $ret;
}

function get_count_by_lid_ip($lid, $ip)
{
	$lid = intval($lid);
	$criteria = new weblinks_criteria_compo();
	$criteria->add( new weblinks_criteria('lid',  $lid, '=') );
	$criteria->add( new weblinks_criteria('ip',   $ip,  '=') );
	$ret = $this->getCount($criteria);
	return $ret;
}

//---------------------------------------------------------
// get objects
//---------------------------------------------------------
function &get_objects_group_by_lid()
{
	$ret = array();
	$limit = $start = 0;

	$sql  = 'SELECT * FROM '.$this->mTable.' ';
	$sql .= 'GROUP BY lid ORDER BY bid DESC';

	$result =& $this->query($sql);
	if ( !$result ) 
	{	return false;	}

	while ( $row = $this->fetchArray($result) ) 
	{
		$obj =& $this->create();
		$obj->assignVars($row);
		$ret[] =& $obj;
		unset($obj);
	}

	return $ret;
}

// --- class end ---
}

// === class end ===
}

?>