<?php
// $Id: weblinks_category_handler.php,v 1.4 2006/09/16 04:16:55 ohwada Exp $

// 2006-08-07 K.OHWADA
// bug: category is html sanitized twice in edit form

// 2006-05-15 K.OHWADA
// new handler
// not use weblinks_module_base
// NOT use another class

// 2006-05-12 K.OHWADA
// BUG 3922: Fatal error when use category image

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//=========================================================
// WebLinks Module
// this file contain 2 class
//   weblinks_category 
//   weblinks_category_handler
// 2004/01/14 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_category_handler') ) 
{

//=========================================================
// class weblinks_category
//=========================================================
class weblinks_category extends weblinks_object
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_category()
{
	$this->weblinks_object();

	$this->initVar('cid',    XOBJ_DTYPE_INT, 0, false);
	$this->initVar('pid',    XOBJ_DTYPE_INT, 0, false);
	$this->initVar('title',  XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('imgurl', XOBJ_DTYPE_URL,    null, false, 255);
	$this->initVar('cflag',      XOBJ_DTYPE_INT, 0, false);
	$this->initVar('lflag',      XOBJ_DTYPE_INT, 0, false);
	$this->initVar('tflag',      XOBJ_DTYPE_INT, 0);
	$this->initVar('displayimg', XOBJ_DTYPE_INT, 0);
	$this->initVar('description',    XOBJ_DTYPE_TEXT);
	$this->initVar('catdescription', XOBJ_DTYPE_TEXT);
	$this->initVar('catfooter',      XOBJ_DTYPE_TEXT);
	$this->initVar('groupid',     XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('orders',      XOBJ_DTYPE_INT,   0);
	$this->initVar('editaccess',  XOBJ_DTYPE_STRING, null, false, 255);
}

//---------------------------------------------------------
// set var
//---------------------------------------------------------
function assign_vars_post($post)
{
	$this->set_var_key($post, 'cid');
	$this->set_var_key($post, 'title');
	$this->set_var_key($post, 'cflag');
	$this->set_var_key($post, 'lflag');
	$this->set_var_key($post, 'tflag');
	$this->set_var_key($post, 'displayimg');
	$this->set_var_key($post, 'description');
	$this->set_var_key($post, 'catdescription');
	$this->set_var_key($post, 'catfooter');
	$this->set_var_key($post, 'groupid');
	$this->set_var_key($post, 'orders');
	$this->set_var_key($post, 'editaccess');
	$this->set_var_key($post, 'imgurl');

	$this->set_pid($post);
}

function set_var_key($post, $key)
{
	if ( isset($post[$key]) )
	{
		$this->setVar($key, $post[$key]);
	}
}

function set_pid($post)
{
	if ( isset($post['pid']) )
	{
		$this->setVar('pid', intval($post['pid']) );
	}
	elseif ( isset($post['cid']) )
	{
		$this->setVar('pid', intval($post['cid']) );
	}
}

// --- class end ---
}

//=========================================================
// class table_category
//=========================================================
class weblinks_category_handler extends weblinks_object_handler
{
// class
	var $_tree;

// config
	var $_conf_cat_sel;

// cache
	var $_cached_objs     = array();
	var $_tree_array      = array();
	var $_tree_info_array = array();

	var $_total_count = 0;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_category_handler( $dirname )
{
	$this->weblinks_object_handler( $dirname, 'category', 'cid' );

	$this->set_debug_sql(   WEBLINKS_DEBUG_CATEGORY_SQL );
	$this->set_debug_error( WEBLINKS_DEBUG_ERROR );

	$this->_tree = new XoopsTree($this->mTable, "cid", "pid");

	$config_basic_handler =& weblinks_get_handler( 'config2_basic', $dirname );
	$conf = $config_basic_handler->get_cached();
	$this->_conf_cat_sel = $conf['cat_sel'];

}

//---------------------------------------------------------
// init
//---------------------------------------------------------
function load()
{
	static $flag_init_load;

	if ( !isset($flag_init_load) ) 
	{
		$flag_init_load = 1;
		$this->_total_count = $this->getCount();
		$this->_load_cache();
		$this->get_tree_array();
	}
}

function _load_cache()
{
	$objs =& $this->getObjects();
	$this->_cached_objs = array();

	foreach ($objs as $obj) 
	{
		$cid = $obj->get('cid');
		$this->_cached_objs[$cid] = $obj;
	}
}

//---------------------------------------------------------
// get count
//---------------------------------------------------------
function get_count_all()
{
	$count = $this->getCount();
	$this->_total_count = $count;
	return $count;
}

function get_count_by_pid($pid)
{
	$pid = intval($pid);
	$criteria = new weblinks_criteria_compo();
	$criteria->add( new weblinks_criteria('pid', $pid, '=') );
	$count = $this->getCount($criteria);
	return $count;
}

function get_total()
{
	return $this->_total_count;
}

//---------------------------------------------------------
// get objects
//---------------------------------------------------------
function &get_objects_all($limit=0, $start=0)
{
	$criteria = new weblinks_criteria_compo();
	$criteria->setStart($start);
	$criteria->setLimit($limit);
	$objs =& $this->getObjects($criteria);
	return $objs;
}

function &get_objects_desc($limit=0, $start=0)
{
	$criteria = new weblinks_criteria_compo();
	$criteria->setSort( 'cid', 'DESC' );
	$criteria->setStart($start);
	$criteria->setLimit($limit);
	$objs =& $this->getObjects($criteria);
	return $objs;
}

function &get_objects_by_pid($pid=0, $limit=0, $start=0)
{
	$pid = intval($pid);

	$criteria = new weblinks_criteria_compo();
	$criteria->add( new weblinks_criteria('pid', $pid, '=') );
	$criteria->addSort( 'orders' );
	$criteria->addSort( 'cid' );
	$criteria->setStart($start);
	$criteria->setLimit($limit);
	$objs =& $this->getObjects($criteria);
	return $objs;
}

function &get_objects_by_title($title)
{
	$title = addslashes($title);
	$criteria = new weblinks_criteria_compo();
	$criteria->add( new weblinks_criteria('title', $title, '=') );
	$objs =& $this->getObjects($criteria);
	return $objs;
}

function &get_cid_array_by_title($title)
{
	$cid_arr = array();

	$objs =& $this->get_objects_by_title($title);

	if (count($objs) > 0)
	{
		foreach ($objs as $obj)
		{
			$cid_arr[] = $obj->get('cid');
		}
	}

	return $cid_arr;
}

//---------------------------------------------------------
// cache array
//---------------------------------------------------------
function &get_cache($cid)
{
	$cid = intval($cid);

	if ( isset($this->_cached_objs[$cid]) )
	{
		$obj =& $this->_cached_objs[$cid];
	}
	else
	{
		$obj =& $this->get($cid);
		if ( is_object($obj) )
		{
			$this->_cached_objs[$cid] = $obj;
		}
	}

	return $obj;
}

function &get_cache_var_all($cid, $format='n')
{
	$arr = array();

	$obj = $this->get_cache($cid);
	if ( is_object($obj) )
	{
		$arr =& $obj->getVarAll($format);
	}

	return $arr;
}

function cache_exists($cid)
{
	if ( isset($this->_cached_objs[$cid]) )
	{
		return true;
	}

	return false;
}

//---------------------------------------------------------
// get category list
//---------------------------------------------------------
function get_cid_array_all($limit=0, $start=0)
{
	$limit   = intval($limit);
	$start   = intval($start);
	$objs    = $this->get_objects_all($limit, $start);
	$cid_arr = $this->_get_cid_array($objs);
	return $cid_arr;
}

function get_cid_array_by_pid($pid=0, $limit=0, $start=0)
{
	$pid     = intval($pid);
	$limit   = intval($limit);
	$start   = intval($start);
	$objs    = $this->get_objects_by_pid($pid, $limit, $start);
	$cid_arr = $this->_get_cid_array($objs);
	return $cid_arr;
}

function _get_cid_array(&$objs)
{
	$cid_arr = array();

	foreach ($objs as $obj)
	{
		if ( is_object($obj) )
		{
			$cid_arr[] = $obj->get('cid');
		}
	}

	return $cid_arr;
}

// Hack by Tom  $chitem
// admin can change the display number of subcategory 
// for viewcat.php
function build_sub_categorys($cid, $chitem=5)
{
	$space   = 0;
	$chcount = 0;
	$subcategories = '';

	$WEBLINKS_URL = XOOPS_URL."/modules/".$this->_dirname;

// bug fix: show all sub categories when $chitem = 0
	if ($chitem > 0) 
	{
		$child_arr = $this->get_cid_array_by_pid($cid);
		foreach($child_arr as $ch_id)
		{
			$arr = $this->get_cache_var_all($ch_id, 's');
			$chtitle_s = $arr['title'];

			if ($chcount >= $chitem) 
			{
				$subcategories .= "...";
				break;
			}

			if ($space>0) 
			{
				$subcategories .= ", ";
			}

			$url = $WEBLINKS_URL.'/viewcat.php?cid='.$ch_id;
			$subcategories .= "<a href='$url'>".$chtitle_s."</a>";
			$space++;
			$chcount++;
		}
	}

	return array($space, $chcount, $subcategories);
}

//=========================================================
// category tree
//=========================================================
//---------------------------------------------------------
// get tree
// recursive function
//---------------------------------------------------------
function get_tree_array( $cid=0 )
{
	$this->_tree_array      = array();
	$this->_tree_info_array = array();
	$this->_get_tree_recursive( $cid );
}

function _get_tree_recursive( $pid=0 )
{
	$cid_arr = $this->get_cid_array_by_pid($pid);

	if ( count($cid_arr) == 0 )  return false;

	foreach ($cid_arr as $cid) 
	{
		if ($pid == 0)
		{
			$path  = "$cid";
			$depth =  0;
		}
		else
		{
			$pid_path  = $this->_tree_info_array[$pid]['path'];
			$pid_depth = $this->_tree_info_array[$pid]['depth'];
			$path  = "$pid_path:$cid";
			$depth =  $pid_depth + 1;
		}

		$this->_tree_array[] = $cid;
		$this->_tree_info_array[$cid]['path']  = $path;
		$this->_tree_info_array[$cid]['depth'] = $depth;

		$this->_get_tree_recursive($cid);
	}

	return;
}

//---------------------------------------------------------
// get_tree
//---------------------------------------------------------
function get_tree($limit=0, $start=0)
{
	$limit = intval($limit);
	$start = intval($start);

	if ( ($limit == 0) && ($start == 0) )
	{
		return $this->_tree_array;
	}

	$total = $this->_total_count;
	$end   = $start + $limit;

	if ($start < 0)       return false;
	if ($end   < 0)       return false;
	if ($start > $total)  return false;
	if ($end   > $total)  $end = $total;

	$arr = array();

	for ($i=$start; $i<$end; $i++)
	{
		$arr[] = $this->_tree_array[$i];
	}

	return $arr;
}

function get_tree_info($cid)
{
	if ( isset($this->_tree_info_array[$cid]) )
	{
		$ret = $this->_tree_info_array[$cid];
		return $ret;
	}

	return false;
}

function &get_objects_tree($limit=0, $start=0)
{
	$limit = intval($limit);
	$start = intval($start);

	$cid_arr = $this->get_tree($limit, $start);

	$objs = array();

	foreach ($cid_arr as $cid) 
	{
		$objs[] =& $this->get($cid);
	}

	return $objs;
}

//---------------------------------------------------------
// category path
//---------------------------------------------------------
function build_cat_path($cid)
{
	$cid = intval($cid);

	$catpath = '';
	$pid_arr = $this->_get_path_array($cid);

	foreach ($pid_arr as $pid) 
	{
		$arr = $this->get_cache_var_all($pid, 's');
		$title_s = $arr['title'];
	
		if ($catpath)
		{
			$catpath .= " : $title_s";
		}
		else
		{
			$catpath .= $title_s;
		}
	}

	return $catpath;
}

function &get_parent_path($cid)
{
	$cid        = intval($cid);
	$pid_arr    = $this->_get_path_array($cid);
	$path_array = array();

	if ( is_array($pid_arr) )
	{
		foreach ($pid_arr as $pid) 
		{
			$arr   = $this->get_cache_var_all($pid, 'n');
			$title = $arr['title'];
			$path_array[] = array('cid'=>$pid, 'title'=>$title);
		}
	}

	return $path_array;
}

function _get_path_array($cid)
{
	if ( isset( $this->_tree_info_array[$cid]['path'] ) )
	{
		$ret = split(":", $this->_tree_info_array[$cid]['path'] );
		return $ret;
	}
	return false;
}

function build_parent_path_multi($cid_arr)
{
	$path_array = array();

	if ( count($cid_arr) == 0 )  return $path_array;

	foreach ($cid_arr as $cid)
	{
		$path_array[] = $this->get_parent_path($cid);
	}

	return $path_array;
}

//=========================================================
// selbox
//=========================================================
function show_selbox_multi($cid_arr='')
{
	if ( count($cid_arr) == 0 )  return '';

	$selbox = '';

	foreach ($cid_arr as $cid)
	{
		$arr = $this->get_cache_var_all($cid, 's');
		$title_s = $arr['title'];
		$selbox .= $title_s."<br />\n";
	}

	return $selbox;
}

//---------------------------------------------------------
// porting from makeMySelBox of xoopstree.php
// makes a nicely ordered selection box
// $preset_id is used to specify a preselected item
// set $none to 1 to add a option with value 0
//---------------------------------------------------------
function build_selbox($preset_id=0, $none=0, $sel_name='', $onchange='', $none_name='---', $flag=0)
{
	$selbox  = '';
	$selbox .= "<select name='".$sel_name."'";

	if ( $onchange != "" ) 
	{
		$selbox .= " onchange='".$onchange."'";
	}

	$selbox .= ">\n";

	if ( $none ) 
	{
		$selbox .=  "<option value='0'>".$none_name."</option>\n\n";
	}

	foreach ($this->_tree_array as $cid) 
	{
		$arr   = $this->get_cache_var_all($cid, 'n');
		$lflag = $arr['lflag'];

		if (($flag == 1)&&($lflag == 0))  continue;

		$catpath = $this->build_cat_path($cid);

// bug: category is html sanitized twice in edit form
//		$catpath = htmlspecialchars($catpath, ENT_QUOTES);

		$sel = '';
		if ( $cid == $preset_id ) 
		{
			$sel = "selected='selected'";
		}

		$selbox .= "<option value='$cid' $sel>$catpath</option>\n";
	}

	$selbox .= "</select>\n";

	return $selbox;
}

function build_selbox_multi( $cid_arr=array() )
{
// show always, if cid array is empty

	if ($cid_arr)
	{
		$cid_count = count($cid_arr);
	}
	else
	{
		$cid_count = 0;
	}

	$catsel_max = $this->_conf_cat_sel;
	if ($catsel_max < $cid_count) { $catsel_max = $cid_count; }

	$selbox = '';

	for($i=0; $i<$catsel_max; $i++)
	{
		$cid = 0;

		if ($i < $cid_count)
		{
			$cid = array_shift($cid_arr); 
		}

		$selbox .= $this->build_selbox( $cid, 1, "cid[]", '', _WLS_NOTSELECT, 1 );
		$selbox .= "<br />\n";
	}

	return $selbox;
}

//=========================================================
// use tree class
//=========================================================
function getAllChildId( $cid, $order="cid", $idarray=array() )
{
	$ret = $this->_tree->getAllChildId($cid, $order, $idarray);
	return $ret;
}

// for admin/category.php
function getPathFromId($cid)
{
	$ret = $this->tree->getPathFromId($cid, "title");
	return $ret;
}

// --- class end ---
}

// === class end ===
}

?>