<?php
// $Id: weblinks_config2_store_handler.php,v 1.1 2006/05/24 01:23:56 ohwada Exp $

// 2006-05-15 K.OHWADA
// this is new file
// use new handler

//================================================================
// WebLinks Module
// this file contain 2 class
//   weblinks_config2_form
//   weblinks_config2_store_handler
// porting form RSSC 
// 2006-05-15 K.OHWADA
//================================================================

// === class begin ===
if( !class_exists('weblinks_config2_store_handler') ) 
{

//=========================================================
// class weblinks_config2_form
//=========================================================
class weblinks_config2_form extends weblinks_form
{
	var $_config_define_handler;

// set parameter
	var $_button_extend = '';

// define by weblinks_form
//	var $_form_name   = 'weblinks';
//	var $_token_name  = 'weblinks';
//	var $_op_name     = 'op';
//	var $_submit_name = 'submit';
//	var $_method      = 'post';

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_config2_form( $dirname )
{
	$this->weblinks_form();

	$this->_config_define_handler =& weblinks_get_handler( 'config2_define', $dirname );
	$this->set_form_name( 'weblinks_config2' );

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new weblinks_config2_form( $dirname );
	}

	return $instance;
}

//---------------------------------------------------------
// main function
//---------------------------------------------------------
function show_by_catid( $catid, $title='' )
{
	$config_arr =& $this->get_by_catid($catid);

	$form_name = $this->get_form_name().'_'.$catid;
	$this->set_form_name( $form_name );

	if ($title)
	{
		$this->set_form_title($title);
	}

	$this->show( $config_arr );
}

function show($config_arr)
{
	if ( !is_array($config_arr) || empty($config_arr) )  return;

// form start
	echo $this->make_form_start();
	echo $this->make_form_token();
	echo $this->make_form_hidden('op', 'save');
	echo $this->make_table_start();
	echo $this->make_table_title();

// list from config array
	foreach ($config_arr as $id => $config) 
	{
		$title = $this->build_conf_caption( $config );
		$ele   = $this->build_conf_element( $config );
		$ele  .= $this->build_conf_hidden( $id );

		echo $this->make_table_line($title, $ele);
	}

	$button = $this->make_form_submit('submit', $this->SUBMIT_VALUE );

	if ($this->_button_extend)
	{
		$button .= $this->_button_extend;
		$this->_button_extend = '';	// clear by myself
	}

	echo $this->make_table_line('', $button, 'foot', 'foot');
	echo $this->make_table_end();
	echo $this->make_form_end();

// form end

}

//---------------------------------------------------------
// make config element
//---------------------------------------------------------
function build_conf_caption( $config )
{
	$title = $config['title'];
	$desc  = $config['description'];
	$cap   = $this->make_caption($title, $desc);
	return $cap;
}

function build_conf_element( $config )
{
	$formtype  = $config['formtype'];
	$valuetype = $config['valuetype'];
	$name      = $config['name'];
	$value     = $config['value'];
	$options   = $config['options'];
	$value     = $config['value'];
	$value_s   = $this->sanitize_html_text( $value );

	switch ( $formtype ) 
	{
		case 'textarea':
			$ele = $this->build_conf_textarea( $name, $value, $valuetype );
			break;

		case 'select':
			$ele = $this->make_form_select( $name, $value, $options );
			break;

		case 'select_multi':
			$ele = $this->make_form_select_multiple( $name, $value, $options );
			break;

		case 'radio':
		case 'radio_select':
			$ele = $this->make_form_radio_select( $name, $value, $options );
			break;

		case 'yesno':
		case 'radio_yesno':
			$ele = $this->make_form_radio_yesno( $name, $value );
			break;

		case 'yesno_check':
		case 'checkbox_yesno':
			$ele = $this->make_form_radio_yesno( $name, $value_s );
			break;

		case 'label':
			$ele = $value_s;
			break;

		case 'text_image':
			$ele = $this->build_conf_text_image( $name, $value );
			break;

		case 'label_image':
			$ele = $this->build_conf_label_image( $name, $value );
			break;

//		case 'group':
//			$ele = $this->make_conf_group( $config );
//			break;

//		case 'group_multi':
//			$ele = $this->make_conf_group_multi( $config );
//			break;

//		case 'user':
//			$ele = $this->make_conf_user( $config );
//			break;

//		case 'user_multi':
//			$ele = $this->make_conf_user_multi( $config );
//			break;

//		case 'password':
//			$ele = $this->make_conf_password( $config );
//			break;

		case 'textbox':
		default:
			$ele   = $this->make_form_text( $name, $value_s );
			break;
	}

	return $ele;
}


//---------------------------------------------------------
// make config form
//---------------------------------------------------------
function build_conf_textarea( $name, $value, $valuetype )
{
	if ($valuetype == 'array') 
	{
		if ($value != '')
		{
			$value_s = $this->sanitize_html_text( implode('|', $value ) );
			$text    = $this->make_form_textarea( $name, $value_s, 5, 50 );
		}
		else
		{
			$text = $this->make_form_textarea($name, '', 5, 50);
		}
	}
	else 
	{
		$value_s = $this->sanitize_html_text( $value );
		$text    = $this->make_form_textarea($name, $value_s, 5, 50);
	}

	return $text;
}

function build_conf_text_image( $name, $value, $size=50, $maxlength=255, $width=0, $height=0, $border=0, $alt='image')
{
	$text   = $this->make_form_text($name, $value, $size);
	$text  .= "<br /><br />\n";
	$text  .= $this->make_html_img($value, $width, $height, $border, $alt);
	return $text;
}

function build_conf_label_image( $name, $value, $width=0, $height=0, $border=0, $alt='image')
{
	$text   = $value;
	$text  .= "<br /><br />\n";
	$text  .= $this->make_html_img($value, $width, $height, $border, $alt);
	return $text;
}

function build_conf_textbox( $name, $value, $size=50, $maxlength=255)
{
	$value = $this->sanitize_html_text( $value );
	$text  = $this->make_form_text($name, $value, $size);
	return $text;
}

function build_conf_label( $value )
{
	$text = $this->sanitize_html_text( $value );
	return $text;
}

function build_conf_select( $name, $value, $options, $none=0, $none_name='---', $none_value='')
{
	$text    = $this->make_form_select($name, $value, $options, $none, $none_name, $none_value);
	return $text;
}

function build_conf_select_multi( $name, $value, $options, $none=0, $none_name='---', $none_value='')
{
	$text = $this->make_form_select_multiple($name, $value, $options, $none, $none_name, $none_value);
	return $text;
}

function build_conf_radio_select( $name, $value, $options, $del='')
{
	$text = $this->make_form_radio_select($name, $value, $options, $del);
	return $text;
}

function build_conf_radio_yesno( $name, $value )
{
	$text = $this->make_form_radio_yesno($name, $value);
	return $text;
}

function build_conf_checkbox_yesno( $name, $value )
{
	$text = $this->make_form_radio_yesno($name, $value);
	return $text;
}

function build_conf_hidden($id)
{
	$text = $this->make_form_hidden('conf_ids[]', $id);
	return $text;
}

//---------------------------------------------------------
// make config by name
//---------------------------------------------------------
function build_conf_caption_by_name($name)
{
	if ( empty($name) )
	{
		return '&nbsp;';
	}

	$title = $this->get_by_name($name, 'title');
	$desc  = $this->get_by_name($name, 'description');
	$cap   = $this->make_caption($title, $desc);
	return $cap;
}

function build_conf_textbox_by_name($name, $size=5)
{
	if ( empty($name) )
	{
		return '&nbsp;';
	}

	$id      = $this->get_by_name($name, 'conf_id');
	$value   = $this->get_by_name($name, 'value');
	$value_s = $this->sanitize_html_text( $value );

	$text    = $this->make_form_text( $name, $value_s, $size );
	$text   .= $this->build_conf_hidden($id);
	return $text;
}

function build_conf_yesno_checkbox_by_name($name)
{
	if ( empty($name) )
	{
		return '&nbsp;';
	}

	$id      = $this->get_by_name($name, 'conf_id');
	$value   = $this->get_by_name($name, 'value');
	$value_s = $this->sanitize_html_text( $value );

	$text    = $this->make_form_radio_yesno( $name, $value_s );
	$text   .= $this->build_conf_hidden($id);
	return $text;
}

function build_conf_radio_select_by_name($name)
{
	if ( empty($name) )
	{
		return '&nbsp;';
	}

	$id      = $this->get_by_name($name, 'conf_id');
	$value   = $this->get_by_name($name, 'value');
	$options = $this->get_by_name($name, 'options');

	$text  = $this->make_form_radio_select( $name, $value, $options, '<br />' );
	$text .= $this->build_conf_hidden($id);
	return $text;
}

//---------------------------------------------------------
// config_define_handler
//---------------------------------------------------------
function load()
{
	$this->_config_define_handler->load();
}

function get_by_confid($id, $key)
{
	$val = $this->_config_define_handler->get_by_itemid($id, $key);
	return $val;
}

function get_by_name($name, $key)
{
	$val = $this->_config_define_handler->get_by_name($name, $key);
	return $val;
}

function &get_by_catid( $catid )
{
	$arr =& $this->_config_define_handler->get_caches_by_catid( $catid );
	return $arr;
}

//---------------------------------------------------------
// set parameter
//---------------------------------------------------------
function set_button_extend( $value )
{
	$this->_button_extend = $value;
}

function set_submit_button_extend( $name, $value )
{
	$button = $this->make_form_submit($name, $value);
	$this->set_button_extend( $button );
}

// --- class end ---
}


//================================================================
// class weblinks_config2_store_handler
//================================================================
class weblinks_config2_store_handler extends weblinks_error
{
	var $_handler;
	var $_define;
	var $_post;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_config2_store_handler( $dirname )
{
	$this->weblinks_error();

	$this->_handler =& weblinks_get_handler('config2', $dirname);
	$this->_define  =& weblinks_config2_define::getInstance();
	$this->_post    =& weblinks_post::getInstance();
}

//---------------------------------------------------------
// init config
//---------------------------------------------------------
function init()
{
	$flag_error = false;

	$define_arr = $this->_define->get_define();

// list from Define
	foreach ($define_arr as $id => $def) 
	{
		$name      = $def['name'];
		$valuetype = $def['valuetype'];
		$value     = $def['default'];

		$obj =& $this->_handler->create();
		$obj->setVar('conf_id',        $id );
		$obj->setVar('conf_name',      $name);
		$obj->setVar('conf_valuetype', $valuetype);
		$obj->setConfValueForInput($value);

		$ret = $this->_handler->insert($obj);
		if ( !$ret )
		{
			$flag_error = true;
			$this->_set_errors( $this->_handler->getErrors() );
		}

		unset($obj);
	}

	if ( $flag_error ) { return false; }
	return true;
}

//---------------------------------------------------------
// save config
//---------------------------------------------------------
function save()
{
	$flag_error = false;

	$confid_arr = $this->_post->get_post('conf_ids');

	$count = count($confid_arr);
	if ($count <= 0)  return true;	// no actuion

// list from POST 
	for ( $i=0; $i<$count; $i++ ) 
	{
		$id = $confid_arr[$i];

		$obj =& $this->_handler->get_by_confid($id);
		if ( !is_object($obj) )  continue;

		$name        = $obj->getVar('conf_name');
		$val_current = $obj->getVar('conf_value');
		$value       = $this->_post->get_post($name);

// update
		if ( is_array($value) || ($value != $val_current) )
		{
			$obj->setConfValueForInput($value);

			$ret = $this->_handler->update($obj);
			if ( !$ret )
			{
				$flag_error = true;
				$this->_set_errors( $this->_handler->getErrors() );
			}
		}

		unset($obj);
	}

	if ( $flag_error ) { return false; }
	return true;
}

//---------------------------------------------------------
// upgrade config
//---------------------------------------------------------
function upgrade()
{
	$define_arr = $this->_define->get_define();

// list from Define
	foreach ($define_arr as $id => $def) 
	{
		$obj =& $this->_handler->get_by_confid($id);
		if ( is_object($obj) )  continue;

// insert, when not in MySQL
		$name      = $def['name'];
		$valuetype = $def['valuetype'];
		$value     = $def['default'];

		$obj =& $this->_handler->create();
		$obj->setVar('conf_id',        $id );
		$obj->setVar('conf_name',      $name);
		$obj->setVar('conf_valuetype', $valuetype);
		$obj->setConfValueForInput($value);
		$this->_handler->insert($obj);

		unset($obj);
	}
}

function check_exist_by_name($name)
{
	$arr = $this->_handler->get_cache_by_name($name);

	if ( is_array($arr) && count($arr) )
	{
		return true;
	}

	return false;
}

//---------------------------------------------------------
// config_handler
//---------------------------------------------------------
function existsTable()
{
	$ret = $this->_handler->existsTable();
	return $ret;
}

function getCount()
{
	$count = $this->_handler->getCount();
	return $count;
}

function create_table()
{
	$ret = $this->_handler->create_table();
	if ( !$ret )
	{
		$this->_set_errors( $this->_handler->getErrors() );
	}

	return $ret;
}

function update_by_name($name, $value)
{
	$ret = $this->_handler->update_by_name($name, $value);
	return $ret;
}

// --- class end ---
}

// === class end ===
}

?>