<?php
// $Id: weblinks_link_edit_handler.php,v 1.3 2006/07/23 09:10:27 ohwada Exp $

// 2006-07-23 K.OHWADA
// BUG 4154: always update time_update in admin mode

// 2006-06-10 K.OHWADA
// BUG 4030: cannot change recommend, mutual

// 2006-05-15 K.OHWADA
// this is new file
// use new handler

//=========================================================
// WebLinks Module
// 2006-05-15 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_link_edit_handler') ) 
{

//=========================================================
// class weblinks_link_edit_handler
//=========================================================
class weblinks_link_edit_handler extends weblinks_error
{
	var $_dirname;

	var $_config_handler;
	var $_link_handler;
	var $_category_handler;
	var $_catlink_handler;
	var $_modify_handler;
	var $_votedata_handler;
	var $_linkitem_define_handler;

	var $_link_utility;
	var $_system;
	var $_post;
	var $_form;
	var $_menu;

	var $error_msg_flag_lid_full = 0;
	var $error_msg_flag_lid_part = 0;
	var $error_msg_lid_arr_full  = array();
	var $error_msg_lid_arr_part  = array();

	var $_newid;
	var $_cid_arr = array();

// config
	var $_conf_check_double;
	var $_conf_use_passwd;
	var $_conf_passwd_min;
	var $_conf_desc_option = array();

// cache
	var $_link_obj;


//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_link_edit_handler( $dirname )
{
	$this->_dirname = $dirname;

	$this->_config_handler   =& weblinks_get_handler( 'config2_basic', $dirname );
	$this->_link_handler     =& weblinks_get_handler( 'link',          $dirname );
	$this->_category_handler =& weblinks_get_handler( 'category',      $dirname );
	$this->_catlink_handler  =& weblinks_get_handler( 'catlink',       $dirname );
	$this->_modify_handler   =& weblinks_get_handler( 'modify',        $dirname );
	$this->_votedata_handler =& weblinks_get_handler( 'votedata',      $dirname );
	$this->_linkitem_define_handler =& weblinks_get_handler( 'linkitem_define', $dirname );

	$this->_menu         =& weblinks_menu::getInstance( $dirname );
	$this->_link_utility =& weblinks_link_utility::getInstance();
	$this->_system       =& weblinks_system::getInstance();
	$this->_post         =& weblinks_post::getInstance();
	$this->_form         =& weblinks_form::getInstance();

	$conf = $this->_config_handler->get_cached();
	$this->_conf_check_double = $conf['check_double'];
	$this->_conf_use_passwd   = $conf['use_passwd'];
	$this->_conf_passwd_min   = $conf['passwd_min'];
}

//---------------------------------------------------------
// init
//---------------------------------------------------------
function init()
{
	$this->_category_handler->load();
}

function &get($lid)
{
	$lid = intval($lid);
	$obj =& $this->_link_handler->get($lid);
	return $obj;
}

function check_exist_link($lid)
{
	$obj =& $this->get($lid);

	if ( is_object($obj) )
	{
		return true;
	}

	return false;
}

function getCount()
{
	$count = $this->_link_handler->getCount();
	return $count;
}

function insert( &$obj )
{
	$newid = $this->_link_handler->insert( $obj );
	return $newid;
}

//---------------------------------------------------------
// Does the user have authority
//---------------------------------------------------------
function has_auth_submit()
{
	$ret = $this->_menu->show_submit();
	return $ret;
}

function has_auth_submit_auto()
{
	$ret = $this->has_auth( 'auth_submit_auto_arr' );
	return $ret;
}

function has_auth_modify( $rec_uid, $flag_passwd )
{
	list($is_permit, $is_owner, $show_passwd) = 
		$this->has_auth_owner( 'auth_modify_arr', $rec_uid, $flag_passwd );

	if ($flag_passwd && $show_passwd)
	{
		$is_permit = true;
		$is_owner  = true;
	}

	return array($is_permit, $is_owner, $show_passwd);
}

function has_auth_modify_auto( $rec_uid, $flag_passwd )
{
	list($is_permit, $is_owner, $show_passwd) = 
		$this->has_auth_owner( 'auth_modify_auto_arr', $rec_uid, $flag_passwd );
	return $is_permit;
}

function get_config_by_name($name)
{
	$ret = $this->_config_handler->get_cache_by_name($name);
	return $ret;
}

function has_auth( $name )
{
	$ret = $this->_config_handler->has_auth( $name );
	return $ret;
}

function has_auth_owner( $name, $rec_uid, $flag_passwd )
{
	$ret = $this->_config_handler->has_auth_owner( $name, $rec_uid, $flag_passwd );
	return $ret;
}

//---------------------------------------------------------
// add new link
//---------------------------------------------------------
function add_link( &$post )
{
//	$cid_arr = $this->_link_utility->make_unique_cid_array( $post );

	$newid = $this->add_link_to_link( $post );
	if ( !$newid )
	{
		return false;
	}

	$ret = $this->_catlink_handler->add_link_by_lid_cid_array($newid, $this->_cid_arr);
	if ( !$ret )
	{
		$this->_set_errors( $this->_catlink_handler->getErrors() );
		return false;
	}

	return $newid;
}

function add_link_to_link( &$post )
{
	$this->_mid = $this->_post->get_post_int('mid');

	$obj =& $this->_link_handler->create();

// desc option
	$obj->set_conf_desc_option( $this->_config_handler->has_auth_desc_option() );

// value
	$obj->assign_vars_post( $post );

// time
	$time = time();
	$obj->setVar('time_create', $time);
	$obj->setVar('time_update', $time);

// banner size
	$banner = $obj->get('banner');
	list($width, $height) = $this->_link_utility->get_banner_size( $banner );
	$obj->setVar('width',  $width);
	$obj->setVar('height', $height);

// password
	$passwd = $this->get_passwd_new( $post, true );
	$obj->setVar('passwd', $passwd);

// cid array
	$this->_cid_arr = $obj->get_cid_array_by_post( $post );

// search
	$search = $this->build_search( $obj, $this->_cid_arr );
	$obj->setVar('search', $search);

// BUG 4030: cannot change recommend, mutual
// recommend, mutual
	if( $this->_system->is_module_admin() )
	{
		$obj->set_checkbox( $post, 'recommend' );
		$obj->set_checkbox( $post, 'mutual' );
	}

	$newid = $this->_link_handler->insert($obj);
	if ( !$newid )
	{
		$this->_set_errors( $this->_link_handler->getErrors() );
		return false;
	}

	return $newid;

}

//---------------------------------------------------------
// search field
//---------------------------------------------------------
function build_search( &$obj, $cid_arr )
{
	foreach( $obj->gets() as $k => $v)
	{
		${$k} = $v;
	}

	$search  = '';
	$search .= $url.' ';
	$search .= $title.' ';
	$search .= $company.' ';
	$search .= $zip.' ';
	$search .= $state.' ';
	$search .= $city.' ';
	$search .= $addr.' ';
	$search .= $addr2.' ';
	$search .= $tel.' ';
	$search .= $fax.' ';
	$search .= $description.' ';

	if ($nameflag)  { $search .= $name.' '; }
	if ($mailflag)  { $search .= $mail.' '; }

// change a category path
	if ( is_array($cid_arr) )
	{
		foreach ($cid_arr as $cid)
		{
			$path_array = $this->_category_handler->get_parent_path($cid);

			foreach ($path_array as $path)
			{
				$search .= $path['title'].' ';
			}
		}
	}

	$search = preg_replace("/\n|\r/",' ',$search);

	return $search;
}

//---------------------------------------------------------
// passwd field
//---------------------------------------------------------
function get_passwd_new( &$post, $flag=false )
{
	if ( $flag && isset($post['passwd_md5']) && $post['passwd_md5'] )
	{
		$passwd = $post['passwd_md5'];
	}
	elseif ( isset($post['passwd_new']) && $post['passwd_new'] )
	{
		$passwd = md5( $post['passwd_new'] );
	}
	else
	{
		$passwd = md5( xoops_makepass() );
	}

	return $passwd;
}

function get_passwd_mod( &$post, $flag=false )
{
	$passwd = '';

	if ( $flag && isset($post['passwd_md5']) )
	{
		if ( $post['passwd_md5'] )
		{
			$passwd = $post['passwd_md5'];
		}
	}
	elseif ( isset($post['passwd_new']) )
	{
		if ( $post['passwd_new'] )
		{
			$passwd = md5( $post['passwd_new'] );
		}
	}

	return $passwd;
}

//---------------------------------------------------------
// modify link
//---------------------------------------------------------
function mod_link( $lid, &$post )
{
	$this->_clear_errors();

	$this->mod_link_to_link( $lid, $post );

	$ret = $this->_catlink_handler->delete_by_lid($lid);
	if (!$ret)
	{
		$this->_set_errors( $this->_catlink_handler->getErrors() );
	}

	$ret = $this->_catlink_handler->add_link_by_lid_cid_array($lid, $this->_cid_arr);
	if (!$ret)
	{
		$this->_set_errors( $this->_catlink_handler->getErrors() );
	}

	return $this->returnExistError();
}

function mod_link_to_link( $lid, &$post )
{
	$obj =& $this->get($lid);
	if ( !is_object($obj) )
	{
		$msg = "link not exist lid = $lid";
		$this->_set_errors( $msg );
		return false;
	}

// desc option
	$obj->set_conf_desc_option( $this->_config_handler->has_auth_desc_option() );

// value
	$obj->assign_vars_post( $post );

//-----
// BUG: always update time_update in admin mode
// TODO: updateflag parameter use in user form
//-----

// time update
	$flag_time_update = false;

// admin mode
	if ( isset($post['updateflag']) )
	{
		if ( intval($post['updateflag']) == 1 )
		{
			$flag_time_update = true;
		}
	}
// user mode
	else
	{
		$flag_time_update = true;
	}

	if ($flag_time_update)
	{
		$obj->setVar('time_update',  time() );
	}

// banner size
	$banner = $obj->get('banner');
	list($width, $height) = $this->_link_utility->get_banner_size( $banner );

	$obj->setVar('width',  $width);
	$obj->setVar('height', $height);

// password
	$passwd = $this->get_passwd_mod( $post, true );
	if ($passwd)
	{
		$obj->setVar('passwd', $passwd);
	}

// cid array
	$this->_cid_arr = $obj->get_cid_array_by_post( $post );

// search
	$search = $this->build_search( $obj, $this->_cid_arr );
	$obj->setVar('search', $search);

// BUG 4030: cannot change recommend, mutual
// recommend, mutual
	if( $this->_system->is_module_admin() )
	{
		$obj->set_checkbox( $post, 'recommend' );
		$obj->set_checkbox( $post, 'mutual' );
	}

	$ret = $this->_link_handler->update($obj);
	if (!$ret)
	{
		$this->_set_errors( $this->_link_handler->getErrors() );
		return false;
	}

	return true;
}

//---------------------------------------------------------
// check form
//---------------------------------------------------------
function check_form_addlink($post)
{
	$ret = $this->check_form_common($post);
	return $ret;
}

function check_form_modlink_for_owner($post)
{
	$ret = $this->check_form_common($post, true, false);
	return $ret;
}

function check_form_modlink($post, $is_owner=true)
{
	$ret = $this->check_form_common($post, $is_owner, false);
	return $ret;
}

function check_form_common($post, $is_owner=true, $flag_new=true)
{
	$linkitem_arr = $this->_linkitem_define_handler->load();

	$this->_clear_errors();

	foreach ($linkitem_arr as $id => $v )
	{
		$name  = $this->get_linkitem_by_itemid($id, 'name');
		$mode  = $this->get_linkitem_by_itemid($id, 'user_mode');
		$form  = $this->get_linkitem_by_itemid($id, 'user_form');
		$title = $this->get_linkitem_by_itemid($id, 'title');

		switch ($name)
		{
			case 'name':
			case 'mail':
			case 'usercomment':
				if (( $mode == 2 )&& $is_owner )
				{
					$this->_check_fill($post, $name, $title);
				}
				break;

			case 'banner':
			case 'rss_url':
				$this->_check_url_form($post, $name, $title, $mode);
				break;

			case 'description':
				$this->_check_desc($post, $name, $title, $mode);
				break;

			case 'cat':
				$this->_check_cat($post, $name, $title, $mode);
				break;

			case 'url':
				$this->_check_url($post, $name, $title, $mode, $flag_new);
				break;

			case 'passwd':
				$this->_check_passwd($post, $name, $title, $flag_new);
				break;

			default:
				if ( $mode == 2 )
				{
					$this->_check_fill($post, $name, $title);
				}
				break;
		}
	}

	if ( $this->_error_flag )  { return false; }
	return true;
}

//---------------------------------------------------------
// check routine
//---------------------------------------------------------
function _check_fill($post, $name, $title)
{
	if ( !isset( $post[$name] ) || empty( $post[$name] ) )
	{
		$msg = sprintf(_WLS_ERROR_FILL, $title);
		$this->_set_errors( $msg );
		return false;
	}

	return true;
}

function _check_desc($post, $name, $title, $mode)
{
	$desc = '';
	if ( isset($post['description']) )
	{
		$desc = $post['description'];
	}
	elseif ( isset($post['description_text']) )
	{
		$desc = $post['description_text'];
	}

	if ( ( $mode == 2 )&& empty($desc) )
	{
		$msg = sprintf(_WLS_ERROR_FILL, $title);
		$this->_set_errors( $msg );
	}
}

function _check_cat($post, $name, $title, $mode)
{
	$flag_cid = false;
	foreach ($post['cid'] as $cid)
	{
		if ($cid != 0)  $flag_cid = true;
	}

	if ( !$flag_cid )
	{
		$msg = sprintf(_WLS_ERROR_FILL, $title);
		$this->_set_errors( $msg );
	}
}

function _check_url_form($post, $name, $title, $mode)
{
	$object =& new weblinks_object();

// bug fix: misjudge to check url
	$flag_empty   = false;
	$flag_illegal = false;

	$url = '';
	if ( isset($post[$name]) )
	{
		$url = $post[$name];
	}

	if ( $url == '' )
	{
		$flag_empty = true;
	}
	elseif ( $object->checkHttpOnly($url) )
	{
		$flag_empty = true;
	}
	elseif ( !$object->checkHttpStart($url) )
	{
		$flag_illegal = true;
	}
	elseif ( $object->checkJavascript($url) )
	{
		$flag_illegal = true;
	}

	if ( ( $mode == 2 ) && $flag_empty )
	{
		$msg = sprintf(_WLS_ERROR_FILL, $title);
		$this->_set_errors( $msg );
		return false;
	}

	if ( $flag_illegal )
	{
		$msg = sprintf(_WLS_ERROR_ILLEGAL, $title);
		$this->_set_errors( $msg );
		return false;
	}

	return true;
}

function _check_url($post, $name, $title, $mode, $flag_new)
{
	$this->_check_url_form($post, $name, $title, $mode);

	if ($flag_new)
	{
		$url = $post['url'];
		$this->_check_url_double($url);
	}
}

function _check_url_double($url)
{
	$this->error_msg_flag_lid_full = 0;
	$this->error_msg_flag_lid_part = 0;
	$this->error_msg_lid_arr_full  = array();
	$this->error_msg_lid_arr_part  = array();

	if ( $this->_conf_check_double >= 1 )
	{
		$ret = $this->_check_url_full( $url );
		if ( !$ret )
		{
			return false;	// error
		}
	}

	if ( $this->_conf_check_double == 2 )
	{
		$ret = $this->_check_url_part( $url );
		if ( !$ret )
		{
			return false;	// warning
		}
	}

	return true;	// OK
}

function _check_url_full($url)
{
	if (( $url == "" )||( $url == "http://" ))
	{	return true;	}	// no check

	$this->error_msg_lid_arr_full = $this->get_lid_array_by_url($url);

	if ( count($this->error_msg_lid_arr_full) > 0 ) 
	{
		$this->error_msg_flag_lid_full = 1;
		return false;	// NG
	}

	return true;	// OK
}

function _check_url_part($url)
{
	if (( $url == "" )||( $url == "http://" ))
	{	return true;	}	// no check

	$arr_out = array();

	$lid_arr = $this->_link_handler->getList();

	foreach ($lid_arr as $lid)
	{
		$flag = 0;

		$obj = $this->get($lid);
		if ( !is_object($obj) )  { continue; }

		$url_db   = $obj->get('url');
		$url_db_r = str_replace("|", '\|', $url_db);
		$url_r    = str_replace("|", '\|', $url);

		if ( preg_match("|$url_db_r|", $url) )
		{	$flag = 1;	}

		if ( preg_match("|$url_r|", $url_db) )
		{	$flag = 1;	}

		if ($flag)
		{
			$arr_out[] = $lid;
		}
	}

	$this->error_msg_lid_arr_part = $arr_out;
	if ( count($this->error_msg_lid_arr_part) > 0 ) 
	{
		$this->error_msg_flag_lid_part = 1;
		return false;	// NG
	}

	return true;	// OK
}

function get_lid_array_by_url($url)
{
	$criteria = new weblinks_criteria_compo();
	$criteria->add( new weblinks_criteria('url', $url, '=') );
	$ret =& $this->_link_handler->getList($criteria);
	return $ret;
}

function _check_passwd($post, $name, $title, $flag_new)
{
	$name1 = 'passwd_new';
	$name2 = 'passwd_2';

	if ( !isset( $post[$name1] ) || empty( $post[$name1] ) )
	{
		if ( $flag_new && $this->_conf_use_passwd && !($this->_system->is_user()) )
		{
			$msg = sprintf(_WLS_ERROR_FILL, $title);
			$this->_set_errors( $msg );
			return false;
		}

		return true;	// no check
	}

	$pass1 = $this->_post->strip_slashes_gpc( trim( $post[$name1] ));
	$pass2 = $this->_post->strip_slashes_gpc( trim( $post[$name2] ));

	if ( strlen($pass1) < $this->_conf_passwd_min ) 
	{
		$msg = sprintf(_US_PWDTOOSHORT, $this->_conf_passwd_min );
		$this->_set_errors( $msg );
		return false;
	}

	if ($pass1 != $pass2) 
	{
		$this->_set_errors( _US_PASSNOTSAME );
		return false;
	}

	return true;
}

//---------------------------------------------------------
// error message
//---------------------------------------------------------
function get_error_msg_addlink()
{
	$text = '';

	if ( $this->_error_flag )
	{
		$text .= $this->get_error_msg_modlink();
	}

	if ( $this->error_msg_flag_lid_full ) 
	{
		$text .= $this->_build_html_error_msg(_WLS_ERROR_URL_EXIST );
		$text .= $this->_build_html_error_url( $this->error_msg_lid_arr_full );
	}

	if ( $this->error_msg_flag_lid_part ) 
	{
		$text .= $this->_build_html_error_msg(_WLS_WARNING_URL_EXIST );
		$text .= $this->_build_html_error_url( $this->error_msg_lid_arr_part );
	}

	return $text;
}

function get_error_msg_modlink()
{
	$text = $this->_build_html_error_msg( $this->getErrors('s') );
	return $text;
}

function _build_html_error_msg($msg)
{
	$msg = "<h4 style='color: #ff0000'>$msg</h4>\n";
	return $msg;
}

function _build_html_error_url($lid_arr)
{
	$text = "<ul>";

	foreach( $lid_arr as $lid )
	{
		$text .= $this->_build_html_error_url_single($lid);
	}

	$text .= "</ul>\n";

	return $text;
}

function _build_html_error_url_single($lid)
{
	$obj = $this->get($lid);
	if ( !is_object($obj) )  { return ''; }

	$title_s = $obj->getVar('title');
	$url_s   = $obj->getVar('url');
	$text = "<li><a href='$url_s' target='_blank'>$title_s</a></li>\n";
	return $text;
}

//---------------------------------------------------------
// event tags
//---------------------------------------------------------
function build_tags_addlink($newid)
{
	$tags = array();

	$link_obj = $this->get($newid);
	if ( !is_object($link_obj) )
	{
		return array($tags, 0);
	}

	$link_title = $link_obj->get('title');

	if ( !isset( $this->_cid_arr[0] ) )
	{
		return array($tags, 0);
	}

	$cid = $this->_cid_arr[0];

	$cat_obj = $this->_category_handler->get_cache($cid);
	if ( !is_object($cat_obj) )
	{
		return array($tags, $cid);
	}

	$cat_title = $cat_obj->get('title');

	$tags['LINK_NAME']     = $link_title;
	$tags['LINK_URL']      = XOOPS_URL.'/modules/'.$this->_dirname.'/singlelink.php?lid='.$newid;
	$tags['CATEGORY_NAME'] = $cat_title;
	$tags['CATEGORY_URL']  = XOOPS_URL.'/modules/'.$this->_dirname.'/viewcat.php?cid='.$cid;

	return array($tags, $cid);
}

//=========================================================
// modify table
//=========================================================
function add_link_to_modify( &$post, $mode=0 )
{
	$muid = $this->_system->get_uid();
	$time = time();

	$mod_obj =& $this->_modify_handler->create();

	if ($mode)
	{
		$lid = $this->_post->get_post_int('lid');

		$link_obj = $this->get($lid);
		if ( !is_object($link_obj) )
		{
			$msg = "link not exist lid = $lid";
			$this->_set_errors( $msg );
			return false;
		}

		$link = $link_obj->getVarAll('n');
		$mod_obj->assign_vars_post( $link );
		$passwd = $this->get_passwd_mod( $post );
	}
	else
	{
		$passwd = $this->get_passwd_new( $post );
	}

// desc option
	$mod_obj->set_conf_desc_option( $this->_config_handler->has_auth_desc_option() );

// value
	$mod_obj->assign_vars_post( $post );

	if ($passwd)
	{
		$mod_obj->setVar('passwd',      $passwd);
	}

	$mod_obj->setVar('mode',        $mode);
	$mod_obj->setVar('muid',        $muid);
//	$mod_obj->setVar('width',       $width);
//	$mod_obj->setVar('height',      $height);
	$mod_obj->setVar('time_create', $time);
	$mod_obj->setVar('time_update', $time);

// cid array
	$this->_cid_arr = $mod_obj->get_cid_array_by_post( $post );
	$mod_obj->set_cids_by_cid_array( $this->_cid_arr );

	$search = $this->build_search( $mod_obj, $this->_cid_arr );
	$mod_obj->setVar('search', $search);

	$newid = $this->_modify_handler->insert($mod_obj);
	if ( !$newid )
	{
		$this->_set_errors( $this->_modify_handler->getErrors() );
		return false;
	}

	return $newid;
}

//=========================================================
// votedata table
// delete link, catlink, modify, votedata, comments, notification
//=========================================================
function del_link_vote_comm_catlink_by_lid($lid)
{
	$flag_error = false;

	$ret = $this->del_link_vote_comm_by_lid($lid);
	if (!$ret)
	{
		$flag_error = true;
	}

	$ret = $this->_catlink_handler->delete_by_lid($lid);
	if (!$ret)
	{
		$this->_set_errors( $this->_catlink_handler->getErrors() );
		$flag_error = true;
	}

	if ( $flag_error )  { return false; }
	return true;
}

function del_link_vote_comm_by_lid($lid)
{
	$flag_error  = false;
	$modid = $this->_system->get_mid();

	$ret = $this->_link_handler->delete_by_lid($lid);
	if (!$ret)
	{
		$this->_set_errors( $this->_link_handler->getErrors() );
		$flag_error = true;
	}

	$ret = $this->_modify_handler->delete_by_lid($lid);
	if (!$ret)
	{
		$this->_set_errors( $this->__modify_handler->getErrors() );
		$flag_error = true;
	}

	$this->_votedata_handler->delete_by_lid($lid);
	if (!$ret)
	{
		$this->_set_errors( $this->_votedata_handler->getErrors() );
		$flag_error = true;
	}

	xoops_comment_delete( $modid, $lid);
	xoops_notification_deletebyitem ( $modid, 'link', $lid);

	if ( $flag_error )  { return false; }
	return true;
}


//---------------------------------------------------------
// wrapper
//---------------------------------------------------------
function get_linkitem_by_itemid($id, $key)
{
	$val = $this->_linkitem_define_handler->get_by_itemid($id, $key);
	return $val;
}

function get_linkitem_by_name($name, $key)
{
	$val = $this->_linkitem_define_handler->get_by_name($name, $key);
	return $val;
}

//---------------------------------------------------------
// token ticket
//---------------------------------------------------------
function make_token( $name='' )
{
	$ret = $this->_form->make_token($name);
	return $ret;
}

function check_token( $name='' )
{
	$ret = $this->_form->check_token($name);
	return $ret;
}

//---------------------------------------------------------
// error Handler
//---------------------------------------------------------
function show_error()
{
	$eh = new ErrorHandler();
	$eh->show("0013");
}

// --- class end ---
}

// === class end ===
}

?>