<?php
// $Id: weblinks_link_utility.php,v 1.1 2006/05/24 01:23:56 ohwada Exp $

// 2006-05-15 K.OHWADA
// this is new file

//=========================================================
// WebLinks Module
// 2006-05-15 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_link_utility') ) 
{

//=========================================================
// class weblinks_link_utility
//=========================================================
class weblinks_link_utility
{
	var $_system;
	var $_strings;
	var $_remote_image;

//-----------------------------------------------
// This is for lower compatibility of mylinks
//-----------------------------------------------
	var $DIR_SHOTS = 'images/shots/';

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_link_utility()
{
	$this->_system       =& weblinks_system::getInstance();
	$this->_strings      =& weblinks_strings::getInstance();
	$this->_remote_image =& weblinks_remote_image::getInstance();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new weblinks_link_utility();
	}

	return $instance;
}

//---------------------------------------------------------
// banner
//---------------------------------------------------------
function get_banner_size($banner)
{
	$image_url = $this->assume_banner_url($banner);
	$ret = $this->get_image_size($image_url);
	return $ret;
}

function assume_banner_url($banner)
{
	if ( empty($banner) ) { return $banner; }

// URL style
	$url = $banner;
	if ( preg_match("/^https?:/", $url) )
	{
		return $url;
	}

// elliptical style
	$url = XOOPS_URL.$banner;
	$fp = fopen($url,"r");
	if ($fp)
  	{
		return $url;
  	}

// mylinks style
	$url = XOOPS_URL.'/modules/'.$this->_dirname.'/'.$this->DIR_SHOTS.'/'.$banner;
	return $url;

}

function get_image_size($url)
{
	if ( empty($url) )
	{
		return array(0, 0);
	}

	$ret = $this->_remote_image->get_image_size($url);

	if (!$ret)
	{
		$code = $this->_remote_image->getErrorCode();
		echo "error code = $code <br />";
		return array(0, 0);
	}

	return $ret;
}

// --- class end ---
}

// === class end ===
}

?>